/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.MemoryEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.listener.MemoryListener;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.memory.MemoryAddrCtrlView;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.memory.MemoryEditListener;
import com.ibm.iseries.debug.memory.MemoryPane;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugPanelFrame;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.MultiClickButton;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MemoryAddrPanel
extends TabPanel
implements ContextListener,
MemoryListener,
MemoryEditListener,
LAFListener,
MouseListener,
ActionListener,
DebugConstants {
    public static final String KEY = "memory";
    protected static final String GIF = "/com/ibm/iseries/debug/dbg073.gif";
    protected static final String SAVE = "save";
    protected static final String CANCEL = "cancel";
    protected static final String PREV = "prev";
    protected static final String NEXT = "next";
    protected MemoryManager m_memMgr;
    protected JPanel m_panel;
    protected MemoryAddrCtrlView m_ctrls;
    protected MemoryPane m_memory;
    protected JPanel m_buttons;
    protected JButton m_save;
    protected JButton m_cancel;
    protected JButton m_prev;
    protected JButton m_next;
    protected ContextMenu m_contextMenu;
    protected boolean m_notCurrent;
    protected boolean m_editing;
    protected boolean m_enabled = true;
    protected boolean m_prevEnabled = true;
    protected boolean m_nextEnabled = true;

    public MemoryAddrPanel() {
        super(MRI.get("DBG_MEMORY"), MRI.getIcon(0, GIF));
        this.addComponents();
    }

    public MemoryAddrPanel(DebugContext debugContext) {
        super(MRI.get("DBG_MEMORY"), MRI.getIcon(0, GIF));
        this.addComponents();
        this.init(debugContext, null);
    }

    protected void addComponents() {
        this.m_panel = new JPanel(new BorderLayout());
        this.m_buttons = new JPanel();
        this.m_save = new JButton(MRI.get("DBG_SAVE"));
        this.m_cancel = new JButton(MRI.get("DBG_CANCEL"));
        this.m_prev = new MultiClickButton(MRI.get("DBG_PREV_BUTTON"));
        this.m_next = new MultiClickButton(MRI.get("DBG_NEXT_BUTTON"));
        this.m_save.setActionCommand(SAVE);
        this.m_cancel.setActionCommand(CANCEL);
        this.m_prev.setActionCommand(PREV);
        this.m_next.setActionCommand(NEXT);
        this.m_save.addActionListener(this);
        this.m_cancel.addActionListener(this);
        this.m_prev.addActionListener(this);
        this.m_next.addActionListener(this);
        Insets insets = new Insets(0, 5, 0, 5);
        this.m_save.setMargin(insets);
        this.m_cancel.setMargin(insets);
        this.m_prev.setMargin(insets);
        this.m_next.setMargin(insets);
        this.m_save.setEnabled(false);
        this.m_cancel.setEnabled(false);
        this.m_buttons.setLayout(new BoxLayout(this.m_buttons, 0));
        this.m_buttons.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        Dimension dimension = new Dimension(3, 0);
        this.m_buttons.add(Box.createRigidArea(dimension));
        this.m_buttons.add(this.m_prev);
        this.m_buttons.add(Box.createRigidArea(dimension));
        this.m_buttons.add(this.m_next);
        this.m_buttons.add(Box.createHorizontalGlue());
        this.m_buttons.add(this.m_save);
        this.m_buttons.add(Box.createRigidArea(dimension));
        this.m_buttons.add(this.m_cancel);
        this.m_buttons.add(Box.createHorizontalGlue());
        Util.setAccessible((Accessible)this.m_save, this.m_save.getText());
        Util.setAccessible((Accessible)this.m_cancel, this.m_cancel.getText());
        Util.setAccessible((Accessible)this.m_prev, this.m_prev.getText());
        Util.setAccessible((Accessible)this.m_next, this.m_next.getText());
        Util.setOrientation(this.m_buttons);
        Util.setOrientation(this.m_save);
        Util.setOrientation(this.m_cancel);
        Util.setOrientation(this.m_prev);
        Util.setOrientation(this.m_next);
    }

    protected void lookAndFeelModifications() {
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("memoryContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
    }

    public void requestMemory() {
        this.m_memMgr.requestMemoryRead(this.m_ctrls.getAddress(), this.m_ctrls.getByteCount());
    }

    public void saveEdit() {
        this.m_memory.acceptEdit();
        this.cleanUpEdit();
        this.m_memMgr.requestMemoryWrite(this.m_memory.getAddress(), this.m_memory.getHexData(), this.m_memory.getTags());
    }

    public void cancelEdit() {
        this.m_memory.cancelEdit();
        this.cleanUpEdit();
        this.m_ctxt.setMessage(MRI.get("DBG_MEMORY_EDIT_CANCELED"));
    }

    protected void cleanUpEdit() {
        this.m_editing = false;
        this.m_ctrls.enableAddressControls(true);
        this.m_save.setEnabled(false);
        this.m_cancel.setEnabled(false);
        this.m_prev.setEnabled(true);
        this.m_next.setEnabled(true);
    }

    public void scrollPrevious() {
        MemoryAddress memoryAddress = this.m_ctrls.getAddress();
        MemoryAddress memoryAddress2 = memoryAddress.subtract(this.m_ctrls.getByteCount());
        this.m_ctrls.setAddress(memoryAddress2);
        this.requestMemory();
    }

    public void scrollNext() {
        MemoryAddress memoryAddress = this.m_ctrls.getAddress();
        MemoryAddress memoryAddress2 = memoryAddress.add(this.m_ctrls.getByteCount());
        this.m_ctrls.setAddress(memoryAddress2);
        this.requestMemory();
    }

    protected void updateAddressRelatedInfo() {
        String string;
        Object[] objectArray;
        if (this.isInFrame()) {
            this.getParentFrame().setTitle(this.getFrameTitle());
        }
        int n = this.m_ctrls.getByteCount();
        MemoryAddress memoryAddress = this.m_ctrls.getAddress();
        MemoryAddress memoryAddress2 = memoryAddress.subtract(n);
        MemoryAddress memoryAddress3 = memoryAddress.add(n);
        if (memoryAddress.isZero()) {
            this.m_prevEnabled = false;
            this.m_prev.setEnabled(false);
            this.m_prev.setToolTipText(null);
        } else {
            this.m_prevEnabled = true;
            this.m_prev.setEnabled(true);
            objectArray = new Object[]{memoryAddress2.toString()};
            string = MessageFormat.format(MRI.get("DBG_GO_TO_ADDRESS_FMT"), objectArray);
            this.m_prev.setToolTipText(string);
        }
        if (memoryAddress3.isMax()) {
            this.m_nextEnabled = false;
            this.m_next.setEnabled(false);
            this.m_next.setToolTipText(null);
        } else {
            this.m_nextEnabled = true;
            this.m_next.setEnabled(true);
            objectArray = new Object[]{memoryAddress3.toString()};
            string = MessageFormat.format(MRI.get("DBG_GO_TO_ADDRESS_FMT"), objectArray);
            this.m_next.setToolTipText(string);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.m_enabled) {
            this.m_enabled = bl;
            this.m_ctrls.enableAddressControls(this.m_enabled);
            this.m_memory.setEnabled(this.m_enabled);
            if (bl) {
                this.m_prev.setEnabled(this.m_prevEnabled);
                this.m_next.setEnabled(this.m_nextEnabled);
            } else {
                this.m_prev.setEnabled(false);
                this.m_next.setEnabled(false);
            }
        }
    }

    public MemoryAddress getAddress() {
        return this.m_ctrls.getAddress();
    }

    public MemoryAddress getAddressAtCursor() {
        return this.m_memory.getAddressAtCursor();
    }

    public void setAddress(MemoryAddress memoryAddress) {
        this.m_ctrls.setAddress(memoryAddress);
    }

    public void insertAddress(MemoryAddress memoryAddress) {
        this.m_ctrls.clearAlignment();
        this.m_ctrls.insertAddress(memoryAddress);
    }

    public int getByteCount() {
        return this.m_ctrls.getByteCount();
    }

    public void setByteCount(int n) {
        this.m_ctrls.setByteCount(n);
    }

    public int getCharacterMode() {
        return this.m_ctrls.getCharacterMode();
    }

    public void setCharacterMode(int n, boolean bl) {
        this.m_ctrls.setCharacterMode(n);
        this.m_memory.setCharacterMode(n, bl);
    }

    public int getBytesPerLine() {
        return this.m_ctrls.getBytesPerLine();
    }

    public void setBytesPerLine(int n, boolean bl) {
        this.m_ctrls.setBytesPerLine(n);
        this.m_memory.setBytesPerLine(n, bl);
    }

    public String getHexData() {
        return this.m_memory.getHexData();
    }

    public String getHexDataAtCursor(int n) {
        return this.m_memory.getHexDataAtCursor(n);
    }

    public void clearActionContext() {
        this.m_ctxt.enableAction("gotomem", false);
        this.m_ctxt.enableAction("newmem", false);
        this.m_ctxt.enableAction("gotooff", false);
        this.m_ctxt.enableAction("godsm", false);
        this.m_ctxt.enableAction("find", false);
    }

    public void prepareActionContext() {
        boolean bl = this.m_memory.getByteCount() > 0;
        this.m_ctxt.enableAction("gotomem", bl);
        this.m_ctxt.enableAction("newmem", bl);
        this.m_ctxt.enableAction("gotooff", bl);
        this.m_ctxt.enableAction("godsm", bl);
        this.m_ctxt.enableAction("find", bl);
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        this.m_memMgr = (MemoryManager)debugContext.getManager("memmgr");
        this.m_memory = new MemoryPane(debugContext, 1);
        this.m_memory.setEditListener(this);
        Settings settings = debugContext.getConfig();
        this.m_ctrls = (MemoryAddrCtrlView)Util.loadObject(settings.getString("memControls", ""));
        this.m_ctrls.init(debugContext, this.m_memory);
        super.init(debugContext, tabbedPane);
        this.m_ctrls.addMouseListener(this);
        this.m_memory.addMouseListener(this);
        this.m_buttons.addMouseListener(this);
        this.m_memory.addFocusListener(this);
        this.m_panel.add((Component)this.m_ctrls.getComponent(), "North");
        this.m_panel.add((Component)this.m_memory.getComponent(), "Center");
        this.m_panel.add((Component)this.m_buttons, "South");
        this.lookAndFeelModifications();
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
        this.m_ctxt.getManager("memmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_ctxt.getManager("memmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_ctrls.removeMouseListener(this);
        this.m_memory.removeMouseListener(this);
        this.m_buttons.removeMouseListener(this);
        this.m_memory.removeFocusListener(this);
        this.m_ctrls.cleanUp();
        this.m_memory.cleanUp();
        this.m_memMgr = null;
        this.m_panel = null;
        this.m_ctrls = null;
        this.m_memory = null;
        this.m_buttons = null;
        this.m_save = null;
        this.m_cancel = null;
        this.m_prev = null;
        this.m_next = null;
        this.m_contextMenu = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgmemory_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void requestFocus() {
        this.m_memory.getView().getHexComponent().requestFocus();
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            this.prepareActionContext();
        } else {
            this.clearActionContext();
        }
    }

    public void setExposed(boolean bl) {
        super.setExposed(bl);
        if (bl && this.m_notCurrent && !this.isSuspended()) {
            this.requestMemory();
        }
    }

    public void clear(boolean bl) {
        if (!bl) {
            this.m_memory.clear();
            this.m_ctrls.clearAddressHistory();
            this.m_prev.setEnabled(false);
            this.m_next.setEnabled(false);
            this.m_notCurrent = false;
        }
    }

    public boolean canDoSuspend() {
        return true;
    }

    public void setSuspended(boolean bl) {
        super.setSuspended(bl);
        this.m_memory.setSuspended(bl);
        this.m_ctrls.enableAddressControls(!bl);
        this.m_prev.setEnabled(!bl);
        this.m_next.setEnabled(!bl);
        if (!bl) {
            this.requestMemory();
        }
    }

    public boolean canClone() {
        return true;
    }

    public DebugPanelFrame cloneFrame(int n, int n2) {
        MemoryAddrPanel memoryAddrPanel = new MemoryAddrPanel(this.m_ctxt);
        memoryAddrPanel.setAddress(this.m_ctrls.getAddress());
        memoryAddrPanel.setByteCount(this.m_ctrls.getByteCount());
        memoryAddrPanel.setCharacterMode(this.m_ctrls.getCharacterMode(), false);
        memoryAddrPanel.setBytesPerLine(this.m_ctrls.getBytesPerLine(), false);
        memoryAddrPanel.m_memory.setHexData(this.m_memory.getAddress(), this.m_memory.getHexData(), this.m_memory.getTags(), this.m_memory.isEditable());
        Rectangle rectangle = null;
        if (this.m_memory.getByteCount() == 0) {
            rectangle = this.getComponent().getBounds();
            rectangle.x = n - rectangle.width / 2;
            rectangle.y = n2;
            rectangle.width += 15;
            rectangle.height += 30;
        } else {
            Dimension dimension = this.getComponent().getPreferredSize();
            rectangle = new Rectangle(n - dimension.width / 2, n2, dimension.width + 10, dimension.height + 20);
            Rectangle rectangle2 = this.m_ctxt.getJFrame().getBounds();
            if (rectangle.height > rectangle2.height - 100) {
                rectangle.height = rectangle2.height - 100;
            }
        }
        return new DebugPanelFrame(memoryAddrPanel, this.getFrameTitle(), rectangle);
    }

    public String getFrameTitle() {
        Object[] objectArray = new Object[]{this.m_ctrls.getAddress().toString()};
        String string = MessageFormat.format(MRI.get("DBG_MEMORY_ADDR_TITLE_BAR_FMT"), objectArray);
        return string;
    }

    public boolean canDoCopyPanel() {
        return true;
    }

    public void copyPanel() {
        this.m_memory.copyAll();
    }

    public boolean canDoFind() {
        return true;
    }

    public boolean find(String string) {
        return this.m_ctrls.find(string);
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: 
            case 1: {
                if (!this.isSuspended() && this.isExposed()) {
                    this.requestMemory();
                } else {
                    this.m_notCurrent = true;
                }
                this.setEnabled(true);
                break;
            }
            case 3: {
                this.setEnabled(false);
                break;
            }
            case 4: {
                this.clear(true);
            }
        }
    }

    public void memoryAvailable(MemoryEvent memoryEvent) {
        if (!this.isSuspended() && !this.m_memory.isEditing()) {
            int n;
            MemoryAddress memoryAddress = memoryEvent.getAddress();
            if (this.m_ctrls.isAddressMatch(memoryAddress, n = memoryEvent.getByteCount())) {
                this.m_memory.setHexData(memoryAddress, memoryEvent.getHexData(), memoryEvent.getTags(), !memoryEvent.dataReadOnly());
                this.updateAddressRelatedInfo();
                MemoryAddress memoryAddress2 = this.m_ctrls.getEditAddress();
                int n2 = memoryAddress2.difference(memoryAddress);
                this.m_memory.highlightPos(n2);
            } else if (this.m_ctrls.isAddressInRange(memoryAddress, n)) {
                this.m_memory.mergeHexData(memoryAddress, memoryEvent.getHexData(), memoryEvent.getTags());
            }
        }
    }

    public void memoryNotAvailable(MemoryEvent memoryEvent) {
        int n;
        MemoryAddress memoryAddress;
        if (!this.isSuspended() && !this.m_memory.isEditing() && this.m_ctrls.isAddressMatch(memoryAddress = memoryEvent.getAddress(), n = memoryEvent.getByteCount())) {
            Object[] objectArray = new Object[]{memoryAddress.toString()};
            String string = MessageFormat.format(MRI.get("DBG_ADDRESS_NOT_AVAILABLE_FMT"), objectArray);
            this.m_memory.setPaneText(string);
        }
    }

    public void memoryChanged(MemoryEvent memoryEvent) {
        this.memoryAvailable(memoryEvent);
    }

    public void memoryPossiblyChanged(MemoryEvent memoryEvent) {
        if (!this.isSuspended() && this.isExposed()) {
            this.requestMemory();
        } else {
            this.m_notCurrent = true;
        }
    }

    public void memoryNotChanged(MemoryEvent memoryEvent) {
        if (this.m_ctrls.isAddressMatch(memoryEvent.getAddress(), memoryEvent.getByteCount())) {
            this.requestMemory();
        }
    }

    public void memoryAddressSizeChanged(int n, int n2) {
        if (this.m_ctrls.getAddressSizeInBits() != n) {
            this.m_ctrls.resetAddressSize(n, n2);
        }
    }

    public void memoryMgrCleanUp() {
        if (this.isInFrame()) {
            this.getParentFrame().dispose();
        }
    }

    public void memoryMgrClear() {
        if (this.isInFrame()) {
            this.clear(false);
        }
    }

    public void memoryEditInitiated() {
        if (!this.m_editing) {
            this.m_editing = true;
            this.m_ctrls.enableAddressControls(false);
            this.m_save.setEnabled(true);
            this.m_cancel.setEnabled(true);
            this.m_prev.setEnabled(false);
            this.m_next.setEnabled(false);
        }
    }

    public void memoryEditCommitted() {
        this.saveEdit();
    }

    public void memoryEditAborted() {
        this.cancelEdit();
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SAVE)) {
            this.saveEdit();
        } else if (string.equals(CANCEL)) {
            this.cancelEdit();
        } else if (string.equals(PREV)) {
            this.scrollPrevious();
        } else if (string.equals(NEXT)) {
            this.scrollNext();
        }
    }

    protected boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent == this.m_memory.getView().getHexComponent()) {
                this.prepareActionContext();
            } else {
                this.clearActionContext();
            }
            this.m_contextMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        this.m_ctxt.setActivePanel(this);
        jComponent.requestFocus();
        if (!this.handlePopupMenu(mouseEvent) && mouseEvent.getClickCount() == 2 && this.m_memory.getByteCount() > 0 && !this.m_memory.isEditing()) {
            if (jComponent == this.m_memory.getView().getHexComponent()) {
                this.prepareActionContext();
                Action action = this.m_ctxt.getAction("gotomem");
                if (action != null && action.isEnabled()) {
                    action.run();
                }
            } else {
                this.clearActionContext();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

