/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.WatchEvent;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;

public class WatchPacket
extends DebuggerPacket
implements DebugConstants {
    public static final int RMV_WATCH = 0;
    public static final int ADD_WATCH = 1;
    private int m_action;
    private VariableDescriptor m_variable;
    private int m_watchNum;
    private String m_watchAddr;
    private int m_watchLength;
    private ISeriesMessage m_msgObj;

    public WatchPacket() {
        super(1517);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_variable = null;
        this.m_msgObj = null;
        this.m_watchAddr = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_action = commLink.readInt();
        this.m_variable = new VariableDescriptor();
        this.m_variable.read(commLink);
        this.m_watchNum = commLink.readInt();
        this.m_watchAddr = commLink.readString();
        this.m_watchLength = commLink.readInt();
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        VariableManager variableManager = (VariableManager)this.m_ctxt.getManager("varmgr");
        if (this.m_msgObj != null) {
            variableManager.fireWatchEvent(new WatchEvent(this, 2, 2, this.m_variable, this.m_watchNum, this.m_watchAddr, this.m_watchLength));
            this.displayMessage(this.m_msgObj);
        } else {
            switch (this.m_action) {
                case 1: {
                    variableManager.fireWatchEvent(new WatchEvent(this, 0, 2, this.m_variable, this.m_watchNum, this.m_watchAddr, this.m_watchLength));
                    break;
                }
                case 0: {
                    variableManager.fireWatchEvent(new WatchEvent(this, 1, 2, this.m_variable, this.m_watchNum, this.m_watchAddr, this.m_watchLength));
                }
            }
        }
        this.cleanUp();
    }
}

