/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.Toolbox;
import java.io.IOException;
import java.util.EventListener;

public class SourceViewPacket
extends DebuggerPacket {
    protected static final String CANT_ACCESS_SOURCE = "CPF954A CPF954C CPF9565 CPF9598 CPF959E CPF9C87";
    protected static final String SOURCE_MODIFIED = "CPF9561 CPF9566 CPF9596 CPF9597";
    protected String m_viewId;
    protected String m_source;
    protected int m_startLineNum;
    protected int m_endLineNum;
    protected int m_lineCount;
    protected ISeriesMessage m_msgObj;

    public SourceViewPacket() {
        super(1504);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_viewId = null;
        this.m_source = null;
        this.m_msgObj = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_viewId = commLink.readString();
        int n2 = commLink.readInt();
        this.m_source = n2 == 1 ? commLink.readString() : commLink.readAsciiString();
        this.m_startLineNum = commLink.readInt();
        this.m_endLineNum = commLink.readInt();
        this.m_lineCount = commLink.readInt();
        int n3 = commLink.readInt();
        if (n3 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            PgmManager pgmManager;
            ViewDescriptor viewDescriptor;
            SourceViewEvent sourceViewEvent = new SourceViewEvent(this, this.m_viewId, this.m_source, this.m_startLineNum, this.m_endLineNum, this.m_lineCount);
            SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
            sourceViewManager.fireSourceViewEvent(sourceViewEvent);
            if (this.m_lineCount > 0 && (viewDescriptor = (pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr")).getView(this.m_viewId)) != null && viewDescriptor.getTotalLineCount() != this.m_lineCount) {
                viewDescriptor.setTotalLineCount(this.m_lineCount);
            }
        } else {
            EventListener eventListener;
            Object object;
            String string = this.m_msgObj.getMsgId();
            boolean bl = true;
            boolean bl2 = true;
            if (SOURCE_MODIFIED.indexOf(string) >= 0) {
                object = new SourceViewEvent(this, this.m_viewId, this.m_source, this.m_startLineNum, this.m_endLineNum, this.m_lineCount);
                eventListener = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                ((SourceViewManager)eventListener).fireSourceViewEvent((SourceViewEvent)object);
            } else if (CANT_ACCESS_SOURCE.indexOf(string) >= 0 || this.m_source.length() > 0) {
                object = (PgmManager)this.m_ctxt.getManager("pgmmgr");
                eventListener = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                String string2 = ((PgmManager)object).getAlternateViewId(this.m_viewId);
                if (string2.length() == 0) {
                    ((SourceViewManager)eventListener).requestLocalSourceView(this.m_viewId, this.m_source);
                    bl2 = false;
                    bl = false;
                } else {
                    ((SourceViewManager)eventListener).requestAlternateSourceView(string2);
                    bl2 = false;
                }
            }
            if (bl || bl2) {
                object = Toolbox.instance().getMsgText(this.m_ctxt, this.m_msgObj);
                if (bl) {
                    this.m_ctxt.setMessage((String)object);
                }
                if (bl2) {
                    eventListener = new ISeriesMessageDialog(this.m_ctxt, this.m_msgObj);
                    ((Dialog)eventListener).display(this.m_ctxt);
                }
            }
        }
        this.m_ctxt.retractClock();
        this.cleanUp();
    }
}

