/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.event.RegisterEvent;
import com.ibm.iseries.debug.manager.RegisterManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.register.RegisterDefinition;
import com.ibm.iseries.debug.register.RegisterDescriptor;
import com.ibm.iseries.debug.register.RegisterSet;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import java.io.IOException;

public class RegistersPacket
extends DebuggerPacket {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private int m_action;
    private RegisterManager m_regMgr;
    private RegisterSet m_regSet;
    private RegisterDescriptor m_regDesc;
    private ISeriesMessage m_msgObj;

    public RegistersPacket() {
        super(1526);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_regMgr = null;
        this.m_regSet = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_regMgr = (RegisterManager)this.m_ctxt.getManager("regmgr");
        this.m_regSet = this.m_regMgr.getRegisterSet();
        this.m_action = commLink.readInt();
        int n2 = commLink.readInt();
        int n3 = 0;
        while (n3 < n2) {
            this.m_regDesc = new RegisterDescriptor();
            this.m_regDesc.read(commLink);
            this.m_regSet.setDescriptor(this.m_regDesc);
            ++n3;
        }
        int n4 = commLink.readInt();
        if (n4 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        if (this.m_msgObj == null) {
            RegisterEvent registerEvent = null;
            switch (this.m_action) {
                case 1: {
                    registerEvent = new RegisterEvent(this, 3, this.m_regSet);
                    break;
                }
                case 2: {
                    RegisterDefinition registerDefinition = this.m_regMgr.getDefinition(this.m_regDesc.getId());
                    registerEvent = registerDefinition.isParentRegister() || registerDefinition.isChildRegister() ? new RegisterEvent(this, 3, this.m_regSet) : new RegisterEvent(this, 4, this.m_regSet, this.m_regDesc);
                    this.m_ctxt.setMessage(MRI.get("DBG_REGISTER_EDIT_SUCCESSFUL"));
                }
            }
            this.m_regMgr.fireRegisterEvent(registerEvent);
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }
}

