/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.action.NewMemAction;
import com.ibm.iseries.debug.event.MemoryEvent;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.panel.MemoryAddrPanel;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugPanelFrame;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debug.util.Util;
import java.awt.Rectangle;
import java.io.IOException;
import java.text.MessageFormat;

public class MemoryExpPacket
extends DebuggerPacket {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int READ_ONLY = 1;
    private static final String HEX_BOUNDS_ERROR = "HEXBOUNDS";
    private int m_action;
    private String m_exp;
    private String m_viewId;
    private int m_lineNum;
    private String m_addr;
    private String m_hexData;
    private String m_tags;
    private int m_dataFlags;
    private ISeriesMessage m_msgObj;

    public MemoryExpPacket() {
        super(1528);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_exp = null;
        this.m_viewId = null;
        this.m_addr = null;
        this.m_hexData = null;
        this.m_tags = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_action = commLink.readInt();
        this.m_exp = commLink.readString();
        this.m_viewId = commLink.readString();
        this.m_lineNum = commLink.readInt();
        this.m_addr = commLink.readString();
        this.m_hexData = commLink.readString();
        this.m_tags = commLink.readString();
        this.m_dataFlags = commLink.readInt();
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        MemoryManager memoryManager = (MemoryManager)this.m_ctxt.getManager("memmgr");
        boolean bl = this.m_exp.equals(this.m_addr);
        if (this.m_msgObj == null && this.m_addr.length() > 0) {
            MemoryEvent memoryEvent;
            if (bl) {
                memoryEvent = new MemoryEvent(this, this.m_action, this.m_exp, this.m_viewId, this.m_lineNum, this.m_hexData, this.m_tags, this.m_dataFlags);
            } else {
                MemoryAddress memoryAddress = new MemoryAddress(this.m_addr.toUpperCase());
                if (NewMemAction.wasActivated()) {
                    this.createNewWindow(memoryAddress);
                } else {
                    this.updateMemoryTab(memoryAddress);
                }
                Object[] objectArray = new Object[]{this.m_exp, this.m_addr.toUpperCase()};
                String string = MessageFormat.format(MRI.get("DBG_GO_TO_ADDRESS_RESULTS_FMT"), objectArray);
                this.m_ctxt.setMessage(string);
                memoryEvent = new MemoryEvent((Object)this, this.m_action, memoryAddress, this.m_hexData, this.m_tags, this.m_dataFlags);
            }
            memoryManager.fireMemoryEvent(memoryEvent);
            if (this.m_action == 2) {
                this.m_ctxt.setMessage(MRI.get("DBG_MEMORY_EDIT_SUCCESSFUL"));
            }
        } else if (this.m_msgObj != null) {
            String string = this.m_msgObj.getMsgId();
            if (bl) {
                MemoryEvent memoryEvent = new MemoryEvent((Object)this, this.m_action == 1 ? 3 : 4, this.m_exp, this.m_viewId, this.m_lineNum, this.m_hexData.length() / 2);
                if (string.equals(HEX_BOUNDS_ERROR)) {
                    memoryManager.fireMemoryEvent(memoryEvent);
                    Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), MRI.get("DBG_MEMORY_EXP_LENGTH_ERROR"));
                } else {
                    memoryEvent.setErrorMessage(Toolbox.instance().getMsgText(this.m_ctxt, this.m_msgObj));
                    memoryManager.fireMemoryEvent(memoryEvent);
                }
            } else {
                Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), MRI.get("DBG_MEMORY_EXP_ERROR"));
            }
        } else {
            Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), MRI.get("DBG_MEMORY_EXP_ERROR"));
        }
        this.cleanUp();
    }

    private void updateMemoryTab(MemoryAddress memoryAddress) {
        MemoryAddrPanel memoryAddrPanel = (MemoryAddrPanel)this.m_ctxt.getPanel("memory");
        if (memoryAddrPanel != null) {
            memoryAddrPanel.insertAddress(memoryAddress);
        }
    }

    private void createNewWindow(MemoryAddress memoryAddress) {
        MemoryAddrPanel memoryAddrPanel = (MemoryAddrPanel)this.m_ctxt.getPanel("memory");
        MemoryAddrPanel memoryAddrPanel2 = new MemoryAddrPanel(this.m_ctxt);
        if (!memoryAddress.canAdd(memoryAddrPanel.getByteCount())) {
            memoryAddress = memoryAddress.setMax().subtract(memoryAddrPanel.getByteCount() - 1);
        }
        memoryAddrPanel2.setAddress(memoryAddress);
        memoryAddrPanel2.setByteCount(memoryAddrPanel.getByteCount());
        memoryAddrPanel2.setCharacterMode(memoryAddrPanel.getCharacterMode(), false);
        memoryAddrPanel2.setBytesPerLine(memoryAddrPanel.getBytesPerLine(), false);
        Rectangle rectangle = null;
        Rectangle rectangle2 = this.m_ctxt.getJFrame().getBounds();
        rectangle = memoryAddrPanel.getComponent().getBounds();
        rectangle.x = rectangle2.x + (rectangle2.width - rectangle.width) / 2;
        rectangle.y = rectangle2.y + (rectangle2.height - rectangle.height) / 2;
        rectangle.width += 15;
        rectangle.height += 30;
        DebugPanelFrame debugPanelFrame = new DebugPanelFrame(memoryAddrPanel2, memoryAddrPanel2.getFrameTitle(), rectangle);
    }
}

