/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.iseries.debug.dialog.ISeriesMessageDialog;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Toolbox;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.unix.panel.UnixLoadmapPanel;
import java.io.IOException;
import java.text.MessageFormat;

public class InfoPacket
extends DebuggerPacket {
    private static final int NOT_AUTHORIZED = 1;
    private static final int THREAD_NOT_DEBUGGABLE = 2;
    private static final int JOB_IS_HELD = 3;
    private static final int JOB_QUEUE_IS_HELD = 4;
    private static final int PROGRAM_DYNAMICALLY_LOADED = 5;
    private static final int PROGRAM_DYNAMICALLY_UNLOADED = 6;
    private int m_action;
    private String m_data;

    public InfoPacket() {
        super(1521);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_data = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_action = commLink.readInt();
        this.m_data = commLink.readString();
    }

    public void run() {
        switch (this.m_action) {
            case 1: {
                this.notAuthorized();
                break;
            }
            case 2: {
                this.threadNotDebuggable();
                break;
            }
            case 3: {
                this.jobIsHeld();
                break;
            }
            case 4: {
                this.jobQueueIsHeld();
                break;
            }
            case 5: {
                this.programLoaded();
                break;
            }
            case 6: {
                this.programUnloaded();
            }
        }
    }

    private void notAuthorized() {
        Dialog dialog = this.m_ctxt.getActiveDialog();
        if (dialog != null) {
            dialog.dispose();
        }
        String string = MRI.get("DBG_NOT_AUTHORIZED");
        this.m_ctxt.setMessage(string);
        Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), string);
    }

    private void threadNotDebuggable() {
        Object[] objectArray = new Object[]{this.m_data};
        String string = MessageFormat.format(MRI.get("DBG_THREAD_NOT_UNDER_DEBUG_FMT"), objectArray);
        Util.infoMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string);
    }

    private void jobIsHeld() {
        Object[] objectArray = new Object[]{this.m_ctxt.getJobId()};
        String string = MessageFormat.format(MRI.get("DBG_JOB_IS_HELD_FMT"), objectArray);
        if (Util.confirm(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string) == 0) {
            block7: {
                this.m_ctxt.postClock();
                try {
                    AS400 aS400 = Toolbox.instance().getAS400(this.m_ctxt.getSystem(), this.m_ctxt.getUser());
                    if (aS400 == null) break block7;
                    CommandCall commandCall = new CommandCall(aS400);
                    if (commandCall.run("QSYS/RLSJOB JOB(" + this.m_ctxt.getJobId() + ")")) {
                        AS400Message[] aS400MessageArray = commandCall.getMessageList();
                        string = aS400MessageArray.length > 0 ? aS400MessageArray[aS400MessageArray.length - 1].getText() : MessageFormat.format(MRI.get("DBG_JOB_RELEASED_OK_FMT"), objectArray);
                        this.m_ctxt.setMessage(string);
                        break block7;
                    }
                    AS400Message[] aS400MessageArray = commandCall.getMessageList();
                    if (aS400MessageArray.length > 0) {
                        string = aS400MessageArray[aS400MessageArray.length - 1].getText();
                        try {
                            aS400MessageArray[aS400MessageArray.length - 1].load();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(this.m_ctxt, string, aS400MessageArray[aS400MessageArray.length - 1].getHelp());
                        iSeriesMessageDialog.display(this.m_ctxt);
                        break block7;
                    }
                    string = MessageFormat.format(MRI.get("DBG_JOB_RELEASED_ERROR_FMT"), objectArray);
                    this.m_ctxt.setMessage(string);
                    Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), string);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.m_ctxt.retractClock();
        }
    }

    private void jobQueueIsHeld() {
        Object[] objectArray = new Object[]{Util.firstUpperObjectPath(this.m_data)};
        String string = MessageFormat.format(MRI.get("DBG_JOBQ_IS_HELD_FMT"), objectArray);
        if (Util.confirm(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string) == 0) {
            block7: {
                this.m_ctxt.postClock();
                try {
                    AS400 aS400 = Toolbox.instance().getAS400(this.m_ctxt.getSystem(), this.m_ctxt.getUser());
                    if (aS400 == null) break block7;
                    CommandCall commandCall = new CommandCall(aS400);
                    if (commandCall.run("QSYS/RLSJOBQ JOBQ(" + this.m_data + ")")) {
                        AS400Message[] aS400MessageArray = commandCall.getMessageList();
                        string = aS400MessageArray.length > 0 ? aS400MessageArray[aS400MessageArray.length - 1].getText() : MessageFormat.format(MRI.get("DBG_JOBQ_RELEASED_OK_FMT"), objectArray);
                        this.m_ctxt.setMessage(string);
                        break block7;
                    }
                    AS400Message[] aS400MessageArray = commandCall.getMessageList();
                    if (aS400MessageArray.length > 0) {
                        string = aS400MessageArray[aS400MessageArray.length - 1].getText();
                        try {
                            aS400MessageArray[aS400MessageArray.length - 1].load();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ISeriesMessageDialog iSeriesMessageDialog = new ISeriesMessageDialog(this.m_ctxt, string, aS400MessageArray[aS400MessageArray.length - 1].getHelp());
                        iSeriesMessageDialog.display(this.m_ctxt);
                        break block7;
                    }
                    string = MessageFormat.format(MRI.get("DBG_JOBQ_RELEASED_ERROR_FMT"), objectArray);
                    this.m_ctxt.setMessage(string);
                    Util.errorMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ERROR"), string);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.m_ctxt.retractClock();
        }
    }

    private void programLoaded() {
        UnixLoadmapPanel unixLoadmapPanel = (UnixLoadmapPanel)this.m_ctxt.getPanel("loadmap");
        if (unixLoadmapPanel != null) {
            unixLoadmapPanel.expose();
            Object[] objectArray = new Object[]{this.m_data};
            String string = MessageFormat.format(MRI.get("DBG_PGM_DYNAMIC_LOAD_FMT"), objectArray);
            Util.infoMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string);
        }
    }

    private void programUnloaded() {
        UnixLoadmapPanel unixLoadmapPanel = (UnixLoadmapPanel)this.m_ctxt.getPanel("loadmap");
        if (unixLoadmapPanel != null) {
            unixLoadmapPanel.expose();
            Object[] objectArray = new Object[]{this.m_data};
            String string = MessageFormat.format(MRI.get("DBG_PGM_DYNAMIC_UNLOAD_FMT"), objectArray);
            Util.infoMessage(this.m_ctxt.getJFrame(), MRI.get("DBG_ATTENTION"), string);
        }
    }
}

