/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import java.awt.Toolkit;
import java.io.IOException;
import java.text.MessageFormat;

public class FindPacket
extends DebuggerPacket {
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    private String m_viewId;
    private String m_text;
    private int m_startLineNum;
    private int m_direction;
    private boolean m_wrap;
    private int m_findLineNum;

    public FindPacket() {
        super(1523);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_viewId = null;
        this.m_text = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_viewId = commLink.readString();
        this.m_text = commLink.readString();
        this.m_startLineNum = commLink.readInt();
        this.m_direction = commLink.readInt();
        this.m_wrap = commLink.readInt() == 1;
        this.m_findLineNum = commLink.readInt();
    }

    public void run() {
        this.m_ctxt.retractClock();
        if (this.m_findLineNum > 0) {
            DebugSource debugSource = this.m_ctxt.getDesktop().getSource(this.m_viewId);
            if (debugSource != null) {
                if (debugSource.containsLineNum(this.m_findLineNum)) {
                    debugSource.findTextInLine(this.m_text, this.m_findLineNum, false, false);
                    Object[] objectArray = new Object[]{this.m_text, new Integer(this.m_findLineNum)};
                    String string = MessageFormat.format(MRI.get("DBG_FIND_SUCCESSFUL_FMT"), objectArray);
                    this.m_ctxt.setMessage(string);
                } else {
                    SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
                    sourceViewManager.requestSourceViewFind(this.m_viewId, this.m_findLineNum, this.m_text);
                }
            }
        } else {
            Object[] objectArray = new Object[]{this.m_text};
            String string = MessageFormat.format(MRI.get("DBG_FIND_FAILED_FMT"), objectArray);
            this.m_ctxt.setMessage(string);
            Toolkit.getDefaultToolkit().beep();
        }
        this.cleanUp();
    }
}

