/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.debugmanager.DebugManager;
import java.io.IOException;
import java.text.MessageFormat;

public class EndDebugPacket
extends DebuggerPacket
implements DebugConstants {
    private static final int ENDDBG_CMD = 0;
    private static final int GUI = 1;
    private int m_initiatedFrom;

    public EndDebugPacket() {
        super(1501);
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_initiatedFrom = commLink.readInt();
    }

    public void run() {
        if (this.m_initiatedFrom == 0) {
            if (DebugManager.instanceValid()) {
                Object[] objectArray = new Object[]{Util.firstUpperJobId(this.m_ctxt.getJobId())};
                String string = MessageFormat.format(MRI.get("DBGMGR_END_DEBUG_ISSUED_FMT"), objectArray);
                DebugManager.instance().logMsg(string);
            }
            this.m_ctxt.close();
        } else if (!this.m_ctxt.isClosed()) {
            this.m_ctxt.cancelClock();
            this.m_ctxt.clear(7);
            if (this.m_ctxt.hasPartnerContext()) {
                if (this.m_ctxt.isMasterContext()) {
                    this.m_ctxt.removePartnerContext();
                } else if (this.m_ctxt.isSlaveContext()) {
                    this.m_ctxt.startAnimation();
                }
            }
        }
    }
}

