/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.CallStackDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.panel.CallStackPanel;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;

public class CallStackPacket
extends DebuggerPacket {
    private CallStackDescriptor[] m_descriptors;

    public CallStackPacket() {
        super(1509);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_descriptors = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        int n2 = commLink.readInt();
        this.m_descriptors = new CallStackDescriptor[n2];
        int n3 = 0;
        while (n3 < n2) {
            CallStackDescriptor callStackDescriptor = new CallStackDescriptor();
            callStackDescriptor.read(commLink);
            if (PgmDescriptor.isUnixPgm(callStackDescriptor.getPgmType())) {
                callStackDescriptor.setAddress(pgmManager.getViewAddress(callStackDescriptor.getViewId(), callStackDescriptor.getLineNum()));
            }
            this.m_descriptors[n3] = callStackDescriptor;
            ++n3;
        }
    }

    public void run() {
        CallStackPanel callStackPanel = (CallStackPanel)this.m_ctxt.getPanel("callStack");
        callStackPanel.setCallStack(this.m_descriptors);
        this.cleanUp();
    }
}

