/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.menu;

import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.SubMenu;
import com.ibm.iseries.debug.util.Util;
import com.ibm.iseries.debugmanager.DebugManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.JMenuItem;

public class RecentPgmMenu
extends SubMenu
implements SettingsListener,
ActionListener {
    private DebugManager m_dbgMgr;
    private DebugContext m_ctxt;
    private SettingsManager m_settingsMgr;
    private ArrayList m_pgms;
    private int m_menuCount;

    public RecentPgmMenu(DebugManager debugManager) {
        super(MRI.get("DBG_RECENT_PGM_MENU"));
        this.m_dbgMgr = debugManager;
        this.m_settingsMgr = this.m_dbgMgr.getSettingsManager();
        this.m_pgms = this.m_settingsMgr.getRecentPgms();
        this.refresh();
        this.m_settingsMgr.addListener(this);
    }

    public RecentPgmMenu(DebugContext debugContext) {
        super(MRI.get("DBG_RECENT_PGM_MENU"));
        this.m_ctxt = debugContext;
        this.m_settingsMgr = (SettingsManager)this.m_ctxt.getManager("settmgr");
        this.m_pgms = this.m_settingsMgr.getRecentPgms();
        this.refresh();
        this.m_settingsMgr.addListener(this);
    }

    public void cleanUp() {
        this.m_settingsMgr.removeListener(this);
        this.m_dbgMgr = null;
        this.m_ctxt = null;
        this.m_settingsMgr = null;
        this.m_pgms = null;
    }

    public void refresh() {
        this.removeAll();
        this.m_menuCount = 0;
        if (this.m_pgms.size() == 0) {
            String string = MRI.get("DBG_EMPTY_PLACEHOLDER");
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setEnabled(false);
            Util.setAccessible((Accessible)jMenuItem, string);
            Util.setOrientation(jMenuItem);
            this.add(jMenuItem);
            return;
        }
        int n = 0;
        while (n < this.m_pgms.size()) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_pgms.get(n);
            String string = pgmDescriptor.getPgmPath();
            String string2 = this.formatMenuValue(string, this.m_menuCount + 1);
            JMenuItem jMenuItem = new JMenuItem(string2);
            String string3 = String.valueOf(this.m_menuCount + 1);
            jMenuItem.addActionListener(this);
            if (string3.length() == 1) {
                jMenuItem.setMnemonic(string3.charAt(0));
            }
            Util.setAccessible((Accessible)jMenuItem, string);
            Util.setOrientation(jMenuItem);
            this.add(jMenuItem);
            ++this.m_menuCount;
            ++n;
        }
    }

    private String formatMenuValue(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = String.valueOf(n) + "  ";
        stringBuffer.insert(0, string2);
        return stringBuffer.toString();
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
        if (settingsEvent.generalChanged()) {
            while (this.m_menuCount > this.m_settingsMgr.getRecentPgmMax()) {
                --this.m_menuCount;
                this.remove(this.m_menuCount);
            }
        }
        if (settingsEvent.recentPgmsChanged()) {
            this.refresh();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        int n = 0;
        while (n < this.m_pgms.size()) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_pgms.get(n);
            if (string.endsWith(pgmDescriptor.getPgmPath())) {
                Settings settings = this.m_settingsMgr.getUserConfig();
                settings.setString("strdbgPgmPath", pgmDescriptor.getPgmPath());
                settings.setString("strdbgPgmLib", pgmDescriptor.getPgmLibrary());
                settings.setString("strdbgPgmName", pgmDescriptor.getPgmName());
                settings.setInt("strdbgPgmType", pgmDescriptor.getPgmType());
                settings.setString("strdbgPgmParms", pgmDescriptor.getPgmParms());
                if (this.m_ctxt != null) {
                    this.m_ctxt.getAction("strdbg").run();
                    break;
                }
                if (this.m_dbgMgr == null) break;
                this.m_dbgMgr.getAction("strdbg2").run();
                break;
            }
            ++n;
        }
    }
}

