/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.menu;

import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.SubMenu;
import com.ibm.iseries.debug.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.JMenuItem;

public class RecentEnvMenu
extends SubMenu
implements SettingsListener,
ActionListener {
    public static final int MAX_REMEMBER = 20;
    private DebugContext m_ctxt;
    private SettingsManager m_settingsMgr;
    private ArrayList m_envPaths;
    private ArrayList m_menuPaths;
    private int m_menuCount;

    public RecentEnvMenu(DebugContext debugContext) {
        super(MRI.get("DBG_RECENT_ENV_MENU"));
        this.m_ctxt = debugContext;
        this.m_settingsMgr = (SettingsManager)this.m_ctxt.getManager("settmgr");
        this.m_envPaths = this.m_settingsMgr.getRecentEnvs();
        this.m_menuPaths = new ArrayList();
        this.refresh();
        this.m_settingsMgr.addListener(this);
    }

    public void cleanUp() {
        this.m_settingsMgr.removeListener(this);
        this.m_ctxt = null;
        this.m_settingsMgr = null;
        this.m_envPaths = null;
        this.m_menuPaths = null;
    }

    public void refresh() {
        this.removeAll();
        this.m_menuCount = 0;
        this.m_menuPaths.clear();
        if (this.m_envPaths.size() == 0) {
            String string = MRI.get("DBG_EMPTY_PLACEHOLDER");
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setEnabled(false);
            Util.setAccessible((Accessible)jMenuItem, string);
            Util.setOrientation(jMenuItem);
            this.add(jMenuItem);
            return;
        }
        String string = this.m_ctxt.getPgmEnv().getExtension();
        int n = 0;
        while (n < this.m_envPaths.size()) {
            String string2 = (String)this.m_envPaths.get(n);
            if (!string2.endsWith(File.separator + string)) {
                File file = new File(string2);
                if (!file.exists() || !file.canRead()) {
                    return;
                }
                String string3 = this.formatMenuValue(string2, this.m_menuCount + 1);
                JMenuItem jMenuItem = new JMenuItem(string3);
                String string4 = String.valueOf(this.m_menuCount + 1);
                jMenuItem.addActionListener(this);
                if (string4.length() == 1) {
                    jMenuItem.setMnemonic(string4.charAt(0));
                }
                Util.setAccessible((Accessible)jMenuItem, string2);
                Util.setOrientation(jMenuItem);
                this.add(jMenuItem);
                this.m_menuPaths.add(string3);
                ++this.m_menuCount;
            }
            ++n;
        }
    }

    private String formatMenuValue(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = this.m_ctxt.getPgmEnv().getExtension();
        if (string.endsWith(string2)) {
            stringBuffer.delete(stringBuffer.length() - string2.length(), stringBuffer.length());
        }
        int n2 = 0;
        int n3 = stringBuffer.length() - 1;
        while (n3 >= 0) {
            char c = stringBuffer.charAt(n3);
            if (c == File.separatorChar && ++n2 == 2) {
                stringBuffer.delete(0, n3);
                stringBuffer.insert(0, "...");
                break;
            }
            --n3;
        }
        String string3 = String.valueOf(n) + "  ";
        stringBuffer.insert(0, string3);
        return stringBuffer.toString();
    }

    public void settingsChanged(SettingsEvent settingsEvent) {
        if (settingsEvent.generalChanged()) {
            while (this.m_menuCount > this.m_settingsMgr.getRecentEnvMax()) {
                --this.m_menuCount;
                this.m_menuPaths.remove(this.m_menuCount);
                this.remove(this.m_menuCount);
            }
        }
        if (settingsEvent.recentEnvsChanged()) {
            this.refresh();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        int n = 0;
        while (n < this.m_menuPaths.size()) {
            String string2 = (String)this.m_menuPaths.get(n);
            if (string2.equals(string)) {
                String string3 = (String)this.m_envPaths.get(n);
                this.m_ctxt.getPgmEnv().open(new File(string3));
                break;
            }
            ++n;
        }
    }
}

