/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.menu;

import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.SubMenu;
import com.ibm.iseries.debug.util.Util;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

public class LookAndFeelMenu
extends SubMenu
implements LAFListener,
ItemListener {
    private UIManager.LookAndFeelInfo[] m_laf = null;
    private JRadioButtonMenuItem[] m_buttons = null;
    private boolean m_ignore = false;

    public LookAndFeelMenu() {
        super(MRI.get("DBG_LOOK_AND_FEEL_MENU"));
        this.init();
    }

    private void init() {
        this.m_laf = UIManager.getInstalledLookAndFeels();
        this.m_buttons = new JRadioButtonMenuItem[this.m_laf.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = UIManager.getLookAndFeel().getName();
        int n = 0;
        while (n < this.m_laf.length) {
            String string2 = this.m_laf[n].getName();
            String string3 = this.m_laf[n].getClassName();
            if (!string3.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") || System.getProperty("os.name").startsWith("Windows")) {
                this.m_buttons[n] = new JRadioButtonMenuItem(string2);
                this.m_buttons[n].setMnemonic(string2.charAt(0));
                if (string.equals(string2)) {
                    this.m_buttons[n].setSelected(true);
                }
                buttonGroup.add(this.m_buttons[n]);
                this.add(this.m_buttons[n]);
                this.m_buttons[n].addItemListener(this);
                Util.setAccessible((Accessible)this.m_buttons[n], string2);
                Util.setOrientation(this.m_buttons[n]);
            }
            ++n;
        }
        LAFManager.instance().addListener(this);
    }

    public void cleanUp() {
        LAFManager.instance().removeListener(this);
        this.m_laf = null;
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        if (this.m_ignore) {
            return;
        }
        String string = lAFEvent.getLookAndFeel();
        int n = 0;
        while (n < this.m_laf.length) {
            if (string.equals(this.m_laf[n].getClassName())) {
                this.m_ignore = true;
                this.m_buttons[n].setSelected(true);
                this.m_ignore = false;
                break;
            }
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_ignore) {
            return;
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
        if (jRadioButtonMenuItem.isSelected()) {
            int n = 0;
            while (n < this.m_laf.length) {
                if (jRadioButtonMenuItem.getText().equals(this.m_laf[n].getName())) {
                    this.m_ignore = true;
                    if (!LAFManager.instance().setLookAndFeel(this.m_laf[n].getClassName(), true)) {
                        jRadioButtonMenuItem.setEnabled(false);
                    }
                    this.m_ignore = false;
                    break;
                }
                ++n;
            }
        }
    }
}

