/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.memory.MemoryCharEditor;
import com.ibm.iseries.debug.memory.MemoryEditListener;
import com.ibm.iseries.debug.memory.MemoryHexEditor;
import com.ibm.iseries.debug.memory.MemoryTagEditor;
import com.ibm.iseries.debug.memory.MemoryView;
import com.ibm.iseries.debug.util.DebugContext;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class MemoryHexView
extends JPanel
implements MemoryView,
ClipboardOwner {
    private MemoryHexEditor m_hexEditor = new MemoryHexEditor(this);
    private MemoryCharEditor m_charEditor = new MemoryCharEditor(this);
    private MemoryTagEditor m_tagEditor = new MemoryTagEditor(this);
    private CharBorder m_left = new CharBorder("   <");
    private CharBorder m_right = new CharBorder(">");
    private MemoryAddress m_addr;
    private String m_hexData;
    private String m_tags;
    private int m_byteCount;
    private int m_bytesPerLine;
    private MemoryEditListener m_listener;
    private boolean m_editing;
    private boolean m_tagsReadOnly;

    public MemoryHexView() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.m_hexEditor);
        this.add(this.m_tagEditor);
        this.add(this.m_left);
        this.add(this.m_charEditor);
        this.add(this.m_right);
        this.setEditable(false);
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getHexComponent() {
        return this.m_hexEditor;
    }

    public JComponent getCharComponent() {
        return this.m_charEditor;
    }

    public JComponent getTagComponent() {
        return this.m_tagEditor;
    }

    public void init(DebugContext debugContext, int n) {
        this.m_bytesPerLine = debugContext.getUserConfig().getInt("memBPL", 16);
        this.m_hexEditor.init(debugContext);
        this.m_charEditor.init(debugContext, n);
    }

    public void cleanUp() {
        this.m_hexEditor.cleanUp();
        this.m_charEditor.cleanUp();
        this.m_tagEditor.cleanUp();
        this.m_left.cleanUp();
        this.m_right.cleanUp();
        this.m_hexEditor = null;
        this.m_charEditor = null;
        this.m_tagEditor = null;
        this.m_left = null;
        this.m_right = null;
        this.m_addr = null;
        this.m_hexData = null;
        this.m_tags = null;
    }

    public boolean find(String string) {
        String string2 = string.toUpperCase();
        int n = this.m_hexEditor.getCursorOffset();
        if (n < 0) {
            n = 0;
        }
        this.syncCharCursor(n);
        if (this.m_hexData != null) {
            int n2;
            int n3 = this.m_hexData.indexOf(string2, n * 2);
            if (n3 > -1) {
                this.syncCharCursor(n3 / 2);
                this.highlightPos(n3 / 2);
                return true;
            }
            int n4 = this.m_byteCount / this.m_bytesPerLine;
            int n5 = n2 = n / this.m_bytesPerLine;
            while (n5 < n4) {
                String string3 = this.m_charEditor.getLine(n5);
                int n6 = string3.length();
                if (n5 + 1 < n4) {
                    String string4 = this.m_charEditor.getLine(n5 + 1);
                    string3 = string3 + string4;
                }
                if ((n3 = (string3 = string3.toUpperCase()).indexOf(string2)) > -1 && n3 < n6) {
                    this.syncCharCursor(n3 += n5 * this.m_bytesPerLine);
                    this.highlightPos(n3);
                    return true;
                }
                ++n5;
                n3 += this.m_bytesPerLine;
            }
        }
        return false;
    }

    public boolean isEditable() {
        return this.m_hexEditor.isEditable() || this.m_charEditor.isEditable() || this.m_tagEditor.isEditable();
    }

    public void setTagsReadOnly(boolean bl) {
        this.m_tagsReadOnly = true;
    }

    public boolean isEditing() {
        return this.m_editing;
    }

    public void acceptEdit() {
        this.m_editing = false;
        this.m_hexData = this.m_hexEditor.getData();
        this.m_tags = this.m_tagEditor.getTags();
        this.m_hexEditor.setEditMode(false);
        this.m_charEditor.setEditMode(false);
        this.m_tagEditor.setEditMode(false);
        if (!(this.m_hexEditor.hasFocus() || this.m_charEditor.hasFocus() || this.m_tagEditor.hasFocus())) {
            this.m_hexEditor.requestFocus();
        }
    }

    public void cancelEdit() {
        this.m_editing = false;
        this.setHexData(this.m_addr, this.m_hexData, this.m_tags, this.m_bytesPerLine, true);
        this.m_hexEditor.setEditMode(false);
        this.m_charEditor.setEditMode(false);
        this.m_tagEditor.setEditMode(false);
        if (!(this.m_hexEditor.hasFocus() || this.m_charEditor.hasFocus() || this.m_tagEditor.hasFocus())) {
            this.m_hexEditor.requestFocus();
        }
    }

    public MemoryAddress getAddress() {
        return this.m_addr;
    }

    public MemoryAddress getAddressAtCursor() {
        return this.m_addr.add(this.m_hexEditor.getCursorOffset());
    }

    public int getByteCount() {
        return this.m_byteCount;
    }

    public String getHexData() {
        return this.m_hexData;
    }

    public String getHexDataAtCursor(int n) {
        int n2 = this.m_hexEditor.getCursorOffset();
        return this.m_hexData.substring(n2 * 2, n2 * 2 + n * 2);
    }

    public String getTags() {
        return this.m_tags;
    }

    public int getCharacterMode() {
        return this.m_charEditor.getCharacterMode();
    }

    public int getBytesPerLine() {
        return this.m_bytesPerLine;
    }

    public void setCharacterMode(int n, boolean bl) {
        if (this.m_charEditor.getCharacterMode() != n && bl) {
            this.m_hexEditor.ensureCursorInVisibleRect();
            this.m_charEditor.setCharacterMode(n);
        }
    }

    public void setBytesPerLine(int n, boolean bl) {
        if (this.m_bytesPerLine != n) {
            int n2 = this.m_bytesPerLine = n <= this.m_byteCount ? n : this.m_byteCount;
            if (bl && this.m_byteCount > 0) {
                this.m_hexEditor.ensureCursorInVisibleRect();
                this.m_hexEditor.setBytesPerLine(this.m_bytesPerLine);
                this.m_charEditor.setBytesPerLine(this.m_bytesPerLine);
                if (this.m_tags != null && this.m_tags.length() > 0) {
                    if (this.m_bytesPerLine == 16) {
                        this.m_tagEditor.setTags(this.m_tags, this.m_tagEditor.isEditable());
                    } else {
                        this.m_tagEditor.clear();
                    }
                }
                int n3 = this.m_byteCount % this.m_bytesPerLine == 0 ? this.m_byteCount / this.m_bytesPerLine : this.m_byteCount / this.m_bytesPerLine + 1;
                this.m_left.setBorder(n3);
                this.m_right.setBorder(n3);
            }
        }
    }

    public void setHexData(MemoryAddress memoryAddress, String string, String string2, int n, boolean bl) {
        this.m_addr = memoryAddress;
        this.m_hexData = string;
        this.m_tags = string2;
        this.m_hexEditor.ensureCursorInVisibleRect();
        byte[] byArray = MemoryHexView.hexStringToByteArray(this.m_hexData);
        int n2 = this.m_hexEditor.getCursorOffset();
        if (n > byArray.length) {
            n = byArray.length;
        }
        if (n == 16 && this.m_tags != null && string2.length() > 0) {
            this.m_tagEditor.setTags(string2, bl && !this.m_tagsReadOnly);
        } else {
            this.m_tagEditor.clear();
        }
        this.m_hexEditor.setData(this.m_hexData, byArray, n, bl);
        this.m_charEditor.setData(byArray, n, bl);
        if (this.m_byteCount != byArray.length || this.m_bytesPerLine != n) {
            this.m_byteCount = byArray.length;
            this.m_bytesPerLine = n;
            int n3 = this.m_byteCount % this.m_bytesPerLine == 0 ? this.m_byteCount / this.m_bytesPerLine : this.m_byteCount / this.m_bytesPerLine + 1;
            this.m_left.setBorder(n3);
            this.m_right.setBorder(n3);
        }
        this.m_hexEditor.setCursorToOffset(n2, true);
        this.highlightPos(n2);
    }

    public void highlightPos(int n) {
        this.m_hexEditor.highlightPos(n);
    }

    public void mergeHexData(MemoryAddress memoryAddress, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(this.m_hexData);
        StringBuffer stringBuffer2 = new StringBuffer(this.m_tags);
        int n = this.m_addr.compareTo(memoryAddress);
        int n2 = string.length() / 2;
        int n3 = this.m_byteCount;
        int n4 = 0;
        int n5 = this.m_hexData.length();
        int n6 = 0;
        int n7 = this.m_tags.length();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                int n8 = this.m_addr.difference(memoryAddress);
                string = string.substring(n8 * 2);
                n2 = string.length() / 2;
                if (string2.length() <= 0) break;
                string2 = string2.substring(n8 / 16);
                break;
            }
            case -1: {
                int n9 = memoryAddress.difference(this.m_addr);
                n4 += n9 * 2;
                n6 += n9 / 16;
                n3 -= n9;
            }
        }
        if (n3 > n2) {
            n5 = n4 + n2 * 2;
            n7 = n6 + n2 / 16;
        } else if (n3 < n2) {
            string = string.substring(0, n3 * 2);
            if (string2.length() > 0) {
                string2 = string2.substring(0, n3 / 16);
            }
        }
        stringBuffer.replace(n4, n5, string);
        if (string2.length() > 0) {
            stringBuffer2.replace(n6, n7, string2);
        }
        this.setHexData(this.m_addr, stringBuffer.toString(), stringBuffer2.toString(), this.m_bytesPerLine, this.isEditable());
    }

    public void clear() {
        if (this.isEditing()) {
            this.cancelEdit();
        }
        this.m_hexData = null;
        this.m_tags = null;
        this.m_byteCount = 0;
        this.m_hexEditor.clear();
        this.m_charEditor.clear();
        this.m_tagEditor.clear();
        this.m_left.clearBorder();
        this.m_right.clearBorder();
        this.setEditable(false);
    }

    public void setEditListener(MemoryEditListener memoryEditListener) {
        this.m_listener = memoryEditListener;
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this.m_hexEditor != null) {
            this.m_hexEditor.addMouseListener(mouseListener);
        }
        if (this.m_charEditor != null) {
            this.m_charEditor.addMouseListener(mouseListener);
        }
        if (this.m_tagEditor != null) {
            this.m_tagEditor.addMouseListener(mouseListener);
        }
        if (this.m_left != null) {
            this.m_left.addMouseListener(mouseListener);
        }
        if (this.m_right != null) {
            this.m_right.addMouseListener(mouseListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (this.m_hexEditor != null) {
            this.m_hexEditor.removeMouseListener(mouseListener);
        }
        if (this.m_charEditor != null) {
            this.m_charEditor.removeMouseListener(mouseListener);
        }
        if (this.m_tagEditor != null) {
            this.m_tagEditor.removeMouseListener(mouseListener);
        }
        if (this.m_left != null) {
            this.m_left.removeMouseListener(mouseListener);
        }
        if (this.m_right != null) {
            this.m_right.removeMouseListener(mouseListener);
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
        if (this.m_hexEditor != null) {
            this.m_hexEditor.addFocusListener(focusListener);
        }
        if (this.m_charEditor != null) {
            this.m_charEditor.addFocusListener(focusListener);
        }
        if (this.m_tagEditor != null) {
            this.m_tagEditor.addFocusListener(focusListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
        if (this.m_hexEditor != null) {
            this.m_hexEditor.removeFocusListener(focusListener);
        }
        if (this.m_charEditor != null) {
            this.m_charEditor.removeFocusListener(focusListener);
        }
        if (this.m_tagEditor != null) {
            this.m_tagEditor.removeFocusListener(focusListener);
        }
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 * 2;
            byte by = Byte.parseByte(string.substring(n3, n3 + 1), 16);
            byte by2 = Byte.parseByte(string.substring(n3 + 1, n3 + 2), 16);
            byArray[n2] = (byte)(by << 4 | by2);
            ++n2;
        }
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            cArray[n++] = MemoryHexView.nibbleChar((byArray[n2] & 0xF0) >> 4);
            cArray[n++] = MemoryHexView.nibbleChar(byArray[n2] & 0xF);
            ++n2;
        }
        return new String(cArray);
    }

    public static char nibbleChar(int n) {
        switch (n) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return ' ';
    }

    public void signalInitiateEdit() {
        if (!this.m_editing) {
            this.m_editing = true;
            this.m_hexEditor.setEditMode(true);
            this.m_charEditor.setEditMode(true);
            this.m_tagEditor.setEditMode(true);
            if (this.m_listener != null) {
                this.m_listener.memoryEditInitiated();
            }
        }
    }

    public void signalAcceptEdit() {
        if (this.m_editing && this.m_listener != null) {
            this.m_listener.memoryEditCommitted();
        }
    }

    public void signalCancelEdit() {
        if (this.m_editing && this.m_listener != null) {
            this.m_listener.memoryEditAborted();
        }
    }

    public void syncHexCursor(int n) {
        this.m_charEditor.setCursorToOffset(n, false);
        if (this.m_tags.length() > 0) {
            this.m_tagEditor.setCursorToOffset(n, false);
        }
    }

    public void hexModified() {
        this.m_charEditor.refresh();
        this.signalInitiateEdit();
    }

    public void hexModified(int n) {
        this.m_charEditor.refreshOffset(n);
        this.signalInitiateEdit();
    }

    public void syncCharCursor(int n) {
        this.m_hexEditor.setCursorToOffset(n, false);
        if (this.m_tags.length() > 0) {
            this.m_tagEditor.setCursorToOffset(n, false);
        }
    }

    public void charsModified() {
        this.m_hexEditor.refresh();
        this.signalInitiateEdit();
    }

    public void charModified(int n, int n2) {
        this.m_hexEditor.refreshOffset(n, n2);
        this.signalInitiateEdit();
    }

    public void syncTagCursor(int n) {
        this.m_hexEditor.setCursorToOffset(n, false);
        this.m_charEditor.setCursorToOffset(n, false);
    }

    public void tagsModified() {
        this.signalInitiateEdit();
    }

    public void copyAll() {
        if (this.m_byteCount == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = this.m_byteCount / this.m_bytesPerLine;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(this.m_addr.add(n2).toString());
            stringBuffer.append("   ");
            stringBuffer.append(this.m_hexEditor.getLine(n3));
            if (this.m_tags.length() > 0) {
                stringBuffer.append(this.m_tagEditor.getLine(n3));
            }
            stringBuffer.append(this.m_left.getBorderString());
            stringBuffer.append(this.m_charEditor.getLine(n3));
            stringBuffer.append(this.m_right.getBorderString());
            stringBuffer.append('\n');
            ++n3;
            n2 += this.m_bytesPerLine;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        clipboard.setContents(stringSelection, this);
    }

    public void setEnabled(boolean bl) {
        this.m_hexEditor.setEnabled(bl);
        this.m_charEditor.setEnabled(bl);
        this.m_tagEditor.setEnabled(bl);
    }

    public void setEditable(boolean bl) {
        this.m_hexEditor.setEditable(bl);
        this.m_charEditor.setEditable(bl);
        this.m_tagEditor.setEditable(bl);
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.m_hexEditor != null) {
            this.m_hexEditor.setCursor(cursor);
        }
        if (this.m_charEditor != null) {
            this.m_charEditor.setCursor(cursor);
        }
        if (this.m_tagEditor != null) {
            this.m_tagEditor.setCursor(cursor);
        }
        if (this.m_left != null) {
            this.m_left.setCursor(cursor);
        }
        if (this.m_right != null) {
            this.m_right.setCursor(cursor);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.m_hexEditor != null) {
            this.m_hexEditor.setFont(font);
        }
        if (this.m_charEditor != null) {
            this.m_charEditor.setFont(font);
        }
        if (this.m_tagEditor != null) {
            this.m_tagEditor.setFont(font);
        }
        if (this.m_left != null) {
            this.m_left.setFont(font);
        }
        if (this.m_right != null) {
            this.m_right.setFont(font);
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("TextArea.background"));
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private class CharBorder
    extends JTextArea {
        private String m_value = null;

        public CharBorder(String string) {
            this.m_value = string;
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            Dimension dimension = this.getMaximumSize();
            dimension.width = fontMetrics.stringWidth(this.m_value);
            this.setMaximumSize(dimension);
            this.setEditable(false);
            this.getCaret().setVisible(false);
        }

        public void cleanUp() {
            this.m_value = null;
            this.setText("");
        }

        public void setBorder(int n) {
            StringBuffer stringBuffer = new StringBuffer(n * (this.m_value.length() + 1));
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this.m_value);
                if (n2 + 1 < n) {
                    stringBuffer.append('\n');
                }
                ++n2;
            }
            this.setText(stringBuffer.toString());
        }

        public String getBorderString() {
            return this.m_value;
        }

        public void clearBorder() {
            this.setText("");
        }

        public void updateUI() {
            super.updateUI();
            this.setFont(SettingsManager.getFixedPitchFont());
        }

        public boolean isManagingFocus() {
            return false;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                super.processMouseEvent(mouseEvent);
            }
        }
    }
}

