/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.memory.MemoryHexView;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class MemoryHexEditor
extends JTextArea
implements CaretListener,
MouseListener {
    private static Color s_fg = UIManager.getColor("TextArea.foreground");
    private static Color s_bg = UIManager.getColor("TextArea.background");
    private static Color s_caret = UIManager.getColor("TextArea.caretForeground");
    private MemoryHexView m_view;
    private String m_hexData;
    private byte[] m_bytes;
    private int m_bytesPerLine;
    private int m_charsPerLine;
    private int m_groupsPerLine;
    private int m_charsPerGroup;
    private int m_cursorDirection;
    private boolean m_cursorNotify;
    private boolean m_forceMaxSizeEval;
    private boolean m_editing;

    public MemoryHexEditor(MemoryHexView memoryHexView) {
        this.m_view = memoryHexView;
        this.m_cursorDirection = 1;
        this.m_cursorNotify = true;
        this.addCaretListener(this);
        this.addMouseListener(this);
    }

    public void init(DebugContext debugContext) {
    }

    public void cleanUp() {
        this.setText("");
        this.m_view = null;
        this.m_hexData = null;
        this.m_bytes = null;
    }

    public JComponent getComponent() {
        return this;
    }

    public void setEditMode(boolean bl) {
        this.m_editing = bl;
        if (bl) {
            this.setBackground(s_fg);
            this.setForeground(s_bg);
            this.setCaretColor(s_bg);
        } else {
            this.setBackground(s_bg);
            this.setForeground(s_fg);
            this.setCaretColor(s_caret);
        }
    }

    public int getBytesPerLine() {
        return this.m_bytesPerLine;
    }

    public void setBytesPerLine(int n) {
        if (this.m_bytes == null) {
            this.m_bytesPerLine = n;
            this.m_forceMaxSizeEval = true;
            return;
        }
        int n2 = this.cursorToOffset(this.getCaretPosition());
        this.setData(this.m_hexData, this.m_bytes, n, this.isEditable());
        int n3 = this.offsetToCursor(n2);
        ScrollToThread scrollToThread = new ScrollToThread(n3);
        scrollToThread.start();
    }

    public String getData() {
        StringBuffer stringBuffer = new StringBuffer(this.getText());
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == ' ' || c == '\n') {
                stringBuffer.deleteCharAt(n--);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setData(String string, byte[] byArray, int n, boolean bl) {
        int n2;
        this.m_hexData = string;
        this.m_bytes = byArray;
        this.m_groupsPerLine = n % 4 == 0 ? n / 4 : n / 4 + 1;
        this.m_charsPerGroup = n >= 4 ? 8 : n * 2;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        stringBuffer.append(string);
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            n2 = 0;
            while (n2 < this.m_groupsPerLine) {
                n3 += this.m_charsPerGroup;
                if (n2 + 1 < this.m_groupsPerLine) {
                    stringBuffer.insert(n3++, ' ');
                }
                ++n2;
            }
            if (n4 + n < byArray.length) {
                stringBuffer.insert(n3++, '\n');
            }
            n4 += n;
        }
        n2 = this.m_cursorNotify;
        this.m_cursorNotify = false;
        this.setText(stringBuffer.toString());
        this.setEditable(bl);
        this.m_cursorNotify = n2;
        if (this.m_forceMaxSizeEval || this.m_bytesPerLine != n) {
            this.m_forceMaxSizeEval = false;
            try {
                String string2 = this.getText(0, this.getLineEndOffset(0));
                Dimension dimension = this.getMaximumSize();
                dimension.width = ((Component)this).getFontMetrics(this.getFont()).stringWidth(string2) + 1;
                this.setMaximumSize(dimension);
                this.m_charsPerLine = string2.length();
                this.m_bytesPerLine = n;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void refresh() {
        int n = this.getCaretPosition();
        this.setData(MemoryHexView.byteArrayToHexString(this.m_bytes), this.m_bytes, this.m_bytesPerLine, this.isEditable());
        this.setCaretPosition(n);
    }

    public void refreshOffset(int n, int n2) {
        this.m_cursorNotify = false;
        int n3 = this.offsetToCursor(n);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_bytes, n, byArray, 0, n2);
        this.replaceRange(MemoryHexView.byteArrayToHexString(byArray), n3, n3 + n2 * 2);
        this.setCaretPosition(n3 + n2 * 2);
        this.m_cursorNotify = true;
    }

    public void clear() {
        this.setText("");
        this.getCaret().setVisible(false);
    }

    public void highlightPos(int n) {
        int n2 = this.offsetToCursor(n);
        this.select(n2, n2 + 1);
    }

    public int getCursorOffset() {
        if (this.getDocument().getLength() == 0) {
            return 0;
        }
        return this.cursorToOffset(this.getCaretPosition());
    }

    public void setCursorToOffset(int n, boolean bl) {
        int n2 = this.offsetToCursor(n);
        if (n2 < this.getDocument().getLength()) {
            this.m_cursorNotify = bl;
            this.setCaretPosition(n2);
            this.m_cursorNotify = true;
        }
    }

    public void ensureCursorInVisibleRect() {
        if (this.m_bytes != null && this.m_bytes.length > 128) {
            try {
                Rectangle rectangle = this.modelToView(this.getCaretPosition());
                Rectangle rectangle2 = this.getVisibleRect();
                if (!rectangle2.contains(rectangle)) {
                    int n = this.getCaretPosition();
                    Point point = new Point(rectangle2.x, rectangle2.y + ((Component)this).getFontMetrics(this.getFont()).getHeight() / 2);
                    int n2 = this.viewToModel(point);
                    this.setCaretPosition(n2);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public String getLine(int n) {
        String string = "";
        try {
            int n2 = this.getLineStartOffset(n);
            int n3 = this.getLineEndOffset(n) - 1;
            int n4 = n3 - n2;
            if (n4 > 0) {
                string = this.getText(n2, n4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    protected int cursorToOffset(int n) {
        int n2 = -1;
        try {
            int n3 = this.getLineOfOffset(n);
            int n4 = n % this.m_charsPerLine;
            int n5 = n4 / 9;
            int n6 = n4 % 9;
            int n7 = n6 / 2;
            n2 = n3 * this.m_bytesPerLine + n5 * 4 + n7;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }

    protected int cursorToNibble(int n) {
        int n2 = 0;
        try {
            int n3 = this.getLineOfOffset(n);
            int n4 = n % this.m_charsPerLine;
            int n5 = n4 / 9;
            int n6 = n4 % 9;
            n2 = n6 % 2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }

    protected int offsetToCursor(int n) {
        int n2 = n / this.m_bytesPerLine;
        int n3 = n % this.m_bytesPerLine;
        int n4 = n3 / 4;
        int n5 = n3 % 4;
        int n6 = n2 * this.m_charsPerLine + n4 * (this.m_charsPerGroup + 1) + n5 * 2;
        return n6;
    }

    protected void ensureVisible(int n) {
        try {
            Rectangle rectangle = this.getVisibleRect();
            Rectangle rectangle2 = this.modelToView(n);
            if (!rectangle.contains(rectangle2)) {
                rectangle.x = 0;
                rectangle.y = rectangle2.y;
                this.scrollRectToVisible(rectangle);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public boolean isManagingFocus() {
        return false;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = keyEvent.getID() == 401;
        switch (keyEvent.getKeyCode()) {
            case 8: {
                int n;
                if (bl && (n = this.getCaretPosition()) > 0) {
                    this.m_cursorDirection = -1;
                    this.setCaretPosition(n - 1);
                }
                keyEvent.consume();
                break;
            }
            case 127: {
                if (bl) {
                    this.getToolkit().beep();
                }
                keyEvent.consume();
                break;
            }
            case 35: {
                if (bl) {
                    try {
                        if (keyEvent.getModifiers() == 2) {
                            this.setCaretPosition(this.getDocument().getLength() - 2);
                        } else {
                            this.setCaretPosition(this.getLineEndOffset(this.getLineOfOffset(this.getCaretPosition())) - 2);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                keyEvent.consume();
                break;
            }
            case 37: 
            case 38: 
            case 224: 
            case 226: {
                this.m_cursorDirection = -1;
                break;
            }
            default: {
                this.m_cursorDirection = 1;
                break;
            }
            case 27: {
                if (bl && this.m_editing) {
                    this.m_view.signalCancelEdit();
                }
                keyEvent.consume();
                break;
            }
            case 10: {
                if (bl && this.m_editing) {
                    this.m_view.signalAcceptEdit();
                }
                keyEvent.consume();
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyChar() == '\b') {
            return true;
        }
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
    }

    public void cut() {
    }

    public void replaceSelection(String string) {
        int n = this.getCaretPosition();
        int n2 = string.length();
        if (n2 == 0 || n >= this.getDocument().getLength()) {
            return;
        }
        if ((string = Util.validateHexData(string)) == null) {
            return;
        }
        n2 = string.length();
        if (this.hasSelection()) {
            this.setCaretPosition(this.getSelectionEnd());
            n = this.getCaretPosition();
        }
        if (n2 == 1) {
            this.replaceRange(string, n, n + 1);
            byte by = Byte.parseByte(string.substring(0, 1), 16);
            int n3 = this.cursorToOffset(n);
            this.m_bytes[n3] = this.cursorToNibble(n) == 0 ? (byte)(this.m_bytes[n3] & 0xF | by << 4) : (byte)(this.m_bytes[n3] & 0xF0 | by);
            this.m_view.hexModified(n3);
        } else {
            byte[] byArray = MemoryHexView.hexStringToByteArray(string);
            int n4 = this.cursorToOffset(n);
            int n5 = n4 + byArray.length < this.m_bytes.length ? byArray.length : this.m_bytes.length - n4;
            System.arraycopy(byArray, 0, this.m_bytes, n4, n5);
            this.refresh();
            this.m_view.hexModified();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(SettingsManager.getFixedPitchFont());
    }

    public void caretUpdate(CaretEvent caretEvent) {
        try {
            int n = this.getDocument().getLength();
            int n2 = caretEvent.getDot();
            if (n > 0 && !this.hasSelection()) {
                if (n2 < n) {
                    char c;
                    String string = this.getText(n2, 1);
                    if (string.length() > 0 && ((c = string.charAt(0)) == ' ' || c == '\n')) {
                        this.setCaretPosition(n2 + this.m_cursorDirection);
                    }
                } else {
                    this.setCaretPosition(n - 2);
                }
                if (this.m_cursorNotify) {
                    this.m_view.syncHexCursor(this.cursorToOffset(this.getCaretPosition()));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isPopupTrigger() && (n = this.viewToModel(mouseEvent.getPoint())) >= 0) {
            this.setCaretPosition(n);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isPopupTrigger() && (n = this.viewToModel(mouseEvent.getPoint())) >= 0) {
            this.setCaretPosition(n);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class ScrollTo
    implements Runnable {
        private int m_pos;

        public ScrollTo(int n) {
            this.m_pos = n;
        }

        public void run() {
            MemoryHexEditor.this.setCaretPosition(this.m_pos);
            MemoryHexEditor.this.ensureVisible(this.m_pos);
        }
    }

    private class ScrollToThread
    extends Thread {
        private int m_pos;

        public ScrollToThread(int n) {
            this.m_pos = n;
        }

        public void run() {
            Thread.yield();
            SwingUtilities.invokeLater(new ScrollTo(this.m_pos));
        }
    }
}

