/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.listener.PgmListener;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.request.AddPgmRequest;
import com.ibm.iseries.debug.request.RmvPgmRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugFile;
import com.ibm.iseries.debug.util.Manager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class PgmManager
extends Manager
implements DebugConstants {
    public static final String KEY = "pgmmgr";
    protected DebugContext m_ctxt;
    protected HashMap m_viewIdToPgm;
    protected HashMap m_viewIdToModule;
    protected HashMap m_viewIdToView;
    protected HashMap m_initialView;
    protected ArrayList m_pgms;
    protected ArrayList m_srvpgms;
    protected ArrayList m_classes;
    protected AddPgmRequest m_envRequest;
    protected ModuleDescriptor m_mainModule;

    public PgmManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        this.m_viewIdToPgm = new HashMap();
        this.m_viewIdToModule = new HashMap();
        this.m_viewIdToView = new HashMap();
        this.m_initialView = new HashMap();
        this.init();
    }

    public String getKey() {
        return KEY;
    }

    public void init() {
        if (this.m_pgms == null) {
            this.m_pgms = new ArrayList();
        }
        if (this.m_srvpgms == null) {
            this.m_srvpgms = new ArrayList();
        }
        if (this.m_classes == null) {
            this.m_classes = new ArrayList();
        }
    }

    public void clear() {
        super.clear();
        this.clearMaps();
        this.fireProgramsClearedEvent(new PgmEvent(this, 3));
    }

    public void cleanUp() {
        super.cleanUp();
        this.clearMaps();
        this.m_ctxt = null;
        this.m_viewIdToPgm = null;
        this.m_viewIdToModule = null;
        this.m_viewIdToView = null;
        this.m_initialView = null;
        this.m_pgms = null;
        this.m_srvpgms = null;
        this.m_classes = null;
        this.m_envRequest = null;
    }

    protected ArrayList pgmTypeToList(int n) {
        switch (n) {
            case 0: {
                return this.m_pgms;
            }
            case 1: {
                return this.m_srvpgms;
            }
            case 2: {
                return this.m_classes;
            }
        }
        return null;
    }

    public PgmDescriptor getProgram(String string) {
        return (PgmDescriptor)this.m_viewIdToPgm.get(string);
    }

    public ModuleDescriptor getModule(String string) {
        return (ModuleDescriptor)this.m_viewIdToModule.get(string);
    }

    public ModuleDescriptor getMainModule() {
        return this.m_mainModule;
    }

    public String getModuleName(String string) {
        String string2 = "";
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (moduleDescriptor != null) {
            string2 = moduleDescriptor.getModuleName();
        }
        return string2;
    }

    public MemoryAddress getModuleAddress(String string) {
        MemoryAddress memoryAddress = null;
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (moduleDescriptor != null) {
            memoryAddress = moduleDescriptor.getStartAddress();
        }
        return memoryAddress;
    }

    public ViewDescriptor getView(String string) {
        return (ViewDescriptor)this.m_viewIdToView.get(string);
    }

    public MemoryAddress getViewAddress(String string, int n) {
        ModuleDescriptor moduleDescriptor;
        MemoryAddress memoryAddress = null;
        ViewDescriptor viewDescriptor = (ViewDescriptor)this.m_viewIdToView.get(string);
        if (viewDescriptor != null && viewDescriptor.isAssembler() && (moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string)) != null) {
            memoryAddress = moduleDescriptor.getStartAddress().add((n - 1) * 4);
        }
        return memoryAddress;
    }

    public String getViewId(String string, String string2, int n, String string3) {
        String string4 = PgmDescriptor.getPgmPath(string, string2, n);
        ArrayList arrayList = this.pgmTypeToList(n);
        int n2 = Collections.binarySearch(arrayList, string4);
        if (n2 >= 0) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)arrayList.get(n2);
            int n3 = pgmDescriptor.getModuleCount();
            int n4 = 0;
            while (n4 < n3) {
                ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(n4);
                if (moduleDescriptor.getModuleName().equals(string3)) {
                    return moduleDescriptor.getViewId();
                }
                ++n4;
            }
        }
        return "";
    }

    public String getCompletePath(String string) {
        String string2 = "";
        PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_viewIdToPgm.get(string);
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (pgmDescriptor != null && moduleDescriptor != null) {
            string2 = PgmDescriptor.getCompletePath(pgmDescriptor.getPgmLibrary(), pgmDescriptor.getPgmName(), pgmDescriptor.getPgmType(), moduleDescriptor.getModuleName());
        }
        return string2;
    }

    public String getPgmPath(String string) {
        String string2 = "";
        PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_viewIdToPgm.get(string);
        if (pgmDescriptor != null) {
            string2 = pgmDescriptor.getPgmPath();
        }
        return string2;
    }

    public String getAlternateViewId(String string) {
        int n;
        ViewDescriptor viewDescriptor;
        String string2 = "";
        ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.m_viewIdToModule.get(string);
        if (moduleDescriptor != null && (viewDescriptor = moduleDescriptor.getCurrentView()).isSource() && (n = moduleDescriptor.getCurrentViewIndex()) < moduleDescriptor.getViewCount() - 1 && !(viewDescriptor = moduleDescriptor.getViewAt(n + 1)).isStatement()) {
            string2 = viewDescriptor.getViewId();
            moduleDescriptor.setCurrentViewIndex(n + 1);
        }
        return string2;
    }

    public int programSortOrder(String string, int n) {
        ArrayList arrayList = this.pgmTypeToList(n);
        if (arrayList != null) {
            return Collections.binarySearch(arrayList, string);
        }
        return 0;
    }

    public void setInitialViewIndex(String string, String string2, int n, String string3, int n2) {
        String string4 = PgmDescriptor.getPgmPath(string, string2, n) + "_" + string3;
        this.m_initialView.put(string4, new Integer(n2));
    }

    protected String setInitialViewId(PgmDescriptor pgmDescriptor, ModuleDescriptor moduleDescriptor) {
        String string = pgmDescriptor.getPgmPath() + "_" + moduleDescriptor.getModuleName();
        Integer n = (Integer)this.m_initialView.get(string);
        String string2 = moduleDescriptor.getViewId();
        if (n != null) {
            moduleDescriptor.setCurrentViewIndex(n);
            this.m_initialView.remove(string);
        }
        return string2;
    }

    public void fireProgramAddedEvent(PgmEvent pgmEvent) {
        int n;
        if (this.m_envRequest != null) {
            switch (pgmEvent.getInitiatedFrom()) {
                case 1: {
                    this.m_envRequest = null;
                    break;
                }
                case 0: {
                    return;
                }
                case -1: {
                    this.m_envRequest = null;
                    return;
                }
            }
        }
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        int n2 = pgmEvent.getCount();
        boolean bl = this.m_viewIdToPgm.isEmpty();
        boolean bl2 = !this.m_initialView.isEmpty();
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        if (bl) {
            string2 = this.m_ctxt.getPgmEnv().getEnvPgmPath();
        }
        int n3 = 0;
        while (n3 < n2) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n3);
            n = pgmDescriptor.getPgmType();
            int n4 = this.programSortOrder(pgmDescriptor.getPgmPath(), n);
            if (n4 < 0) {
                ArrayList arrayList = this.pgmTypeToList(n);
                arrayList.add(n4 * -1 - 1, pgmDescriptor);
                int n5 = pgmDescriptor.getModuleCount();
                int n6 = 0;
                while (n6 < n5) {
                    Object object;
                    ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(n6);
                    int n7 = moduleDescriptor.getViewCount();
                    int n8 = 0;
                    while (n8 < n7) {
                        object = moduleDescriptor.getViewAt(n8);
                        String string3 = ((ViewDescriptor)object).getViewId();
                        if (n8 == 0 && bl && !bl3 && ((ViewDescriptor)object).hasMain()) {
                            this.m_mainModule = moduleDescriptor;
                            string = string3;
                            if (pgmDescriptor.getPgmPath().equals(string2)) {
                                bl3 = true;
                            }
                        }
                        this.m_viewIdToPgm.put(string3, pgmDescriptor);
                        this.m_viewIdToModule.put(string3, moduleDescriptor);
                        this.m_viewIdToView.put(string3, object);
                        ++n8;
                    }
                    if (bl2 && string != null && ((String)(object = this.setInitialViewId(pgmDescriptor, moduleDescriptor))).equals(string)) {
                        string = moduleDescriptor.getViewId();
                    }
                    ++n6;
                }
            }
            ++n3;
        }
        int n9 = this.m_listeners.size();
        n = 0;
        while (n < n9) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(n);
            pgmListener.programAdded(pgmEvent);
            ++n;
        }
        if (bl && bl3) {
            sourceViewManager.autoRequestSourceView(string);
        }
    }

    public void fireProgramUpdatedEvent(PgmEvent pgmEvent) {
        int n;
        int n2 = pgmEvent.getCount();
        int n3 = 0;
        while (n3 < n2) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n3);
            n = pgmDescriptor.getPgmType();
            int n4 = this.programSortOrder(pgmDescriptor.getPgmPath(), n);
            if (n4 >= 0) {
                ArrayList arrayList = this.pgmTypeToList(n);
                PgmDescriptor pgmDescriptor2 = (PgmDescriptor)arrayList.get(n4);
                pgmEvent.setDescriptorAt(pgmDescriptor2.merge(pgmDescriptor), n3);
                int n5 = pgmDescriptor.getModuleCount();
                int n6 = 0;
                while (n6 < n5) {
                    ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(n6);
                    int n7 = moduleDescriptor.getViewCount();
                    int n8 = 0;
                    while (n8 < n7) {
                        ViewDescriptor viewDescriptor = moduleDescriptor.getViewAt(n8);
                        String string = viewDescriptor.getViewId();
                        this.m_viewIdToPgm.put(string, pgmDescriptor2);
                        this.m_viewIdToModule.put(string, moduleDescriptor);
                        this.m_viewIdToView.put(string, viewDescriptor);
                        ++n8;
                    }
                    ++n6;
                }
            }
            ++n3;
        }
        int n9 = this.m_listeners.size();
        n = 0;
        while (n < n9) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(n);
            pgmListener.programUpdated(pgmEvent);
            ++n;
        }
    }

    public void fireProgramRemovedEvent(PgmEvent pgmEvent) {
        Object object;
        int n;
        int n2 = pgmEvent.getCount();
        int n3 = 0;
        while (n3 < n2) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(n3);
            n = this.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType());
            if (n >= 0) {
                Object object2;
                object = this.m_ctxt.getDesktop();
                BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
                int n4 = pgmDescriptor.getModuleCount();
                int n5 = 0;
                while (n5 < n4) {
                    object2 = pgmDescriptor.getModuleAt(n5);
                    int n6 = ((ModuleDescriptor)object2).getViewCount();
                    int n7 = 0;
                    while (n7 < n6) {
                        String string = ((ModuleDescriptor)object2).getViewId(n7);
                        breakpointManager.clearBreakpoints(string);
                        object.closeSource(string);
                        this.m_viewIdToPgm.remove(string);
                        this.m_viewIdToModule.remove(string);
                        this.m_viewIdToView.remove(string);
                        ++n7;
                    }
                    ++n5;
                }
                object2 = this.pgmTypeToList(pgmDescriptor.getPgmType());
                ((ArrayList)object2).remove(n);
            }
            ++n3;
        }
        int n8 = this.m_listeners.size();
        n = 0;
        while (n < n8) {
            object = (PgmListener)this.m_listeners.get(n);
            object.programRemoved(pgmEvent);
            ++n;
        }
    }

    public void fireProgramsClearedEvent(PgmEvent pgmEvent) {
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            PgmListener pgmListener = (PgmListener)this.m_listeners.get(n2);
            pgmListener.programsCleared(pgmEvent);
            ++n2;
        }
    }

    protected void clearMaps() {
        this.m_viewIdToPgm.clear();
        this.m_viewIdToModule.clear();
        this.m_viewIdToView.clear();
        if (this.m_pgms != null) {
            this.m_pgms.clear();
        }
        if (this.m_srvpgms != null) {
            this.m_srvpgms.clear();
        }
        if (this.m_classes != null) {
            this.m_classes.clear();
        }
    }

    public void removeAll() {
        if (this.m_viewIdToPgm.size() > 0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.m_pgms);
            arrayList.addAll(this.m_srvpgms);
            arrayList.addAll(this.m_classes);
            if (arrayList.size() > 0) {
                RmvPgmRequest rmvPgmRequest = new RmvPgmRequest(arrayList);
                this.m_ctxt.sendRequest(rmvPgmRequest);
                RmvPgmRequest.cancelPending();
                arrayList.clear();
                this.clear();
            }
        }
    }

    public int openEnvironment(DebugFile debugFile, String string, String string2) throws IOException {
        String string3;
        this.clearMaps();
        int n = debugFile.readInt();
        int n2 = debugFile.readInt();
        int n3 = debugFile.readInt();
        int n4 = n + n2 + n3;
        if (n4 == 0) {
            return 0;
        }
        PgmDescriptor[] pgmDescriptorArray = new PgmDescriptor[n4];
        int n5 = 0;
        boolean bl = string.length() > 0 && string2.length() > 0;
        int n6 = 0;
        while (n6 < n) {
            String string4 = debugFile.readString();
            string3 = debugFile.readString();
            int n7 = debugFile.readInt();
            if (bl && string4.equals(string)) {
                string4 = string2;
            }
            pgmDescriptorArray[n5++] = new PgmDescriptor(string4, string3, n7);
            ++n6;
        }
        int n8 = 0;
        while (n8 < n2) {
            string3 = debugFile.readString();
            String string5 = debugFile.readString();
            int n9 = debugFile.readInt();
            if (bl && string3.equals(string)) {
                string3 = string2;
            }
            pgmDescriptorArray[n5++] = new PgmDescriptor(string3, string5, n9);
            ++n8;
        }
        int n10 = 0;
        while (n10 < n3) {
            String string6 = debugFile.readString();
            String string7 = debugFile.readString();
            int n11 = debugFile.readInt();
            if (bl && string6.equals(string)) {
                string6 = string2;
            }
            pgmDescriptorArray[n5++] = new PgmDescriptor(string6, string7, n11);
            ++n10;
        }
        if (this.m_ctxt.getPgmEnv().isAutoOpen()) {
            this.m_envRequest = new AddPgmRequest(pgmDescriptorArray);
            this.m_ctxt.sendRequest(this.m_envRequest);
        } else {
            AddPgmRequest addPgmRequest = new AddPgmRequest(pgmDescriptorArray);
            this.m_ctxt.sendRequest(addPgmRequest);
        }
        return n4;
    }

    public void saveEnvironment(DebugFile debugFile) throws IOException {
        int n = this.m_pgms.size();
        int n2 = this.m_srvpgms.size();
        int n3 = this.m_classes.size();
        debugFile.writeInt(n);
        debugFile.writeInt(n2);
        debugFile.writeInt(n3);
        int n4 = 0;
        while (n4 < n) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_pgms.get(n4);
            debugFile.writeString(pgmDescriptor.getPgmLibrary());
            debugFile.writeString(pgmDescriptor.getPgmName());
            debugFile.writeInt(pgmDescriptor.getPgmType());
            ++n4;
        }
        int n5 = 0;
        while (n5 < n2) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_srvpgms.get(n5);
            debugFile.writeString(pgmDescriptor.getPgmLibrary());
            debugFile.writeString(pgmDescriptor.getPgmName());
            debugFile.writeInt(pgmDescriptor.getPgmType());
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)this.m_classes.get(n6);
            debugFile.writeString(pgmDescriptor.getPgmLibrary());
            debugFile.writeString(pgmDescriptor.getPgmName());
            debugFile.writeInt(pgmDescriptor.getPgmType());
            ++n6;
        }
    }
}

