/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.Breakpoints;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.action.LnBrkRmvAllAction;
import com.ibm.iseries.debug.event.BreakpointEvent;
import com.ibm.iseries.debug.listener.BreakpointListener;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Manager;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class BreakpointManager
extends Manager
implements DebugConstants {
    public static final String KEY = "brkmgr";
    protected DebugContext m_ctxt;
    protected HashMap m_breakpoints;
    protected int m_totalCount;
    protected int m_pendingAdd;
    protected int m_pendingDisable;

    public BreakpointManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        this.m_breakpoints = new HashMap();
    }

    public String getKey() {
        return KEY;
    }

    public void clear() {
        super.clear();
        this.m_breakpoints.clear();
        this.m_totalCount = 0;
        this.m_pendingAdd = 0;
        this.m_pendingDisable = 0;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_breakpoints.clear();
        this.m_breakpoints = null;
        this.m_ctxt = null;
    }

    public void setPendingAdd(int n) {
        this.m_pendingAdd = n;
    }

    public void setPendingDisable(int n) {
        this.m_pendingDisable = n;
    }

    public boolean hasPendingBreakpoints() {
        return this.m_pendingAdd > 0 || this.m_pendingDisable > 0;
    }

    public boolean hasPendingAdd() {
        return this.m_pendingAdd > 0;
    }

    public boolean hasPendingDisable() {
        return this.m_pendingDisable > 0;
    }

    public boolean hasBreakpoints() {
        return this.m_totalCount > 0;
    }

    public boolean hasBreakpoints(String string) {
        Breakpoints breakpoints = (Breakpoints)this.m_breakpoints.get(string);
        if (breakpoints != null) {
            return breakpoints.getCount() > 0;
        }
        return false;
    }

    public void getAllBreakpoints(ArrayList arrayList) {
        Iterator iterator = this.m_breakpoints.values().iterator();
        while (iterator.hasNext()) {
            Breakpoints breakpoints = (Breakpoints)iterator.next();
            breakpoints.getDescriptors(arrayList);
        }
    }

    public ArrayList getAllBreakpoints() {
        ArrayList arrayList = new ArrayList();
        this.getAllBreakpoints(arrayList);
        return arrayList;
    }

    public Breakpoints getBreakpoints(String string) {
        Breakpoints breakpoints = (Breakpoints)this.m_breakpoints.get(string);
        if (breakpoints == null) {
            breakpoints = new Breakpoints();
            this.m_breakpoints.put(string, breakpoints);
        }
        return breakpoints;
    }

    public void fireBreakpointEvent(BreakpointEvent breakpointEvent) {
        int n = breakpointEvent.getCount();
        BreakpointDescriptor breakpointDescriptor = null;
        Breakpoints breakpoints = null;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            breakpointDescriptor = breakpointEvent.getDescriptorAt(n2);
            breakpoints = (Breakpoints)this.m_breakpoints.get(breakpointDescriptor.getViewId());
            if (breakpoints == null) {
                breakpoints = new Breakpoints();
                this.m_breakpoints.put(breakpointDescriptor.getViewId(), breakpoints);
            }
            switch (breakpointEvent.getType()) {
                case 1: 
                case 6: {
                    if (breakpointDescriptor.isError()) {
                        String string;
                        Object[] objectArray;
                        breakpointEvent.removeDescriptorAt(n2);
                        --n2;
                        --n;
                        if (breakpointDescriptor.getAddress() == null) {
                            objectArray = new Object[]{new Integer(breakpointDescriptor.getLineNum())};
                            string = MessageFormat.format(MRI.get("DBG_BREAK_ERROR_FMT"), objectArray);
                            this.m_ctxt.setMessage(string);
                        } else {
                            objectArray = new Object[]{breakpointDescriptor.getAddress()};
                            string = MessageFormat.format(MRI.get("DBG_ASM_BREAK_ERROR_FMT"), objectArray);
                            this.m_ctxt.setMessage(string);
                        }
                        if (!bl) {
                            bl = true;
                            Toolkit.getDefaultToolkit().beep();
                        }
                    } else if (breakpoints.breakpointExists(breakpointDescriptor.getLineNum())) {
                        breakpoints.put(breakpointDescriptor);
                    } else {
                        breakpoints.put(breakpointDescriptor);
                        ++this.m_totalCount;
                    }
                    if (this.m_pendingAdd <= 0) break;
                    --this.m_pendingAdd;
                    break;
                }
                case 2: 
                case 5: {
                    breakpoints.remove(breakpointDescriptor.getLineNum());
                    --this.m_totalCount;
                    break;
                }
                case 3: 
                case 4: {
                    if (breakpointDescriptor.isError()) {
                        breakpointEvent.removeDescriptorAt(n2);
                        --n2;
                        --n;
                    } else {
                        breakpoints.put(breakpointDescriptor);
                    }
                    if (this.m_pendingDisable <= 0 || breakpointEvent.getType() != 4) break;
                    --this.m_pendingDisable;
                }
            }
            ++n2;
        }
        if (n == 1) {
            this.m_ctxt.updateBreakpointActions(breakpointDescriptor);
        } else if (this.m_totalCount == 0) {
            this.m_ctxt.updateBreakpointActions();
        }
        int n3 = this.m_listeners.size();
        int n4 = 0;
        while (n4 < n3) {
            BreakpointListener breakpointListener = (BreakpointListener)this.m_listeners.get(n4);
            breakpointListener.breakpointChanged(breakpointEvent);
            ++n4;
        }
    }

    public void clearBreakpoints(String string) {
        Breakpoints breakpoints = (Breakpoints)this.m_breakpoints.get(string);
        if (breakpoints != null && breakpoints.getCount() > 0) {
            BreakpointEvent breakpointEvent = new BreakpointEvent((Object)this, 2, breakpoints.getDescriptors());
            this.fireBreakpointEvent(breakpointEvent);
            breakpointEvent.cleanUp();
        }
    }

    public void removeAll() {
        LnBrkRmvAllAction lnBrkRmvAllAction = (LnBrkRmvAllAction)this.m_ctxt.getAction("rabrk");
        lnBrkRmvAllAction.setPrompt(false);
        lnBrkRmvAllAction.run();
        lnBrkRmvAllAction.setPrompt(true);
        this.m_pendingAdd = 0;
        this.m_pendingDisable = 0;
    }
}

