/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.BreakpointGroup;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.event.BreakpointEvent;
import com.ibm.iseries.debug.event.BreakpointGroupEvent;
import com.ibm.iseries.debug.listener.BreakpointGroupListener;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugFile;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Manager;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.plaf.ColorUIResource;

public class BreakpointGroupManager
extends Manager
implements DebugConstants {
    public static final String KEY = "brkgrpmgr";
    protected DebugContext m_ctxt;
    protected HashMap m_byName;
    protected HashMap m_byId;
    protected int m_currentGroup = -1;
    protected ColorUIResource m_currentColor;
    protected int m_lastGroup = -1;
    protected ColorUIResource m_lastColor;
    protected ColorUIResource m_defaultColor;
    protected int m_nextGroupId = -1;

    public BreakpointGroupManager(DebugContext debugContext) {
        this.m_ctxt = debugContext;
        this.m_byName = new HashMap();
        this.m_byId = new HashMap();
        this.m_defaultColor = new ColorUIResource(Color.red);
    }

    public String getKey() {
        return KEY;
    }

    public void init() {
        this.createDefaultGroup();
    }

    public void clear() {
        super.clear();
        Iterator iterator = this.m_byName.values().iterator();
        while (iterator.hasNext()) {
            BreakpointGroup breakpointGroup = (BreakpointGroup)iterator.next();
            breakpointGroup.cleanUp();
        }
        this.m_byName.clear();
        this.m_byId.clear();
        this.m_currentGroup = -1;
        this.m_lastGroup = -1;
        this.m_nextGroupId = -1;
        this.m_currentColor = null;
        this.m_lastColor = null;
        this.fireBreakpointGroupEvent(new BreakpointGroupEvent(this, 2));
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_byName.clear();
        this.m_byId.clear();
        this.m_ctxt = null;
        this.m_byName = null;
        this.m_byId = null;
        this.m_currentColor = null;
        this.m_lastColor = null;
        this.m_defaultColor = null;
    }

    public int getCount() {
        return this.m_byId.size();
    }

    public boolean groupExists(String string) {
        return this.m_byName.get(string) != null;
    }

    public int getGroupCount() {
        return this.m_byName.size();
    }

    public BreakpointGroup getGroup(String string) {
        return (BreakpointGroup)this.m_byName.get(string);
    }

    public BreakpointGroup getGroup(int n) {
        return (BreakpointGroup)this.m_byId.get(new Integer(n));
    }

    public BreakpointGroup getCurrentGroup() {
        return (BreakpointGroup)this.m_byId.get(new Integer(this.getCurrentGroupId()));
    }

    public ArrayList getGroups() {
        ArrayList<BreakpointGroup> arrayList = new ArrayList<BreakpointGroup>(this.m_byName.size());
        Iterator iterator = this.m_byName.values().iterator();
        while (iterator.hasNext()) {
            BreakpointGroup breakpointGroup = (BreakpointGroup)iterator.next();
            arrayList.add(breakpointGroup);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public int sortOrder(String string) {
        ArrayList<BreakpointGroup> arrayList = new ArrayList<BreakpointGroup>(this.m_byName.size());
        Iterator iterator = this.m_byName.values().iterator();
        while (iterator.hasNext()) {
            BreakpointGroup breakpointGroup = (BreakpointGroup)iterator.next();
            arrayList.add(breakpointGroup);
        }
        Collections.sort(arrayList);
        int n = Collections.binarySearch(arrayList, string);
        arrayList.clear();
        return n;
    }

    public void addGroup(BreakpointGroup breakpointGroup, boolean bl) {
        this.m_byName.put(breakpointGroup.getGroupName(), breakpointGroup);
        this.m_byId.put(new Integer(breakpointGroup.getGroupId()), breakpointGroup);
        if (bl) {
            this.fireBreakpointGroupEvent(new BreakpointGroupEvent(this, 3, breakpointGroup));
        }
    }

    public BreakpointGroup addGroup(String string, ColorUIResource colorUIResource, boolean bl) {
        BreakpointGroup breakpointGroup = null;
        if (!this.groupExists(string)) {
            breakpointGroup = new BreakpointGroup(this.m_ctxt, string, ++this.m_nextGroupId, colorUIResource);
            this.addGroup(breakpointGroup, bl);
        } else {
            breakpointGroup = (BreakpointGroup)this.m_byName.get(string);
        }
        return breakpointGroup;
    }

    public void removeGroup(String string, boolean bl) {
        String[] stringArray = new String[]{string};
        this.removeGroups(stringArray, bl);
    }

    public void removeGroups(String[] stringArray, boolean bl) {
        Object object;
        BreakpointGroup breakpointGroup;
        boolean bl2 = false;
        BreakpointGroup[] breakpointGroupArray = new BreakpointGroup[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            breakpointGroup = (BreakpointGroup)this.m_byName.get(stringArray[n2]);
            if (breakpointGroup != null) {
                this.m_byName.remove(breakpointGroup.getGroupName());
                this.m_byId.remove(new Integer(breakpointGroup.getGroupId()));
                breakpointGroupArray[n++] = breakpointGroup;
                if (!bl2 && breakpointGroup.getGroupId() == this.m_currentGroup) {
                    bl2 = true;
                }
            }
            ++n2;
        }
        if (bl2) {
            breakpointGroup = (BreakpointGroup)this.m_byName.get(MRI.get("DBG_DEFAULT"));
            if (breakpointGroup == null) {
                object = this.m_byName.keySet().iterator();
                this.setCurrentGroup((String)object.next());
            } else {
                this.setCurrentGroup(breakpointGroup.getGroupName());
            }
        }
        int n3 = 0;
        while (n3 < breakpointGroupArray.length) {
            if (breakpointGroupArray[n3] != null) {
                if (bl) {
                    this.fireBreakpointGroupEvent(new BreakpointGroupEvent(this, 4, breakpointGroupArray[n3]));
                }
                if (breakpointGroupArray[n3].hasBreakpoints()) {
                    object = breakpointGroupArray[n3].getDescriptors();
                    breakpointGroupArray[n3].cleanUp();
                    this.m_ctxt.getActionGroup().setLnBrkContext((ArrayList)object);
                    this.m_ctxt.getAction("rbrk").run();
                } else {
                    breakpointGroupArray[n3].cleanUp();
                }
            }
            breakpointGroupArray[n3] = null;
            ++n3;
        }
    }

    public void changeGroup(String string, String string2, ColorUIResource colorUIResource, boolean bl) {
        BreakpointGroup breakpointGroup = (BreakpointGroup)this.m_byName.get(string);
        if (breakpointGroup != null) {
            ColorUIResource colorUIResource2 = breakpointGroup.getColor();
            if (!string2.equals(string) || !colorUIResource.equals(colorUIResource2)) {
                breakpointGroup.setGroupName(string2);
                breakpointGroup.setColor(colorUIResource);
                this.m_byName.remove(string);
                this.m_byName.put(string2, breakpointGroup);
                if (this.m_currentGroup == breakpointGroup.getGroupId()) {
                    this.m_currentColor = colorUIResource;
                }
                if (this.m_lastGroup == breakpointGroup.getGroupId()) {
                    this.m_lastColor = colorUIResource;
                }
                if (bl) {
                    this.fireBreakpointGroupEvent(new BreakpointGroupEvent(this, 5, breakpointGroup, string, colorUIResource2));
                }
            }
        }
    }

    public String getGroupName(int n) {
        BreakpointGroup breakpointGroup = this.getGroup(n);
        if (breakpointGroup != null) {
            return breakpointGroup.getGroupName();
        }
        return "";
    }

    public ColorUIResource getGroupColor(String string) {
        BreakpointGroup breakpointGroup = this.getGroup(string);
        if (breakpointGroup != null) {
            return breakpointGroup.getColor();
        }
        return this.m_defaultColor;
    }

    public ColorUIResource getGroupColor(int n) {
        if (n == this.m_currentGroup) {
            return this.m_currentColor;
        }
        if (n == this.m_lastGroup) {
            return this.m_lastColor;
        }
        BreakpointGroup breakpointGroup = this.getGroup(n);
        if (breakpointGroup != null) {
            return breakpointGroup.getColor();
        }
        return this.m_defaultColor;
    }

    public void setCurrentGroup(String string) {
        BreakpointGroup breakpointGroup = this.getGroup(string);
        if (breakpointGroup != null) {
            this.m_currentGroup = breakpointGroup.getGroupId();
            this.m_currentColor = breakpointGroup.getColor();
            this.m_lastGroup = this.m_currentGroup;
            this.m_lastColor = this.m_currentColor;
        }
    }

    public void setCurrentGroup(int n) {
        BreakpointGroup breakpointGroup = this.getGroup(n);
        if (breakpointGroup != null) {
            this.m_currentGroup = n;
            this.m_currentColor = breakpointGroup.getColor();
            this.m_lastGroup = n;
            this.m_lastColor = this.m_currentColor;
        } else if (n < 0) {
            this.m_currentGroup = -1;
            this.m_currentColor = null;
            this.m_lastGroup = -1;
            this.m_lastColor = null;
        }
    }

    public String getCurrentGroupName() {
        BreakpointGroup breakpointGroup = this.getGroup(this.m_currentGroup);
        return breakpointGroup != null ? breakpointGroup.getGroupName() : "";
    }

    public int getCurrentGroupId() {
        return this.m_currentGroup;
    }

    public ColorUIResource getCurrentGroupColor() {
        return this.m_currentColor;
    }

    public void moveBreakpoints(int n, int n2, ArrayList arrayList) {
        Object object;
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        BreakpointManager breakpointManager = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
        BreakpointEvent breakpointEvent = new BreakpointEvent((Object)this, 5, arrayList2);
        breakpointManager.fireBreakpointEvent(breakpointEvent);
        breakpointEvent.cleanUp();
        int n3 = arrayList2.size();
        int n4 = 0;
        while (n4 < n3) {
            object = (BreakpointDescriptor)arrayList2.get(n4);
            ((BreakpointDescriptor)object).setGroupId(n2);
            ++n4;
        }
        object = new BreakpointEvent((Object)this, 6, arrayList2);
        breakpointManager.fireBreakpointEvent((BreakpointEvent)object);
        ((BreakpointEvent)object).cleanUp();
        arrayList2.clear();
    }

    public void fireBreakpointGroupEvent(BreakpointGroupEvent breakpointGroupEvent) {
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            BreakpointGroupListener breakpointGroupListener = (BreakpointGroupListener)this.m_listeners.get(n2);
            breakpointGroupListener.breakpointGroupChanged(breakpointGroupEvent);
            ++n2;
        }
    }

    private void createDefaultGroup() {
        BreakpointGroup breakpointGroup = new BreakpointGroup(this.m_ctxt, MRI.get("DBG_DEFAULT"), ++this.m_nextGroupId, this.m_defaultColor);
        this.addGroup(breakpointGroup, false);
        this.setCurrentGroup(breakpointGroup.getGroupName());
        this.fireBreakpointGroupEvent(new BreakpointGroupEvent(this, 1));
    }

    public int openEnvironment(DebugFile debugFile, String string, String string2) throws IOException {
        DebugConstants debugConstants;
        int n = 0;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n2 = debugFile.readInt();
        this.m_currentGroup = debugFile.readInt();
        int n3 = 0;
        while (n3 < n2) {
            debugConstants = new BreakpointGroup(this.m_ctxt);
            n += ((BreakpointGroup)debugConstants).read(debugFile, string, string2, arrayList, arrayList2);
            this.addGroup((BreakpointGroup)debugConstants, false);
            if (((BreakpointGroup)debugConstants).getGroupId() >= this.m_nextGroupId) {
                this.m_nextGroupId = ((BreakpointGroup)debugConstants).getGroupId();
            }
            if (this.m_currentGroup < 0) {
                this.m_currentGroup = ((BreakpointGroup)debugConstants).getGroupId();
            }
            ++n3;
        }
        if (n2 > 0) {
            int n4;
            this.setCurrentGroup(this.m_currentGroup);
            this.fireBreakpointGroupEvent(new BreakpointGroupEvent(this, 1));
            debugConstants = (BreakpointManager)this.m_ctxt.getManager("brkmgr");
            int n5 = arrayList.size();
            if (n5 > 0) {
                this.m_ctxt.getActionGroup().setLnBrkContext(arrayList);
                this.m_ctxt.getAction("abrk").run();
                arrayList.clear();
                ((BreakpointManager)debugConstants).setPendingAdd(n5);
            }
            if ((n4 = arrayList2.size()) > 0) {
                this.m_ctxt.getActionGroup().setLnBrkContext(arrayList2);
                this.m_ctxt.getAction("dbrk").run();
                arrayList2.clear();
                ((BreakpointManager)debugConstants).setPendingDisable(n4);
            }
        } else {
            this.createDefaultGroup();
        }
        return n;
    }

    public void saveEnvironment(DebugFile debugFile) throws IOException {
        ArrayList arrayList = this.getGroups();
        int n = arrayList.size();
        debugFile.writeInt(n);
        debugFile.writeInt(this.m_currentGroup);
        int n2 = 0;
        while (n2 < n) {
            BreakpointGroup breakpointGroup = (BreakpointGroup)arrayList.get(n2);
            breakpointGroup.write(debugFile);
            ++n2;
        }
    }
}

