/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.event;

import com.ibm.iseries.debug.event.DebuggerEvent;
import com.ibm.iseries.debug.memory.MemoryAddress;

public class SourceViewEvent
extends DebuggerEvent {
    public static final int SOURCE_VIEW = 1;
    public static final int ASSEMBLER_VIEW = 2;
    private String m_viewId;
    private String m_source;
    private MemoryAddress m_startAddr;
    private int m_startLineNum;
    private int m_endLineNum;
    private int m_lineCount;

    public SourceViewEvent(Object object, String string, String string2, int n, int n2, int n3) {
        super(object, 1);
        this.m_viewId = string;
        this.m_source = string2;
        this.m_startLineNum = n;
        this.m_endLineNum = n2;
        this.m_lineCount = n3;
    }

    public SourceViewEvent(Object object, String string, String string2, MemoryAddress memoryAddress, int n, int n2, int n3) {
        super(object, 2);
        this.m_viewId = string;
        this.m_source = string2;
        this.m_startAddr = memoryAddress;
        this.m_startLineNum = n;
        this.m_endLineNum = n2;
        this.m_lineCount = n3;
    }

    public void cleanUp() {
        this.m_viewId = null;
        this.m_source = null;
        this.m_startAddr = null;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public boolean isAssemblerSource() {
        return this.m_type == 2;
    }

    public String getSourceCode() {
        return this.m_source;
    }

    public MemoryAddress getStartAddress() {
        return this.m_startAddr;
    }

    public int getStartLineNum() {
        return this.m_startLineNum;
    }

    public void setStartLineNum(int n) {
        this.m_startLineNum = n;
    }

    public int getEndLineNum() {
        return this.m_endLineNum;
    }

    public void setEndLineNum(int n) {
        this.m_endLineNum = n;
    }

    public int getTotalLineCount() {
        return this.m_lineCount;
    }

    public void setTotalLineCount(int n) {
        this.m_lineCount = n;
    }

    public boolean isFullSource() {
        return this.m_startLineNum == 1 && this.m_endLineNum == this.m_lineCount;
    }

    public boolean containsLineNum(String string, int n) {
        return n >= this.m_startLineNum && n <= this.m_endLineNum && this.m_viewId.equals(string);
    }
}

