/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FindDialog
extends Dialog {
    private static String TEXT = "text";
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_ctrlPanel;
    private JTextField m_textCtrl;
    private JRadioButton m_upCtrl;
    private JRadioButton m_downCtrl;
    private JCheckBox m_wrapCtrl;
    private String m_text;
    private int m_direction;
    private boolean m_wrap;

    public FindDialog(JFrame jFrame, String string, int n, boolean bl) {
        super(jFrame, MRI.get("DBG_FIND"), true, "");
        this.m_text = string;
        this.m_direction = n;
        this.m_wrap = bl;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_ctrlPanel = new JPanel();
        this.m_ctrlPanel.setLayout(new BoxLayout(this.m_ctrlPanel, 1));
        this.m_ctrlPanel.setBorder(this.getEmptyBorder(15, 10, 0, 10));
        this.m_basePanel.add((Component)this.m_ctrlPanel, "North");
        this.m_panel.setBorder(this.getEmptyBorder(0, 10, 10, 10));
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK"), true, false), "South");
        this.setContentPane(this.m_panel);
        this.addComponents();
        this.addWindowListener(new WndAdapter());
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_ctrlPanel = null;
        this.m_textCtrl = null;
        this.m_upCtrl = null;
        this.m_downCtrl = null;
        this.m_wrapCtrl = null;
    }

    public String getText() {
        return this.m_text;
    }

    public int getDirection() {
        return this.m_direction;
    }

    public boolean getWrap() {
        return this.m_wrap;
    }

    private void addComponents() {
        this.listenForEscape(this.m_panel);
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_FIND_TEXT_LABEL"));
        jLabel.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        this.m_textCtrl = new JTextField(this.m_text, 20);
        this.m_textCtrl.setActionCommand(TEXT);
        this.m_textCtrl.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = MRI.get("DBG_UP");
        String string2 = MRI.get("DBG_DOWN");
        String string3 = MRI.get("DBG_WRAP");
        this.m_upCtrl = new JRadioButton(string, this.m_direction < 0);
        this.m_downCtrl = new JRadioButton(string2, this.m_direction > 0);
        this.m_upCtrl.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        this.m_downCtrl.setHorizontalAlignment(this.m_isLtoR ? 2 : 4);
        buttonGroup.add(this.m_upCtrl);
        buttonGroup.add(this.m_downCtrl);
        jPanel.setBorder(this.getTitledBorder(MRI.get("DBG_DIRECTION")));
        jPanel.add(this.m_upCtrl);
        jPanel.add(this.m_downCtrl);
        this.m_wrapCtrl = new JCheckBox(string3, this.m_wrap);
        jLabel.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_textCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        jPanel.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_wrapCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_ctrlPanel.add(jLabel);
        this.m_ctrlPanel.add(this.m_textCtrl);
        this.m_ctrlPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.m_ctrlPanel.add(jPanel);
        this.m_ctrlPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.m_ctrlPanel.add(this.m_wrapCtrl);
        Util.setAccessible((Accessible)this.m_textCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_upCtrl, string);
        Util.setAccessible((Accessible)this.m_downCtrl, string2);
        Util.setAccessible((Accessible)this.m_wrapCtrl, string3);
        Util.setOrientation(this.m_textCtrl, jLabel);
        Util.setOrientation(this.m_upCtrl);
        Util.setOrientation(this.m_downCtrl);
        Util.setOrientation(this.m_wrapCtrl);
    }

    public void doOk() {
        this.m_text = this.m_textCtrl.getText();
        this.m_direction = this.m_downCtrl.isSelected() ? 1 : -1;
        this.m_wrap = this.m_wrapCtrl.isSelected();
        if (this.m_text.length() == 0) {
            this.getToolkit().beep();
            this.m_textCtrl.requestFocus();
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals(TEXT) || string.equals("doit")) {
            this.doOk();
        }
    }

    private class WndAdapter
    extends WindowAdapter {
        private WndAdapter() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            FindDialog.this.m_textCtrl.requestFocus();
            FindDialog.this.m_textCtrl.selectAll();
        }
    }
}

