/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.RequestPacketElement;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;

public class JobDescriptor
implements RequestPacketElement,
Comparable {
    public static final int SORT_JOB_NAME = 0;
    public static final int SORT_JOB_USER = 1;
    public static final int SORT_JOB_NUM = 2;
    private static int s_sortMode = 1;
    private String m_jobName;
    private String m_jobUser;
    private String m_jobNumber;

    public static int getSortMode() {
        return s_sortMode;
    }

    public static void setSortMode(int n) {
        s_sortMode = n;
    }

    public String getJobName() {
        return this.m_jobName;
    }

    public String getJobUser() {
        return this.m_jobUser;
    }

    public String getJobNumber() {
        return this.m_jobNumber;
    }

    public String toString() {
        return this.m_jobNumber + "/" + this.m_jobUser + "/" + this.m_jobName;
    }

    public void read(CommLink commLink) throws IOException {
        this.m_jobName = commLink.readString();
        this.m_jobUser = commLink.readString();
        this.m_jobNumber = commLink.readString();
        this.m_jobName = Util.firstUpper(this.m_jobName);
        this.m_jobUser = Util.firstUpper(this.m_jobUser);
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_jobName);
        n += commLink.writeSize(this.m_jobUser);
        return n += commLink.writeSize(this.m_jobNumber);
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeString(this.m_jobName);
        commLink.writeString(this.m_jobUser);
        commLink.writeString(this.m_jobNumber);
    }

    public int compareTo(Object object) {
        if (object instanceof JobDescriptor) {
            JobDescriptor jobDescriptor = (JobDescriptor)object;
            switch (s_sortMode) {
                case 0: {
                    if (!this.m_jobName.equals(jobDescriptor.m_jobName)) {
                        return this.m_jobName.compareTo(jobDescriptor.m_jobName);
                    }
                    if (!this.m_jobUser.equals(jobDescriptor.m_jobUser)) {
                        return this.m_jobUser.compareTo(jobDescriptor.m_jobUser);
                    }
                    return this.m_jobNumber.compareTo(jobDescriptor.m_jobNumber);
                }
                case 1: {
                    if (!this.m_jobUser.equals(jobDescriptor.m_jobUser)) {
                        return this.m_jobUser.compareTo(jobDescriptor.m_jobUser);
                    }
                    if (!this.m_jobName.equals(jobDescriptor.m_jobName)) {
                        return this.m_jobName.compareTo(jobDescriptor.m_jobName);
                    }
                    return this.m_jobNumber.compareTo(jobDescriptor.m_jobNumber);
                }
                case 2: {
                    return this.m_jobNumber.compareTo(jobDescriptor.m_jobNumber);
                }
            }
        }
        return this.toString().compareTo(object.toString());
    }
}

