/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.html.URLEncoder;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;

public class ServletHyperlink
extends HTMLHyperlink {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6349134986210346587L;
    private HttpServletResponse response_;
    private String pathInfo_;
    transient PropertyChangeSupport changes_;

    public ServletHyperlink() {
    }

    public ServletHyperlink(String string) {
        super(string);
    }

    public ServletHyperlink(String string, String string2) {
        super(string, string2);
    }

    public ServletHyperlink(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public ServletHyperlink(String string, String string2, String string3, String string4, HttpServletResponse httpServletResponse) {
        super(string, string2, string3);
        this.setPathInfo(string4);
        this.setHttpServletResponse(httpServletResponse);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public Object clone() {
        ServletHyperlink servletHyperlink = new ServletHyperlink();
        try {
            if (this.getHttpServletResponse() != null) {
                servletHyperlink.setHttpServletResponse(this.getHttpServletResponse());
            }
            if (this.getProperties() != null) {
                servletHyperlink.setProperties(this.getProperties());
            }
            if (this.getLocation() != null) {
                servletHyperlink.setLocation(this.getLocation());
            }
            if (this.getPathInfo() != null) {
                servletHyperlink.setPathInfo(this.getPathInfo());
            }
            if (this.getAttributes() != null) {
                servletHyperlink.setAttributes(this.getAttributes());
            }
            if (this.getLink() != null) {
                servletHyperlink.setLink(this.getLink());
            }
            if (this.getTarget() != null) {
                servletHyperlink.setTarget(this.getTarget());
            }
            if (this.getText() != null) {
                servletHyperlink.setText(this.getText());
            }
            if (this.getTitle() != null) {
                servletHyperlink.setTitle(this.getTitle());
            }
            if (this.getDirection() != null) {
                servletHyperlink.setDirection(this.getDirection());
            }
            if (this.getLanguage() != null) {
                servletHyperlink.setLanguage(this.getLanguage());
            }
            if (this.getName() != null) {
                servletHyperlink.setName(this.getName());
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return servletHyperlink;
    }

    String getDirectionTag() {
        if (this.getDirection() != null && this.getDirection().length() > 0) {
            return " dir=\"" + this.getDirection() + "\"";
        }
        return "";
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response_;
    }

    String getLanguageTag() {
        if (this.getLanguage() != null && this.getLanguage().length() > 0) {
            return " lang=\"" + this.getLanguage() + "\"";
        }
        return "";
    }

    public String getPathInfo() {
        return this.pathInfo_;
    }

    public String getTag() {
        return this.getTag(this.getText(), this.getProperties());
    }

    public String getTag(String string, Properties properties) {
        String string2;
        String string3;
        CharSequence charSequence;
        Object object;
        CharSequence charSequence2;
        if (this.getLink() == null) {
            Trace.log(2, "Attempting to get tag before setting the link.");
            throw new ExtendedIllegalStateException("link", 4);
        }
        if (string == null) {
            throw new NullPointerException("text");
        }
        StringBuffer stringBuffer = new StringBuffer(this.getLink());
        if (this.pathInfo_ != null) {
            this.pathInfo_ = this.getLink().endsWith("/") ? (this.pathInfo_.startsWith("/") ? this.pathInfo_.substring(1) : this.pathInfo_) : (this.pathInfo_.startsWith("/") ? this.pathInfo_ : "/" + this.pathInfo_);
            stringBuffer.append(URLEncoder.encode(this.pathInfo_, false));
        }
        if (properties != null) {
            charSequence2 = "?";
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                charSequence = (String)object.nextElement();
                stringBuffer.append((String)charSequence2);
                stringBuffer.append(URLEncoder.encode((String)charSequence));
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode(properties.getProperty((String)charSequence)));
                charSequence2 = "&";
            }
        }
        charSequence = new StringBuffer();
        if (this.response_ != null) {
            ((StringBuffer)charSequence).append(this.response_.encodeUrl(stringBuffer.toString()));
        } else {
            ((StringBuffer)charSequence).append(stringBuffer.toString());
        }
        charSequence2 = new StringBuffer();
        ((StringBuffer)charSequence2).append("<a href=\"");
        ((StringBuffer)charSequence2).append(((StringBuffer)charSequence).toString());
        object = this.getLocation();
        if (object != null) {
            ((StringBuffer)charSequence2).append("#");
            ((StringBuffer)charSequence2).append((String)object);
        }
        ((StringBuffer)charSequence2).append("\"");
        String string4 = this.getName();
        if (string4 != null) {
            ((StringBuffer)charSequence2).append(" name=\"");
            ((StringBuffer)charSequence2).append(string4);
            ((StringBuffer)charSequence2).append("\"");
        }
        if ((string3 = this.getTitle()) != null) {
            ((StringBuffer)charSequence2).append(" title=\"");
            ((StringBuffer)charSequence2).append(string3);
            ((StringBuffer)charSequence2).append("\"");
        }
        if ((string2 = this.getTarget()) != null) {
            ((StringBuffer)charSequence2).append(" target=\"");
            ((StringBuffer)charSequence2).append(string2);
            ((StringBuffer)charSequence2).append("\"");
        }
        ((StringBuffer)charSequence2).append(this.getLanguageTag());
        ((StringBuffer)charSequence2).append(this.getDirectionTag());
        ((StringBuffer)charSequence2).append(this.getAttributeString());
        ((StringBuffer)charSequence2).append(">");
        ((StringBuffer)charSequence2).append(string);
        ((StringBuffer)charSequence2).append("</a>");
        return ((StringBuffer)charSequence2).toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        if (httpServletResponse == null) {
            throw new NullPointerException("response");
        }
        HttpServletResponse httpServletResponse2 = this.response_;
        this.response_ = httpServletResponse;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("response", httpServletResponse2, httpServletResponse);
        }
    }

    public void setPathInfo(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        String string2 = this.pathInfo_;
        this.pathInfo_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("path", string2, string);
        }
    }
}

