/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLHyperlink;
import com.ibm.as400.util.html.HTMLTable;
import com.ibm.as400.util.html.HTMLTableCaption;
import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTableHeader;
import com.ibm.as400.util.html.HTMLTableRow;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import com.ibm.as400.util.html.HTMLText;
import com.ibm.as400.util.html.LineLayoutFormPanel;
import com.ibm.as400.util.servlet.RowData;
import com.ibm.as400.util.servlet.RowDataException;
import com.ibm.as400.util.servlet.RowMetaData;
import com.ibm.as400.util.servlet.SectionCompletedListener;
import com.ibm.as400.util.servlet.SectionCompletedSupport;
import com.ibm.as400.util.servlet.StringConverter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLFormConverter
extends StringConverter
implements Serializable,
HTMLConstants {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = -6301275216248287290L;
    private HTMLTable htmlTable_ = new HTMLTable();
    private HTMLHyperlink[] links_;
    private transient Vector completedListeners_;
    private transient SectionCompletedSupport sectionCompletedSupport_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;

    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (actionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.completedListeners_ == null) {
            this.completedListeners_ = new Vector();
        }
        this.completedListeners_.addElement(actionCompletedListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
        this.htmlTable_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addSectionCompletedListener(SectionCompletedListener sectionCompletedListener) {
        if (this.sectionCompletedSupport_ == null) {
            this.sectionCompletedSupport_ = new SectionCompletedSupport(this);
        }
        this.sectionCompletedSupport_.addSectionCompletedListener(sectionCompletedListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
        this.htmlTable_.addVetoableChangeListener(vetoableChangeListener);
    }

    private Vector convertRowData(RowData rowData, RowMetaData rowMetaData) throws PropertyVetoException, RowDataException {
        HTMLTable hTMLTable;
        if (rowMetaData == null) {
            Trace.log(2, "The rowdata's metadata attribute is invalid.");
            throw new ExtendedIllegalStateException("rowdata metadata", 4);
        }
        Vector<HTMLTable> vector = new Vector<HTMLTable>();
        int n = rowMetaData.getColumnCount();
        HTMLTableHeader[] hTMLTableHeaderArray = this.createFormHeader(rowMetaData);
        if (rowData.length() == 0) {
            hTMLTable = this.createDefaultTable(hTMLTableHeaderArray);
            vector.addElement(hTMLTable);
            if (this.sectionCompletedSupport_ != null) {
                this.sectionCompletedSupport_.fireSectionCompleted(hTMLTable.getTag());
            }
        } else {
            rowData.beforeFirst();
        }
        while (rowData.next()) {
            hTMLTable = this.createDefaultTable(hTMLTableHeaderArray);
            for (int i = 0; i < n; ++i) {
                Object object;
                HTMLTableRow hTMLTableRow = hTMLTable.getRow(i);
                HTMLTableCell hTMLTableCell = new HTMLTableCell();
                Vector vector2 = rowData.getObjectProperties(i);
                if (vector2 != null) {
                    int n2 = vector2.size();
                    for (int j = 0; j < n2; ++j) {
                        if (!(vector2.elementAt(j) instanceof HTMLTableCell)) continue;
                        hTMLTableCell = (HTMLTableCell)vector2.elementAt(j);
                    }
                }
                if ((object = rowData.getObject(i)) == null) {
                    object = new LineLayoutFormPanel();
                }
                try {
                    hTMLTableCell.setElement((HTMLTagElement)object);
                }
                catch (ClassCastException classCastException) {
                    hTMLTableCell.setElement(new HTMLText(object.toString()));
                }
                if (rowMetaData.getColumnAlignment(i) != null) {
                    hTMLTableCell.setHorizontalAlignment(rowMetaData.getColumnAlignment(i));
                }
                if (rowMetaData.getColumnDirection(i) != null) {
                    hTMLTableCell.setDirection(rowMetaData.getColumnDirection(i));
                }
                hTMLTableRow.addColumn(hTMLTableCell);
                hTMLTable.setRow(hTMLTableRow, i);
            }
            vector.addElement(hTMLTable);
            if (this.sectionCompletedSupport_ == null) continue;
            this.sectionCompletedSupport_.fireSectionCompleted(hTMLTable.getTag());
        }
        this.fireCompleted();
        return vector;
    }

    public HTMLTable[] convertToForms(RowData rowData) throws PropertyVetoException, RowDataException {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        Vector vector = this.convertRowData(rowData, rowData.getMetaData());
        Object[] objectArray = new HTMLTable[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private HTMLTable createDefaultTable(HTMLTableHeader[] hTMLTableHeaderArray) {
        HTMLTable hTMLTable = new HTMLTable();
        try {
            if (this.htmlTable_.getCaption() != null) {
                hTMLTable.setCaption(this.htmlTable_.getCaption());
            }
            if (this.htmlTable_.getAlignment() != null) {
                hTMLTable.setAlignment(this.htmlTable_.getAlignment());
            }
            hTMLTable.setBorderWidth(this.htmlTable_.getBorderWidth());
            hTMLTable.setCellPadding(this.htmlTable_.getCellPadding());
            hTMLTable.setCellSpacing(this.htmlTable_.getCellSpacing());
            hTMLTable.setWidth(this.htmlTable_.getWidth(), this.htmlTable_.isWidthInPercent());
            hTMLTable.setHeaderInUse(false);
            if (this.htmlTable_.getLanguage() != null) {
                hTMLTable.setLanguage(this.htmlTable_.getLanguage());
            }
            if (this.htmlTable_.getDirection() != null) {
                hTMLTable.setDirection(this.htmlTable_.getDirection());
            }
            for (int i = 0; i < hTMLTableHeaderArray.length; ++i) {
                HTMLTableRow hTMLTableRow = new HTMLTableRow();
                hTMLTableRow.addColumn(hTMLTableHeaderArray[i]);
                hTMLTable.addRow(hTMLTableRow);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return hTMLTable;
    }

    private HTMLTableHeader[] createFormHeader(RowMetaData rowMetaData) throws PropertyVetoException, RowDataException {
        int n = rowMetaData.getColumnCount();
        HTMLTableHeader[] hTMLTableHeaderArray = new HTMLTableHeader[n];
        for (int i = 0; i < n; ++i) {
            HTMLTagAttributes hTMLTagAttributes;
            hTMLTableHeaderArray[i] = new HTMLTableHeader();
            String string = "";
            try {
                string = rowMetaData.getColumnLabel(i);
            }
            catch (NullPointerException nullPointerException) {
                string = rowMetaData.getColumnName(i);
            }
            if (this.links_ != null && this.links_[i] != null) {
                hTMLTagAttributes = this.links_[i];
                ((HTMLHyperlink)hTMLTagAttributes).setText(string);
                hTMLTableHeaderArray[i].setElement(hTMLTagAttributes);
                continue;
            }
            hTMLTagAttributes = new HTMLText(string);
            hTMLTableHeaderArray[i].setElement(hTMLTagAttributes);
        }
        return hTMLTableHeaderArray;
    }

    String[] doConvert(RowData rowData, RowMetaData rowMetaData) throws PropertyVetoException, RowDataException {
        if (rowMetaData == null) {
            throw new NullPointerException("metadata");
        }
        Vector vector = this.convertRowData(rowData, rowMetaData);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((HTMLTable)vector.elementAt(i)).getTag();
        }
        return stringArray;
    }

    private void fireCompleted() {
        if (this.completedListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.completedListeners_.clone();
        ActionCompletedEvent actionCompletedEvent = new ActionCompletedEvent(this);
        for (int i = 0; i < vector.size(); ++i) {
            ActionCompletedListener actionCompletedListener = (ActionCompletedListener)vector.elementAt(i);
            actionCompletedListener.actionCompleted(actionCompletedEvent);
        }
    }

    public String getAlignment() {
        return this.htmlTable_.getAlignment();
    }

    public int getBorderWidth() {
        return this.htmlTable_.getBorderWidth();
    }

    public HTMLTableCaption getCaption() {
        return this.htmlTable_.getCaption();
    }

    public int getCellPadding() {
        return this.htmlTable_.getCellPadding();
    }

    public int getCellSpacing() {
        return this.htmlTable_.getCellSpacing();
    }

    public String getDirection() {
        return this.htmlTable_.getDirection();
    }

    public HTMLHyperlink[] getHeaderHyperlinks() {
        return this.links_;
    }

    public String getLanguage() {
        return this.htmlTable_.getLanguage();
    }

    public HTMLHyperlink getObjectHyperlink(RowData rowData, int n) {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        return this.getObjectHyperlink(rowData, rowData.getCurrentPosition(), n);
    }

    public HTMLHyperlink getObjectHyperlink(RowData rowData, int n, int n2) {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        HTMLHyperlink hTMLHyperlink = null;
        if (!rowData.absolute(n)) {
            throw new ExtendedIllegalArgumentException("row", 4);
        }
        Vector vector = rowData.getObjectProperties(n2);
        if (vector != null) {
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                if (!(vector.elementAt(i) instanceof HTMLHyperlink)) continue;
                hTMLHyperlink = (HTMLHyperlink)vector.elementAt(i);
                break;
            }
        }
        return hTMLHyperlink;
    }

    public int getWidth() {
        return this.htmlTable_.getWidth();
    }

    public boolean isWidthInPercent() {
        return this.htmlTable_.isWidthInPercent();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (actionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.completedListeners_ != null) {
            this.completedListeners_.removeElement(actionCompletedListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
        this.htmlTable_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeSectionCompletedListener(SectionCompletedListener sectionCompletedListener) {
        if (sectionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.sectionCompletedSupport_ != null) {
            this.sectionCompletedSupport_.removeSectionCompletedListener(sectionCompletedListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
        this.htmlTable_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setAlignment(String string) throws PropertyVetoException {
        this.htmlTable_.setAlignment(string);
    }

    public void setBorderWidth(int n) throws PropertyVetoException {
        this.htmlTable_.setBorderWidth(n);
    }

    public void setCaption(HTMLTableCaption hTMLTableCaption) throws PropertyVetoException {
        this.htmlTable_.setCaption(hTMLTableCaption);
    }

    public void setCellPadding(int n) throws PropertyVetoException {
        this.htmlTable_.setCellPadding(n);
    }

    public void setCellSpacing(int n) throws PropertyVetoException {
        this.htmlTable_.setCellSpacing(n);
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        this.htmlTable_.setDirection(string);
    }

    public void setHeaderHyperlinks(HTMLHyperlink[] hTMLHyperlinkArray) throws PropertyVetoException {
        if (hTMLHyperlinkArray == null) {
            throw new NullPointerException("links");
        }
        HTMLHyperlink[] hTMLHyperlinkArray2 = this.links_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("links", hTMLHyperlinkArray2, hTMLHyperlinkArray);
        }
        this.links_ = hTMLHyperlinkArray;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("links", hTMLHyperlinkArray2, hTMLHyperlinkArray);
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        this.htmlTable_.setLanguage(string);
    }

    public void setObjectHyperlink(RowData rowData, HTMLHyperlink hTMLHyperlink, int n) throws RowDataException {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        this.setObjectHyperlink(rowData, hTMLHyperlink, rowData.getCurrentPosition(), n);
    }

    public void setObjectHyperlink(RowData rowData, HTMLHyperlink hTMLHyperlink, int n, int n2) throws RowDataException {
        if (rowData == null) {
            throw new NullPointerException("rowdata");
        }
        if (hTMLHyperlink == null) {
            throw new NullPointerException("link");
        }
        if (!rowData.absolute(n)) {
            throw new ExtendedIllegalArgumentException("row", 4);
        }
        Vector<HTMLHyperlink> vector = rowData.getObjectProperties(n2);
        if (vector == null) {
            vector = new Vector<HTMLHyperlink>();
            vector.addElement(hTMLHyperlink);
        } else {
            HTMLHyperlink hTMLHyperlink2 = null;
            int n3 = -1;
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                if (!(vector.elementAt(i) instanceof HTMLHyperlink)) continue;
                hTMLHyperlink2 = (HTMLHyperlink)vector.elementAt(i);
                n3 = i;
                break;
            }
            if (hTMLHyperlink2 == null) {
                vector.addElement(hTMLHyperlink);
            } else {
                vector.setElementAt(hTMLHyperlink, n3);
            }
        }
        rowData.setObjectProperties(vector, n2);
    }

    public void setWidth(int n, boolean bl) throws PropertyVetoException {
        this.htmlTable_.setWidth(n, bl);
    }
}

