/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.FormInput;
import java.beans.PropertyVetoException;

public class TextFormInput
extends FormInput {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 2550648845459385938L;
    private int maxLength_ = -1;

    public TextFormInput() {
    }

    public TextFormInput(String string) {
        super(string);
    }

    public TextFormInput(String string, String string2) {
        super(string, string2);
    }

    public int getMaxLength() {
        return this.maxLength_;
    }

    String getMaxLengthAttributeTag() {
        if (this.maxLength_ > 0) {
            return " maxlength=\"" + this.maxLength_ + "\"";
        }
        return "";
    }

    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A TextFormInput was here -->";
    }

    public String getTag() {
        if (this.getName() == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<input type=\"text\"");
        stringBuffer.append(this.getNameAttributeTag());
        stringBuffer.append(this.getValueAttributeTag(false));
        stringBuffer.append(this.getMaxLengthAttributeTag());
        stringBuffer.append(this.getSizeAttributeTag());
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(" />");
        return stringBuffer.toString();
    }

    public void setMaxLength(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("maxLength", 4);
        }
        int n2 = this.maxLength_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("maxLength", new Integer(n2), new Integer(n));
        }
        this.maxLength_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("maxLength", new Integer(n2), new Integer(n));
        }
    }
}

