/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTableCaption;
import com.ibm.as400.util.html.HTMLTableCell;
import com.ibm.as400.util.html.HTMLTableHeader;
import com.ibm.as400.util.html.HTMLTableRow;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLText;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLTable
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4552974069573452181L;
    private Vector rows_ = new Vector();
    private HTMLTableCaption caption_;
    private Vector headerTag_;
    private String alignment_;
    private int borderWidth_ = 0;
    private int cellPadding_ = -1;
    private int cellSpacing_ = -1;
    private int width_ = 0;
    private boolean headerInUse_ = true;
    private boolean widthPercent_ = false;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private transient Vector rowListeners_;
    private transient VetoableChangeSupport vetos_;

    public HTMLTable() {
    }

    public HTMLTable(HTMLTableRow[] hTMLTableRowArray) {
        this();
        if (hTMLTableRowArray == null) {
            throw new NullPointerException("rows");
        }
        for (int i = 0; i < hTMLTableRowArray.length; ++i) {
            this.addRow(hTMLTableRowArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumn(HTMLTableCell[] hTMLTableCellArray) {
        if (hTMLTableCellArray == null) {
            throw new NullPointerException("column");
        }
        int n = this.rows_.size();
        Vector vector = this.rows_;
        synchronized (vector) {
            if (n == 0) {
                for (int i = 0; i < hTMLTableCellArray.length; ++i) {
                    HTMLTableRow hTMLTableRow = new HTMLTableRow();
                    hTMLTableRow.addColumn(hTMLTableCellArray[i]);
                    this.rows_.addElement(hTMLTableRow);
                }
            } else {
                if (hTMLTableCellArray.length != n) {
                    throw new ExtendedIllegalArgumentException("column", 1);
                }
                for (int i = 0; i < n; ++i) {
                    HTMLTableRow hTMLTableRow = (HTMLTableRow)this.rows_.elementAt(i);
                    hTMLTableRow.addColumn(hTMLTableCellArray[i]);
                }
            }
        }
    }

    public void addColumnHeader(String string) {
        this.addColumnHeader(new HTMLTableHeader(new HTMLText(string)));
    }

    public void addColumnHeader(HTMLTableHeader hTMLTableHeader) {
        if (hTMLTableHeader == null) {
            throw new NullPointerException("header");
        }
        if (hTMLTableHeader.getElement() == null) {
            Trace.log(2, "The HTMLTableHeader's element attribute is invalid.");
            throw new ExtendedIllegalArgumentException("header", 2);
        }
        if (this.headerTag_ == null) {
            this.headerTag_ = new Vector();
        }
        this.headerTag_.addElement(hTMLTableHeader);
    }

    public void addRow(HTMLTableRow hTMLTableRow) {
        if (hTMLTableRow == null) {
            throw new NullPointerException("row");
        }
        this.rows_.addElement(hTMLTableRow);
        this.fireAdded();
    }

    public void addRowListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rowListeners_ == null) {
            this.rowListeners_ = new Vector();
        }
        this.rowListeners_.addElement(elementListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private void fireAdded() {
        if (this.rowListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.rowListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, 0);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            elementListener.elementAdded(elementEvent);
        }
    }

    private void fireChanged() {
        if (this.rowListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.rowListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, 1);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            elementListener.elementChanged(elementEvent);
        }
    }

    private void fireRemoved() {
        if (this.rowListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.rowListeners_.clone();
        ElementEvent elementEvent = new ElementEvent(this, 2);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getAlignment() {
        return this.alignment_;
    }

    public int getBorderWidth() {
        return this.borderWidth_;
    }

    public HTMLTableCaption getCaption() {
        return this.caption_;
    }

    public int getCellPadding() {
        return this.cellPadding_;
    }

    public int getCellSpacing() {
        return this.cellSpacing_;
    }

    public HTMLTableCell[] getColumn(int n) {
        if (this.rows_.size() == 0) {
            Trace.log(2, "Attempting to get a column before adding a row to the table.");
            throw new ExtendedIllegalStateException("rows", 4);
        }
        HTMLTableCell[] hTMLTableCellArray = new HTMLTableCell[this.rows_.size()];
        int n2 = this.rows_.size();
        for (int i = 0; i < n2; ++i) {
            HTMLTableRow hTMLTableRow = (HTMLTableRow)this.rows_.elementAt(i);
            hTMLTableCellArray[i] = hTMLTableRow.getColumn(n);
        }
        return hTMLTableCellArray;
    }

    public HTMLTableHeader getColumnHeader(int n) {
        if (n < 0 || n >= this.headerTag_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        return (HTMLTableHeader)this.headerTag_.elementAt(n);
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" dir=\"");
            stringBuffer.append(this.dir_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    private String getEndTableTag() {
        if (!this.useFO_) {
            return "</table>\n";
        }
        return "</fo:table>\n</fo:block>";
    }

    public HTMLTableHeader[] getHeader() {
        if (this.headerTag_ == null) {
            return null;
        }
        Object[] objectArray = new HTMLTableHeader[this.headerTag_.size()];
        this.headerTag_.copyInto(objectArray);
        return objectArray;
    }

    public String getHeaderTag() {
        int n;
        int n2;
        if (this.headerTag_ == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.useFO_) {
            stringBuffer.append("<tr>\n");
        } else {
            int n3 = this.headerTag_.size();
            n2 = 100 / n3;
            for (n = 0; n < n3; ++n) {
                stringBuffer.append("<fo:table-column column-width='");
                stringBuffer.append(n2);
                stringBuffer.append("pt'/>\n");
            }
            stringBuffer.append("<fo:table-header>\n");
            stringBuffer.append("<fo:table-row>\n");
        }
        n2 = this.headerTag_.size();
        for (n = 0; n < n2; ++n) {
            HTMLTableHeader hTMLTableHeader = (HTMLTableHeader)this.headerTag_.elementAt(n);
            if (!this.useFO_) {
                stringBuffer.append(hTMLTableHeader.getTag());
                continue;
            }
            hTMLTableHeader.setBorderWidth(this.borderWidth_);
            if (this.cellPadding_ > -1) {
                hTMLTableHeader.setCellPadding(this.cellPadding_);
            }
            stringBuffer.append(hTMLTableHeader.getFOTag());
        }
        if (!this.useFO_) {
            stringBuffer.append("</tr>\n");
        } else {
            stringBuffer.append("</fo:table-row>\n");
            stringBuffer.append("</fo:table-header>\n");
        }
        return stringBuffer.toString();
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(" lang=\"");
            stringBuffer.append(this.lang_);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return "";
    }

    public int getRowCount() {
        return this.rows_.size();
    }

    public HTMLTableRow getRow(int n) {
        if (n < 0 || n >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        return (HTMLTableRow)this.rows_.elementAt(n);
    }

    private String getStartTableTag() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.useFO_) {
            stringBuffer.append("<table");
            if (this.alignment_ != null) {
                stringBuffer.append(" align=\"");
                stringBuffer.append(this.alignment_);
                stringBuffer.append("\"");
            }
            if (this.borderWidth_ > 0) {
                stringBuffer.append(" border=\"");
                stringBuffer.append(this.borderWidth_);
                stringBuffer.append("\"");
            }
            if (this.cellPadding_ >= 0) {
                stringBuffer.append(" cellpadding=\"");
                stringBuffer.append(this.cellPadding_);
                stringBuffer.append("\"");
            }
            if (this.cellSpacing_ >= 0) {
                stringBuffer.append(" cellspacing=\"");
                stringBuffer.append(this.cellSpacing_);
                stringBuffer.append("\"");
            }
            if (this.width_ > 0) {
                stringBuffer.append(" width=\"");
                stringBuffer.append(this.width_);
                if (this.widthPercent_) {
                    stringBuffer.append("%");
                }
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.getLanguageAttributeTag());
            stringBuffer.append(this.getDirectionAttributeTag());
            stringBuffer.append(this.getAttributeString());
            stringBuffer.append(">\n");
            if (this.caption_ != null) {
                stringBuffer.append(this.caption_.getTag());
            }
        } else {
            stringBuffer.append("<fo:block");
            if (this.alignment_ != null) {
                if (this.alignment_.equals("left")) {
                    stringBuffer.append(" text-align='start'");
                } else if (this.alignment_.equals("right")) {
                    stringBuffer.append(" text-align='end'");
                } else if (this.alignment_.equals("center")) {
                    stringBuffer.append(" text-align='center'");
                }
            }
            stringBuffer.append(">\n");
            if (this.caption_ != null) {
                stringBuffer.append(this.caption_.getFOTag());
            }
            stringBuffer.append("<fo:table");
            stringBuffer.append(this.getDirectionAttributeTag());
            stringBuffer.append(">\n");
        }
        return stringBuffer.toString();
    }

    public String getTag() {
        int n;
        if (this.useFO_) {
            return this.getFOTag();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getStartTableTag());
        if (this.headerInUse_) {
            if (this.rows_.size() > 0) {
                if (this.headerTag_ == null) {
                    Trace.log(2, "Attempting to get the table tag before setting the table header.");
                    throw new ExtendedIllegalStateException("header", 4);
                }
                int n2 = this.headerTag_.size();
                for (n = 0; n < this.rows_.size(); ++n) {
                    if (n2 >= ((HTMLTableRow)this.rows_.elementAt(n)).getColumnCount()) continue;
                    Trace.log(2, "Attempting to get the table tag when the length of the table header is invalid.");
                    throw new ExtendedIllegalArgumentException("header or row " + n, 1);
                }
            }
            stringBuffer.append(this.getHeaderTag());
        }
        n = this.rows_.size();
        for (int i = 0; i < n; ++i) {
            HTMLTableRow hTMLTableRow = (HTMLTableRow)this.rows_.elementAt(i);
            stringBuffer.append(hTMLTableRow.getTag());
        }
        stringBuffer.append(this.getEndTableTag());
        return stringBuffer.toString();
    }

    public String getFOTag() {
        int n;
        boolean bl = this.useFO_;
        this.setUseFO(true);
        StringBuffer stringBuffer = new StringBuffer(this.getStartTableTag());
        if (this.headerInUse_) {
            if (this.rows_.size() > 0) {
                if (this.headerTag_ == null) {
                    Trace.log(2, "Attempting to get the XSL-FO table tag before setting the table header.");
                    throw new ExtendedIllegalStateException("header", 4);
                }
                int n2 = this.headerTag_.size();
                n = this.rows_.size();
                for (int i = 0; i < n; ++i) {
                    if (n2 >= ((HTMLTableRow)this.rows_.elementAt(i)).getColumnCount()) continue;
                    Trace.log(2, "Attempting to get the table tag when the length of the table header is invalid.");
                    throw new ExtendedIllegalArgumentException("header or row " + i, 1);
                }
            }
            stringBuffer.append(this.getHeaderTag());
        }
        try {
            HTMLTableRow hTMLTableRow = (HTMLTableRow)this.rows_.elementAt(0);
            n = hTMLTableRow.getColumnCount();
        }
        catch (Exception exception) {
            n = 0;
        }
        if (!this.headerInUse_) {
            int n3 = 100 / n;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("<fo:table-column column-width='");
                stringBuffer.append(n3);
                stringBuffer.append("pt'/>\n");
            }
        }
        stringBuffer.append("<fo:table-body>\n");
        n = this.rows_.size();
        for (int i = 0; i < n; ++i) {
            HTMLTableRow hTMLTableRow = (HTMLTableRow)this.rows_.elementAt(i);
            hTMLTableRow.setBorderWidth(this.borderWidth_);
            if (this.cellPadding_ > -1) {
                hTMLTableRow.setCellPadding(this.cellPadding_);
            }
            stringBuffer.append(hTMLTableRow.getFOTag());
        }
        stringBuffer.append("</fo:table-body>\n");
        stringBuffer.append(this.getEndTableTag());
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public int getWidth() {
        return this.width_;
    }

    public boolean isHeaderInUse() {
        return this.headerInUse_;
    }

    public boolean isWidthInPercent() {
        return this.widthPercent_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeAllRows() {
        this.rows_.removeAllElements();
        this.fireRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumn(int n) {
        if (this.rows_.size() == 0) {
            Trace.log(2, "Attempting to remove a column before adding a row to the table.");
            throw new ExtendedIllegalStateException("rows", 4);
        }
        Vector vector = this.rows_;
        synchronized (vector) {
            int n2 = this.rows_.size();
            for (int i = 0; i < n2; ++i) {
                HTMLTableRow hTMLTableRow = (HTMLTableRow)this.rows_.elementAt(i);
                hTMLTableRow.removeColumn(hTMLTableRow.getColumn(n));
            }
            if (this.headerTag_ != null && n < this.headerTag_.size()) {
                this.removeColumnHeader(n);
            }
        }
    }

    public void removeColumnHeader(int n) {
        if (this.headerTag_ == null) {
            Trace.log(2, "Attempting to remove a column header before adding the header list to the table.");
            throw new ExtendedIllegalStateException("header", 4);
        }
        if (n < 0 || n >= this.headerTag_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        this.headerTag_.removeElementAt(n);
    }

    public void removeColumnHeader(HTMLTableHeader hTMLTableHeader) {
        if (this.headerTag_ == null) {
            Trace.log(2, "Attempting to remove a column header before adding the header list to the table.");
            throw new ExtendedIllegalStateException("header", 4);
        }
        if (hTMLTableHeader == null) {
            throw new NullPointerException("header");
        }
        if (!this.headerTag_.removeElement(hTMLTableHeader)) {
            throw new ExtendedIllegalArgumentException("header", 2);
        }
    }

    public void removeRow(HTMLTableRow hTMLTableRow) {
        if (hTMLTableRow == null) {
            throw new NullPointerException("row");
        }
        if (this.rows_.size() == 0) {
            Trace.log(2, "Attempting to remove a row when the table is empty.");
            throw new ExtendedIllegalStateException("rows", 4);
        }
        if (this.rows_.removeElement(hTMLTableRow)) {
            this.fireRemoved();
        }
    }

    public void removeRow(int n) {
        if (n < 0 || n >= this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        this.rows_.removeElementAt(n);
        this.fireRemoved();
    }

    public void removeRowListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rowListeners_ != null) {
            this.rowListeners_.removeElement(elementListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setAlignment(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("alignment");
        }
        if (string.equalsIgnoreCase("left") || string.equalsIgnoreCase("center") || string.equalsIgnoreCase("right")) {
            String string2 = this.alignment_;
            if (this.vetos_ != null) {
                this.vetos_.fireVetoableChange("alignment", string2, string);
            }
            this.alignment_ = string;
            if (this.changes_ != null) {
                this.changes_.firePropertyChange("alignment", string2, string);
            }
        } else {
            throw new ExtendedIllegalArgumentException("alignment", 2);
        }
    }

    public void setBorderWidth(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("borderWidth", 4);
        }
        int n2 = this.borderWidth_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("borderWidth", new Integer(n2), new Integer(n));
        }
        this.borderWidth_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("borderWidth", new Integer(n2), new Integer(n));
        }
    }

    public void setCaption(String string) throws PropertyVetoException {
        this.setCaption(new HTMLTableCaption(new HTMLText(string)));
    }

    public void setCaption(HTMLTableCaption hTMLTableCaption) throws PropertyVetoException {
        if (hTMLTableCaption == null) {
            throw new NullPointerException("caption");
        }
        HTMLTableCaption hTMLTableCaption2 = this.caption_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("caption", hTMLTableCaption2, hTMLTableCaption);
        }
        this.caption_ = hTMLTableCaption;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("caption", hTMLTableCaption2, hTMLTableCaption);
        }
    }

    public void setCellPadding(int n) throws PropertyVetoException {
        if (n < -1) {
            throw new ExtendedIllegalArgumentException("cellPadding", 4);
        }
        int n2 = this.cellPadding_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("cellPadding", new Integer(n2), new Integer(n));
        }
        this.cellPadding_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellPadding", new Integer(n2), new Integer(n));
        }
    }

    public void setCellSpacing(int n) throws PropertyVetoException {
        if (n < -1) {
            throw new ExtendedIllegalArgumentException("cellSpacing", 4);
        }
        int n2 = this.cellSpacing_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("cellSpacing", new Integer(n2), new Integer(n));
        }
        this.cellSpacing_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("cellSpacing", new Integer(n2), new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumn(HTMLTableCell[] hTMLTableCellArray, int n) {
        if (hTMLTableCellArray == null) {
            throw new NullPointerException("column");
        }
        int n2 = this.rows_.size();
        if (n2 == 0) {
            this.addColumn(hTMLTableCellArray);
            return;
        }
        if (hTMLTableCellArray.length != n2) {
            throw new ExtendedIllegalArgumentException("column", 1);
        }
        if (n < 0 || n > ((HTMLTableRow)this.rows_.elementAt(0)).getColumnCount()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        Vector vector = this.rows_;
        synchronized (vector) {
            for (int i = 0; i < n2; ++i) {
                HTMLTableRow hTMLTableRow = (HTMLTableRow)this.rows_.elementAt(i);
                hTMLTableRow.setColumn(hTMLTableCellArray[i], n);
            }
        }
    }

    public void setColumnHeader(String string, int n) throws PropertyVetoException {
        this.setColumnHeader(new HTMLTableHeader(new HTMLText(string)), n);
    }

    public void setColumnHeader(HTMLTableHeader hTMLTableHeader, int n) throws PropertyVetoException {
        if (hTMLTableHeader == null) {
            throw new NullPointerException("header");
        }
        if (this.headerTag_ == null) {
            if (n == 0) {
                this.addColumnHeader(hTMLTableHeader);
                return;
            }
            Trace.log(2, "Attempting to change a column header before adding a column header to the table.");
            throw new ExtendedIllegalStateException("header", 4);
        }
        if (hTMLTableHeader.getElement() == null) {
            Trace.log(2, "The HTMLTableHeader's element attribute is invalid.");
            throw new ExtendedIllegalArgumentException("header", 2);
        }
        if (n < 0 || n > this.headerTag_.size()) {
            throw new ExtendedIllegalArgumentException("columnIndex", 4);
        }
        if (n == this.headerTag_.size()) {
            this.addColumnHeader(hTMLTableHeader);
            return;
        }
        Vector vector = this.headerTag_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("header", vector, this.headerTag_);
        }
        this.headerTag_.setElementAt(hTMLTableHeader, n);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("header", vector, this.headerTag_);
        }
    }

    public void setDirection(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", string2, string);
        }
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setHeader(HTMLTableHeader[] hTMLTableHeaderArray) throws PropertyVetoException {
        if (hTMLTableHeaderArray == null) {
            throw new NullPointerException("header");
        }
        if (!this.rows_.isEmpty() && hTMLTableHeaderArray.length != ((HTMLTableRow)this.rows_.elementAt(0)).getColumnCount()) {
            throw new ExtendedIllegalArgumentException("header", 1);
        }
        Vector vector = this.headerTag_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("header", vector, hTMLTableHeaderArray);
        }
        this.headerTag_ = new Vector();
        for (int i = 0; i < hTMLTableHeaderArray.length; ++i) {
            this.headerTag_.addElement(hTMLTableHeaderArray[i]);
        }
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("header", vector, hTMLTableHeaderArray);
        }
    }

    public void setHeader(String[] stringArray) throws PropertyVetoException {
        if (stringArray == null) {
            throw new NullPointerException("header");
        }
        HTMLTableHeader[] hTMLTableHeaderArray = new HTMLTableHeader[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            hTMLTableHeaderArray[i] = new HTMLTableHeader(new HTMLText(stringArray[i]));
        }
        this.setHeader(hTMLTableHeaderArray);
    }

    public void setHeaderInUse(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.headerInUse_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("useHeader", new Boolean(bl2), new Boolean(bl));
        }
        this.headerInUse_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useHeader", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setLanguage(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", string2, string);
        }
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setRow(HTMLTableRow hTMLTableRow, int n) {
        if (hTMLTableRow == null) {
            throw new NullPointerException("row");
        }
        if (n < 0 || n > this.rows_.size()) {
            throw new ExtendedIllegalArgumentException("rowIndex", 4);
        }
        if (n == this.rows_.size()) {
            this.addRow(hTMLTableRow);
        } else {
            if (hTMLTableRow.getColumnCount() != ((HTMLTableRow)this.rows_.elementAt(0)).getColumnCount()) {
                throw new ExtendedIllegalArgumentException("row", 1);
            }
            this.rows_.setElementAt(hTMLTableRow, n);
            this.fireChanged();
        }
    }

    public void setWidth(int n) throws PropertyVetoException {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int n2 = this.width_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("width", new Integer(n2), new Integer(n));
        }
        this.width_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", new Integer(n2), new Integer(n));
        }
    }

    public void setWidth(int n, boolean bl) throws PropertyVetoException {
        int n2 = this.width_;
        this.setWidth(n);
        try {
            this.setWidthInPercent(bl);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.width_ = n2;
            throw new PropertyVetoException("widthInPercent", propertyVetoException.getPropertyChangeEvent());
        }
    }

    public void setWidthInPercent(boolean bl) throws PropertyVetoException {
        boolean bl2 = this.widthPercent_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("widthInPercent", new Boolean(bl2), new Boolean(bl));
        }
        this.widthPercent_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("widthInPercent", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

