/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLConstants;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class HTMLImage
extends HTMLTagAttributes
implements HTMLConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -7792796091910634206L;
    private String name_;
    private String source_;
    private String align_;
    private String alt_;
    private int border_ = -1;
    private int height_ = 0;
    private int hspace_ = 0;
    private int width_ = 0;
    private int vspace_ = 0;
    private boolean useFO_ = false;

    public HTMLImage() {
    }

    public HTMLImage(String string, String string2) {
        this.setSrc(string);
        this.setAlt(string2);
    }

    public String getAlign() {
        return this.align_;
    }

    public String getAlt() {
        return this.alt_;
    }

    public int getBorder() {
        return this.border_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getHSpace() {
        return this.hspace_;
    }

    public String getName() {
        return this.name_;
    }

    public String getSrc() {
        return this.source_;
    }

    public int getVSpace() {
        return this.vspace_;
    }

    public int getWidth() {
        return this.width_;
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.source_ == null) {
            Trace.log(2, "Attempting to get tag before setting image source.");
            throw new ExtendedIllegalStateException("source", 4);
        }
        if (this.alt_ == null) {
            Trace.log(2, "Attempting to get tag before setting image alt.");
            throw new ExtendedIllegalStateException("alt", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<img");
        stringBuffer.append(" src=\"");
        stringBuffer.append(this.source_);
        stringBuffer.append("\"");
        stringBuffer.append(" alt=\"");
        stringBuffer.append(this.alt_);
        stringBuffer.append("\"");
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                stringBuffer.append(" align=\"left\"");
            } else if (this.align_.equals("right")) {
                stringBuffer.append(" align=\"right\"");
            } else if (this.align_.equals("top")) {
                stringBuffer.append(" align=\"top\"");
            } else if (this.align_.equals("texttop")) {
                stringBuffer.append(" align=\"texttop\"");
            } else if (this.align_.equals("middle")) {
                stringBuffer.append(" align=\"middle\"");
            } else if (this.align_.equals("absmiddle")) {
                stringBuffer.append(" align=\"absmiddle\"");
            } else if (this.align_.equals("baseline")) {
                stringBuffer.append(" align=\"baseline\"");
            } else if (this.align_.equals("bottom")) {
                stringBuffer.append(" align=\"bottom\"");
            } else if (this.align_.equals("absbottom")) {
                stringBuffer.append(" align=\"absbottom\"");
            }
        }
        if (this.name_ != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(this.name_);
            stringBuffer.append("\"");
        }
        if (this.border_ > -1) {
            stringBuffer.append(" border=\"");
            stringBuffer.append(this.border_);
            stringBuffer.append("\"");
        }
        if (this.height_ > 0) {
            stringBuffer.append(" height=\"");
            stringBuffer.append(this.height_);
            stringBuffer.append("\"");
        }
        if (this.width_ > 0) {
            stringBuffer.append(" width=\"");
            stringBuffer.append(this.width_);
            stringBuffer.append("\"");
        }
        if (this.hspace_ > 0) {
            stringBuffer.append(" hspace=\"");
            stringBuffer.append(this.hspace_);
            stringBuffer.append("\"");
        }
        if (this.vspace_ > 0) {
            stringBuffer.append(" vspace=\"");
            stringBuffer.append(this.vspace_);
            stringBuffer.append("\"");
        }
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(" />");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        if (this.source_ == null) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting image source.");
            throw new ExtendedIllegalStateException("source", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<fo:block");
        if (this.align_ != null) {
            if (this.align_.equals("left")) {
                stringBuffer.append(" text-align='start'");
            } else if (this.align_.equals("right")) {
                stringBuffer.append(" text-align='end'");
            } else if (this.align_.equals("center")) {
                stringBuffer.append(" text-align='center'");
            }
        }
        stringBuffer.append(">\n");
        stringBuffer.append("<fo:external-graphic");
        stringBuffer.append(" src=\"file:");
        stringBuffer.append(this.source_);
        stringBuffer.append("\"");
        if (this.border_ > -1) {
            stringBuffer.append(" border-width=\"");
            stringBuffer.append(this.border_);
            stringBuffer.append("mm\"");
            stringBuffer.append(" border-style='solid'");
        }
        if (this.height_ > 0) {
            stringBuffer.append(" content-height=\"");
            stringBuffer.append(this.height_);
            stringBuffer.append("px\"");
        }
        if (this.width_ > 0) {
            stringBuffer.append(" content-width=\"");
            stringBuffer.append(this.width_);
            stringBuffer.append("px\"");
        }
        if (this.hspace_ > 0) {
            stringBuffer.append(" width=\"");
            stringBuffer.append(this.hspace_);
            stringBuffer.append("px\"");
        }
        if (this.vspace_ > 0) {
            stringBuffer.append(" height=\"");
            stringBuffer.append(this.vspace_);
            stringBuffer.append("px\"");
        }
        stringBuffer.append("/>\n");
        stringBuffer.append("</fo:block>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void setAlign(String string) {
        if (string == null) {
            throw new NullPointerException("align");
        }
        if (!(string.equals("left") || string.equals("right") || string.equals("top") || string.equals("texttop") || string.equals("middle") || string.equals("absmiddle") || string.equals("baseline") || string.equals("bottom") || string.equals("bottom") || string.equals("absbottom"))) {
            throw new ExtendedIllegalArgumentException("align", 2);
        }
        String string2 = this.align_;
        this.align_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("align", string2, string);
        }
    }

    public void setAlt(String string) {
        if (string == null) {
            throw new NullPointerException("alt");
        }
        String string2 = this.alt_;
        this.alt_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("alt", string2, string);
        }
    }

    public void setBorder(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("border", 4);
        }
        int n2 = this.border_;
        this.border_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("border", new Integer(n2), new Integer(n));
        }
    }

    public void setHeight(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("height", 4);
        }
        int n2 = this.height_;
        this.height_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("height", new Integer(n2), new Integer(n));
        }
    }

    public void setHSpace(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("hspace", 4);
        }
        int n2 = this.hspace_;
        this.hspace_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("hspace", new Integer(n2), new Integer(n));
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        this.name_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, string);
        }
    }

    public void setSrc(String string) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        String string2 = this.source_;
        this.source_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("source", string2, string);
        }
    }

    public void setVSpace(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("vspace", 4);
        }
        int n2 = this.vspace_;
        this.vspace_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("vspace", new Integer(n2), new Integer(n));
        }
    }

    public void setWidth(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("width", 4);
        }
        int n2 = this.width_;
        this.width_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("width", new Integer(n2), new Integer(n));
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

