/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLMeta;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLHead
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 5006426803056962528L;
    private String title_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private Vector list_ = new Vector();
    private transient Vector elementListeners;

    public HTMLHead() {
    }

    public HTMLHead(String string) {
        this.setTitle(string);
    }

    public HTMLHead(String string, HTMLMeta hTMLMeta) {
        this.addMetaInformation(hTMLMeta);
        this.setTitle(string);
    }

    public void addMetaInformation(HTMLMeta hTMLMeta) {
        if (hTMLMeta == null) {
            throw new NullPointerException("meta");
        }
        this.list_.addElement(hTMLMeta);
        this.fireElementEvent(0);
    }

    public void addMetaInformationElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(elementListener);
    }

    private void fireElementEvent(int n) {
        if (this.elementListeners == null) {
            return;
        }
        Vector vector = (Vector)this.elementListeners.clone();
        ElementEvent elementEvent = new ElementEvent(this, n);
        for (int i = 0; i < vector.size(); ++i) {
            ElementListener elementListener = (ElementListener)vector.elementAt(i);
            if (n == 0) {
                elementListener.elementAdded(elementEvent);
                continue;
            }
            if (n != 2) continue;
            elementListener.elementRemoved(elementEvent);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.title_ == null && this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get tag before setting the title or adding meta information to the head.");
            throw new ExtendedIllegalStateException("title/meta", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<head");
        stringBuffer.append(this.getLanguageAttributeTag());
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(this.getAttributeString());
        stringBuffer.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement hTMLTagElement = (HTMLTagElement)this.list_.elementAt(i);
            stringBuffer.append(hTMLTagElement.getTag());
        }
        if (this.title_ != null) {
            stringBuffer.append("<title");
            stringBuffer.append(this.getLanguageAttributeTag());
            stringBuffer.append(this.getDirectionAttributeTag());
            stringBuffer.append(">");
            stringBuffer.append(this.title_);
            stringBuffer.append("</title>\n");
        }
        stringBuffer.append("</head>\n");
        return stringBuffer.toString();
    }

    public String getFOTag() {
        boolean bl = this.useFO_;
        this.setUseFO(true);
        if (this.title_ == null && this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting the title for the head.");
            throw new ExtendedIllegalStateException("title", 4);
        }
        StringBuffer stringBuffer = new StringBuffer("<fo:static-content flow-name='xsl-region-before'>\n");
        stringBuffer.append("<fo:block-container");
        stringBuffer.append(this.getDirectionAttributeTag());
        stringBuffer.append(">\n");
        if (this.title_ != null) {
            stringBuffer.append(this.title_);
        }
        stringBuffer.append("</fo:block-container>\n");
        stringBuffer.append("</fo:static-content>\n");
        this.setUseFO(bl);
        return stringBuffer.toString();
    }

    public String getTitle() {
        return this.title_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public void removeMetaInformationElementListener(ElementListener elementListener) {
        if (elementListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(elementListener);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removeMetaInformation(HTMLMeta hTMLMeta) {
        if (hTMLMeta == null) {
            throw new NullPointerException("meta");
        }
        if (this.list_.removeElement(hTMLMeta)) {
            this.fireElementEvent(2);
        }
    }

    public void setDirection(String string) {
        if (string == null) {
            throw new NullPointerException("dir");
        }
        if (!string.equals("ltr") && !string.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String string2 = this.dir_;
        this.dir_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", string2, string);
        }
    }

    public void setLanguage(String string) {
        if (string == null) {
            throw new NullPointerException("lang");
        }
        String string2 = this.lang_;
        this.lang_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", string2, string);
        }
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new NullPointerException("title");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("title", 2);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting title for <head>.");
        }
        String string2 = this.title_;
        this.title_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("title", string2, string);
        }
    }

    public void setUseFO(boolean bl) {
        boolean bl2 = this.useFO_;
        this.useFO_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", bl2, bl);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

