/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.ActiveStatusEvent;
import com.ibm.as400.resource.ActiveStatusListener;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ResourceEvent;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ResourceListener;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Resource
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static Object counterLock_ = new Object();
    private static long counter_;
    private ResourceMetaDataTable attributes_;
    private Dictionary attributeValues_;
    private boolean connectionEstablished_ = false;
    private String currentLevel_ = null;
    private int defaultBidiStringType_ = -1;
    private Presentation presentation_;
    private boolean propertiesFrozen_ = false;
    private Object resourceKey_;
    private AS400 system_ = null;
    private transient Vector activeStatusListeners_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    transient Vector resourceListeners_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource() {
        this.presentation_ = new Presentation();
        Object object = counterLock_;
        synchronized (object) {
            this.resourceKey_ = new Long(counter_++);
        }
        this.attributes_ = new ResourceMetaDataTable();
        this.attributeValues_ = new Hashtable();
        this.initializeTransient();
    }

    public Resource(Presentation presentation, Object object, ResourceMetaData[] resourceMetaDataArray) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        if (object == null) {
            throw new NullPointerException("resourceKey");
        }
        this.presentation_ = presentation;
        this.resourceKey_ = object;
        this.attributes_ = new ResourceMetaDataTable(resourceMetaDataArray);
        this.attributeValues_ = new Hashtable();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource(Presentation presentation, Object object, ResourceMetaData[] resourceMetaDataArray, Dictionary dictionary) {
        this(presentation, object, resourceMetaDataArray);
        Dictionary dictionary2 = dictionary;
        synchronized (dictionary2) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Initializing attribute value " + k + " (for " + this + ") to " + v + "(" + v.getClass() + ")");
                }
                ResourceMetaData resourceMetaData = this.attributes_.validateID(k);
                dictionary.put(k, resourceMetaData.validateValue(v));
            }
        }
        this.attributeValues_ = dictionary;
        this.initializeTransient();
    }

    public Resource(Presentation presentation, Object object, ResourceMetaDataTable resourceMetaDataTable) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        if (resourceMetaDataTable == null) {
            throw new NullPointerException("attributes");
        }
        this.presentation_ = presentation;
        this.resourceKey_ = object;
        this.attributes_ = resourceMetaDataTable;
        this.attributeValues_ = new Hashtable();
        this.initializeTransient();
    }

    public void addActiveStatusListener(ActiveStatusListener activeStatusListener) {
        if (activeStatusListener == null) {
            throw new NullPointerException("listener");
        }
        this.activeStatusListeners_.addElement(activeStatusListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addResourceListener(ResourceListener resourceListener) {
        if (resourceListener == null) {
            throw new NullPointerException("listener");
        }
        this.resourceListeners_.addElement(resourceListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    protected boolean arePropertiesFrozen() {
        return this.propertiesFrozen_;
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            if (this.resourceKey_ != null && ((Resource)object).resourceKey_ != null) {
                return this.resourceKey_.equals(((Resource)object).resourceKey_);
            }
            return super.equals(object);
        }
        return false;
    }

    protected void establishConnection() throws ResourceException {
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Establishing a connection for " + this + ".");
        }
        if (!this.propertiesFrozen_) {
            this.freezeProperties();
        }
        this.connectionEstablished_ = true;
    }

    protected void fireAttributeValuesRefreshed() {
        ResourceEvent resourceEvent = new ResourceEvent(this, 3);
        Vector vector = (Vector)this.resourceListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ResourceListener)enumeration.nextElement()).attributeValuesRefreshed(resourceEvent);
        }
    }

    protected void fireBusy() {
        ActiveStatusEvent activeStatusEvent = new ActiveStatusEvent(this, 1);
        Vector vector = (Vector)this.activeStatusListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ActiveStatusListener)enumeration.nextElement()).busy(activeStatusEvent);
        }
    }

    protected void fireIdle() {
        ActiveStatusEvent activeStatusEvent = new ActiveStatusEvent(this, 2);
        Vector vector = (Vector)this.activeStatusListeners_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ActiveStatusListener)enumeration.nextElement()).idle(activeStatusEvent);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport_.firePropertyChange(string, object, object2);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vetoableChangeSupport_.fireVetoableChange(string, object, object2);
    }

    protected void freezeProperties() throws ResourceException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Freezing properties for " + this + ".");
        }
        this.propertiesFrozen_ = true;
    }

    public ResourceMetaData getAttributeMetaData(Object object) {
        return this.attributes_.getMetaData(object);
    }

    public ResourceMetaData[] getAttributeMetaData() {
        return this.attributes_.getMetaData(this.getCurrentLevel());
    }

    public Object getAttributeValue(Object object) throws ResourceException {
        if (this.isBidiEnabled()) {
            return this.getAttributeValue(object, this.getDefaultBidiStringType());
        }
        return this.getAttributeValueImplementation(object);
    }

    public Object getAttributeValue(Object object, int n) throws ResourceException {
        if (!this.isBidiEnabled()) {
            return this.getAttributeValue(object);
        }
        return this.getAttributeValueImplementation(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getAttributeValueImplementation(Object object) throws ResourceException {
        Resource resource = this;
        synchronized (resource) {
            this.attributes_.validateID(object);
            return this.attributeValues_.get(object);
        }
    }

    String getCurrentLevel() {
        if (this.system_ == null) {
            return "";
        }
        if (this.currentLevel_ != null) {
            return this.currentLevel_;
        }
        try {
            this.currentLevel_ = ResourceLevel.vrmToLevel(this.system_.getVRM());
        }
        catch (Exception exception) {
            return "";
        }
        return this.currentLevel_;
    }

    int getDefaultBidiStringType() {
        if (this.system_ == null) {
            return 0;
        }
        if (this.defaultBidiStringType_ == -1) {
            this.defaultBidiStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        return this.defaultBidiStringType_;
    }

    public Presentation getPresentation() {
        return this.presentation_;
    }

    public Object getResourceKey() {
        return this.resourceKey_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeAttributeValue(Object object, Object object2) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Initialized attribute value " + object + " (for " + this + ") to " + object2 + "(" + object2.getClass() + ")");
        }
        ResourceMetaData resourceMetaData = this.attributes_.validateID(object);
        if (object2 == null) {
            throw new NullPointerException("value");
        }
        object2 = resourceMetaData.validateValue(object2);
        Resource resource = this;
        synchronized (resource) {
            this.attributeValues_.put(object, object2);
        }
    }

    private void initializeTransient() {
        this.activeStatusListeners_ = new Vector();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.resourceListeners_ = new Vector();
    }

    protected boolean isBidiEnabled() {
        return false;
    }

    protected boolean isConnectionEstablished() {
        return this.connectionEstablished_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void refreshAttributeValues() throws ResourceException {
        this.fireAttributeValuesRefreshed();
    }

    public void removeActiveStatusListener(ActiveStatusListener activeStatusListener) {
        if (activeStatusListener == null) {
            throw new NullPointerException("listener");
        }
        this.activeStatusListeners_.removeElement(activeStatusListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeResourceListener(ResourceListener resourceListener) {
        if (resourceListener == null) {
            throw new NullPointerException("listener");
        }
        this.resourceListeners_.removeElement(resourceListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected void setPresentation(Presentation presentation) {
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.presentation_ = presentation;
    }

    protected void setResourceKey(Object object) {
        if (object == null) {
            throw new NullPointerException("resourceKey");
        }
        this.resourceKey_ = object;
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        AS400 aS4002 = this.system_;
        this.fireVetoableChange("system", aS4002, aS400);
        this.system_ = aS400;
        this.firePropertyChange("system", aS4002, aS400);
    }

    public String toString() {
        if (this.presentation_ == null) {
            return super.toString();
        }
        String string = this.presentation_.getFullName();
        if (string.length() > 0) {
            return string;
        }
        return super.toString();
    }

    ResourceMetaData validateAttributeID(Object object) {
        return this.attributes_.validateID(object);
    }
}

