/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SignonConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.DestroyFailedException;
import com.ibm.as400.security.auth.ProfileHandleCredential;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenImpl;
import com.ibm.as400.security.auth.RefreshFailedException;
import com.ibm.as400.security.auth.RetrieveFailedException;
import com.ibm.as400.security.auth.SwapFailedException;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class ProfileTokenImplNative
implements ProfileTokenImpl {
    private static final String CLASSNAME = "com.ibm.as400.access.ProfileTokenImplNative";
    private AS400Credential credential_ = null;

    public void destroy() throws DestroyFailedException {
        this.nativeRemoveFromSystem(((ProfileTokenCredential)this.getCredential()).getToken());
        this.credential_ = null;
        if (Trace.isTraceOn()) {
            Trace.log(3, "Credential implementation destroyed >> " + this.toString());
        }
    }

    public byte[] generateToken(String string, String string2, int n, int n2) throws RetrieveFailedException {
        if (string2.length() > 10) {
            Trace.log(2, "User profile password exceeds allowed length");
            throw new ExtendedIllegalArgumentException("password", 1);
        }
        return this.nativeCreateToken(string.toUpperCase(), string2, n, n2);
    }

    public byte[] generateToken(String string, int n, int n2, int n3) throws RetrieveFailedException {
        String string2;
        switch (n) {
            case 1: {
                string2 = "*NOPWD    ";
                break;
            }
            case 2: {
                string2 = "*NOPWDCHK ";
                break;
            }
            default: {
                Trace.log(2, "Password special value = " + n + " is not valid.");
                throw new ExtendedIllegalArgumentException("password special value", 2);
            }
        }
        return this.nativeCreateToken(string.toUpperCase(), string2, n2, n3);
    }

    public byte[] generateTokenExtended(String string, String string2, int n, int n2) throws RetrieveFailedException {
        AS400 aS400 = this.getCredential().getSystem();
        ProgramParameter[] programParameterArray = new ProgramParameter[8];
        programParameterArray[0] = new ProgramParameter(32);
        try {
            programParameterArray[1] = new ProgramParameter(SignonConverter.stringToByteArray(string.toUpperCase()));
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new RetrieveFailedException(aS400SecurityException.getReturnCode());
        }
        programParameterArray[2] = new ProgramParameter(BinaryConverter.charArrayToByteArray(string2.toCharArray()));
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        programParameterArray[4] = new ProgramParameter(CharConverter.stringToByteArray(aS400, new Integer(n).toString()));
        programParameterArray[5] = new ProgramParameter(BinaryConverter.intToByteArray(0));
        programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(programParameterArray[2].getInputData().length));
        programParameterArray[7] = new ProgramParameter(BinaryConverter.intToByteArray(13488));
        ProgramCall programCall = new ProgramCall(aS400);
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYGENPT", "PGM"), programParameterArray);
            programCall.setThreadSafe(true);
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYGENPT failed.");
                throw new RetrieveFailedException(programCall.getMessageList());
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Unexpected IOException: ", (Throwable)iOException);
            throw new InternalErrorException(10);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException: ", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
        catch (InterruptedException interruptedException) {
            Trace.log(2, "Unexpected InterruptedException: ", (Throwable)interruptedException);
            throw new InternalErrorException(10);
        }
        catch (Exception exception) {
            throw new RetrieveFailedException();
        }
        return programParameterArray[0].getOutputData();
    }

    AS400Credential getCredential() {
        return this.credential_;
    }

    public int getTimeToExpiration() throws RetrieveFailedException {
        return this.nativeGetTimeToExpiration(((ProfileTokenCredential)this.getCredential()).getToken());
    }

    public int getVersion() {
        return 1;
    }

    public boolean isCurrent() {
        try {
            return !this.getCredential().isTimed() || this.getTimeToExpiration() > 0;
        }
        catch (RetrieveFailedException retrieveFailedException) {
            Trace.log(2, "Unable to retrieve credential time to expiration", (Throwable)retrieveFailedException);
            return false;
        }
    }

    native byte[] nativeCreateToken(String var1, String var2, int var3, int var4) throws RetrieveFailedException;

    native int nativeGetTimeToExpiration(byte[] var1) throws RetrieveFailedException;

    native void nativeRefreshToken(byte[] var1, int var2, int var3) throws RefreshFailedException;

    native void nativeRemoveFromSystem(byte[] var1) throws DestroyFailedException;

    native void nativeSwap(byte[] var1) throws SwapFailedException;

    public void refresh() throws RefreshFailedException {
    }

    public byte[] refresh(int n, int n2) throws RefreshFailedException {
        byte[] byArray = ((ProfileTokenCredential)this.getCredential()).getToken();
        byte[] byArray2 = new byte[32];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        this.nativeRefreshToken(byArray2, n, n2);
        return byArray2;
    }

    public void setCredential(AS400Credential aS400Credential) {
        if (aS400Credential == null) {
            Trace.log(2, "Parameter 'credential' is null.");
            throw new NullPointerException("credential");
        }
        this.credential_ = aS400Credential;
    }

    public AS400Credential swap(boolean bl) throws SwapFailedException {
        ProfileHandleCredential profileHandleCredential = null;
        if (bl) {
            try {
                profileHandleCredential = new ProfileHandleCredential();
                profileHandleCredential.setSystem(((ProfileTokenCredential)this.getCredential()).getSystem());
                profileHandleCredential.setHandle();
            }
            catch (Exception exception) {
                Trace.log(2, "Unable to obtain current profile handle", (Throwable)exception);
            }
        }
        this.nativeSwap(((ProfileTokenCredential)this.getCredential()).getToken());
        return profileHandleCredential;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        System.load("/QSYS.LIB/QYJSPART.SRVPGM");
    }
}

