/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.DestroyFailedException;
import com.ibm.as400.security.auth.ProfileHandleCredential;
import com.ibm.as400.security.auth.ProfileHandleImpl;
import com.ibm.as400.security.auth.RefreshFailedException;
import com.ibm.as400.security.auth.RetrieveFailedException;
import com.ibm.as400.security.auth.SwapFailedException;

public class ProfileHandleImplNative
implements ProfileHandleImpl {
    private static final String CLASSNAME = "com.ibm.as400.access.ProfileHandleImplNative";
    private AS400Credential credential_ = null;

    public void destroy() throws DestroyFailedException {
        this.releaseHandle(((ProfileHandleCredential)this.getCredential()).getHandle());
        this.credential_ = null;
        if (Trace.isTraceOn()) {
            Trace.log(3, "Credential implementation destroyed >> " + this.toString());
        }
    }

    AS400Credential getCredential() {
        return this.credential_;
    }

    public native byte[] getCurrentHandle() throws RetrieveFailedException;

    public int getTimeToExpiration() throws RetrieveFailedException {
        return 0;
    }

    public int getVersion() {
        return 1;
    }

    public boolean isCurrent() {
        try {
            return !this.getCredential().isTimed() || this.getTimeToExpiration() > 0;
        }
        catch (RetrieveFailedException retrieveFailedException) {
            Trace.log(2, "Unable to retrieve credential time to expiration", (Throwable)retrieveFailedException);
            return false;
        }
    }

    public void refresh() throws RefreshFailedException {
    }

    public native void releaseHandle(byte[] var1) throws DestroyFailedException;

    public void setCredential(AS400Credential aS400Credential) {
        if (aS400Credential == null) {
            Trace.log(2, "Parameter 'credential' is null.");
            throw new NullPointerException("credential");
        }
        this.credential_ = aS400Credential;
    }

    public native void setCurrentHandle(byte[] var1) throws SwapFailedException;

    public AS400Credential swap(boolean bl) throws SwapFailedException {
        this.setCurrentHandle(((ProfileHandleCredential)this.getCredential()).getHandle());
        return null;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        System.load("/QSYS.LIB/QYJSPART.SRVPGM");
    }
}

