/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConnectionPool;
import com.ibm.as400.access.Trace;

class PoolMaintenance
extends Thread {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private boolean run_ = false;
    private boolean stayAlive_ = true;
    private transient long lastRun_;
    private transient ConnectionPool pool_;
    private final Object waitLock_ = new Object();

    public PoolMaintenance(ConnectionPool connectionPool) {
        super("AS400ConnectionPoolMaintenanceThread");
        this.setDaemon(true);
        this.pool_ = connectionPool;
        this.lastRun_ = System.currentTimeMillis();
    }

    public long getLastTime() {
        return this.lastRun_;
    }

    public boolean isRunning() {
        return this.run_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Trace.traceOn_) {
            Trace.log(3, "Connection pool maintenance daemon is started...");
        }
        this.run_ = true;
        while (this.stayAlive_) {
            Object object;
            if (this.run_) {
                try {
                    object = this.waitLock_;
                    synchronized (object) {
                        this.waitLock_.wait(this.pool_.getCleanupInterval());
                    }
                }
                catch (InterruptedException interruptedException) {
                    Trace.log(2, "Connection pool maintenance daemon failed.");
                }
                this.pool_.cleanupConnections();
                this.lastRun_ = System.currentTimeMillis();
                continue;
            }
            try {
                object = this.waitLock_;
                synchronized (object) {
                    this.waitLock_.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                Trace.log(2, "Connection pool maintenance daemon failed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean bl) {
        if (this.run_ != bl) {
            Object object = this.waitLock_;
            synchronized (object) {
                this.run_ = bl;
                this.waitLock_.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.run_ = false;
        this.stayAlive_ = false;
        Object object = this.waitLock_;
        synchronized (object) {
            this.waitLock_.notify();
        }
    }
}

