/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSServerSocketContainerAdapter;
import com.ibm.as400.access.PxSecureSocketContainer;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import com.ibm.sslight.SSLContext;
import com.ibm.sslight.SSLException;
import com.ibm.sslight.SSLServerSocket;
import com.ibm.sslight.SSLSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

class PSSecureServerSocketContainer
extends PSServerSocketContainerAdapter {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final String NAME_ = ResourceBundleLoader.getText("PROXY_SERVER_SECURE_CONTAINER");

    public PSSecureServerSocketContainer(int n, String string, String string2) throws IOException {
        super(PSSecureServerSocketContainer.createSSLServerSocket(n, string, string2));
    }

    public Socket accept() throws IOException {
        boolean bl = false;
        SSLSocket sSLSocket = null;
        while (!bl) {
            try {
                sSLSocket = (SSLSocket)((SSLServerSocket)this.serverSocket_).accept(null);
                if (Trace.isTraceOn()) {
                    PxSecureSocketContainer.traceSSLSocket(sSLSocket);
                }
                bl = true;
            }
            catch (SSLException sSLException) {
                if (Trace.isTraceOn()) {
                    Trace.logSSL(1, sSLException.getCategory(), sSLException.getError(), sSLException.getInt1());
                }
                bl = false;
            }
        }
        return sSLSocket;
    }

    private static ServerSocket createSSLServerSocket(int n, String string, String string2) throws IOException {
        SSLContext sSLContext = PxSecureSocketContainer.initializeServerSSLContext(string, string2);
        if (sSLContext == null) {
            return null;
        }
        return new SSLServerSocket(n, sSLContext);
    }

    public boolean isSecure() {
        return true;
    }

    public String toString() {
        return NAME_;
    }
}

