/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDUtilities;

final class JDSearchPattern {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final String ESCAPE_CHAR_ = "\\";
    private String patternString_;

    JDSearchPattern(String string) {
        this.patternString_ = string != null ? string.trim() : null;
    }

    final boolean containsEscape() {
        return this.patternString_ != null ? this.patternString_.indexOf(ESCAPE_CHAR_) != -1 : false;
    }

    final boolean containsSearchPattern() {
        return this.patternString_ != null ? this.patternString_.indexOf(37) != -1 || this.patternString_.indexOf(95) != -1 : false;
    }

    static final String getEscape() {
        return ESCAPE_CHAR_;
    }

    final int getIndicator() {
        int n = this.containsSearchPattern() || this.containsEscape() ? 241 : 240;
        return n;
    }

    final String getPatternString() {
        return this.patternString_;
    }

    final String getSQLWhereClause(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isSpecified()) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            if (this.containsSearchPattern()) {
                stringBuffer.append("LIKE  '");
                stringBuffer.append(JDSearchPattern.unquote(this.patternString_));
                stringBuffer.append("' ");
                if (this.containsEscape()) {
                    stringBuffer.append("ESCAPE '");
                    stringBuffer.append(ESCAPE_CHAR_);
                    stringBuffer.append("' ");
                }
            } else {
                stringBuffer.append("=  '");
                stringBuffer.append(JDSearchPattern.unquote(this.patternString_));
                stringBuffer.append("' ");
            }
        }
        return stringBuffer.toString();
    }

    final boolean isSpecified() {
        return this.patternString_ != null;
    }

    private static final String unquote(String string) {
        return JDUtilities.prepareForSingleQuotes(string, false);
    }
}

