/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileEvent;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSRandomAccessFile;
import com.ibm.as400.access.IFSTextFileInputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class IFSFileDescriptor
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private transient long fileOffset_;
    private transient Object parent_;
    private String path_ = "";
    private int shareOption_;
    private AS400 system_;
    private boolean closed_ = false;
    private transient Boolean fileOffsetLock_ = new Boolean("true");
    private transient IFSFileDescriptorImpl impl_;

    public IFSFileDescriptor() {
    }

    IFSFileDescriptor(AS400 aS400, String string, int n, Object object) {
        this.system_ = aS400;
        this.path_ = string;
        this.shareOption_ = n;
        this.parent_ = object;
    }

    IFSFileDescriptor(int n, Object object) {
        this.shareOption_ = n;
        this.parent_ = object;
    }

    void chooseImpl() {
        if (this.impl_ == null) {
            this.impl_ = (IFSFileDescriptorImpl)this.system_.loadImpl2("com.ibm.as400.access.IFSFileDescriptorImplRemote", "com.ibm.as400.access.IFSFileDescriptorImplProxy");
            Object object = null;
            if (this.parent_ != null) {
                String string = this.parent_.getClass().getName();
                if (this.parent_ instanceof IFSFileInputStream) {
                    object = ((IFSFileInputStream)this.parent_).getImpl();
                } else if (this.parent_ instanceof IFSFileOutputStream) {
                    object = ((IFSFileOutputStream)this.parent_).getImpl();
                } else if (this.parent_ instanceof IFSTextFileInputStream) {
                    object = ((IFSTextFileInputStream)this.parent_).getImpl();
                } else if (this.parent_ instanceof IFSTextFileOutputStream) {
                    object = ((IFSTextFileOutputStream)this.parent_).getImpl();
                } else if (this.parent_ instanceof IFSRandomAccessFile) {
                    object = ((IFSRandomAccessFile)this.parent_).getImpl();
                } else {
                    Trace.log(2, "IFSFileDescriptor has invalid parent: " + string);
                    throw new InternalErrorException(10);
                }
            }
            this.impl_.initialize(this.fileOffset_, object, this.path_, this.shareOption_, this.system_.getImpl());
        }
    }

    void close() {
        if (this.impl_ != null) {
            this.impl_.close();
        }
        this.closed_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireClosedEvents(Object object, Vector vector) {
        FileEvent fileEvent = new FileEvent(object, 0);
        Vector vector2 = vector;
        synchronized (vector2) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                FileListener fileListener = (FileListener)enumeration.nextElement();
                fileListener.fileClosed(fileEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireModifiedEvents(Object object, Vector vector) {
        FileEvent fileEvent = new FileEvent(object, 2);
        Vector vector2 = vector;
        synchronized (vector2) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                FileListener fileListener = (FileListener)enumeration.nextElement();
                fileListener.fileModified(fileEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireOpenedEvents(Object object, Vector vector) {
        FileEvent fileEvent = new FileEvent(object, 3);
        Vector vector2 = vector;
        synchronized (vector2) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                FileListener fileListener = (FileListener)enumeration.nextElement();
                fileListener.fileOpened(fileEvent);
            }
        }
    }

    IFSFileDescriptorImpl getImpl() {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_;
    }

    int getCCSID() throws IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getCCSID();
    }

    long getFileOffset() {
        if (this.impl_ == null) {
            return this.fileOffset_;
        }
        return this.impl_.getFileOffset();
    }

    String getPath() {
        return this.path_;
    }

    int getShareOption() {
        return this.shareOption_;
    }

    AS400 getSystem() {
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementFileOffset(int n) {
        if (this.impl_ == null) {
            Boolean bl = this.fileOffsetLock_;
            synchronized (bl) {
                this.fileOffset_ += (long)n;
            }
        } else {
            this.impl_.incrementFileOffset(n);
        }
    }

    boolean isClosed() {
        return this.closed_;
    }

    boolean isOpen() {
        if (this.impl_ == null) {
            return false;
        }
        return this.impl_.isOpen();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fileOffset_ = 0L;
        this.parent_ = null;
        this.fileOffsetLock_ = new Boolean("true");
        this.impl_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileOffset(long l) {
        if (this.impl_ == null) {
            Boolean bl = this.fileOffsetLock_;
            synchronized (bl) {
                this.fileOffset_ = l;
            }
        } else {
            this.impl_.setFileOffset(l);
        }
    }

    void setPath(String string) {
        if (this.impl_ != null) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        this.path_ = string;
    }

    void setShareOption(int n) {
        if (this.impl_ != null) {
            throw new ExtendedIllegalStateException("shareOption", 5);
        }
        this.shareOption_ = n;
    }

    void setSystem(AS400 aS400) {
        if (this.impl_ != null) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.system_ = aS400;
    }

    public void sync() throws IOException {
        if (this.impl_ == null) {
            if (this.parent_ == null) {
                Trace.log(2, "Parent is null, nothing to synchronize.");
            } else if (this.parent_ instanceof IFSRandomAccessFile) {
                ((IFSRandomAccessFile)this.parent_).flush();
            } else if (this.parent_ instanceof IFSFileOutputStream) {
                ((IFSFileOutputStream)this.parent_).flush();
            } else {
                Trace.log(2, "Parent does not have a flush() method: " + this.parent_.getClass().getName());
            }
        } else {
            this.impl_.sync();
        }
    }

    public boolean valid() {
        return this.isOpen();
    }
}

