/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

class ConnectionPoolProperties
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private long cleanupInterval_ = 300000L;
    private int maxConnections_ = -1;
    private long maxInactivity_ = 3600000L;
    private long maxLifetime_ = 86400000L;
    private int maxUseCount_ = -1;
    private long maxUseTime_ = -1L;
    private boolean useThreads_ = true;
    private transient PropertyChangeSupport changes_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        ConnectionPoolProperties connectionPoolProperties = this;
        synchronized (connectionPoolProperties) {
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public boolean isThreadUsed() {
        return this.useThreads_;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval_;
    }

    public int getMaxConnections() {
        return this.maxConnections_;
    }

    public long getMaxInactivity() {
        return this.maxInactivity_;
    }

    public long getMaxLifetime() {
        return this.maxLifetime_;
    }

    public int getMaxUseCount() {
        return this.maxUseCount_;
    }

    public long getMaxUseTime() {
        return this.maxUseTime_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void setCleanupInterval(long l) {
        String string = "cleanupInterval";
        if (l < 0L) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        long l2 = this.cleanupInterval_;
        this.cleanupInterval_ = l;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, new Long(l2), new Long(l));
        }
    }

    public void setMaxConnections(int n) {
        String string = "maxConnections";
        if (n < -1) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        int n2 = this.maxConnections_;
        this.maxConnections_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, new Integer(n2), new Integer(n));
        }
    }

    public void setMaxInactivity(long l) {
        String string = "maxInactivity";
        if (l < -1L) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        long l2 = this.maxInactivity_;
        this.maxInactivity_ = l;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, new Long(l2), new Long(l));
        }
    }

    public void setMaxLifetime(long l) {
        String string = "maxLifetime";
        if (l < -1L) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        long l2 = this.maxLifetime_;
        this.maxLifetime_ = l;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, new Long(l2), new Long(l));
        }
    }

    public void setThreadUsed(boolean bl, boolean bl2) {
        String string = "threadUsed";
        if (bl2) {
            throw new ExtendedIllegalStateException(string, 5);
        }
        boolean bl3 = this.useThreads_;
        this.useThreads_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, new Boolean(bl3), new Boolean(bl));
        }
    }

    public void setMaxUseCount(int n) {
        String string = "maxUseCount";
        if (n < -1) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        int n2 = this.maxUseCount_;
        this.maxUseCount_ = n;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, new Integer(n2), new Integer(n));
        }
    }

    public void setMaxUseTime(long l) {
        String string = "maxUseTime";
        if (l < -1L) {
            throw new ExtendedIllegalArgumentException(string, 4);
        }
        long l2 = this.maxUseTime_;
        this.maxUseTime_ = l;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, new Long(l2), new Long(l));
        }
    }
}

