/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BaseDataQueueImplRemote;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DQQueryRecord;
import com.ibm.as400.access.DQReceiveRecord;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class BaseDataQueueImplNative
extends BaseDataQueueImplRemote {
    private static final String CLASSNAME = "com.ibm.as400.access.BaseDataQueueImplNative";
    private String name_;
    private String library_;

    BaseDataQueueImplNative() {
    }

    public void setSystemAndPath(AS400Impl aS400Impl, String string, String string2, String string3) throws IOException {
        super.setSystemAndPath(aS400Impl, string, string2, string3);
        this.name_ = string2;
        this.library_ = string3;
    }

    public void clear(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl = this.system_.swapTo(byArray2, byArray3);
        try {
            if (byArray == null) {
                this.clearNative(this.libraryBytes_, this.queueNameBytes_);
            } else {
                this.clearKeyNative(this.libraryBytes_, this.queueNameBytes_, byArray);
            }
        }
        catch (NativeException nativeException) {
            throw this.buildException(byArray != null, nativeException);
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
    }

    public void create(int n, String string, boolean bl, boolean bl2, int n2, boolean bl3, String string2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        String string3 = "QSYS/CRTDTAQ DTAQ(" + this.library_ + "/" + this.name_ + ") TYPE(*STD) MAXLEN(" + n + ") FORCE(" + (bl3 ? "*YES" : "*NO") + ") SEQ(" + (n2 == 0 ? (bl2 ? "*FIFO" : "*LIFO") : "*KEYED) KEYLEN(" + n2) + ") SENDERID(" + (bl ? "*YES" : "*NO") + ") TEXT('" + string2 + "') AUT(" + string + ")";
        byte[] byArray = this.converter_.stringToByteArray(string3);
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl4 = this.system_.swapTo(byArray2, byArray3);
        try {
            this.createNative(byArray);
        }
        catch (NativeException nativeException) {
            String string4 = this.converter_.byteArrayToString(nativeException.data, 12, 7);
            if (string4.equals("CPF9870")) {
                throw new ObjectAlreadyExistsException(this.path_, 1);
            }
            throw this.buildException(nativeException);
        }
        finally {
            if (bl4) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String string = "QSYS/DLTDTAQ DTAQ(" + this.library_ + "/" + this.name_ + ")";
        byte[] byArray = this.converter_.stringToByteArray(string);
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl = this.system_.swapTo(byArray2, byArray3);
        try {
            this.deleteNative(byArray);
        }
        catch (NativeException nativeException) {
            throw this.buildException(nativeException);
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
    }

    public DQReceiveRecord read(String string, int n, boolean bl, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        byte[] byArray2 = byArray == null ? new byte[2] : this.converter_.stringToByteArray(string);
        byte[] byArray3 = null;
        if (byArray != null) {
            byArray3 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        }
        byte[] byArray4 = new byte[12];
        byte[] byArray5 = new byte[12];
        boolean bl2 = this.system_.swapTo(byArray4, byArray5);
        try {
            byte[] byArray6;
            DQQueryRecord dQQueryRecord = this.retrieveAttributes(byArray != null);
            if (dQQueryRecord.saveSenderInformation_) {
                byte[] byArray7;
                byte[] byArray8 = new byte[36];
                byte[] byArray9 = byArray == null ? (bl ? this.peekSenderNative(this.libraryBytes_, this.queueNameBytes_, n, byArray8) : this.readSenderNative(this.libraryBytes_, this.queueNameBytes_, n, byArray8)) : (byArray7 = bl ? this.peekKeyedSenderNative(this.libraryBytes_, this.queueNameBytes_, n, byArray2, byArray3, byArray8) : this.readKeyedSenderNative(this.libraryBytes_, this.queueNameBytes_, n, byArray2, byArray3, byArray8));
                if (byArray7.length == 0) {
                    DQReceiveRecord dQReceiveRecord = null;
                    return dQReceiveRecord;
                }
                DQReceiveRecord dQReceiveRecord = new DQReceiveRecord(this.converter_.byteArrayToString(byArray8), byArray7, byArray3);
                return dQReceiveRecord;
            }
            byte[] byArray10 = byArray == null ? (bl ? this.peekNative(this.libraryBytes_, this.queueNameBytes_, n) : this.readNative(this.libraryBytes_, this.queueNameBytes_, n)) : (byArray6 = bl ? this.peekKeyedNative(this.libraryBytes_, this.queueNameBytes_, n, byArray2, byArray3) : this.readKeyedNative(this.libraryBytes_, this.queueNameBytes_, n, byArray2, byArray3));
            if (byArray6.length == 0) {
                DQReceiveRecord dQReceiveRecord = null;
                return dQReceiveRecord;
            }
            DQReceiveRecord dQReceiveRecord = new DQReceiveRecord(null, byArray6, byArray3);
            return dQReceiveRecord;
        }
        catch (NativeException nativeException) {
            throw this.buildException(byArray != null, nativeException);
        }
        finally {
            if (bl2) {
                this.system_.swapBack(byArray4, byArray5);
            }
        }
    }

    public DQQueryRecord retrieveAttributes(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        byte[] byArray = new byte[61];
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = new byte[12];
        boolean bl2 = this.system_.swapTo(byArray2, byArray3);
        try {
            this.retrieveAttributesNative(this.libraryBytes_, this.queueNameBytes_, byArray);
        }
        catch (NativeException nativeException) {
            throw this.buildException(nativeException);
        }
        finally {
            if (bl2) {
                this.system_.swapBack(byArray2, byArray3);
            }
        }
        DQQueryRecord dQQueryRecord = new DQQueryRecord();
        if (bl) {
            if (byArray[8] != -46) {
                Trace.log(2, "Using KeyedDataQueue for non-keyed data queue.");
                throw new IllegalObjectTypeException(2);
            }
            dQQueryRecord.FIFO_ = true;
        } else if (byArray[8] == -58) {
            dQQueryRecord.FIFO_ = true;
        } else if (byArray[8] == -45) {
            dQQueryRecord.FIFO_ = false;
        } else {
            Trace.log(2, "Using DataQueue for keyed data queue.");
            throw new IllegalObjectTypeException(1);
        }
        dQQueryRecord.maxEntryLength_ = BinaryConverter.byteArrayToInt(byArray, 0);
        dQQueryRecord.saveSenderInformation_ = byArray[9] != -43;
        dQQueryRecord.forceToAuxiliaryStorage_ = byArray[10] != -43;
        dQQueryRecord.description_ = this.converter_.byteArrayToString(byArray, 11, 50);
        dQQueryRecord.keyLength_ = BinaryConverter.byteArrayToInt(byArray, 4);
        return dQQueryRecord;
    }

    public void write(byte[] byArray, byte[] byArray2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        byte[] byArray3 = new byte[12];
        byte[] byArray4 = new byte[12];
        boolean bl = this.system_.swapTo(byArray3, byArray4);
        try {
            if (byArray == null) {
                this.writeNative(this.libraryBytes_, this.queueNameBytes_, byArray2);
            } else {
                this.writeKeyNative(this.libraryBytes_, this.queueNameBytes_, byArray, byArray2);
            }
        }
        catch (NativeException nativeException) {
            throw this.buildException(byArray != null, nativeException);
        }
        finally {
            if (bl) {
                this.system_.swapBack(byArray3, byArray4);
            }
        }
    }

    private AS400Exception buildException(NativeException nativeException) throws AS400SecurityException, ObjectDoesNotExistException {
        String string = this.converter_.byteArrayToString(nativeException.data, 12, 7);
        int n = BinaryConverter.byteArrayToInt(nativeException.data, 80);
        int n2 = BinaryConverter.byteArrayToInt(nativeException.data, 88);
        String string2 = this.converter_.byteArrayToString(nativeException.data, 112 + n, n2);
        if (string.equals("CPF9801") || string.equals("CPF2105") || string.equals("CPF9805")) {
            throw new ObjectDoesNotExistException(this.path_, 2);
        }
        if (string.equals("CPF9810")) {
            throw new ObjectDoesNotExistException(this.path_, 1);
        }
        if (string.equals("CPF9802") || string.equals("CPF2189")) {
            throw new AS400SecurityException(this.path_, 4);
        }
        if (string.equals("CPF9820") || string.equals("CPF2182")) {
            throw new AS400SecurityException(this.path_, 3);
        }
        AS400Message aS400Message = new AS400Message(string, string2);
        aS400Message.setType((nativeException.data[19] & 0xF) * 10 + (nativeException.data[20] & 0xF));
        aS400Message.setSeverity(BinaryConverter.byteArrayToInt(nativeException.data, 8));
        return new AS400Exception(aS400Message);
    }

    private AS400Exception buildException(boolean bl, NativeException nativeException) throws AS400SecurityException, IllegalObjectTypeException, ObjectDoesNotExistException {
        String string = this.converter_.byteArrayToString(nativeException.data, 12, 7);
        if (bl && string.equals("CPF9502")) {
            Trace.log(2, "Using KeyedDataQueue for non-keyed data queue: " + this.path_);
            throw new IllegalObjectTypeException(this.path_, 2);
        }
        if (!bl && string.equals("CPF9506")) {
            Trace.log(2, "Using DataQueue for keyed data queue: " + this.path_);
            throw new IllegalObjectTypeException(this.path_, 1);
        }
        return this.buildException(nativeException);
    }

    private native void clearNative(byte[] var1, byte[] var2) throws NativeException;

    private native void clearKeyNative(byte[] var1, byte[] var2, byte[] var3) throws NativeException;

    private native void createNative(byte[] var1) throws NativeException;

    private native void deleteNative(byte[] var1) throws NativeException;

    private native byte[] peekKeyedSenderNative(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, byte[] var6) throws NativeException;

    private native byte[] readKeyedSenderNative(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, byte[] var6) throws NativeException;

    private native byte[] peekKeyedNative(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5) throws NativeException;

    private native byte[] readKeyedNative(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5) throws NativeException;

    private native byte[] peekSenderNative(byte[] var1, byte[] var2, int var3, byte[] var4) throws NativeException;

    private native byte[] readSenderNative(byte[] var1, byte[] var2, int var3, byte[] var4) throws NativeException;

    private native byte[] peekNative(byte[] var1, byte[] var2, int var3) throws NativeException;

    private native byte[] readNative(byte[] var1, byte[] var2, int var3) throws NativeException;

    private native void retrieveAttributesNative(byte[] var1, byte[] var2, byte[] var3) throws NativeException;

    private native void writeNative(byte[] var1, byte[] var2, byte[] var3) throws NativeException;

    private native void writeKeyNative(byte[] var1, byte[] var2, byte[] var3, byte[] var4) throws NativeException;

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        System.load("/QSYS.LIB/QYJSPART.SRVPGM");
    }
}

