/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class XMLWriter
extends OutputStreamWriter {
    private String newline = System.getProperty("line.separator");
    private int indent = 0;
    public static int DEFAULT = 0;
    public static int PRETTY = 1;
    public static int COMPACT = 2;
    private int outputStyle = PRETTY;

    public XMLWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\n') {
                int n3 = this.newline.length();
                int n4 = 0;
                while (n4 < n3) {
                    this.write(this.newline.charAt(n4));
                    ++n4;
                }
            } else {
                this.write(c);
            }
            ++n2;
        }
    }

    public void writeQuotedString(String string) throws IOException {
        char c = '\"';
        if (string.indexOf(34) >= 0 && string.indexOf(39) < 0) {
            c = '\'';
        }
        this.write(c);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (c2 == c) {
                if (c == '\"') {
                    this.writeChars("&quot;");
                } else {
                    this.writeChars("&apos;");
                }
            } else {
                this.write(c2);
            }
            ++n2;
        }
        this.write(c);
    }

    public void writeNewLine() throws IOException {
        if (this.outputStyle == PRETTY) {
            int n = this.newline.length();
            int n2 = 0;
            while (n2 < n) {
                this.write(this.newline.charAt(n2));
                ++n2;
            }
        }
    }

    public void addIndent(int n) {
        this.indent += n;
    }

    public void writeIndent() throws IOException {
        if (this.outputStyle == PRETTY) {
            int n = 0;
            while (n < this.indent) {
                this.write(9);
                ++n;
            }
        }
    }

    public void setOutputStyle(int n) {
        this.outputStyle = n;
    }

    public int getOutputStyle() {
        return this.outputStyle;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

