/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.java.ChoiceDescriptor;
import com.ibm.as400.ui.framework.java.DeckPaneManager;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.EventHandler;
import com.ibm.as400.ui.framework.java.MenuManager;
import com.ibm.as400.ui.framework.java.PanelListModel;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.PropertySheetManager;
import com.ibm.as400.ui.framework.java.SplitPaneManager;
import com.ibm.as400.ui.framework.java.TabbedPaneManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import com.ibm.as400.ui.framework.java.WizardManager;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.HelpException;
import com.ibm.as400.ui.tools.PopupListener;
import com.ibm.as400.ui.tools.RC2XML;
import com.ibm.as400.ui.tools.ShowPaneHandler;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import com.ibm.as400.ui.tools.XMLGUIDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ViewHandler
extends EventHandler
implements ActionListener {
    protected static String m_PDML;
    protected static XMLGUIDefinition m_definition;
    protected static final String m_viewTemp = "guitemp";
    private static PreviewWindowListener m_previewListener;

    public ViewHandler(PanelManager panelManager) {
        super(panelManager);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        JComboBox jComboBox = (JComboBox)this.panelManager.getComponent("IDCB_com_ibm_as400_ui_tools_PDMLViewerBean_ViewType");
        String string = ((ChoiceDescriptor)jComboBox.getSelectedItem()).getName();
        JList jList = (JList)this.panelManager.getComponent("IDNA_Names");
        Object[] objectArray = jList.getSelectedValues();
        String string2 = ((JTextField)this.panelManager.getComponent("IDCB_com_ibm_as400_ui_tools_PDMLViewerBean_ViewPDML")).getText();
        String string3 = RC2XML.getBaseName(string2);
        Locale locale = null;
        if (string3 != null) {
            object = string2;
            int n = ((String)(object = ((String)object).replace('\\', '/'))).lastIndexOf(47);
            if (n > -1 && n + 1 < ((String)object).length()) {
                object = ((String)object).substring(n + 1);
            }
            if ((n = ((String)object).lastIndexOf(46)) > -1) {
                object = ((String)object).substring(0, n);
            }
            if ((n = ((String)object).indexOf(95)) > -1 && n + 1 < ((String)object).length()) {
                object = ((String)object).substring(n + 1);
            }
            locale = RC2XML.generateLocale((String)object);
        }
        if ((object = actionEvent.getSource()).equals(this.panelManager.getComponent("IDNA_VIEW_REFRESH"))) {
            ViewHandler.refreshViewList(string2, string, jList);
        } else {
            if (object.equals(this.panelManager.getComponent("IDNA_VIEW_VIEW")) && (objectArray == null || objectArray.length == 0)) {
                String string4 = RC2XML.resourceLoader.getString("IDNA_NO_LIST_SELECTION");
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), string4, RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                jList.requestFocus();
                return;
            }
            Container container = jList;
            while (container.getParent() != null) {
                container = container.getParent();
            }
            container.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (object.equals(this.panelManager.getComponent("IDNA_VIEW_VIEW"))) {
                    ViewHandler.view(string, string2, objectArray);
                } else if (object.equals(this.panelManager.getComponent("IDNA_VIEW_SERIALIZE"))) {
                    ViewHandler.serialize(string2);
                    JOptionPane.showMessageDialog(this.panelManager.getWindow(), RC2XML.resourceLoader.getString("IDNA_SERIALIZATION_COMPLETED"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 1);
                }
            }
            catch (DisplayManagerException displayManagerException) {
                displayManagerException.displayUserMessage((Component)jList);
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), RC2XML.resourceLoader.getString("IDNA_PARSE_EXCEPTION"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                parseException.reportErrors();
            }
            catch (PDMLSpecificationException pDMLSpecificationException) {
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), RC2XML.resourceLoader.getString("IDNA_PDML_EXCEPTION"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                pDMLSpecificationException.reportErrors();
            }
            catch (MissingResourceException missingResourceException) {
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), RC2XML.resourceLoader.getString("IDNA_MISSING_RESOURCE_EXCEPTION"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), RC2XML.resourceLoader.getString("IDS_CONVERSION_NOT_PERFORMED"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), RC2XML.resourceLoader.getString("IDNA_FILE_NOT_FOUND_EXCEPTION"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), RC2XML.resourceLoader.getString("IDS_CONVERSION_NOT_PERFORMED"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), throwable.getLocalizedMessage(), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                JOptionPane.showMessageDialog(this.panelManager.getWindow(), RC2XML.resourceLoader.getString("IDS_CONVERSION_NOT_PERFORMED"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
            }
            container.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void refreshViewList(String string, String string2, JList jList) {
        Serializable serializable;
        Container container = jList;
        while (container.getParent() != null) {
            container = container.getParent();
        }
        container.setCursor(Cursor.getPredefinedCursor(3));
        Enumeration enumeration = null;
        if (string != null && string.trim().length() > 0) {
            serializable = null;
            if (!string.equals(m_PDML)) {
                m_definition = null;
                try {
                    m_definition = new XMLGUIDefinition(string, false);
                    m_PDML = string;
                }
                catch (PDMLSpecificationException pDMLSpecificationException) {
                    JOptionPane.showMessageDialog(container, RC2XML.resourceLoader.getString("IDNA_PARSE_EXCEPTION"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                    pDMLSpecificationException.reportErrors();
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(container, RC2XML.resourceLoader.getString("IDNA_PARSE_EXCEPTION"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                    parseException.reportErrors();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JOptionPane.showMessageDialog(container, RC2XML.resourceLoader.getString("IDNA_FILE_NOT_FOUND_EXCEPTION"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                }
                catch (MissingResourceException missingResourceException) {
                    JOptionPane.showMessageDialog(container, RC2XML.resourceLoader.getString("IDNA_MISSING_RESOURCE_EXCEPTION"), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(container, throwable.getLocalizedMessage(), RC2XML.resourceLoader.getString("IDNA_INFO_TITLE"), 2);
                }
            }
            if ((serializable = m_definition) != null) {
                if (string2.equals("PANEL_CHOICE")) {
                    enumeration = ((XMLGUIDefinition)serializable).panelNames();
                } else if (string2.equals("PROPERTYSHEET_CHOICE")) {
                    enumeration = ((XMLGUIDefinition)serializable).propertySheetNames();
                } else if (string2.equals("WIZARD_CHOICE")) {
                    enumeration = ((XMLGUIDefinition)serializable).wizardNames();
                } else if (string2.equals("DECKPANE_CHOICE")) {
                    enumeration = ((XMLGUIDefinition)serializable).deckPaneNames();
                } else if (string2.equals("SPLITPANE_CHOICE")) {
                    enumeration = ((XMLGUIDefinition)serializable).splitPaneNames();
                } else if (string2.equals("TABBEDPANE_CHOICE")) {
                    enumeration = ((XMLGUIDefinition)serializable).tabbedPaneNames();
                } else if (string2.equals("MENU_CHOICE")) {
                    enumeration = ((XMLGUIDefinition)serializable).menuNames();
                }
            }
        }
        serializable = new Vector();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ((Vector)serializable).addElement(enumeration.nextElement());
            }
        }
        Object[] objectArray = new Object[((Vector)serializable).size()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = ((Vector)serializable).elementAt(n);
            ++n;
        }
        PanelListModel panelListModel = new PanelListModel();
        panelListModel.setList(objectArray);
        jList.setModel(panelListModel);
        jList.repaint();
        Container container2 = jList;
        while (container2 != null) {
            ((Component)container2).invalidate();
            ((Component)container2).validate();
            if (container2 instanceof JScrollPane) break;
            container2 = container2.getParent();
        }
        container.setCursor(Cursor.getDefaultCursor());
    }

    public static void view(String string, String string2, Object[] objectArray) throws IOException, DisplayManagerException, ParseException, PDMLSpecificationException, MissingResourceException, FileNotFoundException {
        if (objectArray == null) {
            return;
        }
        String string3 = new String(string2);
        int n = string3.lastIndexOf(46);
        if (n > -1) {
            string3 = string3.substring(0, n);
        }
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = new XMLGUIBuilderDefinition(string2, false);
        xMLGUIBuilderDefinition.setSaveAsResourceName(m_viewTemp);
        try {
            xMLGUIBuilderDefinition.saveAs(new File("guitemp.pdml"), true);
        }
        catch (HelpException helpException) {
            // empty catch block
        }
        String string4 = m_viewTemp;
        Locale locale = null;
        UIFramework.setResourceMode((int)2);
        UIFramework.setSearchMode((int)3);
        int n2 = 0;
        while (n2 < objectArray.length) {
            JFrame jFrame;
            PanelManager panelManager;
            String string5 = (String)objectArray[n2];
            if (string.equals("PANEL_CHOICE")) {
                panelManager = new PanelManager(string4, locale, string5, null);
                panelManager.getWindow().addWindowListener(m_previewListener);
                panelManager.loadData();
                panelManager.setVisible(true);
            } else if (string.equals("PROPERTYSHEET_CHOICE")) {
                panelManager = new PropertySheetManager(string4, locale, string5, null);
                panelManager.getWindow().addWindowListener(m_previewListener);
                panelManager.loadData();
                panelManager.setVisible(true);
            } else if (string.equals("WIZARD_CHOICE")) {
                panelManager = new WizardManager(string4, locale, string5, null, null);
                panelManager.getWindow().addWindowListener(m_previewListener);
                panelManager.loadData();
                panelManager.setVisible(true);
            } else if (string.equals("DECKPANE_CHOICE")) {
                jFrame = new JFrame();
                jFrame.addWindowListener(m_previewListener);
                panelManager = new DeckPaneManager(string4, locale, string5, null, jFrame.getContentPane());
                panelManager.loadData();
                ViewHandler.previewDeckPane((DeckPaneManager)panelManager, jFrame);
            } else if (string.equals("SPLITPANE_CHOICE")) {
                jFrame = new JFrame();
                jFrame.addWindowListener(m_previewListener);
                panelManager = new SplitPaneManager(string4, locale, string5, null, jFrame.getContentPane());
                panelManager.loadData();
                ViewHandler.previewPane(panelManager.getTitle(), jFrame);
            } else if (string.equals("TABBEDPANE_CHOICE")) {
                jFrame = new JFrame();
                jFrame.addWindowListener(m_previewListener);
                panelManager = new TabbedPaneManager(string4, locale, string5, null, jFrame.getContentPane());
                panelManager.loadData();
                ViewHandler.previewPane(panelManager.getTitle(), jFrame);
            } else if (string.equals("MENU_CHOICE")) {
                jFrame = new JFrame();
                jFrame.addWindowListener(m_previewListener);
                ViewHandler.previewMenu(string4, locale, string5, jFrame);
            }
            ++n2;
        }
    }

    protected static void deleteTempFiles() {
        File file = new File("guitemp.pdml");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File("guitemp.properties")).exists()) {
            file.delete();
        }
    }

    protected static void previewPane(String string, JFrame jFrame) {
        jFrame.setTitle(string);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        jFrame.show();
    }

    protected static void previewDeckPane(DeckPaneManager deckPaneManager, JFrame jFrame) {
        ShowPaneHandler showPaneHandler = new ShowPaneHandler(deckPaneManager);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(RC2XML.resourceLoader.getString("IDM_PREVIEW_VIEW_PANE"));
        String[] stringArray = deckPaneManager.getPaneNames();
        if (stringArray != null) {
            ButtonGroup buttonGroup = new ButtonGroup();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                buttonGroup.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem.setActionCommand(string);
                jRadioButtonMenuItem.addActionListener(showPaneHandler);
                jMenu.add(jRadioButtonMenuItem);
                ++n;
            }
            jMenuBar.add(jMenu);
            jFrame.setJMenuBar(jMenuBar);
            ViewHandler.previewPane(deckPaneManager.getTitle(), jFrame);
        }
    }

    protected static void previewMenu(String string, Locale locale, String string2, JFrame jFrame) throws DisplayManagerException {
        MenuManager menuManager = new MenuManager(string, locale, string2, null);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(menuManager.getMenu());
        jFrame.setJMenuBar(jMenuBar);
        String string3 = GUIFactory.getString("IDS_PREVIEW_CONTEXT_MENU");
        JLabel jLabel = new JLabel(string3, 0);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jLabel, "Center");
        PopupListener popupListener = new PopupListener(string, locale, string2, jFrame);
        jFrame.addMouseListener(popupListener);
        jFrame.setTitle(string2);
        jFrame.pack();
        Dimension dimension = jFrame.getSize();
        dimension.height = 300;
        if (dimension.width < 300) {
            dimension.width = 300;
        }
        ((Component)jFrame).setSize(dimension);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        jFrame.show();
    }

    public static void serialize(String string) throws MissingResourceException, ParseException, FileNotFoundException, IOException, PDMLSpecificationException {
        XMLGUIDefinition xMLGUIDefinition = new XMLGUIDefinition(string);
        xMLGUIDefinition.serialize();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        m_previewListener = new PreviewWindowListener();
    }

    static class PreviewWindowListener
    extends WindowAdapter {
        PreviewWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            windowEvent.getWindow().dispose();
        }
    }
}

