/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;

class ValidationDialog
extends JDialog {
    GUIBuilder m_builder;
    XMLGUIBuilderDefinition m_document;
    JList m_list;
    JLabel m_label;
    JButton m_gotoButton;
    Hashtable m_classes;
    Hashtable m_attributes;
    Vector m_errors;
    boolean m_bGenerateBeans;
    boolean m_bGenerateHandlers;

    ValidationDialog(GUIBuilder gUIBuilder) {
        super(gUIBuilder, "", false);
        this.m_builder = gUIBuilder;
        this.m_errors = new Vector(5, 5);
        this.m_classes = new Hashtable();
        this.m_attributes = new Hashtable();
        this.m_label = new JLabel();
        this.m_list = new JList();
        this.m_list.setSelectionMode(0);
        this.m_list.addListSelectionListener(new ValidationListSelectionListener());
        this.m_list.addMouseListener(new ValidationMouseListener());
        this.m_list.setCellRenderer(new ValidationCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.m_list);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        DividerPanel dividerPanel = new DividerPanel();
        dividerPanel.setLayout(new BorderLayout());
        dividerPanel.add((Component)jScrollPane, "Center");
        ValidationActionListener validationActionListener = new ValidationActionListener();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 5, 0));
        this.m_gotoButton = GUIFactory.createButton("Go To", null, "IDS_GO_TO", null, null, false, validationActionListener);
        jPanel.add(this.m_gotoButton);
        JButton jButton = GUIFactory.createButton("Close", null, "IDS_CLOSE", null, null, true, validationActionListener);
        jPanel.add(jButton);
        JButton jButton2 = GUIFactory.createButton("Help", null, "IDS_HELP", null, null, true, validationActionListener);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 0, 0));
        jPanel2.add(jPanel);
        Dimension dimension = new Dimension(80, 25);
        Dimension dimension2 = this.m_gotoButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        dimension2 = jButton2.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        this.m_gotoButton.setPreferredSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.m_label, "North");
        jPanel3.add((Component)dividerPanel, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 10));
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel2, "South");
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel4, "Center");
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.m_gotoButton);
        dimension2 = this.getPreferredSize();
        if (dimension2.width < 400) {
            dimension2.width = 400;
        }
        dimension2.height = 300;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point();
        point.x = (dimension3.width - dimension2.width) / 2;
        point.y = (dimension3.height - dimension2.height) / 2;
        ((Component)this).setBounds(point.x, point.y, dimension2.width, dimension2.height);
        this.addKeyListener(new ValidationKeyListener());
    }

    XMLGUIBuilderDefinition getPDMLDocument() {
        return this.m_document;
    }

    boolean validatePDMLDocument(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, String string) {
        this.m_bGenerateBeans = (Boolean)xMLGUIBuilderDefinition.getPDMLRoot().getProperty("Generate Beans");
        this.m_bGenerateHandlers = (Boolean)xMLGUIBuilderDefinition.getPDMLRoot().getProperty("Generate Handlers");
        this.m_errors.removeAllElements();
        this.m_classes.clear();
        this.m_attributes.clear();
        this.m_document = xMLGUIBuilderDefinition;
        this.validateNode(xMLGUIBuilderDefinition.getPDMLRoot());
        this.validateResourceName(string);
        String string2 = (String)xMLGUIBuilderDefinition.getPDMLRoot().getProperty("File Name");
        if (string2.equals("")) {
            string2 = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, true);
        }
        this.setTitle(GUIFactory.getString("IDS_VALIDATION_TITLEBAR") + " (" + string2 + ")");
        int n = this.m_errors.size();
        this.m_list.setListData(this.m_errors);
        if (n > 1) {
            Object[] objectArray = new Object[]{new Integer(n)};
            string2 = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERRORS_MANY"), objectArray);
        } else {
            string2 = n == 1 ? GUIFactory.getString("IDS_VALIDATION_ERRORS_ONE") : GUIFactory.getString("IDS_VALIDATION_ERRORS_NONE");
        }
        this.m_label.setText(string2);
        this.m_list.requestFocus();
        return n == 0;
    }

    void doGoTo() {
        int n = this.m_list.getSelectedIndex();
        if (n > -1) {
            BuilderFrame builderFrame;
            ValidationError validationError = (ValidationError)this.m_list.getModel().getElementAt(n);
            TreeNode[] treeNodeArray = validationError.m_properties.getPath();
            if (treeNodeArray[0].equals(validationError.m_properties.getPDMLDocument().getPDMLRoot()) && (builderFrame = this.showEditor(validationError.m_properties, true)) != null) {
                builderFrame.setSelectedProperties(validationError.m_properties);
            }
        }
    }

    BuilderFrame showEditor(MutableProperties mutableProperties, boolean bl) {
        if (mutableProperties == null) {
            return null;
        }
        switch (mutableProperties.getType()) {
            default: {
                break;
            }
            case 1: 
            case 50: 
            case 51: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 120: 
            case 121: 
            case 126: {
                this.m_builder.showEditor(mutableProperties);
                return this.m_builder.getEditor(mutableProperties);
            }
            case 8: 
            case 9: 
            case 103: 
            case 104: {
                if (bl) break;
                this.m_builder.showEditor(mutableProperties);
                return this.m_builder.getEditor(mutableProperties);
            }
        }
        return this.showEditor((MutableProperties)mutableProperties.getParent(), false);
    }

    void validateNode(MutableProperties mutableProperties) {
        Object object;
        Object object2;
        String[] stringArray;
        String string;
        int n = mutableProperties.getType();
        String string2 = (String)mutableProperties.getProperty("Name");
        Object[] objectArray = new Object[]{mutableProperties.getFullyQualifiedName(string2)};
        block0 : switch (n) {
            default: {
                break;
            }
            case 61: {
                if (mutableProperties.getChildCount() >= 2) break;
                string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_SPLITPANE_CHILDREN"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string));
                break;
            }
            case 51: 
            case 60: 
            case 62: 
            case 120: 
            case 121: {
                if (mutableProperties.getChildCount() != 0) break;
                string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_NO_CHILDREN"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string));
                break;
            }
            case 50: {
                if (mutableProperties.getChildCount() != 0) break;
                objectArray[0] = mutableProperties.getFullyQualifiedName(string2) + "." + GUIFactory.getString("IDS_MENUBAR");
                string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_NO_CHILDREN"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string));
                break;
            }
            case 55: {
                if (mutableProperties.getChildCount() != 0) break;
                objectArray[0] = mutableProperties.getFullyQualifiedName(string2) + "." + GUIFactory.getString("IDS_TOOLBAR");
                string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_NO_CHILDREN"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string));
                break;
            }
            case 52: {
                if (mutableProperties.getProperty("Menu Item Type").equals("submenu") && mutableProperties.getChildCount() == 0) {
                    string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_NO_CHILDREN"), objectArray);
                    this.m_errors.addElement(new ValidationError(mutableProperties, string));
                }
                if (!mutableProperties.getProperty("Title").equals("") || !mutableProperties.getProperty("Icon").equals("")) break;
                string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_NO_TITLE_OR_ICON"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string));
                break;
            }
            case 110: {
                if (!mutableProperties.getProperty("Title").equals("")) break;
                string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_NO_ICON"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string));
                break;
            }
            case 103: {
                boolean bl = false;
                int n2 = 2;
                while (n2 < mutableProperties.getChildCount()) {
                    MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getChildAt(n2);
                    String string3 = (String)mutableProperties2.getProperty("Data Class");
                    if (n2 == 2) {
                        bl = !string3.equals("");
                    } else if (bl && string3.equals("") || !bl && !string3.equals("")) {
                        string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_COLUMN_DATACLASS"), objectArray);
                        this.m_errors.addElement(new ValidationError(mutableProperties2, string));
                        break block0;
                    }
                    ++n2;
                }
                break block0;
            }
        }
        if (mutableProperties.hasProperty("Data Class") && mutableProperties.isPropertyVisible("Data Class")) {
            stringArray = (String)mutableProperties.getProperty("Data Class");
            object2 = (String)mutableProperties.getProperty("Attribute");
            if (!stringArray.equals("") && ((String)object2).equals("")) {
                string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_ATTRIBUTE_MISSING"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string));
            } else if (stringArray.equals("") && !((String)object2).equals("")) {
                string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_DATACLASS_MISSING"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string));
            } else if (!stringArray.equals("") && !((String)object2).equals("")) {
                this.validateClass((String)stringArray, "Data Class", mutableProperties);
                this.validateAttribute((String)stringArray, (String)object2, mutableProperties);
            }
        }
        if (mutableProperties.hasProperty("* Help Alias") && mutableProperties.isPropertyVisible("* Help Alias") && (stringArray = mutableProperties.getProperty("* Help Alias")) instanceof MutableProperties && (!((MutableProperties)(object2 = (MutableProperties)stringArray)).hasProperty("* Help Link") || !((MutableProperties)object2).isPropertyVisible("* Help Link"))) {
            object = new Object[]{mutableProperties.getFullyQualifiedName(string2), ((MutableProperties)object2).getProperty("Name")};
            string = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_HELP_ALIAS_NOT_VALID"), (Object[])object);
            this.m_errors.addElement(new ValidationError(mutableProperties, string));
        }
        stringArray = new String[]{"Action", "Adjust", "Activate", "Double Click", "Menu Action", "* Class", "Manager Class", "Renderer", "Editor"};
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (mutableProperties.hasProperty(stringArray[n3]) && mutableProperties.isPropertyVisible(stringArray[n3]) && !((String)(object = (String)mutableProperties.getProperty(stringArray[n3]))).equals("")) {
                this.validateClass((String)object, stringArray[n3], mutableProperties);
            }
            ++n3;
        }
        if (mutableProperties.getAllowsChildren()) {
            Enumeration<TreeNode> enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                object = (MutableProperties)enumeration.nextElement();
                this.validateNode((MutableProperties)object);
            }
        }
    }

    void validateClass(String string, String string2, MutableProperties mutableProperties) {
        if (!this.m_bGenerateBeans && !this.m_bGenerateHandlers) {
            return;
        }
        ValidationError validationError = (ValidationError)this.m_classes.get(string);
        if (validationError != null) {
            if (!validationError.m_message.equals(string2)) {
                if (validationError.m_message.equals("Action") && (string2.equals("Double Click") || string2.equals("Adjust") || string2.equals("Activate"))) {
                    return;
                }
                if (validationError.m_message.equals("Data Class") && !string2.equals("Resource") || string2.equals("Data Class") && !validationError.m_message.equals("Resource")) {
                    return;
                }
                if (validationError.m_message.equals("Renderer") && !string2.equals("Resource") || string2.equals("Renderer") && !validationError.m_message.equals("Resource")) {
                    return;
                }
                if (validationError.m_message.equals("Editor") && !string2.equals("Resource") || string2.equals("Editor") && !validationError.m_message.equals("Resource")) {
                    return;
                }
                String string3 = (String)mutableProperties.getProperty("Name");
                String string4 = (String)validationError.m_properties.getProperty("Name");
                Object[] objectArray = new Object[]{mutableProperties.getFullyQualifiedName(string3), string, GUIFactory.getLocalizedPropertyName(string2), GUIFactory.getLocalizedPropertyName(validationError.m_message), validationError.m_properties.getFullyQualifiedName(string4)};
                String string5 = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_DATACLASS_CONFLICT"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string5));
            }
        } else {
            if (string2.equals("Double Click") || string2.equals("Adjust") || string2.equals("Activate")) {
                string2 = "Action";
            }
            this.m_classes.put(string, new ValidationError(mutableProperties, string2));
        }
    }

    void validateResourceName(String string) {
        if (string == null) {
            return;
        }
        ValidationError validationError = (ValidationError)this.m_classes.get(string);
        if (validationError != null) {
            String string2 = (String)validationError.m_properties.getProperty("Name");
            Object[] objectArray = new Object[]{validationError.m_properties.getFullyQualifiedName(string2), string, GUIFactory.getLocalizedPropertyName(validationError.m_message)};
            String string3 = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_RESOURCE_CONFLICT"), objectArray);
            this.m_errors.addElement(new ValidationError(validationError.m_properties, string3));
        }
    }

    void validateAttribute(String string, String string2, MutableProperties mutableProperties) {
        if (!this.m_bGenerateBeans) {
            return;
        }
        String string3 = string + "." + string2;
        MutableProperties mutableProperties2 = (MutableProperties)this.m_attributes.get(string3);
        if (mutableProperties2 != null) {
            int n;
            int n2 = mutableProperties.getType();
            boolean bl = n2 != (n = mutableProperties2.getType());
            switch (n2) {
                default: {
                    break;
                }
                case 101: 
                case 102: {
                    bl = n != 101 && n != 102;
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    bl = n != 4 && n != 5 && n != 2;
                    break;
                }
                case 9: 
                case 113: {
                    boolean bl2 = bl = n != 9 && n != 113;
                }
            }
            if (bl) {
                String string4 = (String)mutableProperties.getProperty("Name");
                String string5 = (String)mutableProperties2.getProperty("Name");
                Object[] objectArray = new Object[]{mutableProperties.getFullyQualifiedName(string4), string2, mutableProperties2.getFullyQualifiedName(string5)};
                String string6 = MessageFormat.format(GUIFactory.getString("IDS_VALIDATION_ERROR_ATTRIBUTE_CONFLICT"), objectArray);
                this.m_errors.addElement(new ValidationError(mutableProperties, string6));
            }
        } else {
            this.m_attributes.put(string3, mutableProperties);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class ValidationKeyListener
    extends KeyAdapter {
        ValidationKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 112) {
                ValidationDialog.this.m_builder.displayHelp("ValidationDialog", ValidationDialog.this);
            }
        }
    }

    class ValidationMouseListener
    extends MouseAdapter {
        ValidationMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                ValidationDialog.this.doGoTo();
            }
        }
    }

    class ValidationCellRenderer
    extends DefaultListCellRenderer {
        ValidationCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ValidationError validationError = (ValidationError)object;
            jLabel.setText(validationError.m_message);
            return jLabel;
        }
    }

    class ValidationListSelectionListener
    implements ListSelectionListener {
        ValidationListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = ValidationDialog.this.m_list.getSelectedIndex();
            ValidationDialog.this.m_gotoButton.setEnabled(n > -1);
        }
    }

    class ValidationActionListener
    implements ActionListener {
        ValidationActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Go To")) {
                ValidationDialog.this.doGoTo();
            } else if (string.equals("Close")) {
                ValidationDialog.this.dispose();
            } else if (string.equals("Help")) {
                ValidationDialog.this.m_builder.displayHelp("ValidationDialog", ValidationDialog.this);
            }
        }
    }

    class ValidationError {
        MutableProperties m_properties;
        String m_message;

        ValidationError(MutableProperties mutableProperties, String string) {
            this.m_properties = mutableProperties;
            this.m_message = string;
        }
    }
}

