/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuBarBorder;
import com.ibm.as400.ui.tools.MenuBuilder;
import com.ibm.as400.ui.tools.MenuItemProperties;
import com.ibm.as400.ui.tools.MenuItemRenderer;
import com.ibm.as400.ui.tools.MenuProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.ToolMenuBuilder;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class ToolMenuEditor
extends JPanel {
    MutableProperties m_properties;
    Hashtable m_items;
    ToolMenuBuilder m_menuBuilder;
    BoxLayout m_layout;
    ActionListener m_menuListener;
    JPopupMenu m_contextMenu;
    JPopupMenu m_linkContextMenu;
    JPopupMenu m_emptyContextMenu;
    Dimension m_buttonSize;
    Dimension m_emptySize = new Dimension(40, 30);

    ToolMenuEditor(ToolMenuBuilder toolMenuBuilder, MutableProperties mutableProperties) {
        Component component;
        this.m_menuBuilder = toolMenuBuilder;
        this.m_properties = mutableProperties;
        this.m_items = new Hashtable();
        this.m_menuListener = toolMenuBuilder.getContextMenuListener();
        this.m_layout = new BoxLayout(this, 0);
        this.setLayout(this.m_layout);
        this.setBorder(new MenuBarBorder(this.getBackground().darker(), this.getBackground().brighter()));
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            component = this.createMenuItem(mutableProperties2);
            if (component == null) continue;
            this.m_items.put(mutableProperties2, component);
            this.add(component);
        }
        component = new JMenuItemME(null);
        component.addMouseListener(new MenuEditorMouseAdapter());
        this.add(component);
        this.resetButtonPreferredSize();
        this.initContextMenus();
    }

    void initContextMenus() {
        this.m_contextMenu = new JPopupMenu();
        JMenu jMenu = GUIFactory.createMenu(null, "IDCM_MENUITEM_TYPE", null, true);
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenu.add(GUIFactory.createRadioButtonMenuItem("Type MenuItem", null, "IDCM_MENUITEM_ITEM", null, true, false, buttonGroup, this.m_menuListener));
        jMenu.add(GUIFactory.createRadioButtonMenuItem("Type Check", null, "IDCM_MENUITEM_CHECKBOX", null, true, false, buttonGroup, this.m_menuListener));
        jMenu.add(GUIFactory.createRadioButtonMenuItem("Type Radio", null, "IDCM_MENUITEM_RADIOBUTTON", null, true, false, buttonGroup, this.m_menuListener));
        this.m_contextMenu.add(jMenu);
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_MENUITEM_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_MENUITEM_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_MENUITEM_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_MENUITEM_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_MENUITEM_PROPERTIES", null, true, this.m_menuListener));
        this.m_linkContextMenu = new JPopupMenu();
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_MENUITEM_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_MENUITEM_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_MENUITEM_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_MENUITEM_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        this.m_linkContextMenu.addSeparator();
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_MENUITEM_PROPERTIES", null, true, this.m_menuListener));
        this.m_emptyContextMenu = new JPopupMenu();
        jMenu = GUIFactory.createMenu(null, "IDCM_MENUITEM_NEW_ITEM", null, true);
        jMenu.add(GUIFactory.createMenuItem("New MenuItem", null, "IDCM_MENUITEM_ITEM", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New Check", null, "IDCM_MENUITEM_CHECKBOX", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New Radio", null, "IDCM_MENUITEM_RADIOBUTTON", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New ItemLink", null, "IDCM_MENUITEM_ITEMLINK", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New Separator", null, "IDCM_MENUITEM_SEPARATOR", null, true, this.m_menuListener));
        this.m_emptyContextMenu.add(jMenu);
    }

    JPopupMenu getContextMenu(MutableProperties mutableProperties) {
        if (mutableProperties != null) {
            if (mutableProperties.getType() == 52) {
                JMenu jMenu = (JMenu)this.m_contextMenu.getComponent(0);
                String string = (String)mutableProperties.getProperty("Menu Item Type");
                int n = 0;
                if (string.equals("check")) {
                    n = 1;
                } else if (string.equals("radio")) {
                    n = 2;
                }
                ((JRadioButtonMenuItem)jMenu.getMenuComponent(n)).setSelected(true);
                this.m_contextMenu.getComponent(2).setEnabled(this.m_menuBuilder.canCut());
                this.m_contextMenu.getComponent(3).setEnabled(this.m_menuBuilder.canCopy());
                this.m_contextMenu.getComponent(4).setEnabled(this.m_menuBuilder.canPaste());
                this.m_contextMenu.getComponent(5).setEnabled(this.m_menuBuilder.canDelete());
                return this.m_contextMenu;
            }
            this.m_linkContextMenu.getComponent(0).setEnabled(this.m_menuBuilder.canCut());
            this.m_linkContextMenu.getComponent(1).setEnabled(this.m_menuBuilder.canCopy());
            this.m_linkContextMenu.getComponent(2).setEnabled(this.m_menuBuilder.canPaste());
            this.m_linkContextMenu.getComponent(3).setEnabled(this.m_menuBuilder.canDelete());
            return this.m_linkContextMenu;
        }
        JMenu jMenu = (JMenu)this.m_emptyContextMenu.getComponent(0);
        ((JMenuItem)jMenu.getMenuComponent(1)).setEnabled(this.m_menuBuilder.canLink());
        return this.m_emptyContextMenu;
    }

    Component createMenuItem(MutableProperties mutableProperties) {
        String string = (String)mutableProperties.getProperty("Menu Item Type");
        if (string.equals("separator")) {
            JSeparatorME jSeparatorME = new JSeparatorME(mutableProperties);
            jSeparatorME.addMouseListener(new MenuEditorMouseAdapter());
            jSeparatorME.addMouseMotionListener(new MenuEditorMouseAdapter());
            return jSeparatorME;
        }
        if (string.equals("itemlink")) {
            JMenuItemME jMenuItemME = new JMenuItemME(mutableProperties);
            jMenuItemME.addMouseListener(new MenuEditorMouseAdapter());
            jMenuItemME.addMouseMotionListener(new MenuEditorMouseAdapter());
            String string2 = (String)mutableProperties.getProperty("Link Menu") + "." + (String)mutableProperties.getProperty("Link Item");
            jMenuItemME.setToolTipText(string2);
            jMenuItemME.setIcon(GUIFactory.getImage("ImportMenu.gif", true));
            return jMenuItemME;
        }
        mutableProperties.setPropertyVisible("Menu Item Type", true);
        mutableProperties.setPropertyVisible("Accelerator", false);
        mutableProperties.setPropertyVisible("* Key", false);
        mutableProperties.setPropertyVisible("* Modifier", false);
        JMenuItemME jMenuItemME = new JMenuItemME(mutableProperties);
        jMenuItemME.addMouseListener(new MenuEditorMouseAdapter());
        jMenuItemME.addMouseMotionListener(new MenuEditorMouseAdapter());
        MenuBuilder.resetMenu(jMenuItemME, mutableProperties);
        String string3 = (String)mutableProperties.getProperty("Flyover Text");
        if (string3.equals("")) {
            string3 = null;
        }
        jMenuItemME.setToolTipText(string3);
        return jMenuItemME;
    }

    void insertItem(MutableProperties mutableProperties, int n) {
        Component component = this.createMenuItem(mutableProperties);
        this.m_items.put(mutableProperties, component);
        this.add(component, n);
        this.resetButtonPreferredSize();
        this.m_layout.invalidateLayout(this);
        this.setSize(this.getPreferredSize());
        this.m_layout.layoutContainer(this);
    }

    void removeItem(MutableProperties mutableProperties) {
        Component component = (Component)this.m_items.get(mutableProperties);
        if (component != null) {
            this.remove(component);
            this.m_items.remove(mutableProperties);
            this.resetButtonPreferredSize();
            this.m_layout.invalidateLayout(this);
            this.setSize(this.getPreferredSize());
            this.m_layout.layoutContainer(this);
        }
    }

    void refresh(MutableProperties mutableProperties) {
        Component component = (Component)this.m_items.get(mutableProperties);
        if (component == null) {
            return;
        }
        int n = 0;
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getComponent(n3).equals(component)) {
                n = n3;
                break;
            }
            ++n3;
        }
        this.remove(component);
        component = this.createMenuItem(mutableProperties);
        this.m_items.put(mutableProperties, component);
        this.add(component, n);
        this.resetButtonPreferredSize();
        this.m_layout.invalidateLayout(this);
        this.setSize(this.getPreferredSize());
        this.m_layout.layoutContainer(this);
    }

    Rectangle getItemBounds(MutableProperties mutableProperties) {
        this.m_layout.layoutContainer(this);
        Component component = (Component)this.m_items.get(mutableProperties);
        if (component != null) {
            return component.getBounds();
        }
        return null;
    }

    boolean containsItem(MutableProperties mutableProperties) {
        return this.m_items.containsKey(mutableProperties);
    }

    MutableProperties getItemAtPoint(Point point) {
        Enumeration enumeration = this.m_items.keys();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            Component component = (Component)this.m_items.get(mutableProperties);
            if (!component.getBounds().contains(point)) continue;
            return mutableProperties;
        }
        if (this.getBounds().contains(point)) {
            return (MutableProperties)this.m_properties.getLastChild();
        }
        return null;
    }

    MutableProperties getItemProperties(Component component) {
        Enumeration enumeration = this.m_items.keys();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            Component component2 = (Component)this.m_items.get(mutableProperties);
            if (!component2.equals(component)) continue;
            return mutableProperties;
        }
        return null;
    }

    MutableProperties getProperties() {
        return this.m_properties;
    }

    void resetButtonPreferredSize() {
        this.m_buttonSize = new Dimension();
        int n = 0;
        Enumeration enumeration = this.m_items.keys();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            if (mutableProperties.getType() != 52) continue;
            ++n;
            JMenuItemME jMenuItemME = (JMenuItemME)this.m_items.get(mutableProperties);
            Dimension dimension = jMenuItemME.getButtonPreferredSize();
            if (dimension.width > this.m_buttonSize.width) {
                this.m_buttonSize.width = dimension.width;
            }
            if (dimension.height <= this.m_buttonSize.height) continue;
            this.m_buttonSize.height = dimension.height;
        }
        if (n == 0) {
            this.m_buttonSize = new Dimension(this.m_emptySize);
        }
    }

    public void paint(Graphics graphics) {
        Serializable serializable;
        Rectangle rectangle;
        Object object;
        MutableProperties mutableProperties;
        super.paint(graphics);
        MutableProperties mutableProperties2 = this.m_menuBuilder.getSelectedProperties();
        MutableProperties mutableProperties3 = this.m_menuBuilder.getHoverProperties();
        Enumeration<TreeNode> enumeration = this.m_properties.children();
        while (enumeration.hasMoreElements()) {
            mutableProperties = (MutableProperties)enumeration.nextElement();
            if (!mutableProperties.equals(mutableProperties2)) continue;
            object = (Component)this.m_items.get(mutableProperties);
            rectangle = ((Component)object).getBounds();
            --rectangle.x;
            --rectangle.y;
            ++rectangle.width;
            ++rectangle.height;
            serializable = graphics.getColor();
            graphics.setColor(Color.blue);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor((Color)serializable);
            break;
        }
        if (mutableProperties3 == null) {
            return;
        }
        if (mutableProperties3.equals(this.getProperties()) && this.m_menuBuilder.getHoverDirection() == 2) {
            object = this.getComponent(0);
            rectangle = ((Component)object).getBounds();
            serializable = graphics.getColor();
            graphics.setColor(Color.magenta);
            graphics.drawLine(rectangle.x, rectangle.y - 1, rectangle.x, rectangle.height + 1);
            graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.x - 1, rectangle.height + 1);
            graphics.setColor((Color)serializable);
        } else {
            object = this.m_properties.children();
            while (object.hasMoreElements()) {
                mutableProperties = (MutableProperties)object.nextElement();
                if (!mutableProperties.equals(mutableProperties3) || this.m_menuBuilder.getHoverDirection() == 2) continue;
                boolean bl = mutableProperties.getProperty("Menu Item Type").equals("separator");
                serializable = (Component)this.m_items.get(mutableProperties);
                Rectangle rectangle2 = ((Component)serializable).getBounds();
                Color color = graphics.getColor();
                graphics.setColor(Color.magenta);
                if (this.m_menuBuilder.getHoverDirection() == 0) {
                    graphics.drawLine(rectangle2.x, rectangle2.y - 1, rectangle2.x, rectangle2.height + 1);
                    graphics.drawLine(rectangle2.x - 1, rectangle2.y - 1, rectangle2.x - 1, rectangle2.height + 1);
                } else {
                    graphics.drawLine(rectangle2.x + rectangle2.width - 1, rectangle2.y - 1, rectangle2.x + rectangle2.width - 1, rectangle2.height + 1);
                    graphics.drawLine(rectangle2.x + rectangle2.width, rectangle2.y - 1, rectangle2.x + rectangle2.width, rectangle2.height + 1);
                }
                graphics.setColor(color);
                break;
            }
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class JSeparatorME
    extends JSeparator {
        MutableProperties myProperties;

        JSeparatorME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
        }

        public Dimension getMinimumSize() {
            return new Dimension(8, 0);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            int n;
            Color color = graphics.getColor();
            int n2 = n = this.getSize().width / 2 - 1;
            int n3 = 0;
            int n4 = this.getSize().height - 1;
            graphics.setColor(ToolMenuEditor.this.getBackground().darker());
            graphics.drawLine(n2, n3, n, n4);
            graphics.setColor(ToolMenuEditor.this.getBackground().brighter());
            graphics.drawLine(n2 + 1, n3, n + 1, n4);
            if (ToolMenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
            graphics.setColor(color);
        }
    }

    class JRadioButtonMenuItemME
    extends JToggleButton
    implements MenuItemRenderer {
        JToggleButton myMenuItem;
        MutableProperties myProperties;
        Insets defaultInsets;
        Insets noInsets = new Insets(0, 0, 0, 0);

        JRadioButtonMenuItemME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
            this.myMenuItem = new JToggleButton();
            this.defaultInsets = this.myMenuItem.getMargin();
            this.setModel(new DefaultButtonModel());
            boolean bl = (Boolean)mutableProperties.getProperty("Toggle Selected");
            this.myMenuItem.setSelected(bl);
            this.myMenuItem.setBorderPainted(bl);
            this.setSelected(bl);
            this.setBorderPainted(bl);
            this.setBorder(this.myMenuItem.getBorder());
            boolean bl2 = (Boolean)mutableProperties.getProperty("Disabled");
            this.myMenuItem.setEnabled(!bl2);
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenuItem != null) {
                this.myMenuItem.setIcon(icon);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.myMenuItem != null) {
                this.myMenuItem.setText(string);
                if (string == null || string.equals("")) {
                    this.myMenuItem.setMargin(this.noInsets);
                } else {
                    this.myMenuItem.setMargin(this.defaultInsets);
                }
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
        }

        public void setAccelerator(KeyStroke keyStroke) {
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenuItem != null) {
                this.myMenuItem.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            return ToolMenuEditor.this.m_buttonSize;
        }

        public Dimension getButtonPreferredSize() {
            if (this.myProperties == null) {
                int n = 50;
                int n2 = 20;
                if (ToolMenuEditor.this.getComponentCount() < 2) {
                    n = 40;
                    n2 = 30;
                }
                return new Dimension(n, n2);
            }
            if (this.myMenuItem != null) {
                return this.myMenuItem.getUI().getPreferredSize(this.myMenuItem);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenuItem != null) {
                this.myMenuItem.getUI().paint(graphics, this.myMenuItem);
            } else {
                super.paint(graphics);
            }
            this.paintBorder(graphics);
            if (ToolMenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            }
        }
    }

    class JCheckBoxMenuItemME
    extends JToggleButton
    implements MenuItemRenderer {
        JToggleButton myMenuItem;
        MutableProperties myProperties;
        Insets defaultInsets;
        Insets noInsets = new Insets(0, 0, 0, 0);

        JCheckBoxMenuItemME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
            this.myMenuItem = new JToggleButton();
            this.defaultInsets = this.myMenuItem.getMargin();
            this.setModel(new DefaultButtonModel());
            boolean bl = (Boolean)mutableProperties.getProperty("Toggle Selected");
            this.myMenuItem.setSelected(bl);
            this.myMenuItem.setBorderPainted(bl);
            this.setSelected(bl);
            this.setBorderPainted(bl);
            this.setBorder(this.myMenuItem.getBorder());
            boolean bl2 = (Boolean)mutableProperties.getProperty("Disabled");
            this.myMenuItem.setEnabled(!bl2);
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenuItem != null) {
                this.myMenuItem.setIcon(icon);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.myMenuItem != null) {
                this.myMenuItem.setText(string);
                if (string == null || string.equals("")) {
                    this.myMenuItem.setMargin(this.noInsets);
                } else {
                    this.myMenuItem.setMargin(this.defaultInsets);
                }
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
        }

        public void setAccelerator(KeyStroke keyStroke) {
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenuItem != null) {
                this.myMenuItem.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            return ToolMenuEditor.this.m_buttonSize;
        }

        public Dimension getButtonPreferredSize() {
            if (this.myProperties == null) {
                int n = 50;
                int n2 = 20;
                if (ToolMenuEditor.this.getComponentCount() < 2) {
                    n = 40;
                    n2 = 30;
                }
                return new Dimension(n, n2);
            }
            if (this.myMenuItem != null) {
                return this.myMenuItem.getUI().getPreferredSize(this.myMenuItem);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenuItem != null) {
                this.myMenuItem.getUI().paint(graphics, this.myMenuItem);
            } else {
                super.paint(graphics);
            }
            this.paintBorder(graphics);
            if (ToolMenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            }
        }
    }

    class JMenuME
    extends AbstractButton {
        JMenu myMenu;
        MutableProperties myProperties;

        JMenuME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
            this.myMenu = new JMenu();
            this.setModel(new DefaultButtonModel());
            boolean bl = (Boolean)mutableProperties.getProperty("Disabled");
            this.myMenu.setEnabled(!bl);
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenu != null) {
                this.myMenu.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenu != null) {
                this.myMenu.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenu != null) {
                this.myMenu.setIcon(icon);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.myMenu != null) {
                this.myMenu.setText(string);
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenu != null) {
                this.myMenu.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenu != null) {
                return this.myMenu.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            if (this.myMenu != null) {
                return this.myMenu.getUI().getPreferredSize(this.myMenu);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.myMenu != null) {
                return this.myMenu.getMinimumSize();
            }
            return super.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenu != null) {
                this.myMenu.getUI().paint(graphics, this.myMenu);
            } else {
                super.paint(graphics);
            }
            if (ToolMenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            }
        }
    }

    class JMenuItemME
    extends AbstractButton
    implements MenuItemRenderer {
        AbstractButton myMenuItem;
        MutableProperties myProperties;
        Insets defaultInsets;
        Insets noInsets = new Insets(0, 0, 0, 0);

        JMenuItemME(MutableProperties mutableProperties) {
            boolean bl;
            this.myProperties = mutableProperties;
            this.myMenuItem = new JToggleButton();
            this.defaultInsets = this.myMenuItem.getMargin();
            this.myMenuItem.setBorderPainted(false);
            this.setBorderPainted(false);
            this.setModel(new DefaultButtonModel());
            if (mutableProperties != null && mutableProperties.hasProperty("Disabled")) {
                bl = (Boolean)mutableProperties.getProperty("Disabled");
                this.myMenuItem.setEnabled(!bl);
            }
            if (mutableProperties != null && mutableProperties.hasProperty("Toggle Selected") && mutableProperties.isPropertyVisible("Toggle Selected")) {
                bl = (Boolean)mutableProperties.getProperty("Toggle Selected");
                this.myMenuItem.setSelected(bl);
                this.myMenuItem.setBorderPainted(bl);
                this.setSelected(bl);
                this.setBorderPainted(bl);
                this.setBorder(new BevelBorder(1));
            }
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenuItem != null) {
                this.myMenuItem.setIcon(icon);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.myMenuItem != null) {
                this.myMenuItem.setText(string);
                if (string == null || string.equals("")) {
                    this.myMenuItem.setMargin(this.noInsets);
                } else {
                    this.myMenuItem.setMargin(this.defaultInsets);
                }
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
        }

        public void setAccelerator(KeyStroke keyStroke) {
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenuItem != null) {
                this.myMenuItem.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            return ToolMenuEditor.this.m_buttonSize;
        }

        public Dimension getButtonPreferredSize() {
            if (this.myProperties == null) {
                int n = 50;
                int n2 = 20;
                if (ToolMenuEditor.this.getComponentCount() < 2) {
                    n = 40;
                    n2 = 30;
                }
                return new Dimension(n, n2);
            }
            if (this.myMenuItem != null) {
                return this.myMenuItem.getUI().getPreferredSize(this.myMenuItem);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenuItem != null) {
                this.myMenuItem.getUI().paint(graphics, this.myMenuItem);
            } else {
                super.paint(graphics);
            }
            this.paintBorder(graphics);
            if (ToolMenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            } else if (this.myProperties == null) {
                Color color = graphics.getColor();
                graphics.setColor(Color.black);
                Dimension dimension = this.getSize();
                BasicGraphicsUtils.drawDashedRect(graphics, 2, 2, dimension.width - 4, dimension.height - 4);
                graphics.setColor(color);
            }
        }
    }

    class MenuEditorMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        int m_dragCount = 0;
        int m_dragThreshold = 5;
        MutableProperties m_dragProperties = null;
        boolean m_createMode = false;

        MenuEditorMouseAdapter() {
        }

        void showContextMenu(MutableProperties mutableProperties, Point point) {
            JPopupMenu jPopupMenu = ToolMenuEditor.this.getContextMenu(mutableProperties);
            if (mutableProperties == null) {
                ToolMenuEditor.this.m_menuBuilder.setEmptyParent(ToolMenuEditor.this.getProperties());
            }
            if (jPopupMenu != null) {
                jPopupMenu.show(ToolMenuEditor.this, point.x, point.y);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MutableProperties mutableProperties = ToolMenuEditor.this.getItemProperties(component);
            if (this.m_dragProperties != null) {
                this.m_dragProperties = null;
            } else {
                if (mutableProperties != null) {
                    ToolMenuEditor.this.m_menuBuilder.setSelectedProperties(mutableProperties);
                    this.m_dragProperties = mutableProperties;
                    ToolMenuEditor.this.repaint();
                } else {
                    this.m_createMode = true;
                }
                if (mouseEvent.isPopupTrigger()) {
                    Point point = mouseEvent.getPoint();
                    Point point2 = component.getLocation();
                    point.x += point2.x;
                    point.y += point2.y;
                    this.showContextMenu(mutableProperties, point);
                    this.m_createMode = false;
                    this.m_dragProperties = null;
                }
            }
            this.m_dragCount = 0;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.m_dragCount > this.m_dragThreshold) {
                Point point = mouseEvent.getPoint();
                Point point2 = ToolMenuEditor.this.getLocation();
                point.x += point2.x;
                point.y += point2.y;
                Component component = (Component)mouseEvent.getSource();
                Point point3 = component.getLocation();
                point.x += point3.x;
                point.y += point3.y;
                ToolMenuEditor.this.m_menuBuilder.processMouseDrag(point);
            }
            ++this.m_dragCount;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MutableProperties mutableProperties = this.m_dragProperties;
            if (mouseEvent.isPopupTrigger() && (mutableProperties != null || this.m_createMode)) {
                Point point = mouseEvent.getPoint();
                Point point2 = component.getLocation();
                point.x += point2.x;
                point.y += point2.y;
                this.showContextMenu(mutableProperties, point);
                this.m_dragCount = 0;
                this.m_dragProperties = null;
                this.m_createMode = false;
                return;
            }
            if (mutableProperties != null) {
                Cloneable cloneable;
                Serializable serializable;
                Cloneable cloneable2;
                if (this.m_dragCount > this.m_dragThreshold) {
                    cloneable2 = mouseEvent.getPoint();
                    serializable = ToolMenuEditor.this.getLocation();
                    ((Point)cloneable2).x += ((Point)serializable).x;
                    ((Point)cloneable2).y += ((Point)serializable).y;
                    cloneable = component.getLocation();
                    ((Point)cloneable2).x += ((Point)cloneable).x;
                    ((Point)cloneable2).y += ((Point)cloneable).y;
                    ToolMenuEditor.this.m_menuBuilder.processMouseDrag((Point)cloneable2);
                }
                if ((cloneable2 = ToolMenuEditor.this.m_menuBuilder.getHoverProperties()) != null && !cloneable2.equals(ToolMenuEditor.this.m_menuBuilder.getProperties()) && !cloneable2.equals(mutableProperties)) {
                    serializable = ToolMenuEditor.this.m_menuBuilder.getPDMLDocument();
                    ((XMLGUIBuilderDefinition)serializable).beginEdit(true);
                    mutableProperties.removeFromParent();
                    cloneable = (MutableProperties)((DefaultMutableTreeNode)cloneable2).getParent();
                    int n = ToolMenuEditor.this.m_menuBuilder.getHoverDirection();
                    if (n == 2) {
                        ((MutableProperties)cloneable2).add(mutableProperties);
                    } else {
                        int n2 = ((DefaultMutableTreeNode)cloneable).getIndex((TreeNode)((Object)cloneable2));
                        if (n == 1) {
                            ++n2;
                        }
                        ((MutableProperties)cloneable).insert(mutableProperties, n2);
                    }
                    ((XMLGUIBuilderDefinition)serializable).endEdit();
                    ToolMenuEditor.this.m_menuBuilder.getBuilder().updateBuilder();
                }
            } else if (this.m_createMode) {
                XMLGUIBuilderDefinition xMLGUIBuilderDefinition = ToolMenuEditor.this.m_menuBuilder.getPDMLDocument();
                xMLGUIBuilderDefinition.beginEdit();
                mutableProperties = new MenuItemProperties();
                try {
                    mutableProperties.setProperty("Name", ((MenuProperties)ToolMenuEditor.this.m_menuBuilder.getProperties()).generateName(6));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                try {
                    mutableProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_BUTTON"));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                mutableProperties.setPDMLDocument(xMLGUIBuilderDefinition);
                ToolMenuEditor.this.m_properties.add(mutableProperties);
                xMLGUIBuilderDefinition.endEdit();
                ToolMenuEditor.this.m_menuBuilder.getBuilder().updateBuilder();
            }
            ToolMenuEditor.this.m_menuBuilder.setHoverProperties(null, 0);
            ToolMenuEditor.this.m_menuBuilder.setSelectedProperties(ToolMenuEditor.this.m_menuBuilder.getSelectedProperties());
            this.m_dragCount = 0;
            this.m_dragProperties = null;
            this.m_createMode = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                Component component = (Component)mouseEvent.getSource();
                MutableProperties mutableProperties = ToolMenuEditor.this.getItemProperties(component);
                if (mutableProperties == null) {
                    XMLGUIBuilderDefinition xMLGUIBuilderDefinition = ToolMenuEditor.this.m_menuBuilder.getPDMLDocument();
                    xMLGUIBuilderDefinition.beginEdit();
                    mutableProperties = new MenuItemProperties();
                    try {
                        mutableProperties.setProperty("Name", ((MenuProperties)ToolMenuEditor.this.m_menuBuilder.getProperties()).generateName(6));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    try {
                        mutableProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_BUTTON"));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    mutableProperties.setPDMLDocument(xMLGUIBuilderDefinition);
                    ToolMenuEditor.this.m_properties.add(mutableProperties);
                    xMLGUIBuilderDefinition.endEdit();
                } else if ((mouseEvent.getModifiers() & 0x10) == 16 && mutableProperties.isPropertyVisible("Title")) {
                    ToolMenuEditor.this.m_menuBuilder.getBuilder().doEditProperty("Title");
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

