/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuBarBorder;
import com.ibm.as400.ui.tools.MenuItemLinkDialog;
import com.ibm.as400.ui.tools.MenuItemProperties;
import com.ibm.as400.ui.tools.MenuProperties;
import com.ibm.as400.ui.tools.MenuSeparatorProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PDMLNodeEvent;
import com.ibm.as400.ui.tools.PDMLNodeListener;
import com.ibm.as400.ui.tools.ToolMenuEditor;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class ToolMenuBuilder
extends BuilderFrame {
    JPanel m_mainToolBar;
    JPanel m_editToolBar;
    JPanel m_moveToolBar;
    JPanel m_helpToolBar;
    JLayeredPane m_canvas;
    JScrollPane m_scroll;
    ActionListener m_actionListener;
    MutableProperties m_emptyParent;
    MutableProperties m_selection;
    MutableProperties m_hover;
    static final int HOVER_ABOVE = 0;
    static final int HOVER_BELOW = 1;
    static final int HOVER_SUBMENU = 2;
    int m_hoverDirection = 0;
    ToolMenuEditor m_toolEditor;
    PDMLNodeListener m_pdmlNodeListener = new MenuPDMLNodeListener();
    TreeModelListener m_treeModelListener;

    ToolMenuBuilder(GUIBuilder gUIBuilder, XMLGUIBuilderDefinition xMLGUIBuilderDefinition, MenuProperties menuProperties) {
        super(gUIBuilder, xMLGUIBuilderDefinition, menuProperties);
        menuProperties.addPDMLNodeListener(this.m_pdmlNodeListener);
        this.m_treeModelListener = new MenuTreeModelListener();
        menuProperties.addTreeModelListener(this.m_treeModelListener);
        this.m_selection = menuProperties;
        this.addKeyListener(new MenuBuilderKeyListener());
        MenuActionListener menuActionListener = new MenuActionListener();
        this.m_actionListener = menuActionListener;
        this.m_mainToolBar = new DividerPanel(2);
        this.m_mainToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_mainToolBar.add(GUIFactory.createButton("Insert MenuItem", null, null, "Add.gif", "IDTT_INSERT_MENUITEM", true, menuActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Insert ItemLink", null, null, "InsertItemLink.gif", "IDTT_INSERT_ITEMLINK", true, menuActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Insert Separator", null, null, "InsertSeparator.gif", "IDTT_INSERT_SEPARATOR", true, menuActionListener));
        this.m_mainToolBar.add(GUIFactory.createButton("Remove", null, null, "Remove.gif", "IDTT_REMOVE_MENUITEM", true, menuActionListener));
        this.m_editToolBar = new DividerPanel(2);
        this.m_editToolBar.setLayout(new GridLayout(1, 5, 0, 0));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Cut", null, null, "Cut.gif", "IDTT_EDIT_CUT", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Copy", null, null, "Copy.gif", "IDTT_EDIT_COPY", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Paste", null, null, "Paste.gif", "IDTT_EDIT_PASTE", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Undo", null, null, "Undo.gif", "IDTT_EDIT_UNDO", false, menuActionListener));
        this.m_editToolBar.add(GUIFactory.createButton("Edit Redo", null, null, "Redo.gif", "IDTT_EDIT_REDO", false, menuActionListener));
        this.m_moveToolBar = new DividerPanel(2);
        this.m_moveToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Left", null, null, "MoveLeft.gif", "IDTT_MOVE_LEFT", true, menuActionListener));
        this.m_moveToolBar.add(GUIFactory.createButton("Move Right", null, null, "MoveRight.gif", "IDTT_MOVE_RIGHT", true, menuActionListener));
        this.m_helpToolBar = new JPanel();
        this.m_helpToolBar.setLayout(new GridLayout(1, 2, 0, 0));
        this.m_helpToolBar.add(GUIFactory.createButton("Preview", null, null, "Preview.gif", "IDTT_PREVIEW", true, menuActionListener));
        this.m_helpToolBar.add(GUIFactory.createButton("Help", null, null, "Help.gif", "IDTT_HELP", true, menuActionListener));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.m_mainToolBar);
        jPanel.add(this.m_editToolBar);
        jPanel.add(this.m_moveToolBar);
        jPanel.add(this.m_helpToolBar);
        jPanel.setBorder(new MenuBarBorder(((Component)this).getBackground().darker(), ((Component)this).getBackground().brighter()));
        this.m_canvas = new JDesktopPane();
        this.m_canvas.setLayout(null);
        this.m_canvas.setBorder(new EmptyBorder(0, 0, 100, 100));
        this.m_scroll = new JScrollPane(this.m_canvas);
        this.m_scroll.setBorder(null);
        this.m_canvas.addMouseListener(new MenuCanvasMouseAdapter());
        this.createToolMenuEditor();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        this.updateTitleBar(null);
        ((Frame)this).setIconImage(GUIFactory.getImage("ToolBar.gif", true).getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "North");
        this.getContentPane().add((Component)this.m_scroll, "Center");
        Dimension dimension = jPanel.getPreferredSize();
        dimension.width += 10;
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        dimension.height = 250;
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        ((Component)this).setSize(dimension);
        this.validateScrollPane();
    }

    String getHelpName() {
        return "ToolBuilder";
    }

    void createToolMenuEditor() {
        this.m_toolEditor = new ToolMenuEditor(this, this.getProperties());
        this.m_toolEditor.setLocation(0, 0);
        this.m_toolEditor.setSize(this.m_toolEditor.getPreferredSize());
        this.m_canvas.add((Component)this.m_toolEditor, new Integer(0));
    }

    void refresh(MutableProperties mutableProperties) {
        ToolMenuEditor toolMenuEditor = this.m_toolEditor;
        if (toolMenuEditor != null) {
            toolMenuEditor.setSize(toolMenuEditor.getPreferredSize());
            toolMenuEditor.repaint();
        }
    }

    void scrollItemToVisible(MutableProperties mutableProperties) {
        Rectangle rectangle;
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        if (mutableProperties2 == null) {
            return;
        }
        ToolMenuEditor toolMenuEditor = this.m_toolEditor;
        if (toolMenuEditor != null && (rectangle = toolMenuEditor.getItemBounds(mutableProperties)) != null) {
            Point point = toolMenuEditor.getLocation();
            rectangle.x += point.x;
            rectangle.y += point.y;
            int n = 20;
            if (rectangle.x >= n) {
                rectangle.x -= n;
            }
            if (rectangle.y >= n) {
                rectangle.y -= n;
            }
            rectangle.width += n * 2;
            rectangle.height += n * 2;
            this.m_canvas.scrollRectToVisible(rectangle);
        }
    }

    void validateScrollPane() {
        Rectangle rectangle = this.m_toolEditor.getBounds();
        Dimension dimension = new Dimension(rectangle.width + 50, rectangle.height + 50);
        this.m_canvas.setSize(dimension);
        this.m_canvas.setPreferredSize(dimension);
        this.m_scroll.getViewport().setViewSize(dimension);
        this.m_scroll.getViewport().invalidate();
        this.m_scroll.validate();
    }

    Point getMenuLocation(MutableProperties mutableProperties) {
        TreeNode[] treeNodeArray = mutableProperties.getPath();
        int n = treeNodeArray.length - 2;
        if (treeNodeArray.length <= 1) {
            return new Point(0, 0);
        }
        MutableProperties mutableProperties2 = (MutableProperties)treeNodeArray[n];
        ToolMenuEditor toolMenuEditor = this.m_toolEditor;
        Point point = new Point(0, 0);
        if (toolMenuEditor != null) {
            Rectangle rectangle = toolMenuEditor.getItemBounds(mutableProperties);
            Point point2 = toolMenuEditor.getLocation();
            point.x += point2.x + rectangle.x + rectangle.width;
            point.y += point2.y + rectangle.y;
        }
        return point;
    }

    public void stopEditing() {
    }

    boolean canLink() {
        Enumeration enumeration = this.getPDMLDocument().linkableMenuNames(this.getProperties());
        return enumeration.hasMoreElements();
    }

    public boolean canCut() {
        return !this.m_selection.equals(this.getProperties());
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canPaste() {
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        if (transferable != null && transferable instanceof MutableProperties) {
            MutableProperties mutableProperties = (MutableProperties)transferable;
            int n = mutableProperties.getType();
            if (n == 52) {
                String string = (String)mutableProperties.getProperty("Menu Item Type");
                return !string.equals("submenu");
            }
            if (n == 56) {
                String string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, false);
                String string2 = (String)this.getProperties().getProperty("Name");
                String string3 = (String)mutableProperties.getProperty("Link Resource");
                String string4 = (String)mutableProperties.getProperty("Link Menu");
                return string.equals(string3) && !string2.equals(string4);
            }
            if (n == 53) {
                return true;
            }
        }
        return false;
    }

    public boolean canDelete() {
        return !this.m_selection.equals(this.getProperties());
    }

    boolean canMoveLeft() {
        MutableProperties mutableProperties;
        if (!this.m_selection.equals(this.getProperties()) && (mutableProperties = (MutableProperties)this.m_selection.getParent()) != null) {
            int n = mutableProperties.getIndex(this.m_selection);
            return n > 0;
        }
        return false;
    }

    boolean canMoveRight() {
        MutableProperties mutableProperties;
        if (!this.m_selection.equals(this.getProperties()) && (mutableProperties = (MutableProperties)this.m_selection.getParent()) != null) {
            int n;
            int n2 = mutableProperties.getIndex(this.m_selection);
            return n2 < (n = mutableProperties.getChildCount()) - 1;
        }
        return false;
    }

    public void setSelectedProperties(MutableProperties mutableProperties) {
        MutableProperties mutableProperties2;
        if (mutableProperties == null) {
            mutableProperties = this.getProperties();
        }
        if (!mutableProperties.equals(mutableProperties2 = this.m_selection)) {
            this.m_selection = mutableProperties;
            this.fireSelectionChangedEvent();
        }
        if (!this.m_selection.equals(this.getProperties())) {
            this.scrollItemToVisible(this.m_selection);
        }
        this.repaint();
    }

    public MutableProperties getSelectedProperties() {
        return this.m_selection;
    }

    void setHoverProperties(MutableProperties mutableProperties, int n) {
        this.m_hoverDirection = n;
        this.m_hover = mutableProperties;
        if (mutableProperties != null) {
            this.scrollItemToVisible(mutableProperties);
        }
    }

    MutableProperties getHoverProperties() {
        return this.m_hover;
    }

    int getHoverDirection() {
        return this.m_hoverDirection;
    }

    void processMouseDrag(Point point) {
        ToolMenuEditor toolMenuEditor = this.m_toolEditor;
        Rectangle rectangle = toolMenuEditor.getBounds();
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        MutableProperties mutableProperties = toolMenuEditor.getItemAtPoint(point);
        if (mutableProperties != null) {
            boolean bl;
            rectangle = toolMenuEditor.getItemBounds(mutableProperties);
            point.x -= rectangle.x;
            point.y -= rectangle.y;
            boolean bl2 = bl = point.x < rectangle.width / 2;
            if (bl) {
                this.setHoverProperties(mutableProperties, 0);
            } else {
                this.setHoverProperties(mutableProperties, 1);
            }
        } else if (toolMenuEditor.getComponentCount() == 1) {
            mutableProperties = toolMenuEditor.getProperties();
            this.setHoverProperties(mutableProperties, 2);
        }
        this.repaint();
    }

    public void cut() {
        if (!this.canCut()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        MutableProperties mutableProperties = this.getSelectedProperties();
        this.getBuilder().getClipboard().setContents(mutableProperties, mutableProperties);
        this.doRemove();
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    public void copy() {
        if (!this.canCopy()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = mutableProperties.cloneNode(this.getPDMLDocument(), null);
        this.getBuilder().getClipboard().setContents(mutableProperties2, mutableProperties2);
        this.getBuilder().updateBuilder();
    }

    public void paste() {
        Object object;
        MutableProperties mutableProperties;
        if (!this.canPaste()) {
            return;
        }
        this.getPDMLDocument().beginEdit();
        Transferable transferable = this.getBuilder().getClipboard().getContents(this);
        MutableProperties mutableProperties2 = (MutableProperties)transferable;
        if (mutableProperties2.getType() == 51) {
            Enumeration<TreeNode> enumeration;
            mutableProperties = mutableProperties2;
            mutableProperties2 = new MenuItemProperties();
            try {
                mutableProperties2.setProperty("Menu Item Type", "submenu");
                enumeration = mutableProperties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)((Object)enumeration.nextElement());
                    if (((String)object).equals("Name")) {
                        mutableProperties2.setProperty("Name", ((MenuProperties)this.getProperties()).generateUniqueName((String)mutableProperties.getProperty("Name")));
                        continue;
                    }
                    if (!mutableProperties2.hasProperty((String)object)) continue;
                    mutableProperties2.setProperty((String)object, mutableProperties.getProperty((String)object));
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            mutableProperties2.setPDMLDocument(this.getPDMLDocument());
            enumeration = mutableProperties.children();
            while (enumeration.hasMoreElements()) {
                object = (MutableProperties)enumeration.nextElement();
                mutableProperties2.add(((MutableProperties)object).cloneNode(this.getPDMLDocument(), (MenuProperties)mutableProperties2));
            }
        } else {
            mutableProperties2 = ((MutableProperties)transferable).cloneNode(this.getPDMLDocument(), (MenuProperties)this.getProperties());
            mutableProperties2.setPDMLDocument(this.getPDMLDocument());
        }
        mutableProperties = this.getSelectedProperties();
        if (mutableProperties.equals(this.getProperties())) {
            mutableProperties.insert(mutableProperties2, 0);
        } else {
            object = (MutableProperties)mutableProperties.getParent();
            int n = ((DefaultMutableTreeNode)object).getIndex(mutableProperties);
            ((MutableProperties)object).insert(mutableProperties2, n + 1);
        }
        this.setSelectedProperties(mutableProperties2);
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    public void delete() {
        if (!this.canDelete()) {
            return;
        }
        this.getPDMLDocument().beginEdit(false);
        this.doRemove();
        this.getPDMLDocument().endEdit();
        this.getBuilder().updateBuilder();
    }

    void doRemove() {
        MutableProperties mutableProperties = this.getSelectedProperties();
        if (mutableProperties != null) {
            MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getNextSibling();
            if (mutableProperties2 == null && (mutableProperties2 = (MutableProperties)mutableProperties.getPreviousSibling()) == null && (mutableProperties2 = (MutableProperties)mutableProperties.getParent()) == null) {
                mutableProperties2 = this.getProperties();
            }
            mutableProperties.removeFromParent();
            if (mutableProperties2 != null) {
                this.setSelectedProperties(mutableProperties2);
            }
        }
    }

    void moveLeft() {
        if (!this.canMoveLeft()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties2.getIndex(mutableProperties);
        this.getPDMLDocument().beginEdit(true);
        mutableProperties.removeFromParent();
        mutableProperties2.insert(mutableProperties, n - 1);
        this.getPDMLDocument().endEdit();
    }

    void moveRight() {
        if (!this.canMoveRight()) {
            return;
        }
        MutableProperties mutableProperties = this.getSelectedProperties();
        MutableProperties mutableProperties2 = (MutableProperties)mutableProperties.getParent();
        int n = mutableProperties2.getIndex(mutableProperties);
        this.getPDMLDocument().beginEdit(true);
        mutableProperties.removeFromParent();
        mutableProperties2.insert(mutableProperties, n + 1);
        this.getPDMLDocument().endEdit();
    }

    public void updateBuilder() {
        this.m_mainToolBar.getComponent(1).setEnabled(this.canLink());
        this.m_mainToolBar.getComponent(3).setEnabled(this.canDelete());
        this.m_editToolBar.getComponent(0).setEnabled(this.canCut());
        this.m_editToolBar.getComponent(1).setEnabled(this.canCopy());
        this.m_editToolBar.getComponent(2).setEnabled(this.canPaste());
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.getPDMLDocument();
        this.m_editToolBar.getComponent(3).setEnabled(xMLGUIBuilderDefinition.getUndoManager().canUndo());
        this.m_editToolBar.getComponent(4).setEnabled(xMLGUIBuilderDefinition.getUndoManager().canRedo());
        this.m_moveToolBar.getComponent(0).setEnabled(this.canMoveLeft());
        this.m_moveToolBar.getComponent(1).setEnabled(this.canMoveRight());
        this.m_helpToolBar.getComponent(0).setEnabled(this.getProperties().getChildCount() > 0);
    }

    public void updateTitleBar(String string) {
        if (string == null && (string = (String)this.getPDMLDocument().getPDMLRoot().getProperty("File Name")).equals("")) {
            string = this.getPDMLDocument().getPDMLRoot().getResourceName(true, true);
        }
        String string2 = (String)this.getProperties().getProperty("Name");
        string2 = string2 + " (" + string + ")";
        this.setTitle(string2);
    }

    ActionListener getContextMenuListener() {
        return this.m_actionListener;
    }

    void setEmptyParent(MutableProperties mutableProperties) {
        this.m_emptyParent = mutableProperties;
    }

    public void uninstallListeners() {
        this.getProperties().removePDMLNodeListener(this.m_pdmlNodeListener);
        this.getProperties().removeTreeModelListener(this.m_treeModelListener);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class MenuBuilderKeyListener
    extends KeyAdapter {
        MenuBuilderKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            MutableProperties mutableProperties = ToolMenuBuilder.this.getSelectedProperties();
            if (mutableProperties == null) {
                return;
            }
            MutableProperties mutableProperties2 = null;
            boolean bl = mutableProperties.equals(ToolMenuBuilder.this.getProperties());
            switch (keyEvent.getKeyCode()) {
                default: {
                    return;
                }
                case 37: 
                case 38: {
                    if (bl) {
                        if (mutableProperties.getChildCount() <= 0) break;
                        mutableProperties2 = (MutableProperties)mutableProperties.getFirstChild();
                        break;
                    }
                    mutableProperties2 = (MutableProperties)mutableProperties.getPreviousSibling();
                    break;
                }
                case 39: 
                case 40: {
                    if (bl) {
                        if (mutableProperties.getChildCount() <= 0) break;
                        mutableProperties2 = (MutableProperties)mutableProperties.getFirstChild();
                        break;
                    }
                    mutableProperties2 = (MutableProperties)mutableProperties.getNextSibling();
                }
            }
            if (mutableProperties2 != null) {
                ToolMenuBuilder.this.setSelectedProperties(mutableProperties2);
            }
        }
    }

    class JMenuItemMB
    extends AbstractButton {
        JMenuItem myMenuItem = new JMenuItem();

        JMenuItemMB() {
            this.setModel(new DefaultButtonModel());
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenuItem != null) {
                this.myMenuItem.setIcon(icon);
            }
        }

        public void setText(String string) {
            if (string == null || string.equals("")) {
                string = " ";
            }
            super.setText(string);
            if (this.myMenuItem != null) {
                this.myMenuItem.setText(string);
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(c);
            }
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(n);
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenuItem != null) {
                this.myMenuItem.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getUI().getPreferredSize(this.myMenuItem);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getMinimumSize();
            }
            return super.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenuItem != null) {
                this.myMenuItem.getUI().paint(graphics, this.myMenuItem);
            } else {
                super.paint(graphics);
            }
            if (ToolMenuBuilder.this.getSelectedProperties().equals(ToolMenuBuilder.this.getProperties())) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
                graphics.setColor(color);
            }
        }
    }

    class MenuCanvasMouseAdapter
    extends MouseAdapter {
        MenuCanvasMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ToolMenuBuilder.this.setSelectedProperties(null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }
    }

    class MenuTreeModelListener
    implements TreeModelListener {
        MenuTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            int n = 0;
            while (n < objectArray.length) {
                MutableProperties mutableProperties = (MutableProperties)objectArray[n];
                ToolMenuEditor toolMenuEditor = ToolMenuBuilder.this.m_toolEditor;
                if (toolMenuEditor != null) {
                    toolMenuEditor.refresh(mutableProperties);
                    toolMenuEditor.repaint();
                    ToolMenuBuilder.this.setSelectedProperties(mutableProperties);
                }
                ++n;
            }
            ToolMenuBuilder.this.refresh(ToolMenuBuilder.this.getProperties());
            ToolMenuBuilder.this.validateScrollPane();
            ToolMenuBuilder.this.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            ToolMenuEditor toolMenuEditor = ToolMenuBuilder.this.m_toolEditor;
            if (toolMenuEditor != null) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n];
                    toolMenuEditor.insertItem(mutableProperties2, nArray[n]);
                    toolMenuEditor.repaint();
                    ToolMenuBuilder.this.setSelectedProperties(mutableProperties2);
                    ++n;
                }
                ToolMenuBuilder.this.refresh(ToolMenuBuilder.this.getProperties());
                ToolMenuBuilder.this.validateScrollPane();
                ToolMenuBuilder.this.repaint();
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            MutableProperties mutableProperties = (MutableProperties)treePath.getLastPathComponent();
            ToolMenuEditor toolMenuEditor = ToolMenuBuilder.this.m_toolEditor;
            if (toolMenuEditor != null) {
                Object[] objectArray = treeModelEvent.getChildren();
                int[] nArray = treeModelEvent.getChildIndices();
                int n = 0;
                while (n < objectArray.length) {
                    MutableProperties mutableProperties2 = (MutableProperties)objectArray[n];
                    toolMenuEditor.removeItem(mutableProperties2);
                    toolMenuEditor.repaint();
                    ++n;
                }
                ToolMenuBuilder.this.setSelectedProperties(mutableProperties);
                ToolMenuBuilder.this.refresh(ToolMenuBuilder.this.getProperties());
                ToolMenuBuilder.this.validateScrollPane();
                ToolMenuBuilder.this.repaint();
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class MenuActionListener
    implements ActionListener {
        MenuActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.startsWith("Insert")) {
                string = string.substring(7);
                MutableProperties mutableProperties = null;
                MutableProperties mutableProperties2 = ToolMenuBuilder.this.getSelectedProperties();
                MutableProperties mutableProperties3 = (MutableProperties)mutableProperties2.getParent();
                XMLGUIBuilderDefinition xMLGUIBuilderDefinition = ToolMenuBuilder.this.getPDMLDocument();
                if (string.equals("ItemLink")) {
                    mutableProperties = ToolMenuBuilder.this.getSelectedProperties();
                    if (!mutableProperties.equals(ToolMenuBuilder.this.getProperties())) {
                        mutableProperties = mutableProperties3;
                    }
                    MenuItemLinkDialog menuItemLinkDialog = new MenuItemLinkDialog(ToolMenuBuilder.this, mutableProperties, GUIFactory.getString("IDS_ITEMLINK_DIALOG_NEW_TITLEBAR"));
                    menuItemLinkDialog.show();
                    mutableProperties = menuItemLinkDialog.getItemLinkProperties();
                } else if (string.equals("Separator")) {
                    mutableProperties = new MenuSeparatorProperties();
                } else {
                    mutableProperties = new MenuItemProperties();
                    try {
                        mutableProperties.setProperty("Name", ((MenuProperties)ToolMenuBuilder.this.getProperties()).generateName(6));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    try {
                        mutableProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_BUTTON"));
                        mutableProperties.setProperty("* Position", "center");
                        mutableProperties.setProperty("* V Position", "top");
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (mutableProperties != null) {
                    xMLGUIBuilderDefinition.beginEdit();
                    mutableProperties.setPDMLDocument(xMLGUIBuilderDefinition);
                    if (mutableProperties.getType() == 56) {
                        mutableProperties.initTargets();
                    }
                    if (mutableProperties2.equals(ToolMenuBuilder.this.getProperties())) {
                        mutableProperties2.insert(mutableProperties, 0);
                    } else {
                        int n = mutableProperties3.getIndex(mutableProperties2);
                        mutableProperties3.insert(mutableProperties, n + 1);
                    }
                    ToolMenuBuilder.this.getPDMLDocument().endEdit();
                    ToolMenuBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.equals("Remove")) {
                ToolMenuBuilder.this.delete();
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Cut")) {
                    ToolMenuBuilder.this.cut();
                } else if (string.equals("Copy")) {
                    ToolMenuBuilder.this.copy();
                } else if (string.equals("Paste")) {
                    ToolMenuBuilder.this.paste();
                } else if (string.equals("Delete")) {
                    ToolMenuBuilder.this.delete();
                } else if (string.equals("Undo")) {
                    ToolMenuBuilder.this.getBuilder().doUndo();
                } else if (string.equals("Redo")) {
                    ToolMenuBuilder.this.getBuilder().doRedo();
                }
            } else if (string.startsWith("Type")) {
                string = string.substring(5).toLowerCase();
                MutableProperties mutableProperties = ToolMenuBuilder.this.getSelectedProperties();
                String string2 = (String)mutableProperties.getProperty("Menu Item Type");
                if (!string2.equals(string)) {
                    ToolMenuBuilder.this.getPDMLDocument().beginEdit();
                    try {
                        mutableProperties.setProperty("Menu Item Type", string);
                        ToolMenuBuilder.this.getPDMLDocument().endEdit();
                        ToolMenuBuilder.this.getBuilder().updateBuilder();
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        JOptionPane.showMessageDialog(ToolMenuBuilder.this, propertyVetoException.getMessage(), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                        ToolMenuBuilder.this.getPDMLDocument().abortEdit();
                    }
                }
            } else if (string.startsWith("New")) {
                Object object;
                string = string.substring(4).toLowerCase();
                ToolMenuBuilder.this.getPDMLDocument().beginEdit();
                Object object2 = null;
                if (string.equalsIgnoreCase("ItemLink")) {
                    object2 = ToolMenuBuilder.this.getSelectedProperties();
                    object = (MutableProperties)((DefaultMutableTreeNode)object2).getParent();
                    if (!object2.equals(ToolMenuBuilder.this.getProperties())) {
                        object2 = object;
                    }
                    MenuItemLinkDialog menuItemLinkDialog = new MenuItemLinkDialog(ToolMenuBuilder.this, (MutableProperties)object2, GUIFactory.getString("IDS_ITEMLINK_DIALOG_NEW_TITLEBAR"));
                    menuItemLinkDialog.show();
                    object2 = menuItemLinkDialog.getItemLinkProperties();
                } else if (string.equalsIgnoreCase("Separator")) {
                    object2 = new MenuSeparatorProperties();
                } else {
                    object2 = new MenuItemProperties();
                    try {
                        ((MutableProperties)object2).setProperty("Name", ((MenuProperties)ToolMenuBuilder.this.getProperties()).generateName(6));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    object = GUIFactory.getString("IDS_DEFAULT_LABEL_BUTTON");
                    try {
                        ((MutableProperties)object2).setProperty("Title", object);
                        ((MutableProperties)object2).setProperty("* Position", "center");
                        ((MutableProperties)object2).setProperty("* V Position", "top");
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    try {
                        ((MutableProperties)object2).setProperty("Menu Item Type", string);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    ((MutableProperties)object2).setPDMLDocument(ToolMenuBuilder.this.getPDMLDocument());
                    if (((MutableProperties)object2).getType() == 56) {
                        ((MutableProperties)object2).initTargets();
                    }
                    if ((object = ToolMenuBuilder.this.m_emptyParent) == null) {
                        object = ToolMenuBuilder.this.getProperties();
                    }
                    ((MutableProperties)object).add((MutableProperties)object2);
                    ToolMenuBuilder.this.m_emptyParent = null;
                    ToolMenuBuilder.this.getPDMLDocument().endEdit();
                    ToolMenuBuilder.this.getBuilder().updateBuilder();
                    ToolMenuBuilder.this.setHoverProperties(null, 0);
                    ToolMenuBuilder.this.setSelectedProperties((MutableProperties)object2);
                }
            } else if (string.startsWith("Move")) {
                if ((string = string.substring(5)).equals("Left")) {
                    ToolMenuBuilder.this.moveLeft();
                    ToolMenuBuilder.this.getBuilder().updateBuilder();
                } else if (string.equals("Right")) {
                    ToolMenuBuilder.this.moveRight();
                    ToolMenuBuilder.this.getBuilder().updateBuilder();
                }
            } else if (string.equals("Show Properties")) {
                ToolMenuBuilder.this.getBuilder().doShowProperties();
            } else if (string.equals("Preview")) {
                ToolMenuBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                ToolMenuBuilder.this.getBuilder().doPreview(ToolMenuBuilder.this.getProperties());
                ToolMenuBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (string.equals("Help")) {
                ToolMenuBuilder.this.displayHelp();
            }
        }
    }

    class MenuPDMLNodeListener
    implements PDMLNodeListener {
        MenuPDMLNodeListener() {
        }

        public void PDMLNodeChanged(PDMLNodeEvent pDMLNodeEvent) {
            ToolMenuBuilder.this.updateTitleBar(null);
        }

        public void PDMLNodeInserted(PDMLNodeEvent pDMLNodeEvent) {
        }

        public void PDMLNodeRemoved(PDMLNodeEvent pDMLNodeEvent) {
        }
    }
}

