/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.ComponentDescriptor;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.tools.ComponentProperties;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.MutableResource;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import com.ibm.as400.ui.tools.XMLWriter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.MessageFormat;

class TextProperties
extends ComponentProperties {
    TextProperties() {
        super(4);
    }

    TextProperties(XMLGUIBuilderDefinition xMLGUIBuilderDefinition) throws PDMLSpecificationException {
        super(xMLGUIBuilderDefinition, 4);
    }

    TextProperties(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, ComponentDescriptor componentDescriptor) throws PDMLSpecificationException {
        super(xMLGUIBuilderDefinition, componentDescriptor, componentDescriptor.m_element.equals("TEXTAREA") ? 5 : 4);
        try {
            this.setProperty("Multiline", new Boolean(this.getType() == 5));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.processAttributes(componentDescriptor);
    }

    void processAttributes(ComponentDescriptor componentDescriptor) throws PDMLSpecificationException {
        try {
            this.setProperty("Editable", new Boolean(componentDescriptor.m_editable));
            this.setProperty("Masked", new Boolean(componentDescriptor.m_masked));
            this.setProperty("Disabled", new Boolean(componentDescriptor.m_disabled));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        String string = null;
        if (componentDescriptor.m_format != null) {
            if (componentDescriptor.m_format.equals("INTEGER")) {
                try {
                    Integer n = new Integer(componentDescriptor.m_intMinValue);
                    Integer n2 = new Integer(componentDescriptor.m_intMaxValue);
                    this.setProperty("Format", componentDescriptor.m_format);
                    if (n != 0) {
                        this.setProperty("* Int Min Value", n.toString());
                    }
                    if (n2 != Integer.MAX_VALUE) {
                        this.setProperty("* Int Max Value", n2.toString());
                    }
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.equals("SHORT")) {
                try {
                    Short s = new Short(componentDescriptor.m_shortMinValue);
                    Short s2 = new Short(componentDescriptor.m_shortMaxValue);
                    this.setProperty("Format", componentDescriptor.m_format);
                    if (s != 0) {
                        this.setProperty("* Short Min Value", s.toString());
                    }
                    if (s2 != Short.MAX_VALUE) {
                        this.setProperty("* Short Max Value", s2.toString());
                    }
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.equals("LONG")) {
                try {
                    Long l = new Long(componentDescriptor.m_longMinValue);
                    Long l2 = new Long(componentDescriptor.m_longMaxValue);
                    this.setProperty("Format", componentDescriptor.m_format);
                    if (l != 0L) {
                        this.setProperty("* Long Min Value", l.toString());
                    }
                    if (l2 != Long.MAX_VALUE) {
                        this.setProperty("* Long Max Value", l2.toString());
                    }
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.equals("FLOAT")) {
                try {
                    Float f = new Float(componentDescriptor.m_floatMinValue);
                    Float f2 = new Float(componentDescriptor.m_floatMaxValue);
                    this.setProperty("Format", componentDescriptor.m_format);
                    if (f.floatValue() != 0.0f) {
                        this.setProperty("* Float Min Value", f.toString());
                    }
                    if (f2.floatValue() != Float.MAX_VALUE && f2.floatValue() != Float.POSITIVE_INFINITY) {
                        this.setProperty("* Float Max Value", f2.toString());
                    }
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.equals("STRING")) {
                try {
                    Integer n = new Integer(componentDescriptor.m_minLength);
                    Integer n3 = new Integer(componentDescriptor.m_maxLength);
                    this.setProperty("Format", componentDescriptor.m_format);
                    if (n != 0) {
                        this.setProperty("* Min Length", n.toString());
                    }
                    if (n3 != Integer.MAX_VALUE) {
                        this.setProperty("* Max Length", n3.toString());
                    }
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.equals("PERCENT")) {
                try {
                    Integer n = new Integer(componentDescriptor.m_minFractionDigits);
                    Integer n4 = new Integer(componentDescriptor.m_maxFractionDigits);
                    this.setProperty("Format", componentDescriptor.m_format);
                    if (n != 0) {
                        this.setProperty("* Percent Min Fraction", n.toString());
                    }
                    if (n4 != Integer.MAX_VALUE) {
                        this.setProperty("* Percent Max Fraction", n4.toString());
                    }
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.equals("DATE")) {
                try {
                    this.setProperty("Format", componentDescriptor.m_format);
                    if (componentDescriptor.m_dateTimeStyle == 2) {
                        string = "medium";
                    }
                    this.setProperty("* Date Style", "style " + string);
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.equals("TIME")) {
                try {
                    this.setProperty("Format", componentDescriptor.m_format);
                    if (componentDescriptor.m_dateTimeStyle == 2) {
                        string = "medium";
                    }
                    this.setProperty("* Time Style", "style " + string);
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.equals("INTERNET_ADDRESS")) {
                try {
                    this.setProperty("Format", componentDescriptor.m_format);
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (componentDescriptor.m_format.length() > 0) {
                try {
                    this.setProperty("Format", "CLASS");
                    this.setProperty("* Class", componentDescriptor.m_format);
                    this.setProperty("* Required", new Boolean(componentDescriptor.m_required));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    void initProperties() {
        super.initProperties();
        this.addProperty("Multiline");
        try {
            this.setProperty("Multiline", new Boolean(this.getType() == 5));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Masked");
        try {
            this.setProperty("Masked", new Boolean(false));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Editable");
        try {
            this.setProperty("Editable", new Boolean(true));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("Format");
        try {
            this.setProperty("Format", "@NONE");
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("* Required");
        try {
            this.setProperty("* Required", new Boolean(true));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.addProperty("* Int Min Value");
        this.addProperty("* Int Max Value");
        this.addProperty("* Short Min Value");
        this.addProperty("* Short Max Value");
        this.addProperty("* Long Min Value");
        this.addProperty("* Long Max Value");
        this.addProperty("* Float Min Value");
        this.addProperty("* Float Max Value");
        this.addProperty("* Min Length");
        this.addProperty("* Max Length");
        this.addProperty("* Percent Min Fraction");
        this.addProperty("* Percent Max Fraction");
        this.addProperty("* Date Style");
        this.addProperty("* Time Style");
        this.addProperty("* Class");
        this.setPropertyVisible("* Required", false);
        this.setPropertyVisible("* Int Min Value", false);
        this.setPropertyVisible("* Int Max Value", false);
        this.setPropertyVisible("* Short Min Value", false);
        this.setPropertyVisible("* Short Max Value", false);
        this.setPropertyVisible("* Long Min Value", false);
        this.setPropertyVisible("* Long Max Value", false);
        this.setPropertyVisible("* Float Min Value", false);
        this.setPropertyVisible("* Float Max Value", false);
        this.setPropertyVisible("* Min Length", false);
        this.setPropertyVisible("* Max Length", false);
        this.setPropertyVisible("* Percent Min Fraction", false);
        this.setPropertyVisible("* Percent Max Fraction", false);
        this.setPropertyVisible("* Date Style", false);
        this.setPropertyVisible("* Time Style", false);
        this.setPropertyVisible("* Class", false);
        try {
            this.setProperty("* Date Style", "style medium");
            this.setProperty("* Time Style", "style medium");
            this.setProperty("* Class", GUIFactory.getString("IDS_DEFAULT_FORMAT_CLASS"));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    void propertyUpdate(String string, Object object, Object object2) {
        super.propertyUpdate(string, object, object2);
        if (string.equals("Multiline")) {
            boolean bl = (Boolean)object2;
            if (bl) {
                this.setType(5);
                try {
                    this.setProperty("Masked", new Boolean(false));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.setPropertyVisible("Masked", false);
            } else {
                this.setType(4);
                this.setPropertyVisible("Masked", true);
            }
        } else if (string.equals("Format")) {
            String string2 = (String)object;
            String string3 = (String)object2;
            boolean bl = false;
            this.setPropertyVisible("* Required", bl);
            if (string2.equals("INTEGER")) {
                this.setPropertyVisible("* Int Min Value", bl);
                this.setPropertyVisible("* Int Max Value", bl);
            } else if (string2.equals("SHORT")) {
                this.setPropertyVisible("* Short Min Value", bl);
                this.setPropertyVisible("* Short Max Value", bl);
            } else if (string2.equals("LONG")) {
                this.setPropertyVisible("* Long Min Value", bl);
                this.setPropertyVisible("* Long Max Value", bl);
            } else if (string2.equals("FLOAT")) {
                this.setPropertyVisible("* Float Min Value", bl);
                this.setPropertyVisible("* Float Max Value", bl);
            } else if (string2.equals("STRING")) {
                this.setPropertyVisible("* Min Length", bl);
                this.setPropertyVisible("* Max Length", bl);
            } else if (string2.equals("PERCENT")) {
                this.setPropertyVisible("* Percent Min Fraction", bl);
                this.setPropertyVisible("* Percent Max Fraction", bl);
            } else if (string2.equals("DATE")) {
                this.setPropertyVisible("* Date Style", bl);
            } else if (string2.equals("TIME")) {
                this.setPropertyVisible("* Time Style", bl);
            } else if (string2.equals("CLASS")) {
                this.setPropertyVisible("* Class", bl);
            }
            bl = true;
            this.setPropertyVisible("* Required", bl);
            if (string3.equals("INTEGER")) {
                this.setPropertyVisible("* Int Min Value", bl);
                this.setPropertyVisible("* Int Max Value", bl);
            } else if (string3.equals("SHORT")) {
                this.setPropertyVisible("* Short Min Value", bl);
                this.setPropertyVisible("* Short Max Value", bl);
            } else if (string3.equals("LONG")) {
                this.setPropertyVisible("* Long Min Value", bl);
                this.setPropertyVisible("* Long Max Value", bl);
            } else if (string3.equals("FLOAT")) {
                this.setPropertyVisible("* Float Min Value", bl);
                this.setPropertyVisible("* Float Max Value", bl);
            } else if (string3.equals("STRING")) {
                this.setPropertyVisible("* Min Length", bl);
                this.setPropertyVisible("* Max Length", bl);
            } else if (string3.equals("CLASS")) {
                this.setPropertyVisible("* Class", bl);
            } else if (string3.equals("PERCENT")) {
                this.setPropertyVisible("* Percent Min Fraction", bl);
                this.setPropertyVisible("* Percent Max Fraction", bl);
            } else if (string3.equals("DATE")) {
                this.setPropertyVisible("* Date Style", bl);
            } else if (string3.equals("TIME")) {
                this.setPropertyVisible("* Time Style", bl);
            } else if (!string3.equals("INTERNET_ADDRESS")) {
                this.setPropertyVisible("* Required", false);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        super.vetoableChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("* Class")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if (!this.isValidClassName(string2)) {
                Object[] objectArray = new Object[]{string2};
                String string3 = MessageFormat.format(GUIFactory.getString("IDS_CLASS_NOT_VALID"), objectArray);
                throw new PropertyVetoException(string3, propertyChangeEvent);
            }
        } else if (string.endsWith("Length")) {
            if (!propertyChangeEvent.getNewValue().equals("")) {
                int n = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                if (n < 0) {
                    throw new PropertyVetoException(GUIFactory.getString("IDS_VALUE_LESS_THAN_ZERO"), propertyChangeEvent);
                }
                if (string.startsWith("* Max") && !this.getProperty("* Min Length").equals("")) {
                    int n2;
                    int n3 = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                    if (n3 < (n2 = Integer.parseInt(this.getProperty("* Min Length").toString()))) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LENGTH_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                } else if (string.startsWith("* Min") && !this.getProperty("* Max Length").equals("")) {
                    int n4 = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                    int n5 = Integer.parseInt(this.getProperty("* Max Length").toString());
                    if (n5 < n4) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LENGTH_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                }
            }
        } else if (string.startsWith("* Int")) {
            if (!propertyChangeEvent.getNewValue().equals("")) {
                if (string.equals("* Int Max Value") && !this.getProperty("* Int Min Value").equals("")) {
                    int n;
                    int n6 = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                    if (n6 < (n = Integer.parseInt(this.getProperty("* Int Min Value").toString()))) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                } else if (string.equals("* Int Min Value") && !this.getProperty("* Int Max Value").equals("")) {
                    int n = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                    int n7 = Integer.parseInt(this.getProperty("* Int Max Value").toString());
                    if (n7 < n) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                }
            }
        } else if (string.startsWith("* Short")) {
            if (!propertyChangeEvent.getNewValue().equals("")) {
                if (string.equals("* Short Max Value") && !this.getProperty("* Short Min Value").equals("")) {
                    short s;
                    short s2 = Short.parseShort(propertyChangeEvent.getNewValue().toString());
                    if (s2 < (s = Short.parseShort(this.getProperty("* Short Min Value").toString()))) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                } else if (string.equals("* Short Min Value") && !this.getProperty("* Short Max Value").equals("")) {
                    short s = Short.parseShort(propertyChangeEvent.getNewValue().toString());
                    short s3 = Short.parseShort(this.getProperty("* Short Max Value").toString());
                    if (s3 < s) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                }
            }
        } else if (string.startsWith("* Long")) {
            if (!propertyChangeEvent.getNewValue().equals("")) {
                if (string.equals("* Long Max Value") && !this.getProperty("* Long Min Value").equals("")) {
                    long l;
                    long l2 = Long.parseLong(propertyChangeEvent.getNewValue().toString());
                    if (l2 < (l = Long.parseLong(this.getProperty("* Long Min Value").toString()))) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                } else if (string.equals("* Long Min Value") && !this.getProperty("* Long Max Value").equals("")) {
                    long l = Long.parseLong(propertyChangeEvent.getNewValue().toString());
                    long l3 = Long.parseLong(this.getProperty("* Long Max Value").toString());
                    if (l3 < l) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                }
            }
        } else if (string.startsWith("* Float")) {
            if (!propertyChangeEvent.getNewValue().equals("")) {
                if (string.equals("* Float Max Value") && !this.getProperty("* Float Min Value").equals("")) {
                    float f;
                    float f2 = Float.valueOf(propertyChangeEvent.getNewValue().toString()).floatValue();
                    if (f2 < (f = Float.valueOf(this.getProperty("* Float Min Value").toString()).floatValue())) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                } else if (string.equals("* Float Min Value") && !this.getProperty("* Float Max Value").equals("")) {
                    float f = Float.valueOf(propertyChangeEvent.getNewValue().toString()).floatValue();
                    float f3 = Float.valueOf(this.getProperty("* Float Max Value").toString()).floatValue();
                    if (f3 < f) {
                        throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                    }
                }
            }
        } else if (string.startsWith("* Percent") && !propertyChangeEvent.getNewValue().equals("")) {
            if (string.equals("* Percent Max Fraction")) {
                int n;
                int n8 = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                if (n8 < 0) {
                    throw new PropertyVetoException(GUIFactory.getString("IDS_VALUE_LESS_THAN_ZERO"), propertyChangeEvent);
                }
                if (!this.getProperty("* Percent Min Fraction").equals("") && n8 < (n = Integer.parseInt(this.getProperty("* Percent Min Fraction").toString()))) {
                    throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                }
            } else if (string.equals("* Percent Min Fraction")) {
                int n;
                int n9 = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                if (n9 < 0) {
                    throw new PropertyVetoException(GUIFactory.getString("IDS_VALUE_LESS_THAN_ZERO"), propertyChangeEvent);
                }
                if (!this.getProperty("* Percent Max Fraction").equals("") && (n = Integer.parseInt(this.getProperty("* Percent Max Value").toString())) < n9) {
                    throw new PropertyVetoException(GUIFactory.getString("IDS_MAX_LESS_THAN_MIN"), propertyChangeEvent);
                }
            }
        }
    }

    String getOpenTag() {
        boolean bl;
        boolean bl2;
        String string = "TEXTFIELD";
        if (this.getType() == 5) {
            string = "TEXTAREA";
        }
        String string2 = "<" + string + " name=\"" + this.getProperty("Name");
        boolean bl3 = (Boolean)this.getProperty("Masked");
        if (bl3 && string.equals("TEXTFIELD")) {
            string2 = string2 + "\" masked=\"yes";
        }
        if (!(bl2 = ((Boolean)this.getProperty("Editable")).booleanValue())) {
            string2 = string2 + "\" editable=\"no";
        }
        if (bl = ((Boolean)this.getProperty("Disabled")).booleanValue()) {
            string2 = string2 + "\" disabled=\"yes";
        }
        string2 = string2 + "\">";
        return string2;
    }

    String getCloseTag() {
        String string = "TEXTFIELD";
        if (this.getType() == 5) {
            string = "TEXTAREA";
        }
        return "</" + string + ">";
    }

    void saveChildren(XMLWriter xMLWriter, MutableResource mutableResource) throws IOException {
        String string = (String)this.getProperty("Format");
        if (!string.equals("") && !string.equals("@NONE")) {
            boolean bl = (Boolean)this.getProperty("* Required");
            String string2 = null;
            if (string.equals("INTEGER")) {
                String string3;
                string2 = "<INTEGER";
                String string4 = this.getProperty("* Int Min Value").toString();
                if (!string4.equals("")) {
                    string2 = string2 + " minvalue=\"" + string4 + "\"";
                }
                if (!(string3 = this.getProperty("* Int Max Value").toString()).equals("")) {
                    string2 = string2 + " maxvalue=\"" + string3 + "\"";
                }
            } else if (string.equals("SHORT")) {
                String string5;
                string2 = "<SHORT";
                String string6 = this.getProperty("* Short Min Value").toString();
                if (!string6.equals("")) {
                    string2 = string2 + " minvalue=\"" + string6 + "\"";
                }
                if (!(string5 = this.getProperty("* Short Max Value").toString()).equals("")) {
                    string2 = string2 + " maxvalue=\"" + string5 + "\"";
                }
            } else if (string.equals("LONG")) {
                String string7;
                string2 = "<LONG";
                String string8 = this.getProperty("* Long Min Value").toString();
                if (!string8.equals("")) {
                    string2 = string2 + " minvalue=\"" + string8 + "\"";
                }
                if (!(string7 = this.getProperty("* Long Max Value").toString()).equals("")) {
                    string2 = string2 + " maxvalue=\"" + string7 + "\"";
                }
            } else if (string.equals("FLOAT")) {
                String string9;
                string2 = "<FLOAT";
                String string10 = this.getProperty("* Float Min Value").toString();
                if (!string10.equals("")) {
                    string2 = string2 + " minvalue=\"" + string10 + "\"";
                }
                if (!(string9 = this.getProperty("* Float Max Value").toString()).equals("")) {
                    string2 = string2 + " maxvalue=\"" + string9 + "\"";
                }
            } else if (string.equals("STRING")) {
                string2 = "<STRING";
                String string11 = this.getProperty("* Min Length").toString();
                String string12 = this.getProperty("* Max Length").toString();
                string2 = !string11.equals("") ? string2 + " minlength=\"" + string11 + "\"" : string2 + " minlength=\"0\"";
                if (!string12.equals("")) {
                    string2 = string2 + " maxlength=\"" + string12 + "\"";
                }
            } else if (string.equals("PERCENT")) {
                string2 = "<PERCENT";
                String string13 = this.getProperty("* Percent Min Fraction").toString();
                String string14 = this.getProperty("* Percent Max Fraction").toString();
                if (!string13.equals("")) {
                    string2 = string2 + " minfractiondigits=\"" + string13 + "\"";
                }
                if (!string14.equals("")) {
                    string2 = string2 + " maxfractiondigits=\"" + string14 + "\"";
                }
            } else if (string.equals("DATE")) {
                string2 = "<DATE";
                String string15 = this.getProperty("* Date Style").toString().substring(6);
                string2 = string2 + " style=\"" + string15 + "\"";
            } else if (string.equals("TIME")) {
                string2 = "<TIME";
                String string16 = this.getProperty("* Time Style").toString().substring(6);
                string2 = string2 + " style=\"" + string16 + "\"";
            } else if (string.equals("INTERNET_ADDRESS")) {
                string2 = "<FORMAT";
                string2 = bl ? string2 + " required=\"yes\"" : string2 + " required=\"no\"";
                string2 = string2 + ">" + string + "</FORMAT>";
            } else if (string.equals("CLASS")) {
                string2 = "<FORMAT";
                string2 = bl ? string2 + " required=\"yes\"" : string2 + " required=\"no\"";
                string2 = string2 + ">" + this.getProperty("* Class") + "</FORMAT>";
            }
            if (string2 != null) {
                if (!string2.startsWith("<FORMAT")) {
                    string2 = bl ? string2 + " required=\"yes\"" : string2 + " required=\"no\"";
                    string2 = string2 + "/>";
                }
                xMLWriter.writeIndent();
                xMLWriter.writeChars(string2);
                xMLWriter.writeNewLine();
            }
        }
    }

    MutableProperties cloneNodeInstance() {
        TextProperties textProperties = new TextProperties();
        textProperties.setType(this.getType());
        try {
            textProperties.setProperty("Multiline", new Boolean(textProperties.getType() == 5));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return textProperties;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

