/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.BrowseCellEditor;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PanelProperties;
import com.ibm.as400.ui.tools.PropertyDialog;
import com.ibm.as400.ui.tools.SpinnerProperties;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class PropertyTable
extends JTable {
    Hashtable m_customEditors = new Hashtable();
    PanelProperties m_panelProperties = null;
    PropertyDialog m_parent;

    PropertyTable(PropertyDialog propertyDialog, TableModel tableModel) {
        super(tableModel);
        this.m_parent = propertyDialog;
        this.initLocaleEditors(propertyDialog.getBuilder());
    }

    void setPanelProperties(PanelProperties panelProperties) {
        this.m_panelProperties = panelProperties;
    }

    void initLocaleEditors(GUIBuilder gUIBuilder) {
        DefaultCellEditor defaultCellEditor;
        int n;
        String[] stringArray;
        ComboCellEditor comboCellEditor;
        boolean bl;
        boolean bl2 = bl = gUIBuilder != null;
        if (this.m_customEditors.get("+ Language") == null) {
            if (bl) {
                gUIBuilder.updateSplash(10);
            }
            comboCellEditor = new ComboCellEditor();
            stringArray = GUIFactory.getLanguages();
            n = stringArray.length;
            comboCellEditor.setModel(new DefaultComboBoxModel<String>(stringArray));
            comboCellEditor.insertItemAt("@BASE", 0);
            if (bl) {
                gUIBuilder.updateSplash(10);
            }
            defaultCellEditor = new DefaultCellEditor(comboCellEditor);
            this.m_customEditors.put("+ Language", defaultCellEditor);
        }
        if (this.m_customEditors.get("+ Country") == null) {
            comboCellEditor = new ComboCellEditor();
            stringArray = GUIFactory.getCountries();
            n = stringArray.length;
            comboCellEditor.setModel(new DefaultComboBoxModel<String>(stringArray));
            comboCellEditor.insertItemAt("@BASE", 0);
            defaultCellEditor = new DefaultCellEditor(comboCellEditor);
            this.m_customEditors.put("+ Country", defaultCellEditor);
        }
    }

    TableCellEditor getCustomCellEditor(int n, int n2) {
        if (n2 != 1) {
            return null;
        }
        String string = (String)this.getModel().getValueAt(n, 0);
        Object object = this.getModel().getValueAt(n, n2);
        TableCellEditor tableCellEditor = null;
        if (object instanceof Boolean) {
            tableCellEditor = this.lookupCustomCellEditor("Boolean");
        } else {
            int n3 = this.m_parent.getProperties().getType();
            if (string.equals("Icon") || string.equals("Expanded Icon") || string.equals("Title") && n3 == 110) {
                string = "@IMAGE";
            } else if (string.equals("Title") && (n3 == 4 || n3 == 5 || n3 == 2)) {
                string = "@TEXT";
            }
            tableCellEditor = this.lookupCustomCellEditor(string);
        }
        if (tableCellEditor == null && (object instanceof String || object instanceof Integer)) {
            tableCellEditor = new DefaultCellEditor(new ListCellEditor());
            ((DefaultCellEditor)tableCellEditor).setClickCountToStart(1);
        }
        return tableCellEditor;
    }

    TableCellEditor lookupCustomCellEditor(String string) {
        if (this.m_customEditors.containsKey(string)) {
            return (TableCellEditor)this.m_customEditors.get(string);
        }
        DefaultCellEditor defaultCellEditor = null;
        ComboCellEditor comboCellEditor = new ComboCellEditor();
        if (string.equals("Boolean")) {
            comboCellEditor.addItem(Boolean.TRUE);
            comboCellEditor.addItem(Boolean.FALSE);
        } else if (string.equals("Resource")) {
            comboCellEditor.addItem("Property resource bundle");
            comboCellEditor.addItem("List resource bundle");
        } else if (string.equals("Format")) {
            comboCellEditor.addItem("@NONE");
            comboCellEditor.addItem("INTEGER");
            comboCellEditor.addItem("SHORT");
            comboCellEditor.addItem("LONG");
            comboCellEditor.addItem("FLOAT");
            comboCellEditor.addItem("STRING");
            comboCellEditor.addItem("PERCENT");
            comboCellEditor.addItem("DATE");
            comboCellEditor.addItem("TIME");
            comboCellEditor.addItem("INTERNET_ADDRESS");
            comboCellEditor.addItem("CLASS");
        } else if (string.equals("Orientation")) {
            comboCellEditor.addItem("horizontal");
            comboCellEditor.addItem("vertical");
        } else if (string.equals("Selection Mode")) {
            comboCellEditor.addItem("single");
            comboCellEditor.addItem("singleinterval");
            comboCellEditor.addItem("multiinterval");
        } else if (string.equals("Table Selection Mode")) {
            comboCellEditor.addItem("@NONE");
            comboCellEditor.addItem("single");
            comboCellEditor.addItem("singleinterval");
            comboCellEditor.addItem("multiinterval");
        } else if (string.equals("Placement")) {
            comboCellEditor.addItem("top");
            comboCellEditor.addItem("bottom");
            comboCellEditor.addItem("left");
            comboCellEditor.addItem("right");
        } else if (string.equals("Style")) {
            comboCellEditor.addItem("@NONE");
            comboCellEditor.addItem("DEFAULT");
        } else {
            if (string.equals("Action")) {
                comboCellEditor.addItem("COMMIT");
                comboCellEditor.addItem("CANCEL");
                comboCellEditor.addItem("HELP");
                comboCellEditor.addItem("CONTEXTHELP");
                comboCellEditor.setEditable(true);
                defaultCellEditor = new EditableComboBoxDefaultCellEditor(comboCellEditor);
                this.m_customEditors.put(string, defaultCellEditor);
                return defaultCellEditor;
            }
            if (string.equals("Menu Action")) {
                comboCellEditor.addItem("CONTEXTHELP");
                comboCellEditor.setEditable(true);
                defaultCellEditor = new EditableComboBoxDefaultCellEditor(comboCellEditor);
                this.m_customEditors.put(string, defaultCellEditor);
                return defaultCellEditor;
            }
            if (string.equals("Data Class") || string.equals("Activate") || string.equals("Adjust") || string.equals("Manager Class") || string.equals("Double Click") || string.equals("* Class") || string.equals("Renderer") || string.equals("Editor")) {
                BrowseCellEditor browseCellEditor = new BrowseCellEditor((BuilderFrame)this.m_parent, true);
                this.m_customEditors.put(string, browseCellEditor);
                return browseCellEditor;
            }
            if (string.equals("@IMAGE")) {
                BrowseCellEditor browseCellEditor = new BrowseCellEditor((BuilderFrame)this.m_parent, false);
                this.m_customEditors.put(string, browseCellEditor);
                return browseCellEditor;
            }
            if (string.equals("@TEXT")) {
                BrowseCellEditor browseCellEditor = new BrowseCellEditor((BuilderFrame)this.m_parent, 2);
                this.m_customEditors.put(string, browseCellEditor);
                return browseCellEditor;
            }
            if (string.equals("* H Position")) {
                comboCellEditor.addItem("left");
                comboCellEditor.addItem("center");
                comboCellEditor.addItem("right");
            } else if (string.equals("* V Position")) {
                comboCellEditor.addItem("top");
                comboCellEditor.addItem("center");
                comboCellEditor.addItem("bottom");
            } else {
                if (string.equals("Menu Item Type")) {
                    boolean bl = false;
                    MutableProperties mutableProperties = (MutableProperties)this.m_parent.getProperties().getParent();
                    if (mutableProperties.getType() == 51) {
                        bl = !mutableProperties.getProperty("Type").toString().equals("menu");
                    }
                    comboCellEditor.addItem("menuitem");
                    if (!bl) {
                        comboCellEditor.addItem("submenu");
                    }
                    comboCellEditor.addItem("check");
                    comboCellEditor.addItem("radio");
                    return new DefaultCellEditor(comboCellEditor);
                }
                if (string.equals("Header Alignment") || string.equals("Column Alignment")) {
                    comboCellEditor.addItem("left");
                    comboCellEditor.addItem("center");
                    comboCellEditor.addItem("right");
                } else {
                    if (string.equals("* Key")) {
                        comboCellEditor.addItem("ESC");
                        comboCellEditor.addItem("F1");
                        comboCellEditor.addItem("F2");
                        comboCellEditor.addItem("F3");
                        comboCellEditor.addItem("F4");
                        comboCellEditor.addItem("F5");
                        comboCellEditor.addItem("F6");
                        comboCellEditor.addItem("F7");
                        comboCellEditor.addItem("F8");
                        comboCellEditor.addItem("F9");
                        comboCellEditor.addItem("F10");
                        comboCellEditor.addItem("F11");
                        comboCellEditor.addItem("F12");
                        comboCellEditor.addItem("PAUSE");
                        comboCellEditor.addItem("TAB");
                        comboCellEditor.addItem("BACKSPACE");
                        comboCellEditor.addItem("ENTER");
                        comboCellEditor.addItem("INSERT");
                        comboCellEditor.addItem("DELETE");
                        comboCellEditor.addItem("HOME");
                        comboCellEditor.addItem("END");
                        comboCellEditor.addItem("PAGEUP");
                        comboCellEditor.addItem("PAGEDOWN");
                        comboCellEditor.addItem("UP");
                        comboCellEditor.addItem("DOWN");
                        comboCellEditor.addItem("LEFT");
                        comboCellEditor.addItem("RIGHT");
                        comboCellEditor.setEditable(true);
                        defaultCellEditor = new EditableComboBoxDefaultCellEditor(comboCellEditor);
                        this.m_customEditors.put(string, defaultCellEditor);
                        return defaultCellEditor;
                    }
                    if (string.equals("* Modifier")) {
                        comboCellEditor.addItem("none");
                        comboCellEditor.addItem("ctrl");
                        comboCellEditor.addItem("alt");
                        comboCellEditor.addItem("shift");
                        comboCellEditor.addItem("ctrl-alt");
                        comboCellEditor.addItem("ctrl-shift");
                        comboCellEditor.addItem("alt-shift");
                        comboCellEditor.addItem("ctrl-alt-shift");
                    } else {
                        if (string.equals("* Help Alias") && this.m_panelProperties != null) {
                            String string2 = (String)this.m_parent.getProperties().getProperty("Name");
                            MutableProperties[] mutablePropertiesArray = this.m_panelProperties.getHelpAliases(string2);
                            int n = mutablePropertiesArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                comboCellEditor.addItem(mutablePropertiesArray[n2]);
                                ++n2;
                            }
                            defaultCellEditor = new DefaultCellEditor(comboCellEditor);
                            comboCellEditor.setRenderer(new HelpComboCellRenderer());
                            return defaultCellEditor;
                        }
                        if (string.equals("* Help Link")) {
                            comboCellEditor.addItem("DEFAULT");
                            comboCellEditor.setEditable(true);
                            defaultCellEditor = new EditableComboBoxDefaultCellEditor(comboCellEditor);
                            this.m_customEditors.put(string, defaultCellEditor);
                            return defaultCellEditor;
                        }
                        if (string.equals("Spinner Format")) {
                            comboCellEditor.addItem("INTEGER");
                            comboCellEditor.addItem("DATE");
                            comboCellEditor.addItem("TIME");
                        } else if (string.equals("* Date Style")) {
                            comboCellEditor.setRenderer(new DateStyleCellRenderer());
                            comboCellEditor.addItem("style short");
                            comboCellEditor.addItem("style medium");
                            comboCellEditor.addItem("style long");
                        } else if (string.equals("* Time Style")) {
                            comboCellEditor.setRenderer(new TimeStyleCellRenderer());
                            comboCellEditor.addItem("style short");
                            comboCellEditor.addItem("style medium");
                            comboCellEditor.addItem("style long");
                        } else if (string.equals("Generate Field Help")) {
                            comboCellEditor.addItem("true");
                            comboCellEditor.addItem("alias");
                            comboCellEditor.addItem("false");
                        } else if (string.equals("Generate BG Field Help")) {
                            comboCellEditor.addItem("true");
                            comboCellEditor.addItem("false");
                        } else if (string.endsWith("Value")) {
                            if (string.startsWith("* Date")) {
                                JTextField jTextField = new JTextField();
                                jTextField.setBorder(new LineBorder(Color.black));
                                defaultCellEditor = new CalendarDefaultCellEditor(jTextField, true);
                                this.m_customEditors.put(string, defaultCellEditor);
                                return defaultCellEditor;
                            }
                            if (string.startsWith("* Time")) {
                                JTextField jTextField = new JTextField();
                                jTextField.setBorder(new LineBorder(Color.black));
                                defaultCellEditor = new CalendarDefaultCellEditor(jTextField, false);
                                this.m_customEditors.put(string, defaultCellEditor);
                                return defaultCellEditor;
                            }
                            comboCellEditor = null;
                        } else if (string.equals("* Date Incr Caret")) {
                            comboCellEditor.addItem("caret year");
                            comboCellEditor.addItem("caret month");
                            comboCellEditor.addItem("caret date");
                        } else if (string.equals("* Time Incr Caret")) {
                            comboCellEditor.addItem("caret hour");
                            comboCellEditor.addItem("caret minute");
                            comboCellEditor.addItem("caret second");
                        } else if (string.equals("Base Screen Size")) {
                            comboCellEditor.addItem("640x480");
                            comboCellEditor.addItem("800x600");
                            comboCellEditor.addItem("1024x768");
                            comboCellEditor.addItem("1280x1024");
                            comboCellEditor.addItem("1600x1200");
                        } else if (string.equals("Data Type")) {
                            comboCellEditor.addItem("string");
                            comboCellEditor.addItem("boolean");
                        } else {
                            comboCellEditor = null;
                        }
                    }
                }
            }
        }
        if (comboCellEditor != null) {
            defaultCellEditor = new DefaultCellEditor(comboCellEditor);
            this.m_customEditors.put(string, defaultCellEditor);
        }
        return defaultCellEditor;
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        TableColumn tableColumn;
        boolean bl;
        if (!this.isCellEditable(n, n2)) {
            return false;
        }
        if (this.isEditing() && this.cellEditor != null && !(bl = this.cellEditor.stopCellEditing())) {
            return false;
        }
        TableCellEditor tableCellEditor = this.getCustomCellEditor(n, n2);
        if (tableCellEditor == null && (tableCellEditor = (tableColumn = this.getColumnModel().getColumn(n2)).getCellEditor()) == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2));
        }
        if (tableCellEditor != null) {
            this.editorComp = this.prepareEditor(tableCellEditor, n, n2);
            if (tableCellEditor.isCellEditable(eventObject)) {
                this.editorComp.setBounds(this.getCellRect(n, n2, false));
                this.add(this.editorComp);
                this.editorComp.validate();
                boolean bl2 = tableCellEditor.shouldSelectCell(eventObject);
                this.setCellEditor(tableCellEditor);
                this.setEditingRow(n);
                this.setEditingColumn(n2);
                tableCellEditor.addCellEditorListener(this);
                this.repaint();
                return true;
            }
        }
        return false;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class ListCellEditor
    extends JTextField {
        ListCellEditor() {
            this.setBorder(new LineBorder(Color.black));
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ListCellEditor this$1;
                {
                    this.this$1 = listCellEditor;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27 && ListCellEditor.access$100(this.this$1).isEditing()) {
                        ((DefaultCellEditor)ListCellEditor.access$100(this.this$1).getCellEditor()).cancelCellEditing();
                    } else if (keyEvent.getKeyCode() == 10 && ListCellEditor.access$100(this.this$1).isEditing()) {
                        ((DefaultCellEditor)ListCellEditor.access$100(this.this$1).getCellEditor()).stopCellEditing();
                    }
                }
            });
        }

        static /* synthetic */ PropertyTable access$100(ListCellEditor listCellEditor) {
            return listCellEditor.PropertyTable.this;
        }
    }

    class CalendarDefaultCellEditor
    extends DefaultCellEditor {
        JTextField m_textField;
        boolean m_isDate;

        public CalendarDefaultCellEditor(JTextField jTextField, boolean bl) {
            super(jTextField);
            this.m_textField = jTextField;
            this.m_isDate = bl;
            this.clickCountToStart = 1;
            this.editorComponent = jTextField;
            this.delegate = new DefaultCellEditor.EditorDelegate(this){
                private final /* synthetic */ CalendarDefaultCellEditor this$1;
                {
                    this.this$1 = calendarDefaultCellEditor;
                }

                public void setValue(Object object) {
                    if (object == null) {
                        this.this$1.m_textField.setText("");
                    } else if (object instanceof Calendar) {
                        Calendar calendar = (Calendar)object;
                        DateFormat dateFormat = this.this$1.m_isDate ? SpinnerProperties.getDateFormat(calendar) : SpinnerProperties.getTimeFormat(calendar);
                        this.this$1.m_textField.setText(dateFormat.format(calendar.getTime()));
                    } else {
                        this.this$1.m_textField.setText(object.toString());
                    }
                }

                public Object getCellEditorValue() {
                    return this.this$1.m_textField.getText();
                }

                public boolean startCellEditing(EventObject eventObject) {
                    if (eventObject == null) {
                        this.this$1.getComponent().requestFocus();
                    }
                    return true;
                }
            };
            ((JTextField)this.editorComponent).addActionListener(this.delegate);
        }
    }

    class EditableComboBoxDefaultCellEditor
    extends DefaultCellEditor {
        JComboBox m_comboBox;
        final EditableComboBoxDefaultCellEditor m_editor = this;

        public EditableComboBoxDefaultCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.m_comboBox = jComboBox;
            this.editorComponent = jComboBox;
            this.delegate = new DefaultCellEditor.EditorDelegate(this){
                private final /* synthetic */ EditableComboBoxDefaultCellEditor this$1;
                {
                    this.this$1 = editableComboBoxDefaultCellEditor;
                }

                public void setValue(Object object) {
                    this.this$1.m_comboBox.setSelectedItem(object);
                }

                public Object getCellEditorValue() {
                    String string = this.this$1.m_comboBox.getSelectedItem().toString();
                    String string2 = ((JTextField)this.this$1.m_comboBox.getEditor().getEditorComponent()).getText();
                    if (!string2.equals(string)) {
                        return string2;
                    }
                    return string;
                }

                public boolean startCellEditing(EventObject eventObject) {
                    return eventObject instanceof AWTEvent;
                }
            };
            ((JComboBox)this.editorComponent).addItemListener(this.delegate);
        }
    }

    class ComboCellEditor
    extends JComboBox {
        public ComboCellEditor() {
            this.setEditable(false);
            this.setBorder(new LineBorder(Color.black));
            this.setRenderer(new ComboCellRenderer());
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ComboCellEditor this$1;
                {
                    this.this$1 = comboCellEditor;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() != 9) {
                        if (keyEvent.getKeyCode() == 27 && ComboCellEditor.access$000(this.this$1).isEditing()) {
                            ((DefaultCellEditor)ComboCellEditor.access$000(this.this$1).getCellEditor()).cancelCellEditing();
                        } else if (keyEvent.getKeyCode() == 10 && ComboCellEditor.access$000(this.this$1).isEditing()) {
                            ((DefaultCellEditor)ComboCellEditor.access$000(this.this$1).getCellEditor()).stopCellEditing();
                        }
                    }
                }
            });
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isManagingFocus() {
            return true;
        }

        static /* synthetic */ PropertyTable access$000(ComboCellEditor comboCellEditor) {
            return comboCellEditor.PropertyTable.this;
        }
    }

    class TimeStyleCellRenderer
    extends DefaultListCellRenderer {
        TimeStyleCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            String string2 = object.toString();
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1999, 11, 31, 23, 22, 33);
            int n2 = 0;
            if (string2.endsWith("short")) {
                n2 = 3;
                string = "IDS_STYLE_SHORT";
            } else if (string2.endsWith("long")) {
                n2 = 1;
                string = "IDS_STYLE_LONG";
            } else if (string2.endsWith("full")) {
                n2 = 0;
                string = "IDS_STYLE_FULL";
            } else {
                n2 = 2;
                string = "IDS_STYLE_MEDIUM";
            }
            DateFormat dateFormat = DateFormat.getTimeInstance(n2);
            jLabel.setText(GUIFactory.getString(string) + "  (" + dateFormat.format(calendar.getTime()) + ")");
            return jLabel;
        }
    }

    class DateStyleCellRenderer
    extends DefaultListCellRenderer {
        DateStyleCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            String string2 = object.toString();
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1999, 11, 31, 23, 22, 33);
            int n2 = 0;
            if (string2.endsWith("short")) {
                n2 = 3;
                string = "IDS_STYLE_SHORT";
            } else if (string2.endsWith("long")) {
                n2 = 1;
                string = "IDS_STYLE_LONG";
            } else if (string2.endsWith("full")) {
                n2 = 0;
                string = "IDS_STYLE_FULL";
            } else {
                n2 = 2;
                string = "IDS_STYLE_MEDIUM";
            }
            DateFormat dateFormat = DateFormat.getDateInstance(n2);
            jLabel.setText(GUIFactory.getString(string) + "  (" + dateFormat.format(calendar.getTime()) + ")");
            return jLabel;
        }
    }

    class HelpComboCellRenderer
    extends DefaultListCellRenderer {
        HelpComboCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = null;
            string = object instanceof MutableProperties ? ((MutableProperties)object).getProperty("Name").toString() : GUIFactory.getLocalizedPropertyValue(object);
            if (string != null) {
                jLabel.setText(string);
            }
            return jLabel;
        }
    }

    class ComboCellRenderer
    extends DefaultListCellRenderer {
        ComboCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = GUIFactory.getLocalizedPropertyValue(object);
            if (string != null) {
                jLabel.setText(string);
            }
            return jLabel;
        }
    }
}

