/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuBuilder;
import com.ibm.as400.ui.tools.MenuItemProperties;
import com.ibm.as400.ui.tools.MenuItemRenderer;
import com.ibm.as400.ui.tools.MenuProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class MenuEditor
extends JPanel {
    MutableProperties m_properties;
    Hashtable m_items;
    MenuBuilder m_menuBuilder;
    BoxLayout m_layout;
    ActionListener m_menuListener;
    JPopupMenu m_contextMenu;
    JPopupMenu m_linkContextMenu;
    JPopupMenu m_emptyContextMenu;

    MenuEditor(MenuBuilder menuBuilder, MutableProperties mutableProperties) {
        Component component;
        this.m_menuBuilder = menuBuilder;
        this.m_properties = mutableProperties;
        this.m_items = new Hashtable();
        this.m_menuListener = menuBuilder.getContextMenuListener();
        this.m_layout = new BoxLayout(this, 1);
        this.setLayout(this.m_layout);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        Enumeration<TreeNode> enumeration = mutableProperties.children();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties2 = (MutableProperties)enumeration.nextElement();
            component = this.createMenuItem(mutableProperties2);
            this.m_items.put(mutableProperties2, component);
            this.add(component);
        }
        component = new JMenuItemME(null);
        component.addMouseListener(new MenuEditorMouseAdapter());
        this.add(component);
        this.initContextMenus();
    }

    void initContextMenus() {
        this.m_contextMenu = new JPopupMenu();
        JMenu jMenu = GUIFactory.createMenu(null, "IDCM_MENUITEM_TYPE", null, true);
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenu.add(GUIFactory.createRadioButtonMenuItem("Type MenuItem", null, "IDCM_MENUITEM_ITEM", null, true, false, buttonGroup, this.m_menuListener));
        jMenu.add(GUIFactory.createRadioButtonMenuItem("Type Check", null, "IDCM_MENUITEM_CHECKBOX", null, true, false, buttonGroup, this.m_menuListener));
        jMenu.add(GUIFactory.createRadioButtonMenuItem("Type Radio", null, "IDCM_MENUITEM_RADIOBUTTON", null, true, false, buttonGroup, this.m_menuListener));
        jMenu.add(GUIFactory.createRadioButtonMenuItem("Type Submenu", null, "IDCM_MENUITEM_SUBMENU", null, true, false, buttonGroup, this.m_menuListener));
        this.m_contextMenu.add(jMenu);
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_MENUITEM_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_MENUITEM_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_MENUITEM_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        this.m_contextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_MENUITEM_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        this.m_contextMenu.addSeparator();
        this.m_contextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_MENUITEM_PROPERTIES", null, true, this.m_menuListener));
        this.m_linkContextMenu = new JPopupMenu();
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_MENUITEM_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_MENUITEM_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_MENUITEM_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_MENUITEM_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        this.m_linkContextMenu.addSeparator();
        this.m_linkContextMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_MENUITEM_PROPERTIES", null, true, this.m_menuListener));
        this.m_emptyContextMenu = new JPopupMenu();
        jMenu = GUIFactory.createMenu(null, "IDCM_MENUITEM_NEW_ITEM", null, true);
        jMenu.add(GUIFactory.createMenuItem("New MenuItem", null, "IDCM_MENUITEM_ITEM", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New Check", null, "IDCM_MENUITEM_CHECKBOX", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New Radio", null, "IDCM_MENUITEM_RADIOBUTTON", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New Submenu", null, "IDCM_MENUITEM_SUBMENU", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New ItemLink", null, "IDCM_MENUITEM_ITEMLINK", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("New Separator", null, "IDCM_MENUITEM_SEPARATOR", null, true, this.m_menuListener));
        this.m_emptyContextMenu.add(jMenu);
    }

    JPopupMenu getContextMenu(MutableProperties mutableProperties) {
        if (mutableProperties != null) {
            if (mutableProperties.getType() == 52) {
                JMenu jMenu = (JMenu)this.m_contextMenu.getComponent(0);
                String string = (String)mutableProperties.getProperty("Menu Item Type");
                int n = 0;
                if (string.equals("check")) {
                    n = 1;
                } else if (string.equals("radio")) {
                    n = 2;
                } else if (string.equals("submenu")) {
                    n = 3;
                }
                ((JRadioButtonMenuItem)jMenu.getMenuComponent(n)).setSelected(true);
                this.m_contextMenu.getComponent(2).setEnabled(this.m_menuBuilder.canCut());
                this.m_contextMenu.getComponent(3).setEnabled(this.m_menuBuilder.canCopy());
                this.m_contextMenu.getComponent(4).setEnabled(this.m_menuBuilder.canPaste());
                this.m_contextMenu.getComponent(5).setEnabled(this.m_menuBuilder.canDelete());
                return this.m_contextMenu;
            }
            this.m_linkContextMenu.getComponent(0).setEnabled(this.m_menuBuilder.canCut());
            this.m_linkContextMenu.getComponent(1).setEnabled(this.m_menuBuilder.canCopy());
            this.m_linkContextMenu.getComponent(2).setEnabled(this.m_menuBuilder.canPaste());
            this.m_linkContextMenu.getComponent(3).setEnabled(this.m_menuBuilder.canDelete());
            return this.m_linkContextMenu;
        }
        JMenu jMenu = (JMenu)this.m_emptyContextMenu.getComponent(0);
        ((JMenuItem)jMenu.getMenuComponent(4)).setEnabled(this.m_menuBuilder.canLink());
        return this.m_emptyContextMenu;
    }

    Component createMenuItem(MutableProperties mutableProperties) {
        String string = (String)mutableProperties.getProperty("Menu Item Type");
        if (string.equals("separator")) {
            JSeparatorME jSeparatorME = new JSeparatorME(mutableProperties);
            jSeparatorME.addMouseListener(new MenuEditorMouseAdapter());
            jSeparatorME.addMouseMotionListener(new MenuEditorMouseAdapter());
            return jSeparatorME;
        }
        if (string.equals("itemlink")) {
            JMenuItemME jMenuItemME = new JMenuItemME(mutableProperties);
            jMenuItemME.addMouseListener(new MenuEditorMouseAdapter());
            jMenuItemME.addMouseMotionListener(new MenuEditorMouseAdapter());
            String string2 = (String)mutableProperties.getProperty("Link Menu") + "." + (String)mutableProperties.getProperty("Link Item");
            jMenuItemME.setText(string2);
            return jMenuItemME;
        }
        mutableProperties.setPropertyVisible("Menu Item Type", true);
        boolean bl = string.equals("submenu");
        mutableProperties.setPropertyVisible("Accelerator", !bl);
        mutableProperties.setPropertyVisible("* Key", !bl);
        mutableProperties.setPropertyVisible("* Modifier", !bl);
        AbstractButton abstractButton = string.equals("submenu") ? new JMenuME(mutableProperties) : (string.equals("check") ? new JCheckBoxMenuItemME(mutableProperties) : (string.equals("radio") ? new JRadioButtonMenuItemME(mutableProperties) : new JMenuItemME(mutableProperties)));
        abstractButton.addMouseListener(new MenuEditorMouseAdapter());
        abstractButton.addMouseMotionListener(new MenuEditorMouseAdapter());
        MenuBuilder.resetMenu(abstractButton, mutableProperties);
        String string3 = (String)mutableProperties.getProperty("Flyover Text");
        if (string3.equals("")) {
            string3 = null;
        }
        abstractButton.setToolTipText(string3);
        return abstractButton;
    }

    void insertItem(MutableProperties mutableProperties, int n) {
        Component component = this.createMenuItem(mutableProperties);
        this.m_items.put(mutableProperties, component);
        this.add(component, n);
        this.m_layout.invalidateLayout(this);
        this.setSize(this.getPreferredSize());
        this.m_layout.layoutContainer(this);
    }

    void removeItem(MutableProperties mutableProperties) {
        Component component = (Component)this.m_items.get(mutableProperties);
        if (component != null) {
            this.remove(component);
            this.m_items.remove(mutableProperties);
            this.m_layout.invalidateLayout(this);
            this.setSize(this.getPreferredSize());
            this.m_layout.layoutContainer(this);
        }
    }

    void refresh(MutableProperties mutableProperties) {
        Component component = (Component)this.m_items.get(mutableProperties);
        if (component == null) {
            return;
        }
        int n = 0;
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getComponent(n3).equals(component)) {
                n = n3;
                break;
            }
            ++n3;
        }
        this.remove(component);
        component = this.createMenuItem(mutableProperties);
        this.m_items.put(mutableProperties, component);
        this.add(component, n);
        this.m_layout.invalidateLayout(this);
        this.setSize(this.getPreferredSize());
        this.m_layout.layoutContainer(this);
    }

    Rectangle getItemBounds(MutableProperties mutableProperties) {
        this.m_layout.layoutContainer(this);
        Component component = (Component)this.m_items.get(mutableProperties);
        if (component != null) {
            return component.getBounds();
        }
        return null;
    }

    boolean containsItem(MutableProperties mutableProperties) {
        return this.m_items.containsKey(mutableProperties);
    }

    MutableProperties getItemAtPoint(Point point) {
        Enumeration enumeration = this.m_items.keys();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            Component component = (Component)this.m_items.get(mutableProperties);
            if (!component.getBounds().contains(point)) continue;
            return mutableProperties;
        }
        if (this.getBounds().contains(point)) {
            return (MutableProperties)this.m_properties.getLastChild();
        }
        return null;
    }

    MutableProperties getItemProperties(Component component) {
        Enumeration enumeration = this.m_items.keys();
        while (enumeration.hasMoreElements()) {
            MutableProperties mutableProperties = (MutableProperties)enumeration.nextElement();
            Component component2 = (Component)this.m_items.get(mutableProperties);
            if (!component2.equals(component)) continue;
            return mutableProperties;
        }
        return null;
    }

    MutableProperties getProperties() {
        return this.m_properties;
    }

    public void paint(Graphics graphics) {
        Serializable serializable;
        Rectangle rectangle;
        Object object;
        MutableProperties mutableProperties;
        super.paint(graphics);
        MutableProperties mutableProperties2 = this.m_menuBuilder.getSelectedProperties();
        MutableProperties mutableProperties3 = this.m_menuBuilder.getHoverProperties();
        Enumeration<TreeNode> enumeration = this.m_properties.children();
        while (enumeration.hasMoreElements()) {
            mutableProperties = (MutableProperties)enumeration.nextElement();
            if (!mutableProperties.equals(mutableProperties2)) continue;
            object = (Component)this.m_items.get(mutableProperties);
            rectangle = ((Component)object).getBounds();
            --rectangle.x;
            --rectangle.y;
            ++rectangle.width;
            ++rectangle.height;
            serializable = graphics.getColor();
            graphics.setColor(Color.blue);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor((Color)serializable);
            break;
        }
        if (mutableProperties3 == null) {
            return;
        }
        if (mutableProperties3.equals(this.getProperties()) && this.m_menuBuilder.getHoverDirection() == 2) {
            object = this.getComponent(0);
            rectangle = ((Component)object).getBounds();
            serializable = graphics.getColor();
            graphics.setColor(Color.magenta);
            graphics.drawLine(rectangle.x - 1, rectangle.y, rectangle.width + 1, rectangle.y);
            graphics.drawLine(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.y - 1);
            graphics.setColor((Color)serializable);
        } else {
            object = this.m_properties.children();
            while (object.hasMoreElements()) {
                mutableProperties = (MutableProperties)object.nextElement();
                if (!mutableProperties.equals(mutableProperties3) || this.m_menuBuilder.getHoverDirection() == 2) continue;
                boolean bl = mutableProperties.getProperty("Menu Item Type").equals("separator");
                serializable = (Component)this.m_items.get(mutableProperties);
                Rectangle rectangle2 = ((Component)serializable).getBounds();
                Color color = graphics.getColor();
                graphics.setColor(Color.magenta);
                if (this.m_menuBuilder.getHoverDirection() == 0) {
                    graphics.drawLine(rectangle2.x - 1, rectangle2.y, rectangle2.width + 1, rectangle2.y);
                    graphics.drawLine(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 1, rectangle2.y - 1);
                } else {
                    graphics.drawLine(rectangle2.x - 1, rectangle2.y + rectangle2.height - 1, rectangle2.width + 1, rectangle2.y + rectangle2.height - 1);
                    graphics.drawLine(rectangle2.x - 1, rectangle2.y + rectangle2.height, rectangle2.width + 1, rectangle2.y + rectangle2.height);
                }
                graphics.setColor(color);
                break;
            }
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class JSeparatorME
    extends JSeparator {
        MutableProperties myProperties;

        JSeparatorME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height += 2;
            return dimension;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (MenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            }
        }
    }

    class JRadioButtonMenuItemME
    extends AbstractButton
    implements MenuItemRenderer {
        JRadioButtonMenuItem myMenuItem;
        MutableProperties myProperties;

        JRadioButtonMenuItemME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
            this.myMenuItem = new JRadioButtonMenuItem();
            this.setModel(new DefaultButtonModel());
            boolean bl = (Boolean)mutableProperties.getProperty("Toggle Selected");
            this.myMenuItem.setSelected(bl);
            boolean bl2 = (Boolean)mutableProperties.getProperty("Disabled");
            this.myMenuItem.setEnabled(!bl2);
            boolean bl3 = (Boolean)mutableProperties.getProperty("Default Menu Item");
            if (bl3) {
                Font font = UIManager.getFont("MenuItem.font");
                this.myMenuItem.setFont(new Font(font.getFamily(), 1, font.getSize()));
            }
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenuItem != null) {
                this.myMenuItem.setIcon(icon);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.myMenuItem != null) {
                this.myMenuItem.setText(string);
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(c);
            }
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(n);
            }
        }

        public void setAccelerator(KeyStroke keyStroke) {
            if (this.myMenuItem != null) {
                this.myMenuItem.setAccelerator(keyStroke);
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenuItem != null) {
                this.myMenuItem.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getUI().getPreferredSize(this.myMenuItem);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getMinimumSize();
            }
            return super.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenuItem != null) {
                this.myMenuItem.getUI().paint(graphics, this.myMenuItem);
            } else {
                super.paint(graphics);
            }
            if (MenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            }
        }
    }

    class JCheckBoxMenuItemME
    extends AbstractButton
    implements MenuItemRenderer {
        JCheckBoxMenuItem myMenuItem;
        MutableProperties myProperties;

        JCheckBoxMenuItemME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
            this.myMenuItem = new JCheckBoxMenuItem();
            this.setModel(new DefaultButtonModel());
            boolean bl = (Boolean)mutableProperties.getProperty("Toggle Selected");
            this.myMenuItem.setSelected(bl);
            this.myMenuItem.setState(bl);
            boolean bl2 = (Boolean)mutableProperties.getProperty("Disabled");
            this.myMenuItem.setEnabled(!bl2);
            boolean bl3 = (Boolean)mutableProperties.getProperty("Default Menu Item");
            if (bl3) {
                Font font = UIManager.getFont("MenuItem.font");
                this.myMenuItem.setFont(new Font(font.getFamily(), 1, font.getSize()));
            }
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenuItem != null) {
                this.myMenuItem.setIcon(icon);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.myMenuItem != null) {
                this.myMenuItem.setText(string);
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(c);
            }
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(n);
            }
        }

        public void setAccelerator(KeyStroke keyStroke) {
            if (this.myMenuItem != null) {
                this.myMenuItem.setAccelerator(keyStroke);
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenuItem != null) {
                this.myMenuItem.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getUI().getPreferredSize(this.myMenuItem);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getMinimumSize();
            }
            return super.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenuItem != null) {
                this.myMenuItem.getUI().paint(graphics, this.myMenuItem);
            } else {
                super.paint(graphics);
            }
            if (MenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            }
        }
    }

    class JMenuME
    extends AbstractButton {
        JMenu myMenu;
        MutableProperties myProperties;

        JMenuME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
            this.myMenu = new JMenu();
            this.setModel(new DefaultButtonModel());
            boolean bl = (Boolean)mutableProperties.getProperty("Disabled");
            this.myMenu.setEnabled(!bl);
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenu != null) {
                this.myMenu.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenu != null) {
                this.myMenu.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenu != null) {
                this.myMenu.setIcon(icon);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.myMenu != null) {
                this.myMenu.setText(string);
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
            if (this.myMenu != null) {
                this.myMenu.setMnemonic(c);
            }
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
            if (this.myMenu != null) {
                this.myMenu.setMnemonic(n);
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenu != null) {
                this.myMenu.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenu != null) {
                return this.myMenu.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            if (this.myMenu != null) {
                return this.myMenu.getUI().getPreferredSize(this.myMenu);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.myMenu != null) {
                return this.myMenu.getMinimumSize();
            }
            return super.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenu != null) {
                this.myMenu.getUI().paint(graphics, this.myMenu);
            } else {
                super.paint(graphics);
            }
            if (MenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            }
        }
    }

    class JMenuItemME
    extends AbstractButton
    implements MenuItemRenderer {
        JMenuItem myMenuItem;
        MutableProperties myProperties;

        JMenuItemME(MutableProperties mutableProperties) {
            this.myProperties = mutableProperties;
            this.myMenuItem = new JMenuItem();
            this.setModel(new DefaultButtonModel());
            if (mutableProperties != null) {
                boolean bl;
                if (mutableProperties.hasProperty("Disabled")) {
                    bl = (Boolean)mutableProperties.getProperty("Disabled");
                    this.myMenuItem.setEnabled(!bl);
                }
                if (mutableProperties.hasProperty("Default Menu Item") && (bl = ((Boolean)mutableProperties.getProperty("Default Menu Item")).booleanValue())) {
                    Font font = UIManager.getFont("MenuItem.font");
                    this.myMenuItem.setFont(new Font(font.getFamily(), 1, font.getSize()));
                }
            }
        }

        public void setHorizontalTextPosition(int n) {
            super.setHorizontalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setHorizontalTextPosition(n);
            }
        }

        public void setVerticalTextPosition(int n) {
            super.setVerticalTextPosition(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setVerticalTextPosition(n);
            }
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (this.myMenuItem != null) {
                this.myMenuItem.setIcon(icon);
            }
        }

        public void setText(String string) {
            super.setText(string);
            if (this.myMenuItem != null) {
                this.myMenuItem.setText(string);
            }
        }

        public void setMnemonic(char c) {
            super.setMnemonic(c);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(c);
            }
        }

        public void setMnemonic(int n) {
            super.setMnemonic(n);
            if (this.myMenuItem != null) {
                this.myMenuItem.setMnemonic(n);
            }
        }

        public void setAccelerator(KeyStroke keyStroke) {
            if (this.myMenuItem != null) {
                this.myMenuItem.setAccelerator(keyStroke);
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.myMenuItem != null) {
                this.myMenuItem.setBounds(n, n2, n3, n4);
            }
        }

        public Rectangle getBounds() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getBounds();
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize() {
            if (this.myProperties == null) {
                return new Dimension(50, 20);
            }
            if (this.myMenuItem != null) {
                return this.myMenuItem.getUI().getPreferredSize(this.myMenuItem);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.myMenuItem != null) {
                return this.myMenuItem.getMinimumSize();
            }
            return super.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            if (this.myMenuItem != null) {
                this.myMenuItem.getUI().paint(graphics, this.myMenuItem);
            } else {
                super.paint(graphics);
            }
            if (MenuEditor.this.m_menuBuilder.getSelectedProperties().equals(this.myProperties)) {
                Color color = graphics.getColor();
                graphics.setColor(Color.blue);
                Dimension dimension = this.getSize();
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                graphics.setColor(color);
            } else if (this.myProperties == null) {
                Color color = graphics.getColor();
                graphics.setColor(Color.black);
                Dimension dimension = this.getSize();
                BasicGraphicsUtils.drawDashedRect(graphics, 2, 2, dimension.width - 4, dimension.height - 4);
                graphics.setColor(color);
            }
        }
    }

    class MenuEditorMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        int m_dragCount = 0;
        int m_dragThreshold = 5;
        MutableProperties m_dragProperties = null;
        boolean m_createMode = false;

        MenuEditorMouseAdapter() {
        }

        void showContextMenu(MutableProperties mutableProperties, Point point) {
            JPopupMenu jPopupMenu = MenuEditor.this.getContextMenu(mutableProperties);
            if (mutableProperties == null) {
                MenuEditor.this.m_menuBuilder.setEmptyParent(MenuEditor.this.getProperties());
            }
            if (jPopupMenu != null) {
                jPopupMenu.show(MenuEditor.this, point.x, point.y);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MutableProperties mutableProperties = MenuEditor.this.getItemProperties(component);
            if (this.m_dragProperties != null) {
                this.m_dragProperties = null;
            } else {
                if (mutableProperties != null) {
                    MenuEditor.this.m_menuBuilder.setSelectedProperties(mutableProperties);
                    this.m_dragProperties = mutableProperties;
                    MenuEditor.this.repaint();
                } else {
                    this.m_createMode = true;
                }
                if (mouseEvent.isPopupTrigger()) {
                    Point point = mouseEvent.getPoint();
                    Point point2 = component.getLocation();
                    point.x += point2.x;
                    point.y += point2.y;
                    this.showContextMenu(mutableProperties, point);
                    this.m_createMode = false;
                    this.m_dragProperties = null;
                }
            }
            this.m_dragCount = 0;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.m_dragCount > this.m_dragThreshold) {
                Point point = mouseEvent.getPoint();
                Point point2 = MenuEditor.this.getLocation();
                point.x += point2.x;
                point.y += point2.y;
                Component component = (Component)mouseEvent.getSource();
                Point point3 = component.getLocation();
                point.x += point3.x;
                point.y += point3.y;
                MenuEditor.this.m_menuBuilder.processMouseDrag(point);
            }
            ++this.m_dragCount;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MutableProperties mutableProperties = this.m_dragProperties;
            if (mouseEvent.isPopupTrigger() && (mutableProperties != null || this.m_createMode)) {
                Point point = mouseEvent.getPoint();
                Point point2 = component.getLocation();
                point.x += point2.x;
                point.y += point2.y;
                this.showContextMenu(mutableProperties, point);
                this.m_dragCount = 0;
                this.m_dragProperties = null;
                this.m_createMode = false;
                return;
            }
            if (mutableProperties != null) {
                Cloneable cloneable;
                Serializable serializable;
                Cloneable cloneable2;
                if (this.m_dragCount > this.m_dragThreshold) {
                    cloneable2 = mouseEvent.getPoint();
                    serializable = MenuEditor.this.getLocation();
                    ((Point)cloneable2).x += ((Point)serializable).x;
                    ((Point)cloneable2).y += ((Point)serializable).y;
                    cloneable = component.getLocation();
                    ((Point)cloneable2).x += ((Point)cloneable).x;
                    ((Point)cloneable2).y += ((Point)cloneable).y;
                    MenuEditor.this.m_menuBuilder.processMouseDrag((Point)cloneable2);
                }
                if ((cloneable2 = MenuEditor.this.m_menuBuilder.getHoverProperties()) != null && !cloneable2.equals(MenuEditor.this.m_menuBuilder.getProperties()) && !cloneable2.equals(mutableProperties)) {
                    serializable = MenuEditor.this.m_menuBuilder.getPDMLDocument();
                    ((XMLGUIBuilderDefinition)serializable).beginEdit(true);
                    mutableProperties.removeFromParent();
                    cloneable = (MutableProperties)((DefaultMutableTreeNode)cloneable2).getParent();
                    int n = MenuEditor.this.m_menuBuilder.getHoverDirection();
                    if (n == 2) {
                        ((MutableProperties)cloneable2).add(mutableProperties);
                    } else {
                        int n2 = ((DefaultMutableTreeNode)cloneable).getIndex((TreeNode)((Object)cloneable2));
                        if (n == 1) {
                            ++n2;
                        }
                        ((MutableProperties)cloneable).insert(mutableProperties, n2);
                    }
                    ((XMLGUIBuilderDefinition)serializable).endEdit();
                    MenuEditor.this.m_menuBuilder.getBuilder().updateBuilder();
                }
            } else if (this.m_createMode) {
                XMLGUIBuilderDefinition xMLGUIBuilderDefinition = MenuEditor.this.m_menuBuilder.getPDMLDocument();
                xMLGUIBuilderDefinition.beginEdit();
                mutableProperties = new MenuItemProperties();
                try {
                    mutableProperties.setProperty("Name", ((MenuProperties)MenuEditor.this.m_menuBuilder.getProperties()).generateName(52));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                try {
                    mutableProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_MENUITEM"));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                mutableProperties.setPDMLDocument(xMLGUIBuilderDefinition);
                MenuEditor.this.m_properties.add(mutableProperties);
                xMLGUIBuilderDefinition.endEdit();
                MenuEditor.this.m_menuBuilder.getBuilder().updateBuilder();
            }
            MenuEditor.this.m_menuBuilder.setHoverProperties(null, 0);
            MenuEditor.this.m_menuBuilder.setSelectedProperties(MenuEditor.this.m_menuBuilder.getSelectedProperties());
            this.m_dragCount = 0;
            this.m_dragProperties = null;
            this.m_createMode = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                Component component = (Component)mouseEvent.getSource();
                MutableProperties mutableProperties = MenuEditor.this.getItemProperties(component);
                if (mutableProperties == null) {
                    XMLGUIBuilderDefinition xMLGUIBuilderDefinition = MenuEditor.this.m_menuBuilder.getPDMLDocument();
                    xMLGUIBuilderDefinition.beginEdit();
                    mutableProperties = new MenuItemProperties();
                    try {
                        mutableProperties.setProperty("Name", ((MenuProperties)MenuEditor.this.m_menuBuilder.getProperties()).generateName(52));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    try {
                        mutableProperties.setProperty("Title", GUIFactory.getString("IDS_DEFAULT_LABEL_MENUITEM"));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    mutableProperties.setPDMLDocument(xMLGUIBuilderDefinition);
                    MenuEditor.this.m_properties.add(mutableProperties);
                    xMLGUIBuilderDefinition.endEdit();
                } else if ((mouseEvent.getModifiers() & 0x10) == 16 && mutableProperties.isPropertyVisible("Title")) {
                    MenuEditor.this.m_menuBuilder.getBuilder().doEditProperty("Title");
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

