/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.MessageLog;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.PopupMenuButton;
import com.ibm.as400.ui.tools.GUIBuilder;
import com.ibm.as400.ui.tools.StringTableEntry;
import com.ibm.as400.ui.tools.StringTableProperties;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;

class GUIFactory {
    static String[] m_languageCodes;
    static String[] m_countryCodes;
    static boolean m_showMenuIcons;
    static boolean m_flushButtons;
    static Hashtable m_imageCache;
    static Hashtable m_propertyNames;
    static Hashtable m_propertyHelp;
    static Hashtable m_propertyValues;
    static Hashtable m_elementNames;
    static ResourceBundle m_bundle;
    static String[] m_languages;
    static String[] m_countries;
    static String m_imageBase;
    static GUIBuilder m_builder;

    GUIFactory() {
    }

    static String getString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return m_bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    static String[] getLanguages() {
        return m_languages;
    }

    static String[] getCountries() {
        return m_countries;
    }

    static String getLocalizedPropertyName(String string) {
        return (String)m_propertyNames.get(string);
    }

    static String getPropertyHelp(String string) {
        return (String)m_propertyHelp.get(string);
    }

    static String getLocalizedPropertyValue(Object object) {
        return (String)m_propertyValues.get(object);
    }

    static String getLocalizedElementName(String string) {
        return (String)m_elementNames.get(string);
    }

    static void setMenuText(JMenuItem jMenuItem, String string) {
        String string2;
        String string3 = string2 = GUIFactory.getString(string);
        int n = string2.indexOf(38);
        if (n > -1) {
            jMenuItem.setMnemonic(string2.charAt(n + 1));
            string3 = string2.substring(0, n);
            string3 = string3 + string2.substring(n + 1);
        }
        jMenuItem.setText(string3);
    }

    static ImageIcon getImage(String string, boolean bl) {
        if (bl && m_imageCache.containsKey(string)) {
            return (ImageIcon)m_imageCache.get(string);
        }
        ImageIcon imageIcon = null;
        try {
            imageIcon = SystemResourceFinder.getImageResource((String)(m_imageBase + string));
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError((Object)missingResourceException);
        }
        if (bl && imageIcon != null) {
            m_imageCache.put(string, imageIcon);
        }
        return imageIcon;
    }

    static ImageIcon getUserImage(String string) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = SystemResourceFinder.getImageResource((String)string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (imageIcon != null) {
            imageIcon = new ImageIcon(imageIcon.getImage());
        }
        return imageIcon;
    }

    static JMenu createMenu(String string, String string2, String string3, boolean bl) {
        if (!m_showMenuIcons) {
            string3 = null;
        }
        JMenu jMenu = new JMenu();
        if (string != null) {
            jMenu.setName(string);
        }
        if (string2 != null) {
            string2 = GUIFactory.getString(string2);
            GUIFactory.setMenuText(jMenu, string2);
        }
        if (string3 != null) {
            jMenu.setIcon(GUIFactory.getImage(string3, true));
        }
        jMenu.setEnabled(bl);
        return jMenu;
    }

    static JMenuItem createMenuItem(String string, String string2, String string3, String string4, boolean bl, ActionListener actionListener) {
        return GUIFactory.createMenuItem(string, string2, string3, string4, bl, null, actionListener);
    }

    static JMenuItem createMenuItem(String string, String string2, String string3, String string4, boolean bl, KeyStroke keyStroke, ActionListener actionListener) {
        if (!m_showMenuIcons) {
            string4 = null;
        }
        JMenuItem jMenuItem = new JMenuItem();
        if (string2 != null) {
            jMenuItem.setName(string2);
        }
        if (string3 != null) {
            string3 = GUIFactory.getString(string3);
            GUIFactory.setMenuText(jMenuItem, string3);
        }
        if (string4 != null) {
            jMenuItem.setIcon(GUIFactory.getImage(string4, true));
        }
        if (string != null) {
            jMenuItem.setActionCommand(string);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setEnabled(bl);
        if (actionListener != null) {
            jMenuItem.addActionListener(actionListener);
        }
        return jMenuItem;
    }

    static JCheckBoxMenuItem createCheckBoxMenuItem(String string, String string2, String string3, String string4, boolean bl, boolean bl2, ActionListener actionListener) {
        return (JCheckBoxMenuItem)GUIFactory.createStateMenuItem(string, string2, string3, string4, bl, bl2, null, actionListener);
    }

    static JRadioButtonMenuItem createRadioButtonMenuItem(String string, String string2, String string3, String string4, boolean bl, boolean bl2, ButtonGroup buttonGroup, ActionListener actionListener) {
        return (JRadioButtonMenuItem)GUIFactory.createStateMenuItem(string, string2, string3, string4, bl, bl2, buttonGroup, actionListener);
    }

    static JMenuItem createStateMenuItem(String string, String string2, String string3, String string4, boolean bl, boolean bl2, ButtonGroup buttonGroup, ActionListener actionListener) {
        JMenuItem jMenuItem;
        if (!m_showMenuIcons) {
            string4 = null;
        }
        if (buttonGroup == null) {
            jMenuItem = new JCheckBoxMenuItem();
        } else {
            jMenuItem = new JRadioButtonMenuItem();
            buttonGroup.add(jMenuItem);
        }
        if (string2 != null) {
            jMenuItem.setName(string2);
        }
        if (string3 != null) {
            string3 = GUIFactory.getString(string3);
            GUIFactory.setMenuText(jMenuItem, string3);
        }
        if (string4 != null) {
            jMenuItem.setIcon(GUIFactory.getImage(string4, true));
        }
        if (string != null) {
            jMenuItem.setActionCommand(string);
        }
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setEnabled(bl);
        jMenuItem.setSelected(bl2);
        if (actionListener != null) {
            jMenuItem.addActionListener(actionListener);
        }
        return jMenuItem;
    }

    static JButton createButton(String string, String string2, String string3, String string4, String string5, boolean bl, ActionListener actionListener) {
        JButton jButton = new JButton();
        jButton.setDefaultCapable(false);
        if (string != null) {
            jButton.setActionCommand(string);
        }
        if (string2 != null) {
            jButton.setName(string2);
        }
        if (string3 != null) {
            string3 = GUIFactory.getString(string3);
            jButton.setText(string3);
        }
        if (string4 != null) {
            jButton.setIcon(GUIFactory.getImage(string4, true));
        }
        if (string5 != null) {
            string5 = GUIFactory.getString(string5);
            jButton.setToolTipText(string5);
        }
        jButton.setEnabled(bl);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        if (string4 != null && string3 != null) {
            jButton.setMargin(new Insets(0, 0, 0, 4));
        }
        if (string4 != null) {
            jButton.setMargin(new Insets(0, 0, 0, 0));
            if (m_flushButtons) {
                jButton.setBorderPainted(false);
                jButton.setFocusPainted(false);
                jButton.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent mouseEvent) {
                        AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
                        abstractButton.setBorderPainted(abstractButton.isEnabled());
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        AbstractButton abstractButton;
                        abstractButton.setBorderPainted((abstractButton = (AbstractButton)mouseEvent.getComponent()).isEnabled() && abstractButton.isSelected());
                    }
                });
            }
        } else if (string3 != null) {
            jButton.setMargin(new Insets(2, 4, 2, 4));
        }
        return jButton;
    }

    static PopupMenuButton createPopupMenuButton(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, ActionListener actionListener) {
        String string7 = string3 != null ? GUIFactory.getString(string3) : null;
        String string8 = string5 != null ? GUIFactory.getString(string5) : null;
        String string9 = string6 != null ? GUIFactory.getString(string6) : null;
        ImageIcon imageIcon = string4 != null ? GUIFactory.getImage(string4, true) : null;
        PopupMenuButton popupMenuButton = new PopupMenuButton(string7, (Icon)imageIcon, string8, null, string9, null);
        popupMenuButton.getButton().setFocusPainted(false);
        popupMenuButton.getArrowButton().setFocusPainted(false);
        if (string != null) {
            popupMenuButton.setActionCommand(string);
        }
        if (string2 != null) {
            popupMenuButton.setName(string2);
        }
        popupMenuButton.setEnabled(bl);
        if (actionListener != null) {
            popupMenuButton.addActionListener(actionListener);
        }
        return popupMenuButton;
    }

    static JRadioButton createRadioButton(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, ButtonGroup buttonGroup, ActionListener actionListener) {
        return (JRadioButton)GUIFactory.createStateButton(true, string, string2, string3, string4, string5, bl, bl2, buttonGroup, actionListener);
    }

    static JToggleButton createToggleButton(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, ButtonGroup buttonGroup, ActionListener actionListener) {
        return GUIFactory.createStateButton(false, string, string2, string3, string4, string5, bl, bl2, buttonGroup, actionListener);
    }

    static JToggleButton createStateButton(boolean bl, String string, String string2, String string3, String string4, String string5, boolean bl2, boolean bl3, ButtonGroup buttonGroup, ActionListener actionListener) {
        JToggleButton jToggleButton = null;
        jToggleButton = !bl ? new JToggleButton() : new JRadioButton();
        if (buttonGroup != null) {
            buttonGroup.add(jToggleButton);
        }
        jToggleButton.setSelected(bl3);
        if (string != null) {
            jToggleButton.setActionCommand(string);
        }
        if (string2 != null) {
            jToggleButton.setName(string2);
        }
        if (string3 != null) {
            string3 = GUIFactory.getString(string3);
            jToggleButton.setText(string3);
        }
        if (string4 != null) {
            jToggleButton.setIcon(GUIFactory.getImage(string4, true));
        }
        if (string5 != null) {
            string5 = GUIFactory.getString(string5);
            jToggleButton.setToolTipText(string5);
        }
        jToggleButton.setEnabled(bl2);
        if (actionListener != null) {
            jToggleButton.addActionListener(actionListener);
        }
        if (string4 != null && string3 != null) {
            jToggleButton.setMargin(new Insets(0, 0, 0, 4));
        } else if (string4 != null) {
            jToggleButton.setMargin(new Insets(0, 0, 0, 0));
            if (m_flushButtons) {
                jToggleButton.setBorderPainted(bl3);
                jToggleButton.setFocusPainted(false);
                jToggleButton.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent mouseEvent) {
                        AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
                        abstractButton.setBorderPainted(abstractButton.isEnabled());
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        AbstractButton abstractButton;
                        abstractButton.setBorderPainted((abstractButton = (AbstractButton)mouseEvent.getComponent()).isEnabled() && abstractButton.isSelected());
                    }
                });
                jToggleButton.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        AbstractButton abstractButton;
                        abstractButton.setBorderPainted((abstractButton = (AbstractButton)changeEvent.getSource()).isEnabled() && abstractButton.isSelected());
                    }
                });
            }
        } else if (string3 != null) {
            jToggleButton.setMargin(new Insets(2, 4, 2, 4));
        }
        return jToggleButton;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        StringTableEntry stringTableEntry;
        String string;
        m_languageCodes = new String[]{"aa", "ab", "af", "am", "ar", "as", "ay", "az", "ba", "be", "bg", "bh", "bi", "bn", "bo", "br", "ca", "co", "cs", "cy", "da", "de", "dz", "el", "en", "eo", "es", "et", "eu", "fa", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "ha", "he", "hi", "hr", "hu", "hy", "ia", "id", "ie", "ik", "is", "it", "iu", "ja", "jw", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "kz", "la", "ln", "lo", "lt", "lv", "mg", "mi", "mk", "ml", "mn", "mo", "mr", "ms", "mt", "my", "na", "ne", "nl", "no", "oc", "om", "or", "pa", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sd", "sg", "sh", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ug", "uk", "ur", "uz", "vi", "vo", "wo", "xh", "yi", "yo", "za", "zh", "zu"};
        m_countryCodes = new String[]{"AF", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN", "CX", "CC", "CO", "KM", "CG", "CK", "CR", "CI", "HR", "CU", "CY", "CZ", "DK", "DJ", "DM", "DO", "TP", "EC", "EG", "SV", "GQ", "ER", "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "FX", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GN", "GW", "GY", "HT", "HM", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "AN", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "KN", "LC", "VC", "WS", "SM", "ST", "SA", "SN", "SC", "SL", "SG", "SK", "SI", "SB", "SO", "ZA", "GS", "ES", "LK", "SH", "PM", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VA", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "YU", "ZR", "ZM", "ZW"};
        m_showMenuIcons = true;
        m_flushButtons = true;
        m_imageCache = new Hashtable();
        m_propertyNames = new Hashtable();
        m_propertyHelp = new Hashtable();
        m_propertyValues = new Hashtable();
        m_elementNames = new Hashtable();
        m_bundle = ResourceBundle.getBundle("com.ibm.as400.ui.tools.guibuilderpanels");
        m_imageBase = "com/ibm/as400/ui/tools/img/";
        m_propertyNames.put("Element", GUIFactory.getString("IDP_ELEMENT"));
        m_propertyNames.put("Name", GUIFactory.getString("IDP_NAME"));
        m_propertyNames.put("Title", GUIFactory.getString("IDP_TITLE"));
        m_propertyNames.put("Size", GUIFactory.getString("IDP_SIZE"));
        m_propertyNames.put("-> Width", GUIFactory.getString("IDP_SIZE_WIDTH"));
        m_propertyNames.put("-> Height", GUIFactory.getString("IDP_SIZE_HEIGHT"));
        m_propertyNames.put("Icon", GUIFactory.getString("IDP_ICON"));
        m_propertyNames.put("Expanded Icon", GUIFactory.getString("IDP_EXPANDED_ICON"));
        m_propertyNames.put("Activate", GUIFactory.getString("IDP_ACTIVATE"));
        m_propertyNames.put("Margins", GUIFactory.getString("IDP_MARGINS"));
        m_propertyNames.put("-> Top", GUIFactory.getString("IDP_MARGINS_TOP"));
        m_propertyNames.put("-> Bottom", GUIFactory.getString("IDP_MARGINS_BOTTOM"));
        m_propertyNames.put("-> Left", GUIFactory.getString("IDP_MARGINS_LEFT"));
        m_propertyNames.put("-> Right", GUIFactory.getString("IDP_MARGINS_RIGHT"));
        m_propertyNames.put("Grid", GUIFactory.getString("IDP_GRID"));
        m_propertyNames.put("Bounds", GUIFactory.getString("IDP_BOUNDS"));
        m_propertyNames.put("-> X", GUIFactory.getString("IDP_BOUNDS_X"));
        m_propertyNames.put("-> Y", GUIFactory.getString("IDP_BOUNDS_Y"));
        m_propertyNames.put("Data Class", GUIFactory.getString("IDP_DATACLASS"));
        m_propertyNames.put("Attribute", GUIFactory.getString("IDP_ATTRIBUTE"));
        m_propertyNames.put("Label", GUIFactory.getString("IDP_LABEL"));
        m_propertyNames.put("Text", GUIFactory.getString("IDP_TEXT"));
        m_propertyNames.put("Style", GUIFactory.getString("IDP_STYLE"));
        m_propertyNames.put("Action", GUIFactory.getString("IDP_ACTION"));
        m_propertyNames.put("Menu Action", GUIFactory.getString("IDP_ACTION"));
        m_propertyNames.put("Generate Field Help", GUIFactory.getString("IDP_GENERATE_FIELD_HELP"));
        m_propertyNames.put("Generate BG Field Help", GUIFactory.getString("IDP_GENERATE_FIELD_HELP"));
        m_propertyNames.put("* Help Alias", GUIFactory.getString("IDP_HELP_ALIAS"));
        m_propertyNames.put("* Help Link", GUIFactory.getString("IDP_HELP_LINK"));
        m_propertyNames.put("Tooltip", GUIFactory.getString("IDP_TOOLTIP"));
        m_propertyNames.put("Editable", GUIFactory.getString("IDP_EDITABLE"));
        m_propertyNames.put("Width", GUIFactory.getString("IDP_COLUMN_WIDTH"));
        m_propertyNames.put("Format", GUIFactory.getString("IDP_FORMAT"));
        m_propertyNames.put("Locale", GUIFactory.getString("IDP_LOCALE"));
        m_propertyNames.put("+ Language", GUIFactory.getString("IDP_LOCALE_LANGUAGE"));
        m_propertyNames.put("+ Country", GUIFactory.getString("IDP_LOCALE_COUNTRY"));
        m_propertyNames.put("Resource", GUIFactory.getString("IDP_RESOURCE"));
        m_propertyNames.put("File", GUIFactory.getString("IDP_FILE"));
        m_propertyNames.put("Min Value", GUIFactory.getString("IDP_MIN_VALUE"));
        m_propertyNames.put("Max Value", GUIFactory.getString("IDP_MAX_VALUE"));
        m_propertyNames.put("Major Ticks", GUIFactory.getString("IDP_MAJOR_TICKS"));
        m_propertyNames.put("Minor Ticks", GUIFactory.getString("IDP_MINOR_TICKS"));
        m_propertyNames.put("Adjust", GUIFactory.getString("IDP_ADJUST"));
        m_propertyNames.put("Multiline", GUIFactory.getString("IDP_MULTILINE"));
        m_propertyNames.put("Masked", GUIFactory.getString("IDP_MASKED"));
        m_propertyNames.put("Selected", GUIFactory.getString("IDP_SELECTED"));
        m_propertyNames.put("+ Enable", GUIFactory.getString("IDP_SELECTED_ENABLE"));
        m_propertyNames.put("+ Disable", GUIFactory.getString("IDP_SELECTED_DISABLE"));
        m_propertyNames.put("+ Refresh", GUIFactory.getString("IDP_SELECTED_REFRESH"));
        m_propertyNames.put("+ Show", GUIFactory.getString("IDP_SELECTED_SHOW"));
        m_propertyNames.put("+ Hide", GUIFactory.getString("IDP_SELECTED_HIDE"));
        m_propertyNames.put("+ Display", GUIFactory.getString("IDP_SELECTED_DISPLAY"));
        m_propertyNames.put("Deselected", GUIFactory.getString("IDP_DESELECTED"));
        m_propertyNames.put("- Enable", GUIFactory.getString("IDP_DESELECTED_ENABLE"));
        m_propertyNames.put("- Disable", GUIFactory.getString("IDP_DESELECTED_DISABLE"));
        m_propertyNames.put("- Refresh", GUIFactory.getString("IDP_DESELECTED_REFRESH"));
        m_propertyNames.put("- Show", GUIFactory.getString("IDP_DESELECTED_SHOW"));
        m_propertyNames.put("- Hide", GUIFactory.getString("IDP_DESELECTED_HIDE"));
        m_propertyNames.put("- Display", GUIFactory.getString("IDP_DESELECTED_DISPLAY"));
        m_propertyNames.put("Version", GUIFactory.getString("IDP_VERSION"));
        m_propertyNames.put("Orientation", GUIFactory.getString("IDP_ORIENTATION"));
        m_propertyNames.put("Generate Help", GUIFactory.getString("IDP_GENERATE_HELP"));
        m_propertyNames.put("Eclipse Plugin ID", GUIFactory.getString("IDP_ECLIPSE_PLUGIN_ID"));
        m_propertyNames.put("* Int Min Value", GUIFactory.getString("IDP_INT_MIN_VALUE"));
        m_propertyNames.put("* Int Max Value", GUIFactory.getString("IDP_INT_MAX_VALUE"));
        m_propertyNames.put("* Short Min Value", GUIFactory.getString("IDP_INT_MIN_VALUE"));
        m_propertyNames.put("* Short Max Value", GUIFactory.getString("IDP_INT_MAX_VALUE"));
        m_propertyNames.put("* Long Min Value", GUIFactory.getString("IDP_INT_MIN_VALUE"));
        m_propertyNames.put("* Long Max Value", GUIFactory.getString("IDP_INT_MAX_VALUE"));
        m_propertyNames.put("* Float Min Value", GUIFactory.getString("IDP_FLOAT_MIN_VALUE"));
        m_propertyNames.put("* Float Max Value", GUIFactory.getString("IDP_FLOAT_MAX_VALUE"));
        m_propertyNames.put("* Min Length", GUIFactory.getString("IDP_MIN_LENGTH"));
        m_propertyNames.put("* Max Length", GUIFactory.getString("IDP_MAX_LENGTH"));
        m_propertyNames.put("* Class", GUIFactory.getString("IDP_CLASS_NAME"));
        m_propertyNames.put("Flyover Text", GUIFactory.getString("IDP_FLYOVER_TEXT"));
        m_propertyNames.put("Double Click", GUIFactory.getString("IDP_DOUBLE_CLICK"));
        m_propertyNames.put("Selection Mode", GUIFactory.getString("IDP_SELECTION_MODE"));
        m_propertyNames.put("Table Selection Mode", GUIFactory.getString("IDP_SELECTION_MODE"));
        m_propertyNames.put("Placement", GUIFactory.getString("IDP_TAB_PLACEMENT"));
        m_propertyNames.put("Primary", GUIFactory.getString("IDP_PRIMARY_COLUMN"));
        m_propertyNames.put("Manager Class", GUIFactory.getString("IDP_MANAGER_CLASS"));
        m_propertyNames.put("Package", GUIFactory.getString("IDP_PACKAGE_NAME"));
        m_propertyNames.put("Generate Beans", GUIFactory.getString("IDP_GENERATE_BEANS"));
        m_propertyNames.put("Generate Handlers", GUIFactory.getString("IDP_GENERATE_EVENT_HANDLERS"));
        m_propertyNames.put("Serialize", GUIFactory.getString("IDP_SERIALIZE"));
        m_propertyNames.put("Disabled", GUIFactory.getString("IDP_DISABLED"));
        m_propertyNames.put("Show Steps", GUIFactory.getString("IDP_SHOW_STEPS"));
        m_propertyNames.put("* Required", GUIFactory.getString("IDP_FORMAT_REQUIRED"));
        m_propertyNames.put("* H Position", GUIFactory.getString("IDP_ICON_POSITION"));
        m_propertyNames.put("* V Position", GUIFactory.getString("IDP_ICON_VPOSITION"));
        m_propertyNames.put("Base Name", GUIFactory.getString("IDP_BASE_RESOURCE_NAME"));
        m_propertyNames.put("Menu Item Type", GUIFactory.getString("IDP_MENUITEM_TYPE"));
        m_propertyNames.put("Floatable", GUIFactory.getString("IDP_TOOLBAR_FLOATABLE"));
        m_propertyNames.put("Header Alignment", GUIFactory.getString("IDP_HEADER_ALIGNMENT"));
        m_propertyNames.put("Column Alignment", GUIFactory.getString("IDP_COLUMN_ALIGNMENT"));
        m_propertyNames.put("Accelerator", GUIFactory.getString("IDP_ACCELERATOR"));
        m_propertyNames.put("* Key", GUIFactory.getString("IDP_ACCELERATOR_KEY"));
        m_propertyNames.put("* Modifier", GUIFactory.getString("IDP_ACCELERATOR_MODIFIER"));
        m_propertyNames.put("Link Resource", GUIFactory.getString("IDP_RESOURCE"));
        m_propertyNames.put("Link Menu", GUIFactory.getString("IDP_ITEMLINK_MENU"));
        m_propertyNames.put("Link Item", GUIFactory.getString("IDP_NAME"));
        m_propertyNames.put("Wrap", GUIFactory.getString("IDP_WRAP"));
        m_propertyNames.put("Spinner Format", GUIFactory.getString("IDP_FORMAT"));
        m_propertyNames.put("* Int Init Value", GUIFactory.getString("IDP_INT_INITIAL_VALUE"));
        m_propertyNames.put("* Int Incr Value", GUIFactory.getString("IDP_INT_INCREMENT_VALUE"));
        m_propertyNames.put("* Date Init Value", GUIFactory.getString("IDP_DATE_INITIAL_VALUE"));
        m_propertyNames.put("* Date Min Value", GUIFactory.getString("IDP_DATE_MIN_VALUE"));
        m_propertyNames.put("* Date Max Value", GUIFactory.getString("IDP_DATE_MAX_VALUE"));
        m_propertyNames.put("* Date Style", GUIFactory.getString("IDP_DATE_STYLE"));
        m_propertyNames.put("* Date Incr Caret", GUIFactory.getString("IDP_DATE_INCREMENT_CARET"));
        m_propertyNames.put("* Time Init Value", GUIFactory.getString("IDP_TIME_INITIAL_VALUE"));
        m_propertyNames.put("* Time Min Value", GUIFactory.getString("IDP_TIME_MIN_VALUE"));
        m_propertyNames.put("* Time Max Value", GUIFactory.getString("IDP_TIME_MAX_VALUE"));
        m_propertyNames.put("* Time Style", GUIFactory.getString("IDP_TIME_STYLE"));
        m_propertyNames.put("* Time Incr Caret", GUIFactory.getString("IDP_TIME_INCREMENT_CARET"));
        m_propertyNames.put("Toggle Selected", GUIFactory.getString("IDP_TOGGLE_SELECTED"));
        m_propertyNames.put("Renderer", GUIFactory.getString("IDP_RENDERER"));
        m_propertyNames.put("Editor", GUIFactory.getString("IDP_EDITOR"));
        m_propertyNames.put("* Percent Min Fraction", GUIFactory.getString("IDP_PERCENT_MIN_FRACTION_DIGITS"));
        m_propertyNames.put("* Percent Max Fraction", GUIFactory.getString("IDP_PERCENT_MAX_FRACTION_DIGITS"));
        m_propertyNames.put("Scroll", GUIFactory.getString("IDP_PANEL_SCROLL"));
        m_propertyNames.put("Default Menu Item", GUIFactory.getString("IDP_DEFAULT_MENU_ITEM"));
        m_propertyNames.put("Button Group", GUIFactory.getString("IDP_BUTTON_GROUP"));
        m_propertyNames.put("Base Screen Size", GUIFactory.getString("IDP_BASE_SCREEN_SIZE"));
        m_propertyNames.put("Tree Column", GUIFactory.getString("IDP_TREECOLUMN"));
        m_propertyNames.put("Tree Table", GUIFactory.getString("IDP_TREETABLE"));
        m_propertyNames.put("Fill", GUIFactory.getString("IDP_FILL"));
        m_propertyNames.put("Data Type", GUIFactory.getString("IDP_DATATYPE"));
        m_propertyHelp.put("Element", "element");
        m_propertyHelp.put("Name", "name");
        m_propertyHelp.put("Title", "text");
        m_propertyHelp.put("Size", "size");
        m_propertyHelp.put("-> Width", "bounds");
        m_propertyHelp.put("-> Height", "bounds");
        m_propertyHelp.put("Icon", "icon");
        m_propertyHelp.put("Expanded Icon", "expandedicon");
        m_propertyHelp.put("Activate", "activate");
        m_propertyHelp.put("Margins", "margins");
        m_propertyHelp.put("-> Top", "margins");
        m_propertyHelp.put("-> Bottom", "margins");
        m_propertyHelp.put("-> Left", "margins");
        m_propertyHelp.put("-> Right", "margins");
        m_propertyHelp.put("Grid", "grid");
        m_propertyHelp.put("Bounds", "bounds");
        m_propertyHelp.put("-> X", "bounds");
        m_propertyHelp.put("-> Y", "bounds");
        m_propertyHelp.put("Data Class", "dataclass");
        m_propertyHelp.put("Attribute", "attribute");
        m_propertyHelp.put("Label", "label");
        m_propertyHelp.put("Text", "text");
        m_propertyHelp.put("Style", "style");
        m_propertyHelp.put("Action", "action");
        m_propertyHelp.put("Menu Action", "action");
        m_propertyHelp.put("Generate Field Help", "generatefieldhelp");
        m_propertyHelp.put("Generate BG Field Help", "generatefieldhelp");
        m_propertyHelp.put("* Help Alias", "generatefieldhelp");
        m_propertyHelp.put("* Help Link", "generatefieldhelp");
        m_propertyHelp.put("Tooltip", "flyovertext");
        m_propertyHelp.put("Editable", "editable");
        m_propertyHelp.put("Width", "width");
        m_propertyHelp.put("Format", "format");
        m_propertyHelp.put("Locale", "file.locale");
        m_propertyHelp.put("+ Language", "file.locale");
        m_propertyHelp.put("+ Country", "file.locale");
        m_propertyHelp.put("Resource", "file.resource");
        m_propertyHelp.put("File", "file");
        m_propertyHelp.put("Min Value", "minvalue");
        m_propertyHelp.put("Max Value", "maxvalue");
        m_propertyHelp.put("Major Ticks", "majorticks");
        m_propertyHelp.put("Minor Ticks", "minorticks");
        m_propertyHelp.put("Adjust", "adjust");
        m_propertyHelp.put("Multiline", "multiline");
        m_propertyHelp.put("Masked", "masked");
        m_propertyHelp.put("Selected", "selectdeselect");
        m_propertyHelp.put("+ Enable", "selectdeselect");
        m_propertyHelp.put("+ Disable", "selectdeselect");
        m_propertyHelp.put("+ Refresh", "selectdeselect");
        m_propertyHelp.put("+ Show", "selectdeselect");
        m_propertyHelp.put("+ Hide", "selectdeselect");
        m_propertyHelp.put("+ Display", "selectdeselect");
        m_propertyHelp.put("Deselected", "selectdeselect");
        m_propertyHelp.put("- Enable", "selectdeselect");
        m_propertyHelp.put("- Disable", "selectdeselect");
        m_propertyHelp.put("- Refresh", "selectdeselect");
        m_propertyHelp.put("- Show", "selectdeselect");
        m_propertyHelp.put("- Hide", "selectdeselect");
        m_propertyHelp.put("- Display", "selectdeselect");
        m_propertyHelp.put("Version", "file.version");
        m_propertyHelp.put("Orientation", "orientation");
        m_propertyHelp.put("Generate Help", "file.generatehelp");
        m_propertyHelp.put("* Int Min Value", "format");
        m_propertyHelp.put("* Int Max Value", "format");
        m_propertyHelp.put("* Short Min Value", "format");
        m_propertyHelp.put("* Short Max Value", "format");
        m_propertyHelp.put("* Long Min Value", "format");
        m_propertyHelp.put("* Long Max Value", "format");
        m_propertyHelp.put("* Float Min Value", "format");
        m_propertyHelp.put("* Float Max Value", "format");
        m_propertyHelp.put("* Min Length", "format");
        m_propertyHelp.put("* Max Length", "format");
        m_propertyHelp.put("* Class", "format");
        m_propertyHelp.put("Flyover Text", "flyovertext");
        m_propertyHelp.put("Double Click", "doubleclick");
        m_propertyHelp.put("Selection Mode", "selectionmode");
        m_propertyHelp.put("Table Selection Mode", "selectionmode");
        m_propertyHelp.put("Placement", "tabplacement");
        m_propertyHelp.put("Primary", "primarycolumn");
        m_propertyHelp.put("Manager Class", "managerclass");
        m_propertyHelp.put("Package", "file.package");
        m_propertyHelp.put("Generate Beans", "file.generatedatabeans");
        m_propertyHelp.put("Generate Handlers", "file.generateeventhandlers");
        m_propertyHelp.put("Serialize", "file.serialize");
        m_propertyHelp.put("Disabled", "disabled");
        m_propertyHelp.put("Show Steps", "showsteps");
        m_propertyHelp.put("* Required", "format");
        m_propertyHelp.put("* H Position", "icon");
        m_propertyHelp.put("* V Position", "icon");
        m_propertyHelp.put("Base Name", "basename");
        m_propertyHelp.put("Menu Item Type", "type");
        m_propertyHelp.put("Floatable", "floatable");
        m_propertyHelp.put("Header Alignment", "headeralignment");
        m_propertyHelp.put("Column Alignment", "alignment");
        m_propertyHelp.put("Accelerator", "accelerator");
        m_propertyHelp.put("* Key", "accelerator");
        m_propertyHelp.put("* Modifier", "accelerator");
        m_propertyHelp.put("Link Resource", "itemlink");
        m_propertyHelp.put("Link Menu", "menu");
        m_propertyHelp.put("Link Item", "name");
        m_propertyHelp.put("Wrap", "wrap");
        m_propertyHelp.put("Spinner Format", "spinnerformat");
        m_propertyHelp.put("* Int Init Value", "spinnerformat");
        m_propertyHelp.put("* Int Incr Value", "spinnerformat");
        m_propertyHelp.put("* Date Init Value", "spinnerformat");
        m_propertyHelp.put("* Date Min Value", "spinnerformat");
        m_propertyHelp.put("* Date Max Value", "spinnerformat");
        m_propertyHelp.put("* Date Style", "spinnerformat");
        m_propertyHelp.put("* Date Incr Caret", "spinnerformat");
        m_propertyHelp.put("* Time Init Value", "spinnerformat");
        m_propertyHelp.put("* Time Min Value", "spinnerformat");
        m_propertyHelp.put("* Time Max Value", "spinnerformat");
        m_propertyHelp.put("* Time Style", "spinnerformat");
        m_propertyHelp.put("* Time Incr Caret", "spinnerformat");
        m_propertyHelp.put("Toggle Selected", "selected");
        m_propertyHelp.put("Renderer", "renderer");
        m_propertyHelp.put("Editor", "editor");
        m_propertyHelp.put("* Percent Min Fraction", "spinnerformat");
        m_propertyHelp.put("* Percent Max Fraction", "spinnerformat");
        m_propertyHelp.put("Scroll", "scroll");
        m_propertyHelp.put("Default Menu Item", "default");
        m_propertyHelp.put("Button Group", "buttongroup");
        m_propertyHelp.put("Base Screen Size", "basescreensize");
        m_propertyHelp.put("Tree Column", "treecolumn");
        m_propertyHelp.put("Tree Table", "treetable");
        m_propertyHelp.put("Fill", "fill");
        m_propertyHelp.put("Data Type", "datatype");
        m_elementNames.put("PANEL", GUIFactory.getString("IDE_PANEL"));
        m_elementNames.put("LABEL", GUIFactory.getString("IDE_LABEL"));
        m_elementNames.put("GROUPBOX", GUIFactory.getString("IDE_GROUPBOX"));
        m_elementNames.put("TEXTFIELD", GUIFactory.getString("IDE_TEXTFIELD"));
        m_elementNames.put("TEXTAREA", GUIFactory.getString("IDE_TEXTAREA"));
        m_elementNames.put("TEXT", GUIFactory.getString("IDE_TEXT"));
        m_elementNames.put("BUTTON", GUIFactory.getString("IDE_BUTTON"));
        m_elementNames.put("COMBOBOX", GUIFactory.getString("IDE_COMBOBOX"));
        m_elementNames.put("LIST", GUIFactory.getString("IDE_LIST"));
        m_elementNames.put("DECKPANE", GUIFactory.getString("IDE_DECKPANE"));
        m_elementNames.put("SPLITPANE", GUIFactory.getString("IDE_SPLITPANE"));
        m_elementNames.put("TABBEDPANE", GUIFactory.getString("IDE_TABBEDPANE"));
        m_elementNames.put("STRINGTABLE", GUIFactory.getString("IDE_STRINGTABLE"));
        m_elementNames.put("RADIOBUTTON", GUIFactory.getString("IDE_RADIOBUTTON"));
        m_elementNames.put("CHECKBOX", GUIFactory.getString("IDE_CHECKBOX"));
        m_elementNames.put("TABLE", GUIFactory.getString("IDE_TABLE"));
        m_elementNames.put("TREE", GUIFactory.getString("IDE_TREE"));
        m_elementNames.put("PROGRESSBAR", GUIFactory.getString("IDE_PROGRESSBAR"));
        m_elementNames.put("SLIDER", GUIFactory.getString("IDE_SLIDER"));
        m_elementNames.put("IMAGE", GUIFactory.getString("IDE_IMAGE"));
        m_elementNames.put("CUSTOM", GUIFactory.getString("IDE_CUSTOM"));
        m_elementNames.put("BUTTONGROUP", GUIFactory.getString("IDE_BUTTONGROUP"));
        m_elementNames.put("CHOICE", GUIFactory.getString("IDE_CHOICE"));
        m_elementNames.put("ITEM", GUIFactory.getString("IDE_ITEM"));
        m_elementNames.put("COLUMN", GUIFactory.getString("IDE_COLUMN"));
        m_elementNames.put("NODE", GUIFactory.getString("IDE_NODE"));
        m_elementNames.put("ROOT", GUIFactory.getString("IDE_NODE"));
        m_elementNames.put("WIZARD", GUIFactory.getString("IDE_WIZARD"));
        m_elementNames.put("PROPERTYSHEET", GUIFactory.getString("IDE_PROPERTYSHEET"));
        m_elementNames.put("FILE", GUIFactory.getString("IDE_FILE"));
        m_elementNames.put("STRING", GUIFactory.getString("IDE_STRING"));
        m_elementNames.put("MENUITEM", GUIFactory.getString("IDE_MENUITEM"));
        m_elementNames.put("MENU", GUIFactory.getString("IDE_MENU"));
        m_elementNames.put("MENUBAR", GUIFactory.getString("IDE_MENUBAR"));
        m_elementNames.put("TOOLBAR", GUIFactory.getString("IDE_TOOLBAR"));
        m_elementNames.put("SEPARATOR", GUIFactory.getString("IDE_SEPARATOR"));
        m_elementNames.put("ITEMLINK", GUIFactory.getString("IDE_ITEMLINK"));
        m_elementNames.put("SPINNER", GUIFactory.getString("IDE_SPINNER"));
        m_propertyValues.put(Boolean.TRUE, GUIFactory.getString("IDS_TRUE"));
        m_propertyValues.put(Boolean.FALSE, GUIFactory.getString("IDS_FALSE"));
        m_propertyValues.put("true", GUIFactory.getString("IDS_TRUE"));
        m_propertyValues.put("false", GUIFactory.getString("IDS_FALSE"));
        m_propertyValues.put("vertical", GUIFactory.getString("IDS_VERTICAL"));
        m_propertyValues.put("horizontal", GUIFactory.getString("IDS_HORIZONTAL"));
        m_propertyValues.put("List resource bundle", GUIFactory.getString("IDP_LIST_RESOURCE"));
        m_propertyValues.put("Property resource bundle", GUIFactory.getString("IDP_PROPERTY_RESOURCE"));
        m_propertyValues.put("INTEGER", GUIFactory.getString("IDS_FORMAT_INTEGER"));
        m_propertyValues.put("STRING", GUIFactory.getString("IDS_FORMAT_STRING"));
        m_propertyValues.put("SHORT", GUIFactory.getString("IDS_FORMAT_SHORT"));
        m_propertyValues.put("LONG", GUIFactory.getString("IDS_FORMAT_LONG"));
        m_propertyValues.put("FLOAT", GUIFactory.getString("IDS_FORMAT_FLOAT"));
        m_propertyValues.put("PERCENT", GUIFactory.getString("IDS_FORMAT_PERCENT"));
        m_propertyValues.put("DATE", GUIFactory.getString("IDS_FORMAT_DATE"));
        m_propertyValues.put("TIME", GUIFactory.getString("IDS_FORMAT_TIME"));
        m_propertyValues.put("INTERNET_ADDRESS", GUIFactory.getString("IDS_FORMAT_INTERNET_ADDRESS"));
        m_propertyValues.put("CLASS", GUIFactory.getString("IDS_FORMAT_CLASS"));
        m_propertyValues.put("DEFAULT", GUIFactory.getString("IDS_DEFAULT_STYLE"));
        m_propertyValues.put("multiinterval", GUIFactory.getString("IDS_MULTIINTERVAL_SELECT"));
        m_propertyValues.put("singleinterval", GUIFactory.getString("IDS_SINGLEINTERVAL_SELECT"));
        m_propertyValues.put("single", GUIFactory.getString("IDS_SINGLE_SELECT"));
        m_propertyValues.put("bottom", GUIFactory.getString("IDS_BOTTOM"));
        m_propertyValues.put("left", GUIFactory.getString("IDS_LEFT"));
        m_propertyValues.put("right", GUIFactory.getString("IDS_RIGHT"));
        m_propertyValues.put("top", GUIFactory.getString("IDS_TOP"));
        m_propertyValues.put("center", GUIFactory.getString("IDS_CENTER"));
        m_propertyValues.put("@NONE", GUIFactory.getString("IDS_NONE"));
        m_propertyValues.put("@BASE", GUIFactory.getString("IDS_LOCALE_BASE"));
        m_propertyValues.put("COMMIT", GUIFactory.getString("IDS_ACTION_COMMIT"));
        m_propertyValues.put("CANCEL", GUIFactory.getString("IDS_ACTION_CANCEL"));
        m_propertyValues.put("HELP", GUIFactory.getString("IDS_ACTION_HELP"));
        m_propertyValues.put("CONTEXTHELP", GUIFactory.getString("IDS_ACTION_CONTEXT_HELP"));
        m_propertyValues.put("menuitem", GUIFactory.getString("IDS_MENUITEM_ITEM"));
        m_propertyValues.put("check", GUIFactory.getString("IDS_MENUITEM_CHECKBOX"));
        m_propertyValues.put("radio", GUIFactory.getString("IDS_MENUITEM_RADIOBUTTON"));
        m_propertyValues.put("separator", GUIFactory.getString("IDS_MENUITEM_SEPARATOR"));
        m_propertyValues.put("submenu", GUIFactory.getString("IDS_MENUITEM_SUBMENU"));
        m_propertyValues.put("itemlink", GUIFactory.getString("IDS_MENUITEM_ITEMLINK"));
        m_propertyValues.put("ESC", GUIFactory.getString("IDS_ACCELERATOR_KEY_ESCAPE"));
        m_propertyValues.put("F1", GUIFactory.getString("IDS_ACCELERATOR_KEY_F1"));
        m_propertyValues.put("F2", GUIFactory.getString("IDS_ACCELERATOR_KEY_F2"));
        m_propertyValues.put("F3", GUIFactory.getString("IDS_ACCELERATOR_KEY_F3"));
        m_propertyValues.put("F4", GUIFactory.getString("IDS_ACCELERATOR_KEY_F4"));
        m_propertyValues.put("F5", GUIFactory.getString("IDS_ACCELERATOR_KEY_F5"));
        m_propertyValues.put("F6", GUIFactory.getString("IDS_ACCELERATOR_KEY_F6"));
        m_propertyValues.put("F7", GUIFactory.getString("IDS_ACCELERATOR_KEY_F7"));
        m_propertyValues.put("F8", GUIFactory.getString("IDS_ACCELERATOR_KEY_F8"));
        m_propertyValues.put("F9", GUIFactory.getString("IDS_ACCELERATOR_KEY_F9"));
        m_propertyValues.put("F10", GUIFactory.getString("IDS_ACCELERATOR_KEY_F10"));
        m_propertyValues.put("F11", GUIFactory.getString("IDS_ACCELERATOR_KEY_F11"));
        m_propertyValues.put("F12", GUIFactory.getString("IDS_ACCELERATOR_KEY_F12"));
        m_propertyValues.put("PAUSE", GUIFactory.getString("IDS_ACCELERATOR_KEY_PAUSE"));
        m_propertyValues.put("TAB", GUIFactory.getString("IDS_ACCELERATOR_KEY_TAB"));
        m_propertyValues.put("BACKSPACE", GUIFactory.getString("IDS_ACCELERATOR_KEY_BACKSPACE"));
        m_propertyValues.put("ENTER", GUIFactory.getString("IDS_ACCELERATOR_KEY_ENTER"));
        m_propertyValues.put("INSERT", GUIFactory.getString("IDS_ACCELERATOR_KEY_INSERT"));
        m_propertyValues.put("DELETE", GUIFactory.getString("IDS_ACCELERATOR_KEY_DELETE"));
        m_propertyValues.put("HOME", GUIFactory.getString("IDS_ACCELERATOR_KEY_HOME"));
        m_propertyValues.put("END", GUIFactory.getString("IDS_ACCELERATOR_KEY_END"));
        m_propertyValues.put("PAGEUP", GUIFactory.getString("IDS_ACCELERATOR_KEY_PAGEUP"));
        m_propertyValues.put("PAGEDOWN", GUIFactory.getString("IDS_ACCELERATOR_KEY_PAGEDOWN"));
        m_propertyValues.put("UP", GUIFactory.getString("IDS_ACCELERATOR_KEY_UP"));
        m_propertyValues.put("DOWN", GUIFactory.getString("IDS_ACCELERATOR_KEY_DOWN"));
        m_propertyValues.put("LEFT", GUIFactory.getString("IDS_ACCELERATOR_KEY_LEFT"));
        m_propertyValues.put("RIGHT", GUIFactory.getString("IDS_ACCELERATOR_KEY_RIGHT"));
        m_propertyValues.put("none", GUIFactory.getString("IDS_ACCELERATOR_MODIFIER_NONE"));
        m_propertyValues.put("ctrl", GUIFactory.getString("IDS_ACCELERATOR_MODIFIER_CTRL"));
        m_propertyValues.put("alt", GUIFactory.getString("IDS_ACCELERATOR_MODIFIER_ALT"));
        m_propertyValues.put("shift", GUIFactory.getString("IDS_ACCELERATOR_MODIFIER_SHIFT"));
        m_propertyValues.put("ctrl-alt", GUIFactory.getString("IDS_ACCELERATOR_MODIFIER_CTRL_ALT"));
        m_propertyValues.put("ctrl-shift", GUIFactory.getString("IDS_ACCELERATOR_MODIFIER_CTRL_SHIFT"));
        m_propertyValues.put("alt-shift", GUIFactory.getString("IDS_ACCELERATOR_MODIFIER_ALT_SHIFT"));
        m_propertyValues.put("ctrl-alt-shift", GUIFactory.getString("IDS_ACCELERATOR_MODIFIER_CTRL_ALT_SHIFT"));
        m_propertyValues.put("alias", GUIFactory.getString("IDS_HELP_ALIAS"));
        m_propertyValues.put("style short", GUIFactory.getString("IDS_STYLE_SHORT"));
        m_propertyValues.put("style medium", GUIFactory.getString("IDS_STYLE_MEDIUM"));
        m_propertyValues.put("style long", GUIFactory.getString("IDS_STYLE_LONG"));
        m_propertyValues.put("style full", GUIFactory.getString("IDS_STYLE_FULL"));
        m_propertyValues.put("caret year", GUIFactory.getString("IDS_CARET_YEAR"));
        m_propertyValues.put("caret month", GUIFactory.getString("IDS_CARET_MONTH"));
        m_propertyValues.put("caret date", GUIFactory.getString("IDS_CARET_DATE"));
        m_propertyValues.put("caret hour", GUIFactory.getString("IDS_CARET_HOUR"));
        m_propertyValues.put("caret minute", GUIFactory.getString("IDS_CARET_MINUTE"));
        m_propertyValues.put("caret second", GUIFactory.getString("IDS_CARET_SECOND"));
        m_propertyValues.put("640x480", GUIFactory.getString("640 x 480"));
        m_propertyValues.put("800x600", GUIFactory.getString("800 x 600"));
        m_propertyValues.put("1024x768", GUIFactory.getString("1024 x 768"));
        m_propertyValues.put("1280x1024", GUIFactory.getString("1280 x 1024"));
        m_propertyValues.put("1600x1200", GUIFactory.getString("1600 x 1200"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.as400.ui.tools.xmlviewerpanels");
        String[] stringArray = m_languageCodes;
        String[][] stringArray2 = new String[stringArray.length][2];
        StringTableProperties stringTableProperties = new StringTableProperties();
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n][0] = string = stringArray[n];
            try {
                stringArray2[n][1] = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                stringArray2[n][1] = stringArray[n];
            }
            stringTableEntry = new StringTableEntry(null, stringArray2[n][0], stringArray2[n][1]);
            stringTableProperties.add(stringTableEntry);
            m_propertyValues.put(stringArray2[n][0], stringArray2[n][1]);
            ++n;
        }
        stringTableProperties.sortEntries(false, true);
        m_languages = new String[stringArray.length];
        int n2 = 0;
        Enumeration<TreeNode> enumeration = stringTableProperties.children();
        while (enumeration.hasMoreElements()) {
            stringTableEntry = (StringTableEntry)enumeration.nextElement();
            GUIFactory.m_languages[n2] = (String)stringTableEntry.getProperty("Name");
            ++n2;
        }
        stringArray = m_countryCodes;
        stringArray2 = new String[stringArray.length][2];
        stringTableProperties = new StringTableProperties();
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray2[n3][0] = string = stringArray[n3];
            try {
                stringArray2[n3][1] = resourceBundle.getString("c_" + string);
            }
            catch (MissingResourceException missingResourceException) {
                stringArray2[n3][1] = stringArray[n3];
            }
            stringTableEntry = new StringTableEntry(null, stringArray2[n3][0], stringArray2[n3][1]);
            stringTableProperties.add(stringTableEntry);
            m_propertyValues.put(stringArray2[n3][0], stringArray2[n3][1]);
            ++n3;
        }
        stringTableProperties.sortEntries(false, true);
        m_countries = new String[stringArray.length];
        n2 = 0;
        Enumeration<TreeNode> enumeration2 = stringTableProperties.children();
        while (enumeration2.hasMoreElements()) {
            stringTableEntry = (StringTableEntry)enumeration2.nextElement();
            GUIFactory.m_countries[n2] = (String)stringTableEntry.getProperty("Name");
            ++n2;
        }
    }
}

