/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.MenuItemDescriptor;
import com.ibm.as400.ui.framework.MessageLog;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DeckPaneManager;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DividerPanel;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.HelpViewer;
import com.ibm.as400.ui.framework.java.MenuManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.PropertySheetManager;
import com.ibm.as400.ui.framework.java.SplitPaneManager;
import com.ibm.as400.ui.framework.java.TabbedPaneManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import com.ibm.as400.ui.framework.java.WizardManager;
import com.ibm.as400.ui.tools.AboutDialog;
import com.ibm.as400.ui.tools.BuilderFrame;
import com.ibm.as400.ui.tools.DeckPaneBuilder;
import com.ibm.as400.ui.tools.DeckPaneProperties;
import com.ibm.as400.ui.tools.FileBuilder;
import com.ibm.as400.ui.tools.FileProperties;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.ListBuilder;
import com.ibm.as400.ui.tools.LoopDialog;
import com.ibm.as400.ui.tools.MenuBarBorder;
import com.ibm.as400.ui.tools.MenuBarBuilder;
import com.ibm.as400.ui.tools.MenuBarProperties;
import com.ibm.as400.ui.tools.MenuBuilder;
import com.ibm.as400.ui.tools.MenuProperties;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.OptionsDialogBean;
import com.ibm.as400.ui.tools.PaneProperties;
import com.ibm.as400.ui.tools.PanelBuilder;
import com.ibm.as400.ui.tools.PanelProperties;
import com.ibm.as400.ui.tools.PopupListener;
import com.ibm.as400.ui.tools.PropertyDialog;
import com.ibm.as400.ui.tools.PropertySheetBuilder;
import com.ibm.as400.ui.tools.PropertySheetProperties;
import com.ibm.as400.ui.tools.PulldownProperties;
import com.ibm.as400.ui.tools.RC2XML;
import com.ibm.as400.ui.tools.SelectionEvent;
import com.ibm.as400.ui.tools.SelectionListener;
import com.ibm.as400.ui.tools.ShowPaneHandler;
import com.ibm.as400.ui.tools.SplitPaneBuilder;
import com.ibm.as400.ui.tools.SplitPaneProperties;
import com.ibm.as400.ui.tools.StringTableBuilder;
import com.ibm.as400.ui.tools.StringTableProperties;
import com.ibm.as400.ui.tools.TabbedPaneBuilder;
import com.ibm.as400.ui.tools.TabbedPaneProperties;
import com.ibm.as400.ui.tools.TableBuilder;
import com.ibm.as400.ui.tools.TableProperties;
import com.ibm.as400.ui.tools.ToolBarBuilder;
import com.ibm.as400.ui.tools.ToolBarProperties;
import com.ibm.as400.ui.tools.ToolMenuBuilder;
import com.ibm.as400.ui.tools.ToolsFileChooser;
import com.ibm.as400.ui.tools.ToolsFileFilter;
import com.ibm.as400.ui.tools.TreeBuilder;
import com.ibm.as400.ui.tools.TreeProperties;
import com.ibm.as400.ui.tools.ValidationDialog;
import com.ibm.as400.ui.tools.ViewManager;
import com.ibm.as400.ui.tools.WizardBuilder;
import com.ibm.as400.ui.tools.WizardProperties;
import com.ibm.as400.ui.tools.XMLGUIBuilderDefinition;
import com.ibm.as400.ui.tools.XMLGUIDefinition;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.TreeNode;

class GUIBuilder
extends JFrame {
    boolean m_translationMode = false;
    static boolean m_msysMode = false;
    static final String m_tempBaseName = "guitemp";
    HelpViewer m_helpViewer = null;
    static final String m_helpBase = "com.ibm.as400.ui.tools/guibuilderpanels/";
    JMenuBar m_menubar;
    JToolBar m_toolbar;
    PropertyDialog m_propertyDialog;
    PropertySheetManager m_optionsDialog;
    AboutDialog m_splash;
    ValidationDialog m_validationDialog;
    int m_splashCount;
    OptionsDialogBean m_optionsBean;
    GUISelectionListener m_selectionListener;
    GUIWindowListener m_windowListener;
    GUIToolListener m_toolListener;
    Hashtable m_viewManagers;
    BuilderFrame m_activeEditor;
    Clipboard m_clipboard;
    Point m_ptCascade;
    int m_newFileCount = 0;
    String m_lastDirectory;
    Vector m_MRU;
    int m_MRUSize;
    Dimension m_panelGrid = new Dimension(20, 20);
    Insets m_panelMargins = new Insets(20, 20, 20, 20);
    boolean m_panelDefaultButtons = true;
    int m_scaledFontSize = 12;
    Font m_scaledFont;
    double m_xScalingFactor = 1.0;
    double m_yScalingFactor = 1.0;
    boolean m_scaledResolution = false;
    Dimension m_initScreenSize;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    GUIBuilder() {
    }

    void setTranslationMode(boolean bl) {
        this.m_translationMode = bl;
    }

    boolean isTranslationMode() {
        return this.m_translationMode;
    }

    static void setMSYSMode(boolean bl) {
        m_msysMode = bl;
    }

    static boolean isMSYSMode() {
        return m_msysMode;
    }

    Clipboard getClipboard() {
        return this.m_clipboard;
    }

    Font getScaledFont() {
        return this.m_scaledFont;
    }

    Dimension getPanelGrid() {
        return this.m_panelGrid;
    }

    void setPanelGrid(Dimension dimension) {
        this.m_panelGrid = dimension;
    }

    Insets getPanelMargins() {
        return this.m_panelMargins;
    }

    void setPanelMargins(Insets insets) {
        this.m_panelMargins = insets;
    }

    String getLastDirectory() {
        return this.m_lastDirectory;
    }

    void setLastDirectory(String string) {
        this.m_lastDirectory = string;
    }

    void updateSplash(int n) {
        if (this.m_splash != null) {
            this.m_splashCount += n;
            this.m_splash.setProgress(this.m_splashCount);
        }
    }

    void init() {
        Dimension dimension;
        ((Frame)this).setIconImage(GUIFactory.getImage("GUIBuilder.gif", true).getImage());
        this.m_splashCount = 0;
        this.m_splash = new AboutDialog(this, false, true, GUIFactory.getString("IDS_LOADING_GUIBUILDER"), 80);
        this.m_toolListener = new GUIToolListener();
        this.m_selectionListener = new GUISelectionListener();
        this.m_windowListener = new GUIWindowListener(this);
        this.m_viewManagers = new Hashtable();
        this.m_clipboard = new Clipboard("GUIBuilder");
        this.addKeyListener(new GUIKeyListener());
        this.m_activeEditor = null;
        this.m_lastDirectory = System.getProperty("user.dir");
        this.m_ptCascade = new Point(0, 0);
        this.updateSplash(10);
        this.initMenuBar();
        this.updateSplash(10);
        this.initToolBar();
        this.updateSplash(10);
        this.m_validationDialog = new ValidationDialog(this);
        this.updateSplash(10);
        this.m_propertyDialog = new PropertyDialog(this);
        this.m_propertyDialog.addWindowListener(this.m_windowListener);
        this.addWindowListener(this.m_windowListener);
        this.setDefaultCloseOperation(0);
        this.setTitle(GUIFactory.getString("IDS_MAIN_TITLEBAR"));
        this.setJMenuBar(this.m_menubar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_toolbar, "North");
        this.updateSplash(10);
        this.m_optionsBean = new OptionsDialogBean(this);
        this.m_optionsBean.load();
        Rectangle rectangle = this.m_optionsBean.getPropertyDialogBounds();
        this.m_MRU = this.m_optionsBean.getMRU();
        this.m_MRUSize = this.m_optionsBean.getMRUSize();
        this.updateMRU();
        this.updateSplash(10);
        this.pack();
        Dimension dimension2 = this.getSize();
        if (dimension2.width < 200) {
            dimension2.width = 200;
        }
        ((Component)this).setSize(dimension2);
        this.show();
        this.m_initScreenSize = dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = this.getLocation();
        if (rectangle == null) {
            ((Component)this.m_propertyDialog).setSize(400, 400);
            point.x = 0;
            if (point.y < dimension.height - 450) {
                point.y = dimension.height - 450;
            }
            ((Component)this.m_propertyDialog).setLocation(point);
        } else {
            if (rectangle.x + rectangle.width > dimension.width) {
                rectangle.x = dimension.width - rectangle.width;
            }
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.y + rectangle.height > dimension.height) {
                rectangle.y = dimension.height - rectangle.height;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            ((Component)this.m_propertyDialog).setBounds(rectangle);
        }
        this.m_propertyDialog.show();
        XMLGUIDefinition.setInitialScreenSize(dimension);
        this.m_xScalingFactor = (double)dimension.width / 1280.0;
        this.m_yScalingFactor = (double)dimension.height / 1024.0;
        this.m_scaledResolution = this.m_xScalingFactor != 1.0 || this.m_yScalingFactor != 1.0;
        int[] nArray = new int[]{640, 800, 1024, 1280, 1600};
        int[] nArray2 = new int[]{480, 600, 768, 1024, 1200};
        int[] nArray3 = new int[]{9, 11, 12, 12, 14};
        int n = 0;
        while (n < nArray.length) {
            if (dimension.width == nArray[n] && dimension.height == nArray2[n]) {
                this.m_scaledFontSize = nArray3[n];
                break;
            }
            ++n;
        }
        Font font = this.getFont();
        this.m_scaledFontSize = 12;
        this.m_scaledFont = new Font(font.getName(), font.getStyle(), this.m_scaledFontSize);
        this.requestFocus();
        this.m_splash.dispose();
        this.m_splash = null;
        if (!this.m_optionsBean.loadedCompilerConfiguration()) {
            this.doOptionsDialog();
        }
    }

    void initMenuBar() {
        this.m_menubar = new JMenuBar();
        GUIToolListener gUIToolListener = this.m_toolListener;
        JMenu jMenu = this.m_menubar.add(GUIFactory.createMenu(null, "IDM_FILE", null, true));
        jMenu.add(GUIFactory.createMenuItem("File New", null, "IDM_FILE_NEW", "New.gif", !this.isTranslationMode(), KeyStroke.getKeyStroke(78, 2), gUIToolListener));
        jMenu.add(GUIFactory.createMenuItem("File Open", null, "IDM_FILE_OPEN", "Open.gif", true, KeyStroke.getKeyStroke(79, 2), gUIToolListener));
        jMenu.add(GUIFactory.createMenuItem("File Close", null, "IDM_FILE_CLOSE", "Close.gif", false, gUIToolListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("File Save", null, "IDM_FILE_SAVE", "Save.gif", false, KeyStroke.getKeyStroke(83, 2), gUIToolListener));
        jMenu.add(GUIFactory.createMenuItem("File SaveAs", null, "IDM_FILE_SAVE_AS", "SaveAs.gif", false, gUIToolListener));
        jMenu.add(GUIFactory.createMenuItem("File SaveAll", null, "IDM_FILE_SAVE_ALL", "SaveAll.gif", false, gUIToolListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("File Exit", null, "IDM_FILE_EXIT", "Exit.gif", true, gUIToolListener));
        jMenu = this.m_menubar.add(GUIFactory.createMenu(null, "IDM_EDIT", null, true));
        jMenu.add(GUIFactory.createMenuItem("Edit Undo", null, "IDM_EDIT_UNDO", "Undo.gif", false, gUIToolListener));
        jMenu.add(GUIFactory.createMenuItem("Edit Redo", null, "IDM_EDIT_REDO", "Redo.gif", false, gUIToolListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDM_EDIT_CUT", "Cut.gif", false, KeyStroke.getKeyStroke(88, 2), gUIToolListener));
        jMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDM_EDIT_COPY", "Copy.gif", false, KeyStroke.getKeyStroke(67, 2), gUIToolListener));
        jMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDM_EDIT_PASTE", "Paste.gif", false, KeyStroke.getKeyStroke(86, 2), gUIToolListener));
        jMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDM_EDIT_DELETE", "Remove.gif", false, KeyStroke.getKeyStroke(127, 0), gUIToolListener));
        this.m_menubar.remove(1);
        jMenu = this.m_menubar.add(GUIFactory.createMenu(null, "IDM_VIEW", null, true));
        jMenu.add(GUIFactory.createCheckBoxMenuItem("View Properties", null, "IDM_VIEW_PROPERTIES", null, true, false, gUIToolListener));
        ((JMenuItem)jMenu.getMenuComponent(0)).setAccelerator(KeyStroke.getKeyStroke(115, 0));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("View Options", null, "IDM_VIEW_OPTIONS", null, true, gUIToolListener));
        jMenu = this.m_menubar.add(GUIFactory.createMenu(null, "IDM_HELP", null, true));
        jMenu.add(GUIFactory.createMenuItem("Help Topics", null, "IDM_HELP_TOPICS", "Help.gif", true, KeyStroke.getKeyStroke(112, 0), gUIToolListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Help About", null, "IDM_HELP_ABOUT", "GUIBuilder.gif", true, gUIToolListener));
    }

    void initToolBar() {
        this.m_toolbar = new JToolBar();
        this.m_toolbar.setFloatable(false);
        this.m_toolbar.setBorderPainted(false);
        GUIToolListener gUIToolListener = this.m_toolListener;
        this.m_toolbar.add(GUIFactory.createButton("File New", null, null, "New.gif", "IDTT_NEW_FILE", !this.isTranslationMode(), gUIToolListener));
        this.m_toolbar.add(GUIFactory.createButton("File Open", null, null, "Open.gif", "IDTT_OPEN_FILE", true, gUIToolListener));
        this.m_toolbar.add(GUIFactory.createButton("File Save", null, null, "Save.gif", "IDTT_SAVE_FILE", false, gUIToolListener));
        this.m_toolbar.add(GUIFactory.createButton("File SaveAll", null, null, "SaveAll.gif", "IDTT_SAVE_ALL_FILES", false, gUIToolListener));
    }

    void createEditor(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, MutableProperties mutableProperties) {
        BuilderFrame builderFrame = null;
        int n = mutableProperties.getType();
        switch (n) {
            case 126: {
                builderFrame = new FileBuilder(this, xMLGUIBuilderDefinition, (FileProperties)mutableProperties);
                break;
            }
            case 120: {
                if (this.isTranslationMode()) break;
                builderFrame = new PropertySheetBuilder(this, xMLGUIBuilderDefinition, (PropertySheetProperties)mutableProperties);
                break;
            }
            case 60: {
                if (this.isTranslationMode()) break;
                builderFrame = new DeckPaneBuilder(this, xMLGUIBuilderDefinition, (DeckPaneProperties)mutableProperties);
                break;
            }
            case 61: {
                if (this.isTranslationMode()) break;
                builderFrame = new SplitPaneBuilder(this, xMLGUIBuilderDefinition, (SplitPaneProperties)mutableProperties);
                break;
            }
            case 62: {
                if (this.isTranslationMode()) break;
                builderFrame = new TabbedPaneBuilder(this, xMLGUIBuilderDefinition, (TabbedPaneProperties)mutableProperties);
                break;
            }
            case 121: {
                if (this.isTranslationMode()) break;
                builderFrame = new WizardBuilder(this, xMLGUIBuilderDefinition, (WizardProperties)mutableProperties);
                break;
            }
            case 1: {
                builderFrame = new PanelBuilder(this, xMLGUIBuilderDefinition, (PanelProperties)mutableProperties);
                break;
            }
            case 51: {
                if (this.isTranslationMode()) break;
                MenuProperties menuProperties = (MenuProperties)mutableProperties;
                if (menuProperties.getProperty("Type").equals("toolbar")) {
                    builderFrame = new ToolMenuBuilder(this, xMLGUIBuilderDefinition, menuProperties);
                    break;
                }
                builderFrame = new MenuBuilder(this, xMLGUIBuilderDefinition, menuProperties);
                break;
            }
            case 80: {
                if (this.isTranslationMode()) break;
                builderFrame = new StringTableBuilder(this, xMLGUIBuilderDefinition, (StringTableProperties)mutableProperties);
                break;
            }
            case 50: {
                if (this.isTranslationMode()) break;
                builderFrame = new MenuBarBuilder(this, xMLGUIBuilderDefinition, (MenuBarProperties)mutableProperties);
                break;
            }
            case 55: {
                if (this.isTranslationMode()) break;
                builderFrame = new ToolBarBuilder(this, xMLGUIBuilderDefinition, (ToolBarProperties)mutableProperties);
                break;
            }
            case 8: 
            case 9: {
                if (this.isTranslationMode()) break;
                builderFrame = new ListBuilder(this, xMLGUIBuilderDefinition, mutableProperties);
                break;
            }
            case 103: {
                if (this.isTranslationMode()) break;
                builderFrame = new TableBuilder(this, xMLGUIBuilderDefinition, (TableProperties)mutableProperties);
                break;
            }
            case 104: {
                if (this.isTranslationMode()) break;
                builderFrame = new TreeBuilder(this, xMLGUIBuilderDefinition, (TreeProperties)mutableProperties);
            }
        }
        if (builderFrame != null) {
            Cloneable cloneable;
            Object object;
            ViewManager viewManager = (ViewManager)this.m_viewManagers.get(xMLGUIBuilderDefinition);
            if (viewManager == null) {
                viewManager = new ViewManager(this, xMLGUIBuilderDefinition);
                this.m_viewManagers.put(xMLGUIBuilderDefinition, viewManager);
            }
            viewManager.setEditor(mutableProperties, builderFrame);
            builderFrame.setDefaultCloseOperation(0);
            builderFrame.addWindowListener(this.m_windowListener);
            String string = "";
            int[] nArray = new int[4];
            boolean bl = false;
            if (mutableProperties.hasProperty("EditorBounds")) {
                string = (String)mutableProperties.getProperty("EditorBounds");
                object = new StringTokenizer(string, ",");
                try {
                    int n2 = 0;
                    while (n2 < 4) {
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            nArray[n2] = Integer.parseInt(((StringTokenizer)object).nextToken());
                            bl = n2 == 3;
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            object = Toolkit.getDefaultToolkit().getScreenSize();
            if (bl) {
                Rectangle rectangle = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
                cloneable = new Rectangle(0, 0, ((Dimension)object).width, ((Dimension)object).height);
                bl = rectangle.intersects((Rectangle)cloneable);
                if (bl) {
                    if (nArray[0] + nArray[2] > ((Rectangle)cloneable).width) {
                        nArray[0] = ((Rectangle)cloneable).width - nArray[2];
                    }
                    if (nArray[0] < 0) {
                        nArray[0] = 0;
                    }
                    if (nArray[1] + nArray[3] > ((Rectangle)cloneable).height) {
                        nArray[1] = ((Rectangle)cloneable).height - nArray[3];
                    }
                    if (nArray[1] < 0) {
                        nArray[1] = 0;
                    }
                }
                if (nArray[2] > 20 && nArray[3] > 20) {
                    ((Component)builderFrame).setSize(nArray[2], nArray[3]);
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                Dimension dimension = this.getSize();
                dimension.width = 0;
                cloneable = builderFrame.getSize();
                Point point = new Point(dimension.width + this.m_ptCascade.x, dimension.height + this.m_ptCascade.y);
                if (point.x + cloneable.width > ((Dimension)object).width || point.y + cloneable.height > ((Dimension)object).height) {
                    point.x = dimension.width;
                    point.y = dimension.height;
                    this.m_ptCascade.x = 0;
                    this.m_ptCascade.y = 0;
                }
                this.m_ptCascade.x += 25;
                this.m_ptCascade.y += 25;
                ((Component)builderFrame).setLocation(point.x, point.y);
            } else {
                ((Component)builderFrame).setSize(nArray[2], nArray[3]);
                ((Component)builderFrame).setLocation(nArray[0], nArray[1]);
            }
            builderFrame.show();
            builderFrame.updateBuilder();
        }
    }

    void showEditor(MutableProperties mutableProperties) {
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = mutableProperties.getPDMLDocument();
        if (xMLGUIBuilderDefinition != null) {
            BuilderFrame builderFrame = null;
            ViewManager viewManager = (ViewManager)this.m_viewManagers.get(xMLGUIBuilderDefinition);
            if (viewManager != null) {
                builderFrame = viewManager.getEditor(mutableProperties);
            }
            if (builderFrame != null) {
                builderFrame.show();
                builderFrame.requestFocus();
            } else {
                this.createEditor(xMLGUIBuilderDefinition, mutableProperties);
            }
        }
    }

    BuilderFrame getEditor(MutableProperties mutableProperties) {
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = mutableProperties.getPDMLDocument();
        if (xMLGUIBuilderDefinition != null) {
            Object var3_3 = null;
            ViewManager viewManager = (ViewManager)this.m_viewManagers.get(xMLGUIBuilderDefinition);
            if (viewManager != null) {
                return viewManager.getEditor(mutableProperties);
            }
        }
        return null;
    }

    void removeEditor(BuilderFrame builderFrame) {
        if (builderFrame != null) {
            builderFrame.dispose();
            builderFrame.removeWindowListener(this.m_windowListener);
        }
    }

    void doNew() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = new XMLGUIBuilderDefinition();
        ++this.m_newFileCount;
        String string = GUIFactory.getString("IDP_FILE") + this.m_newFileCount;
        String string2 = this.m_initScreenSize.width + "x" + this.m_initScreenSize.height;
        try {
            xMLGUIBuilderDefinition.getPDMLRoot().setProperty("Base Name", string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.showEditor(xMLGUIBuilderDefinition.getPDMLRoot());
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void doOpen() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String[] stringArray = new String[]{".pdml", ".pdmlsrc"};
        ToolsFileFilter toolsFileFilter = new ToolsFileFilter(stringArray, GUIFactory.getString("IDS_FILE_FILTER_PDML"));
        String[] stringArray2 = new String[]{".rc"};
        ToolsFileFilter toolsFileFilter2 = new ToolsFileFilter(stringArray2, GUIFactory.getString("IDS_FILE_FILTER_RC"));
        ToolsFileChooser toolsFileChooser = new ToolsFileChooser(this.m_lastDirectory);
        toolsFileChooser.addChoosableFileFilter(toolsFileFilter);
        toolsFileChooser.addChoosableFileFilter(toolsFileFilter2);
        toolsFileChooser.setFileFilter(toolsFileFilter);
        toolsFileChooser.setDialogTitle(GUIFactory.getString("IDS_OPEN_TITLEBAR"));
        toolsFileChooser.setMultiSelectionEnabled(false);
        int n = toolsFileChooser.showOpenDialog(this);
        this.repaint();
        if (n == 0) {
            File file = toolsFileChooser.getSelectedFile();
            String string = file.getPath();
            boolean bl = true;
            if (string.toLowerCase().endsWith(".rc")) {
                String string2 = string.substring(0, string.lastIndexOf(46));
                try {
                    RC2XML.convert(file.getPath(), string2 + ".pdml", string2 + ".properties", null, null, null);
                    file = new File(string2 + ".pdml");
                }
                catch (Exception exception) {
                    this.displayGeneralException(exception);
                    file = null;
                }
            }
            if (file != null) {
                this.doOpenFileBuilder(file);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void doOpenFileBuilder(File file) {
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = null;
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            if (file.getPath().equals(xMLGUIBuilderDefinition.getPDMLRoot().getProperty("File Name"))) break;
            xMLGUIBuilderDefinition = null;
        }
        if (xMLGUIBuilderDefinition != null) {
            this.showEditor(xMLGUIBuilderDefinition.getPDMLRoot());
        } else {
            String string = file.getPath();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            File file2 = new File(string + ".class");
            File file3 = new File(string + ".java");
            if (file2.exists() && file3.exists()) {
                long l = file2.lastModified();
                long l2 = file3.lastModified();
                if (l2 > l && !this.doCheckCompiler()) {
                    return;
                }
            } else if (file3.exists() && !this.doCheckCompiler()) {
                return;
            }
            try {
                xMLGUIBuilderDefinition = new XMLGUIBuilderDefinition(file.getPath(), true);
                this.showEditor(xMLGUIBuilderDefinition.getPDMLRoot());
                this.addMRU(file.getPath());
            }
            catch (ParseException parseException) {
                this.displayParseException((Exception)((Object)parseException), true);
            }
            catch (PDMLSpecificationException pDMLSpecificationException) {
                this.displayParseException((Exception)((Object)pDMLSpecificationException), false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this, fileNotFoundException.getLocalizedMessage(), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
            }
            catch (MissingResourceException missingResourceException) {
                JOptionPane.showMessageDialog(this, missingResourceException.getLocalizedMessage(), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
            }
            catch (Throwable throwable) {
                this.displayGeneralException(throwable);
            }
        }
    }

    int doSave(boolean bl) {
        if (this.m_activeEditor == null) {
            return 0;
        }
        return this.doSave(this.m_activeEditor.getPDMLDocument(), bl);
    }

    int doSave(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (xMLGUIBuilderDefinition == null || !xMLGUIBuilderDefinition.isModified() && !bl) {
            return 0;
        }
        ViewManager viewManager = (ViewManager)this.m_viewManagers.get(xMLGUIBuilderDefinition);
        viewManager.updateAllEditorBounds();
        BuilderFrame builderFrame = viewManager.getEditor(xMLGUIBuilderDefinition.getPDMLRoot());
        LoopDialog loopDialog = new LoopDialog(xMLGUIBuilderDefinition.getPDMLRoot(), this, builderFrame);
        if (loopDialog.findLoops()) {
            return 2;
        }
        if (!this.m_validationDialog.validatePDMLDocument(xMLGUIBuilderDefinition, null)) {
            this.m_validationDialog.show();
            return 2;
        }
        this.m_validationDialog.dispose();
        final FileProperties fileProperties = xMLGUIBuilderDefinition.getPDMLRoot();
        String string = (String)fileProperties.getProperty("File Name");
        if ((fileProperties.getProperty("Resource").equals("List resource bundle") || fileProperties.getProperty("Generate Beans").equals(Boolean.TRUE) || fileProperties.getProperty("Generate Handlers").equals(Boolean.TRUE)) && !this.doCheckCompiler()) {
            return 2;
        }
        if (this.isTranslationMode()) {
            try {
                fileProperties.setProperty("Generate Help", Boolean.FALSE);
                fileProperties.setProperty("Generate Beans", Boolean.FALSE);
                fileProperties.setProperty("Generate Handlers", Boolean.FALSE);
                fileProperties.setProperty("Serialize", Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        String string2 = fileProperties.getResourceName(true, true);
        string2 = string2.replace('.', File.separatorChar);
        int n = string.indexOf(string2);
        if (string.equals("") || bl || n == -1 || string2.endsWith(m_tempBaseName)) {
            object3 = string.equals("") || n == -1 ? this.m_lastDirectory + File.separatorChar + string2 + ".pdml" : (string2.endsWith(m_tempBaseName) ? "temp.pdml" : string);
            string = null;
            object2 = new String[]{".pdml", ".pdmlsrc"};
            object = new ToolsFileFilter((String[])object2, GUIFactory.getString("IDS_FILE_FILTER_PDML"));
            ToolsFileChooser toolsFileChooser = new ToolsFileChooser(this.m_lastDirectory){

                public void approveSelection() {
                    this.addDefaultExtension();
                    GUIBuilder.this.m_lastDirectory = this.getCurrentDirectory().getPath();
                    String string = this.getSelectedFile().getPath();
                    if (!string.toLowerCase().endsWith(".pdml") && !string.toLowerCase().endsWith(".pdmlsrc")) {
                        JOptionPane.showMessageDialog(this, GUIFactory.getString("IDS_FILE_EXTENSION_NOT_VALID"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                    } else {
                        Object object;
                        Object object2;
                        String string2;
                        int n;
                        String string3 = string;
                        int n2 = string3.lastIndexOf(File.separatorChar);
                        if (n2 > -1 && n2 + 1 < string3.length()) {
                            string3 = string3.substring(n2 + 1);
                        }
                        if ((n = (string3 = string3.substring(0, string3.lastIndexOf(46))).indexOf(string2 = "_" + fileProperties.getLocale().toString())) > -1) {
                            string3 = string3.substring(0, n);
                        }
                        if (string3.equals(GUIBuilder.m_tempBaseName)) {
                            Object[] objectArray = new Object[]{string3};
                            String string4 = MessageFormat.format(GUIFactory.getString("IDS_NAME_NOT_VALID"), objectArray);
                            JOptionPane.showMessageDialog(this, string4, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            return;
                        }
                        try {
                            fileProperties.setProperty("Base Name", string3);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            JOptionPane.showMessageDialog(this, propertyVetoException.getMessage(), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            return;
                        }
                        String string5 = fileProperties.getResourceName(true, true);
                        string5 = string5.replace('.', File.separatorChar);
                        if (string.indexOf(string5) == -1) {
                            Object[] objectArray = new Object[]{string5 + ".pdml"};
                            String string6 = MessageFormat.format(GUIFactory.getString("IDS_FILE_SIGNATURE_NOT_VALID"), objectArray);
                            JOptionPane.showMessageDialog(this, string6, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                            return;
                        }
                        boolean bl = true;
                        if (this.getSelectedFile().exists()) {
                            object2 = new Object[]{string};
                            object = MessageFormat.format(GUIFactory.getString("IDS_FILE_EXISTS_REPLACE"), (Object[])object2);
                            int n3 = JOptionPane.showConfirmDialog(this, object, GUIFactory.getString("IDS_SAVEAS_TITLEBAR"), 0);
                            boolean bl2 = bl = n3 == 0;
                        }
                        if (bl) {
                            if (!this.getSelectedFile().exists()) {
                                int n4;
                                String string7;
                                string3 = this.getSelectedFile().getPath();
                                string3 = string3.substring(0, string3.lastIndexOf(46));
                                object2 = new File(string3 + ".java");
                                object = new File(string3 + ".properties");
                                if (((File)object2).exists()) {
                                    Object[] objectArray = new Object[]{((File)object2).getPath()};
                                    string7 = MessageFormat.format(GUIFactory.getString("IDS_FILE_EXISTS_REPLACE"), objectArray);
                                    n4 = JOptionPane.showConfirmDialog(this, string7, GUIFactory.getString("IDS_SAVEAS_TITLEBAR"), 0);
                                    boolean bl3 = bl = n4 == 0;
                                }
                                if (((File)object).exists()) {
                                    Object[] objectArray = new Object[]{((File)object).getPath()};
                                    string7 = MessageFormat.format(GUIFactory.getString("IDS_FILE_EXISTS_REPLACE"), objectArray);
                                    n4 = JOptionPane.showConfirmDialog(this, string7, GUIFactory.getString("IDS_SAVEAS_TITLEBAR"), 0);
                                    boolean bl4 = bl = n4 == 0;
                                }
                            }
                            if (bl) {
                                super.approveSelection();
                            }
                        }
                    }
                }
            };
            toolsFileChooser.addChoosableFileFilter((FileFilter)object);
            toolsFileChooser.setFileFilter((FileFilter)object);
            toolsFileChooser.setDialogTitle(GUIFactory.getString("IDS_SAVEAS_TITLEBAR"));
            toolsFileChooser.setMultiSelectionEnabled(false);
            toolsFileChooser.setSelectedFile(new File((String)object3));
            int n2 = toolsFileChooser.showSaveDialog(this);
            this.repaint();
            if (n2 == 0) {
                string = toolsFileChooser.getSelectedFile().getPath();
            }
        }
        if (string != null && string.trim().length() > 0) {
            if (!this.m_validationDialog.validatePDMLDocument(xMLGUIBuilderDefinition, fileProperties.getResourceName(true, false))) {
                this.m_validationDialog.show();
                return 2;
            }
            this.m_validationDialog.dispose();
            object3 = new File(string);
            if (((File)object3).exists() && !((File)object3).canWrite()) {
                object2 = new Object[]{string};
                object = MessageFormat.format(GUIFactory.getString("IDS_FILE_READONLY_NOT_VALID"), (Object[])object2);
                JOptionPane.showMessageDialog(this, object, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                return 1;
            }
            object2 = new File(((File)object3).getParent());
            if (!((File)object2).exists()) {
                ((File)object2).mkdirs();
            }
            try {
                xMLGUIBuilderDefinition.saveAs((File)object3);
                this.updateBuilder();
                viewManager = (ViewManager)this.m_viewManagers.get(xMLGUIBuilderDefinition);
                viewManager.updateAllTitleBars();
                this.addMRU(((File)object3).getPath());
                return 0;
            }
            catch (Throwable throwable) {
                this.displayGeneralException(throwable);
            }
        }
        return 1;
    }

    void doSaveAll() {
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            if (this.doSave(xMLGUIBuilderDefinition, false) != 0) break;
        }
    }

    boolean doCheckCompiler() {
        String string = this.m_optionsBean.getCompilerExecutable();
        if (string == null || string.equals("")) {
            JOptionPane.showMessageDialog(this, GUIFactory.getString("IDS_COMPILER_REQUIRED"), GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
            this.doOptionsDialog();
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            Object[] objectArray = new Object[]{string};
            String string2 = MessageFormat.format(GUIFactory.getString("IDS_COMPILER_NOT_FOUND"), objectArray);
            JOptionPane.showMessageDialog(this, string2, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
            this.doOptionsDialog();
            return false;
        }
        return true;
    }

    void doPreview(MutableProperties mutableProperties) {
        this.doPreview(mutableProperties, false);
    }

    void doPreview(MutableProperties mutableProperties, boolean bl) {
        LoopDialog loopDialog;
        if (this.m_activeEditor == null) {
            return;
        }
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_activeEditor.getPDMLDocument();
        if (xMLGUIBuilderDefinition == null) {
            return;
        }
        MutableProperties mutableProperties2 = mutableProperties;
        FileProperties fileProperties = xMLGUIBuilderDefinition.getPDMLRoot();
        MutableProperties mutableProperties3 = (MutableProperties)mutableProperties.getParent();
        while (!mutableProperties3.equals(fileProperties)) {
            mutableProperties = mutableProperties3;
            mutableProperties3 = (MutableProperties)mutableProperties3.getParent();
        }
        ViewManager viewManager = (ViewManager)this.m_viewManagers.get(xMLGUIBuilderDefinition);
        BuilderFrame builderFrame = viewManager.getEditor(mutableProperties2);
        if (builderFrame == null) {
            builderFrame = viewManager.getEditor(fileProperties);
        }
        if ((loopDialog = new LoopDialog(mutableProperties2, this, builderFrame)).findLoops()) {
            return;
        }
        String string = m_tempBaseName;
        if (!this.m_validationDialog.validatePDMLDocument(xMLGUIBuilderDefinition, string)) {
            this.m_validationDialog.show();
            return;
        }
        this.m_validationDialog.dispose();
        File file = new File(string + ".pdml");
        try {
            xMLGUIBuilderDefinition.setSaveAsResourceName(string);
            xMLGUIBuilderDefinition.saveAs(file, true);
        }
        catch (Throwable throwable) {
            this.displayGeneralException(throwable);
            return;
        }
        UIFramework.setSystemLookAndFeelEnabled((boolean)false);
        UIFramework.setResourceMode((int)2);
        UIFramework.setSearchMode((int)3);
        try {
            Locale locale = null;
            String string2 = (String)mutableProperties.getProperty("Name");
            switch (mutableProperties.getType()) {
                case 1: {
                    DynamicPanelManager dynamicPanelManager = bl ? new DynamicPanelManager(string, locale, string2, null, (Dimension)null) : new PanelManager(string, locale, string2, null);
                    dynamicPanelManager.loadData();
                    dynamicPanelManager.setVisible(true);
                    break;
                }
                case 120: {
                    PropertySheetManager propertySheetManager = new PropertySheetManager(string, locale, string2, null, bl);
                    propertySheetManager.loadData();
                    propertySheetManager.setVisible(true);
                    break;
                }
                case 121: {
                    WizardManager wizardManager = new WizardManager(string, locale, string2, null, null, bl);
                    wizardManager.loadData();
                    wizardManager.setVisible(true);
                    break;
                }
                case 60: {
                    JFrame jFrame = new JFrame();
                    jFrame.setResizable(false);
                    jFrame.setDefaultCloseOperation(2);
                    DeckPaneManager deckPaneManager = new DeckPaneManager(string, locale, string2, null, jFrame.getContentPane());
                    deckPaneManager.loadData();
                    this.previewDeckPane(deckPaneManager, jFrame);
                    break;
                }
                case 61: {
                    JFrame jFrame = new JFrame();
                    jFrame.setResizable(false);
                    jFrame.setDefaultCloseOperation(2);
                    SplitPaneManager splitPaneManager = new SplitPaneManager(string, locale, string2, null, jFrame.getContentPane());
                    splitPaneManager.loadData();
                    this.previewPane(splitPaneManager.getTitle(), jFrame);
                    break;
                }
                case 62: {
                    JFrame jFrame = new JFrame();
                    jFrame.setResizable(false);
                    jFrame.setDefaultCloseOperation(2);
                    TabbedPaneManager tabbedPaneManager = new TabbedPaneManager(string, locale, string2, null, jFrame.getContentPane());
                    tabbedPaneManager.loadData();
                    this.previewPane(tabbedPaneManager.getTitle(), jFrame);
                    break;
                }
                case 51: {
                    JFrame jFrame = new JFrame();
                    jFrame.setDefaultCloseOperation(2);
                    this.previewMenu(string, locale, string2, jFrame, mutableProperties.getProperty("Type").equals("menu"));
                }
            }
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage((Component)this);
        }
        UIFramework.setResourceMode((int)1);
        UIFramework.setSearchMode((int)2);
    }

    void previewPane(String string, JFrame jFrame) {
        jFrame.setTitle(string);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        jFrame.show();
    }

    void previewDeckPane(DeckPaneManager deckPaneManager, JFrame jFrame) {
        ShowPaneHandler showPaneHandler = new ShowPaneHandler(deckPaneManager);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(GUIFactory.getString("IDM_PREVIEW_VIEW_PANE"));
        String[] stringArray = deckPaneManager.getPaneNames();
        if (stringArray != null) {
            ButtonGroup buttonGroup = new ButtonGroup();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                buttonGroup.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem.setActionCommand(string);
                jRadioButtonMenuItem.addActionListener(showPaneHandler);
                jMenu.add(jRadioButtonMenuItem);
                ++n;
            }
            jMenuBar.add(jMenu);
            jFrame.setJMenuBar(jMenuBar);
            this.previewPane(deckPaneManager.getTitle(), jFrame);
        }
    }

    void previewMenu(String string, Locale locale, String string2, JFrame jFrame, boolean bl) throws DisplayManagerException {
        Object object;
        Serializable serializable;
        MenuManager menuManager = new MenuManager(string, locale, string2, null);
        if (bl) {
            serializable = new JMenuBar();
            object = ((JMenuBar)serializable).add(menuManager.getMenu());
            this.scaleMenu((Component)object);
            jFrame.setJMenuBar((JMenuBar)serializable);
            String string3 = GUIFactory.getString("IDS_PREVIEW_CONTEXT_MENU");
            JLabel jLabel = new JLabel(string3, 0);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)jLabel, "Center");
            PopupListener popupListener = new PopupListener(string, locale, string2, jFrame);
            jFrame.addMouseListener(popupListener);
        } else {
            Object object2;
            serializable = new JToolBar();
            ((JComponent)serializable).setBorder(new MenuBarBorder(((Component)serializable).getBackground().darker(), ((Component)serializable).getBackground().brighter()));
            object = menuManager.getActions();
            JToolBar jToolBar = new JToolBar();
            Dimension dimension = new Dimension();
            int n = 0;
            while (n < ((Action[])object).length) {
                object2 = object[n];
                if (((String)object2.getValue("Default")).equalsIgnoreCase("SEPARATOR")) {
                    jToolBar.add(new ToolBarSeparator(true, ((Component)serializable).getBackground().darker(), ((Component)serializable).getBackground().brighter()));
                } else {
                    MenuItemDescriptor menuItemDescriptor = (MenuItemDescriptor)object2.getValue("pdml.menuitem.descriptor");
                    AbstractButton abstractButton = null;
                    if (menuItemDescriptor.m_type.equalsIgnoreCase("RADIO") || menuItemDescriptor.m_type.equalsIgnoreCase("CHECK")) {
                        abstractButton = new JToggleButton(menuItemDescriptor.m_title, (Icon)object2.getValue("SmallIcon"), menuItemDescriptor.m_selected);
                        jToolBar.add(abstractButton);
                    } else {
                        abstractButton = jToolBar.add((Action)object2);
                    }
                    abstractButton.setFont(this.m_scaledFont);
                    if (object2.getValue("SmallIcon") != null) {
                        if (menuItemDescriptor.m_iconPosition.equals("LEFT")) {
                            abstractButton.setHorizontalTextPosition(4);
                        } else if (menuItemDescriptor.m_iconPosition.equals("CENTER")) {
                            abstractButton.setHorizontalTextPosition(0);
                        } else if (menuItemDescriptor.m_iconPosition.equals("RIGHT")) {
                            abstractButton.setHorizontalTextPosition(2);
                        }
                        if (menuItemDescriptor.m_vIconPosition.equals("CENTER")) {
                            abstractButton.setVerticalTextPosition(0);
                        } else if (menuItemDescriptor.m_iconPosition.equals("CENTER")) {
                            if (menuItemDescriptor.m_vIconPosition.equals("TOP")) {
                                abstractButton.setVerticalTextPosition(3);
                            } else if (menuItemDescriptor.m_vIconPosition.equals("BOTTOM")) {
                                abstractButton.setVerticalTextPosition(1);
                            }
                        } else if (menuItemDescriptor.m_vIconPosition.equals("TOP")) {
                            abstractButton.setVerticalTextPosition(1);
                        } else if (menuItemDescriptor.m_vIconPosition.equals("BOTTOM")) {
                            abstractButton.setVerticalTextPosition(3);
                        }
                    }
                    abstractButton.setBorderPainted(false);
                    abstractButton.setFocusPainted(false);
                    if (object2.getValue("Name") == null || object2.getValue("Name").equals("")) {
                        abstractButton.setMargin(new Insets(0, 0, 0, 0));
                    }
                    Dimension dimension2 = abstractButton.getPreferredSize();
                    if (dimension2.width > dimension.width) {
                        dimension.width = dimension2.width;
                    }
                    if (dimension2.height > dimension.height) {
                        dimension.height = dimension2.height;
                    }
                }
                ++n;
            }
            object2 = null;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < ((Action[])object).length) {
                Action action = object[n2];
                if (((String)action.getValue("Default")).equalsIgnoreCase("SEPARATOR")) {
                    ((Container)serializable).add(new ToolBarSeparator(true, ((Component)serializable).getBackground().darker(), ((Component)serializable).getBackground().brighter()));
                } else {
                    Object object3;
                    MenuItemDescriptor menuItemDescriptor = (MenuItemDescriptor)action.getValue("pdml.menuitem.descriptor");
                    AbstractButton abstractButton = null;
                    if (menuItemDescriptor.m_type.equalsIgnoreCase("RADIO")) {
                        if (object2 == null) {
                            object2 = new ButtonGroup();
                        }
                        abstractButton = new JToggleButton(menuItemDescriptor.m_title, (Icon)action.getValue("SmallIcon"), menuItemDescriptor.m_selected);
                        abstractButton.setEnabled(action.isEnabled());
                        abstractButton.addActionListener(action);
                        if (!(class$java$awt$event$ItemListener == null ? GUIBuilder.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener).isAssignableFrom(action.getClass())) {
                            object3 = new Object[]{action.getClass().getName()};
                            MessageLog.traceErr((Object)SystemResourceFinder.format((String)"menuListenerNotImplemented", (Object[])object3));
                        } else {
                            abstractButton.addItemListener((ItemListener)((Object)action));
                        }
                        ((Container)serializable).add(abstractButton);
                        ((ButtonGroup)object2).add(abstractButton);
                        bl2 = true;
                    } else if (menuItemDescriptor.m_type.equalsIgnoreCase("CHECK")) {
                        abstractButton = new JToggleButton(menuItemDescriptor.m_title, (Icon)action.getValue("SmallIcon"), menuItemDescriptor.m_selected);
                        abstractButton.setEnabled(action.isEnabled());
                        abstractButton.addActionListener(action);
                        if (!(class$java$awt$event$ItemListener == null ? GUIBuilder.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener).isAssignableFrom(action.getClass())) {
                            object3 = new Object[]{action.getClass().getName()};
                            MessageLog.traceErr((Object)SystemResourceFinder.format((String)"menuListenerNotImplemented", (Object[])object3));
                        } else {
                            abstractButton.addItemListener((ItemListener)((Object)action));
                        }
                        ((Container)serializable).add(abstractButton);
                        object2 = null;
                        bl2 = true;
                    } else {
                        abstractButton = ((JToolBar)serializable).add(action);
                        object2 = null;
                        bl2 = false;
                    }
                    abstractButton.setFont(this.m_scaledFont);
                    abstractButton.setName(menuItemDescriptor.m_name);
                    abstractButton.setPreferredSize(dimension);
                    abstractButton.setMaximumSize(dimension);
                    if (action.getValue("SmallIcon") != null) {
                        if (menuItemDescriptor.m_iconPosition.equals("LEFT")) {
                            abstractButton.setHorizontalTextPosition(4);
                        } else if (menuItemDescriptor.m_iconPosition.equals("CENTER")) {
                            abstractButton.setHorizontalTextPosition(0);
                        } else if (menuItemDescriptor.m_iconPosition.equals("RIGHT")) {
                            abstractButton.setHorizontalTextPosition(2);
                        }
                        if (menuItemDescriptor.m_vIconPosition.equals("CENTER")) {
                            abstractButton.setVerticalTextPosition(0);
                        } else if (menuItemDescriptor.m_iconPosition.equals("CENTER")) {
                            if (menuItemDescriptor.m_vIconPosition.equals("TOP")) {
                                abstractButton.setVerticalTextPosition(3);
                            } else if (menuItemDescriptor.m_vIconPosition.equals("BOTTOM")) {
                                abstractButton.setVerticalTextPosition(1);
                            }
                        } else if (menuItemDescriptor.m_vIconPosition.equals("TOP")) {
                            abstractButton.setVerticalTextPosition(1);
                        } else if (menuItemDescriptor.m_vIconPosition.equals("BOTTOM")) {
                            abstractButton.setVerticalTextPosition(3);
                        }
                    }
                    abstractButton.setActionCommand((String)action.getValue("Default"));
                    object3 = (String)action.getValue("ShortDescription");
                    if (object3 != null && !((String)object3).trim().equals("")) {
                        abstractButton.setToolTipText((String)object3);
                    }
                    abstractButton.setBorderPainted(abstractButton.isEnabled() && abstractButton.isSelected());
                    abstractButton.setFocusPainted(false);
                    if (action.getValue("Name") == null || action.getValue("Name").equals("")) {
                        abstractButton.setMargin(new Insets(0, 0, 0, 0));
                    }
                    abstractButton.addMouseListener(new MouseAdapter(){

                        public void mouseEntered(MouseEvent mouseEvent) {
                            AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
                            abstractButton.setBorderPainted(abstractButton.isEnabled());
                        }

                        public void mouseExited(MouseEvent mouseEvent) {
                            AbstractButton abstractButton;
                            abstractButton.setBorderPainted((abstractButton = (AbstractButton)mouseEvent.getComponent()).isEnabled() && abstractButton.isSelected());
                        }
                    });
                    if (bl2) {
                        abstractButton.addChangeListener(new ChangeListener(){

                            public void stateChanged(ChangeEvent changeEvent) {
                                AbstractButton abstractButton;
                                abstractButton.setBorderPainted((abstractButton = (AbstractButton)changeEvent.getSource()).isEnabled() && abstractButton.isSelected());
                            }
                        });
                    }
                }
                ++n2;
            }
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)serializable, "North");
        }
        jFrame.setTitle(string2);
        jFrame.pack();
        serializable = jFrame.getSize();
        ((Dimension)serializable).height = 300;
        if (bl && ((Dimension)serializable).width < 300) {
            ((Dimension)serializable).width = 300;
        }
        ((Component)jFrame).setSize((Dimension)serializable);
        object = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(object.width / 2 - ((Dimension)serializable).width / 2, object.height / 2 - ((Dimension)serializable).height / 2);
        jFrame.show();
    }

    void scaleMenu(Component component) {
        if (component != null) {
            component.setFont(this.m_scaledFont);
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                int n = jMenu.getMenuComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    this.scaleMenu(jMenu.getMenuComponent(n2));
                    ++n2;
                }
            }
        }
    }

    int doClose() {
        if (this.m_activeEditor == null) {
            return 0;
        }
        return this.doClose(this.m_activeEditor.getPDMLDocument(), false);
    }

    int doClose(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, boolean bl) {
        Object object;
        if (xMLGUIBuilderDefinition == null) {
            return 0;
        }
        if (xMLGUIBuilderDefinition.isModified()) {
            object = (String)xMLGUIBuilderDefinition.getPDMLRoot().getProperty("File Name");
            if (((String)object).equals("")) {
                object = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, true);
            }
            Object[] objectArray = new Object[]{object};
            String string = MessageFormat.format(GUIFactory.getString("IDS_SAVE_PROMPT"), objectArray);
            int n = JOptionPane.showConfirmDialog(this, string);
            if (n == 0) {
                int n2 = this.doSave(false);
                if (n2 != 0) {
                    return 1;
                }
            } else if (n != 1) {
                return 2;
            }
        }
        if (bl) {
            return 0;
        }
        object = (ViewManager)this.m_viewManagers.get(xMLGUIBuilderDefinition);
        if (object != null) {
            ((ViewManager)object).closeAllEditors();
            this.m_viewManagers.remove(xMLGUIBuilderDefinition);
        }
        this.m_propertyDialog.setProperties(null);
        if (xMLGUIBuilderDefinition.equals(this.m_validationDialog.getPDMLDocument())) {
            this.m_validationDialog.dispose();
        }
        this.m_activeEditor.removeSelectionListener(this.m_selectionListener);
        this.m_activeEditor = null;
        this.updateBuilder();
        if (this.m_viewManagers.isEmpty()) {
            this.m_ptCascade.x = 0;
            this.m_ptCascade.y = 0;
        }
        return 0;
    }

    void doUndo() {
        if (this.m_activeEditor != null) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_activeEditor.getPDMLDocument();
            try {
                xMLGUIBuilderDefinition.getUndoManager().undo();
                xMLGUIBuilderDefinition.setModified(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateBuilder();
        }
    }

    void doRedo() {
        if (this.m_activeEditor != null) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = this.m_activeEditor.getPDMLDocument();
            try {
                xMLGUIBuilderDefinition.getUndoManager().redo();
                xMLGUIBuilderDefinition.setModified(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateBuilder();
        }
    }

    void doCut() {
        if (this.m_activeEditor != null) {
            this.m_activeEditor.cut();
            this.updateBuilder();
        }
    }

    void doCopy() {
        if (this.m_activeEditor != null) {
            this.m_activeEditor.copy();
            this.updateBuilder();
        }
    }

    void doPaste() {
        if (this.m_activeEditor != null) {
            this.m_activeEditor.paste();
            this.updateBuilder();
        }
    }

    void doDelete() {
        if (this.m_activeEditor != null) {
            this.m_activeEditor.delete();
            this.updateBuilder();
        }
    }

    void doOptionsDialog() {
        PanelManager panelManager;
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_optionsDialog == null) {
            panelManager = new PanelManager[]{this.m_optionsBean};
            try {
                this.m_optionsDialog = new PropertySheetManager("com.ibm.as400.ui.tools.guibuilderpanels", "IDD_OPTIONS_SHEET", (DataBean[])panelManager, (Frame)this);
            }
            catch (DisplayManagerException displayManagerException) {
                this.m_optionsDialog = null;
                displayManagerException.displayUserMessage((Component)this);
            }
        }
        if (this.m_optionsDialog != null) {
            panelManager = this.m_optionsDialog.getPage(0);
            panelManager.loadData();
            panelManager = this.m_optionsDialog.getPage(1);
            panelManager.loadData();
            this.m_optionsDialog.showPage(0);
            this.m_optionsDialog.setVisible(true);
            Enumeration enumeration = this.m_viewManagers.elements();
            while (enumeration.hasMoreElements()) {
                ViewManager viewManager = (ViewManager)enumeration.nextElement();
                viewManager.repaintAllBuilders();
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    void doShowProperties() {
        ((Component)this.m_propertyDialog).setVisible(true);
        this.m_propertyDialog.requestFocus();
    }

    void doEditProperty(String string) {
        this.m_propertyDialog.editProperty(string);
    }

    void doAbout() {
        AboutDialog aboutDialog = new AboutDialog(this, true, false, null);
    }

    void doExit() {
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            if (this.doClose(xMLGUIBuilderDefinition, true) == 0) continue;
            return;
        }
        File file = new File("guitemp.pdml");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File("guitemp.properties")).exists()) {
            file.delete();
        }
        this.m_optionsBean.setPropertyDialogBounds(this.m_propertyDialog.getBounds());
        this.m_optionsBean.save();
        System.exit(0);
    }

    void displayHelp(String string, Component component) {
        if (string == null) {
            string = "GUIBuilder";
        }
        try {
            URL uRL = SystemResourceFinder.getHTMLDocument((String)(m_helpBase + string), (Locale)null);
            component.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_helpViewer == null) {
                URL uRL2 = SystemResourceFinder.getHTMLDocument((String)"com.ibm.as400.ui.tools/guibuilderpanels/GUIBuilder", (Locale)null);
                this.m_helpViewer = new HelpViewer(uRL2);
                this.m_helpViewer.setHome(uRL2);
                this.m_helpViewer.setIconImage(GUIFactory.getImage("GUIBuilder.gif", false).getImage());
            }
            this.m_helpViewer.showPage(uRL);
            component.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (MissingResourceException missingResourceException) {
            MessageLog.logError((Object)missingResourceException);
        }
    }

    void updateBuilder() {
        BuilderFrame builderFrame = this.m_activeEditor;
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = builderFrame != null ? builderFrame.getPDMLDocument() : null;
        JMenu jMenu = (JMenu)this.m_menubar.getComponent(0);
        boolean bl = xMLGUIBuilderDefinition != null ? xMLGUIBuilderDefinition.isModified() : false;
        JButton jButton = (JButton)this.m_toolbar.getComponent(2);
        jButton.setEnabled(bl);
        JMenuItem jMenuItem = (JMenuItem)jMenu.getMenuComponent(4);
        jMenuItem.setEnabled(bl);
        bl = xMLGUIBuilderDefinition != null;
        jMenuItem = (JMenuItem)jMenu.getMenuComponent(2);
        jMenuItem.setEnabled(bl);
        jMenuItem = (JMenuItem)jMenu.getMenuComponent(5);
        jMenuItem.setEnabled(bl);
        bl = this.m_viewManagers.size() > 0;
        jButton = (JButton)this.m_toolbar.getComponent(3);
        jButton.setEnabled(bl);
        jMenuItem = (JMenuItem)jMenu.getMenuComponent(6);
        jMenuItem.setEnabled(bl);
        JMenu jMenu2 = (JMenu)this.m_menubar.getComponent(1);
        JCheckBoxMenuItem jCheckBoxMenuItem = null;
        jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenu2.getMenuComponent(0);
        jCheckBoxMenuItem.setState(this.m_propertyDialog.isShowing());
        Enumeration enumeration = this.m_viewManagers.elements();
        while (enumeration.hasMoreElements()) {
            ViewManager viewManager = (ViewManager)enumeration.nextElement();
            viewManager.updateAllEditors();
        }
        this.m_propertyDialog.updateBuilder();
    }

    int getAvailablePaneCount(boolean bl) {
        int n = 0;
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            Vector vector = xMLGUIBuilderDefinition.panes(bl);
            if (vector == null) continue;
            n += vector.size();
        }
        return n;
    }

    boolean arePanesAvailable(boolean bl) {
        return this.getAvailablePaneCount(bl) > 0;
    }

    boolean arePanesAvailable(MutableProperties mutableProperties, boolean bl) {
        Vector vector;
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition;
        int n = mutableProperties.getType();
        int n2 = this.getAvailablePaneCount(bl);
        if (n2 == 1 && (xMLGUIBuilderDefinition = mutableProperties.getPDMLDocument()) != null && (vector = xMLGUIBuilderDefinition.panes(bl)) != null && vector.size() == 1) {
            PaneProperties paneProperties = (PaneProperties)vector.firstElement();
            if (paneProperties.getProperty("ID").equals(mutableProperties.getProperty("Name"))) {
                return false;
            }
            TreeNode[] treeNodeArray = mutableProperties.getPath();
            if (treeNodeArray.length > 2) {
                MutableProperties mutableProperties2 = (MutableProperties)treeNodeArray[1];
                String string = (String)mutableProperties2.getProperty("Name");
                return !paneProperties.getProperty("ID").equals(string);
            }
            return true;
        }
        return n2 > 0;
    }

    PaneProperties getFirstAvailablePane(MutableProperties mutableProperties, boolean bl) {
        PaneProperties paneProperties = null;
        if (this.arePanesAvailable(mutableProperties, bl)) {
            Vector vector;
            String string = (String)mutableProperties.getProperty("Name");
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = mutableProperties.getPDMLDocument();
            if (xMLGUIBuilderDefinition != null && (vector = xMLGUIBuilderDefinition.panes(bl)) != null) {
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    MutableProperties mutableProperties2;
                    String string2;
                    TreeNode[] treeNodeArray;
                    paneProperties = (PaneProperties)vector.elementAt(n2);
                    String string3 = (String)paneProperties.getProperty("ID");
                    if (!(string3.equals(string) || (treeNodeArray = mutableProperties.getPath()).length > 2 && string3.equals(string2 = (String)(mutableProperties2 = (MutableProperties)treeNodeArray[1]).getProperty("Name")))) {
                        try {
                            paneProperties.setProperty("Target", xMLGUIBuilderDefinition.getPDMLRoot().getNodeNamed(string3));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return paneProperties;
                    }
                    ++n2;
                }
            }
            Enumeration enumeration = this.m_viewManagers.keys();
            while (enumeration.hasMoreElements()) {
                xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
                if (xMLGUIBuilderDefinition.equals(mutableProperties.getPDMLDocument()) || (vector = xMLGUIBuilderDefinition.panes(bl)) == null || vector.size() <= 0) continue;
                paneProperties = (PaneProperties)vector.firstElement();
                return paneProperties;
            }
        }
        return null;
    }

    Vector getAvailablePanes(String string, MutableProperties mutableProperties, boolean bl) {
        Vector vector = null;
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = null;
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            String string2 = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
            if (!string2.equals(string)) continue;
            vector = xMLGUIBuilderDefinition.panes(bl);
            break;
        }
        if (vector != null && xMLGUIBuilderDefinition != null && xMLGUIBuilderDefinition.equals(mutableProperties.getPDMLDocument())) {
            PaneProperties paneProperties;
            int n = vector.size();
            String string3 = (String)mutableProperties.getProperty("Name");
            int n2 = 0;
            while (n2 < n) {
                paneProperties = (PaneProperties)vector.elementAt(n2);
                if (paneProperties.getProperty("ID").equals(string3)) {
                    vector.removeElementAt(n2);
                    break;
                }
                ++n2;
            }
            TreeNode[] treeNodeArray = mutableProperties.getPath();
            if (treeNodeArray.length > 2) {
                MutableProperties mutableProperties2 = (MutableProperties)treeNodeArray[1];
                string3 = (String)mutableProperties2.getProperty("Name");
                int n3 = 0;
                while (n3 < n) {
                    paneProperties = (PaneProperties)vector.elementAt(n3);
                    if (paneProperties.getProperty("ID").equals(string3)) {
                        vector.removeElementAt(n3);
                        break;
                    }
                    ++n3;
                }
            }
        }
        return vector;
    }

    Vector getAvailableResources(MutableProperties mutableProperties, boolean bl) {
        Vector vector = new Vector();
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            Vector vector2 = xMLGUIBuilderDefinition.panes(bl);
            if (vector2 == null) continue;
            if (vector2.size() > 1) {
                string = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
                this.addDefinitionInOrder(xMLGUIBuilderDefinition, string, vector);
                continue;
            }
            if (vector2.size() != 1) continue;
            if (xMLGUIBuilderDefinition.equals(mutableProperties.getPDMLDocument())) {
                PaneProperties paneProperties = (PaneProperties)vector2.firstElement();
                if (paneProperties.getProperty("ID").equals(mutableProperties.getProperty("Name"))) continue;
                string = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
                this.addDefinitionInOrder(xMLGUIBuilderDefinition, string, vector);
                continue;
            }
            string = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
            this.addDefinitionInOrder(xMLGUIBuilderDefinition, string, vector);
        }
        return vector;
    }

    boolean arePulldownsAvailable() {
        return this.getAvailablePulldownCount() > 0;
    }

    int getAvailablePulldownCount() {
        int n = 0;
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            Vector vector = xMLGUIBuilderDefinition.pulldowns();
            if (vector == null) continue;
            n += vector.size();
        }
        return n;
    }

    PulldownProperties getFirstAvailablePulldown(MutableProperties mutableProperties) {
        PulldownProperties pulldownProperties = null;
        if (this.arePulldownsAvailable()) {
            Vector vector;
            String string = (String)mutableProperties.getProperty("Name");
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = mutableProperties.getPDMLDocument();
            if (xMLGUIBuilderDefinition != null && (vector = xMLGUIBuilderDefinition.pulldowns()) != null) {
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    pulldownProperties = (PulldownProperties)vector.elementAt(n2);
                    if (!pulldownProperties.getProperty("ID").equals(string)) {
                        try {
                            pulldownProperties.setProperty("Target", xMLGUIBuilderDefinition.getPDMLRoot().getNodeNamed((String)pulldownProperties.getProperty("ID")));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return pulldownProperties;
                    }
                    ++n2;
                }
            }
            Enumeration enumeration = this.m_viewManagers.keys();
            while (enumeration.hasMoreElements()) {
                xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
                if (xMLGUIBuilderDefinition.equals(mutableProperties.getPDMLDocument()) || (vector = xMLGUIBuilderDefinition.pulldowns()) == null || vector.size() <= 0) continue;
                pulldownProperties = (PulldownProperties)vector.firstElement();
                return pulldownProperties;
            }
        }
        return null;
    }

    Vector getAvailablePulldowns(String string, MutableProperties mutableProperties) {
        Vector vector = null;
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = null;
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            String string2 = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
            if (!string2.equals(string)) continue;
            vector = xMLGUIBuilderDefinition.pulldowns();
            break;
        }
        return vector;
    }

    Vector getAvailablePulldownResources(MutableProperties mutableProperties) {
        Vector vector = new Vector();
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            Vector vector2 = xMLGUIBuilderDefinition.pulldowns();
            if (vector2 == null || vector2.size() <= 0) continue;
            String string = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
            this.addDefinitionInOrder(xMLGUIBuilderDefinition, string, vector);
        }
        return vector;
    }

    Vector getAvailableSelectionResources() {
        Vector vector = new Vector();
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            String string = xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false);
            this.addDefinitionInOrder(xMLGUIBuilderDefinition, string, vector);
        }
        return vector;
    }

    XMLGUIBuilderDefinition getPDMLDocument(String string) {
        XMLGUIBuilderDefinition xMLGUIBuilderDefinition = null;
        Enumeration enumeration = this.m_viewManagers.keys();
        while (enumeration.hasMoreElements()) {
            xMLGUIBuilderDefinition = (XMLGUIBuilderDefinition)enumeration.nextElement();
            if (!xMLGUIBuilderDefinition.getPDMLRoot().getResourceName(true, false).equals(string)) continue;
            return xMLGUIBuilderDefinition;
        }
        return null;
    }

    void addDefinitionInOrder(XMLGUIBuilderDefinition xMLGUIBuilderDefinition, String string, Vector vector) {
        Collator collator = Collator.getInstance();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            XMLGUIBuilderDefinition xMLGUIBuilderDefinition2 = (XMLGUIBuilderDefinition)vector.elementAt(n2);
            String string2 = xMLGUIBuilderDefinition2.getPDMLRoot().getResourceName(true, false);
            int n3 = collator.compare(string2, string);
            if (n3 > 0) {
                vector.insertElementAt(xMLGUIBuilderDefinition, n2);
                return;
            }
            if (n3 == 0) {
                return;
            }
            ++n2;
        }
        vector.addElement(xMLGUIBuilderDefinition);
    }

    Rectangle scaleRect(Rectangle rectangle) {
        rectangle.setSize(new Double((double)rectangle.width * this.m_xScalingFactor).intValue(), new Double((double)rectangle.height * this.m_yScalingFactor).intValue());
        rectangle.setLocation(new Double((double)rectangle.x * this.m_xScalingFactor).intValue(), new Double((double)rectangle.y * this.m_yScalingFactor).intValue());
        return rectangle;
    }

    boolean includePanelDefaultButtons() {
        return this.m_panelDefaultButtons;
    }

    void setIncludePanelDefaultButtons(boolean bl) {
        this.m_panelDefaultButtons = bl;
    }

    void addMRU(String string) {
        String string2 = string.replace('\\', '/');
        if (this.m_MRU.contains(string2)) {
            this.m_MRU.removeElement(string2);
        }
        this.m_MRU.insertElementAt(string2, 0);
        while (this.m_MRU.size() > this.m_MRUSize) {
            this.m_MRU.removeElementAt(this.m_MRUSize);
        }
        this.updateMRU();
    }

    void removeMRU(int n) {
        this.m_MRU.removeElementAt(n);
        this.updateMRU();
    }

    void updateMRU() {
        int n = 8;
        JMenu jMenu = (JMenu)this.m_menubar.getComponent(0);
        while (jMenu.getMenuComponentCount() > 9) {
            jMenu.remove(n);
        }
        int n2 = this.m_MRU.size();
        int n3 = 0;
        while (n3 < n2) {
            String string = (String)this.m_MRU.elementAt(n3);
            JMenuItem jMenuItem = GUIFactory.createMenuItem("MRU." + n3, null, "&" + (n3 + 1) + " " + string, "Empty.gif", true, this.m_toolListener);
            jMenu.insert(jMenuItem, n + n3);
            ++n3;
        }
        if (n2 > 0) {
            jMenu.insertSeparator(n + n2);
        }
    }

    void displayParseException(Exception exception, boolean bl) {
        Object[] objectArray = new Object[3];
        JTextArea jTextArea = new JTextArea(5, 60);
        jTextArea.setEditable(false);
        jTextArea.setBackground(UIManager.getColor("Panel.background"));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        objectArray[0] = new JLabel(GUIFactory.getString("IDS_PARSE_EXCEPTION"));
        objectArray[1] = new DividerPanel();
        objectArray[2] = jScrollPane;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessageLog.setLogStream((OutputStream)byteArrayOutputStream);
        if (bl) {
            ((ParseException)((Object)exception)).reportErrors();
        } else {
            ((PDMLSpecificationException)((Object)exception)).reportErrors();
        }
        jTextArea.setText(byteArrayOutputStream.toString());
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MessageLog.setLogStream(null);
        this.displayDetailsDialog(objectArray);
    }

    void displayGeneralException(Throwable throwable) {
        Object[] objectArray = new Object[3];
        JTextArea jTextArea = new JTextArea(5, 60);
        jTextArea.setEditable(false);
        jTextArea.setBackground(UIManager.getColor("Panel.background"));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        objectArray[0] = new JLabel(throwable.getLocalizedMessage());
        objectArray[1] = new DividerPanel();
        objectArray[2] = jScrollPane;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        jTextArea.setText(stringWriter.toString());
        printWriter.close();
        this.displayDetailsDialog(objectArray);
    }

    void displayDetailsDialog(Object[] objectArray) {
        final JDialog jDialog = new JDialog(this, GUIFactory.getString("IDS_ALERT_TITLEBAR"), true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(UIManager.getIcon("OptionPane.warningIcon")), "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        JButton jButton = new JButton(GUIFactory.getString("IDS_OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        Dimension dimension = new Dimension(80, 25);
        Dimension dimension2 = jButton.getPreferredSize();
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
        jButton.setPreferredSize(dimension);
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)objectArray[0], "North");
        jPanel3.add((Component)objectArray[1], "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)objectArray[2], "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 10));
        jPanel5.add((Component)jPanel4, "Center");
        jPanel5.add((Component)jPanel2, "South");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(10, 0));
        jPanel6.add((Component)jPanel, "West");
        jPanel6.add((Component)jPanel5, "Center");
        jPanel6.setBorder(new EmptyBorder(10, 10, 10, 10));
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPanel6, "Center");
        jDialog.pack();
        jDialog.show();
    }

    public static void main(String[] stringArray) {
        GUIBuilder gUIBuilder = new GUIBuilder();
        try {
            if (stringArray.length == 2 && stringArray[0].equalsIgnoreCase("-plaf")) {
                if (stringArray[1].equalsIgnoreCase("metal") || stringArray[1].equalsIgnoreCase("java") || stringArray[1].equalsIgnoreCase("swing")) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                } else if (stringArray[1].equalsIgnoreCase("windows")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                } else if (stringArray[1].equalsIgnoreCase("motif")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            } else {
                if (stringArray.length == 1 && (stringArray[0].equalsIgnoreCase("-translate") || stringArray[0].equalsIgnoreCase("-translation"))) {
                    gUIBuilder.setTranslationMode(true);
                } else if (stringArray.length == 2 && stringArray[0].equalsIgnoreCase("-mode") && stringArray[1].equalsIgnoreCase("msys")) {
                    GUIBuilder.setMSYSMode(true);
                }
                String string = System.getProperty("os.name").toUpperCase();
                Object object = string.indexOf("WINDOWS") != -1 ? new WindowsLookAndFeel() : (string.indexOf("AIX") != -1 ? new MotifLookAndFeel() : (string.indexOf("LINUX") != -1 ? new MotifLookAndFeel() : (string.indexOf("SOLARIS") != -1 ? new MotifLookAndFeel() : new MetalLookAndFeel())));
                try {
                    UIManager.setLookAndFeel((LookAndFeel)object);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        gUIBuilder.init();
    }

    void doEasterEgg(Component component) {
        TestThread testThread = new TestThread();
        new Thread(testThread).start();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ToolBarSeparator
    extends JComponent {
        boolean m_updown;
        Color m_shadow;
        Color m_highlight;

        ToolBarSeparator(boolean bl, Color color, Color color2) {
            this.m_updown = bl;
            this.m_shadow = color;
            this.m_highlight = color2;
        }

        public Dimension getMinimumSize() {
            if (this.m_updown) {
                return new Dimension(8, 0);
            }
            return new Dimension(0, 8);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            if (this.m_updown) {
                int n;
                int n2 = n = this.getSize().width / 2 - 1;
                int n3 = 0;
                int n4 = this.getSize().height - 1;
                graphics.setColor(this.m_shadow);
                graphics.drawLine(n2, n3, n, n4);
                graphics.setColor(this.m_highlight);
                graphics.drawLine(n2 + 1, n3, n + 1, n4);
            } else {
                int n;
                int n5 = n = this.getSize().height / 2 - 1;
                int n6 = 0;
                int n7 = this.getSize().width - 1;
                graphics.setColor(this.m_shadow);
                graphics.drawLine(n6, n5, n7, n);
                graphics.setColor(this.m_highlight);
                graphics.drawLine(n6, n5 + 1, n7, n + 1);
            }
            graphics.setColor(color);
        }
    }

    class TestThread
    extends Thread {
        TestThread() {
        }

        public void run() {
            try {
                URL uRL = new URL("http://www.danger-island.com/~mark/bobs.html");
                HelpViewer helpViewer = new HelpViewer(uRL);
                helpViewer.setHome(uRL);
                helpViewer.setIconImage(GUIFactory.getImage("DefaultImage.gif", false).getImage());
                helpViewer.showPage(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class GUIToolListener
    implements ActionListener {
        GUIToolListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.startsWith("File")) {
                if ((string = string.substring(5)).equals("New")) {
                    GUIBuilder.this.doNew();
                } else if (string.equals("Open")) {
                    GUIBuilder.this.doOpen();
                } else if (string.equals("Exit")) {
                    GUIBuilder.this.doExit();
                } else if (string.equals("Close")) {
                    GUIBuilder.this.doClose();
                } else if (string.equals("Save")) {
                    GUIBuilder.this.doSave(false);
                } else if (string.equals("SaveAs")) {
                    GUIBuilder.this.doSave(true);
                } else if (string.equals("SaveAll")) {
                    GUIBuilder.this.doSaveAll();
                }
            } else if (string.startsWith("Edit")) {
                if ((string = string.substring(5)).equals("Undo")) {
                    GUIBuilder.this.doUndo();
                } else if (string.equals("Redo")) {
                    GUIBuilder.this.doRedo();
                } else if (string.equals("Cut")) {
                    GUIBuilder.this.doCut();
                } else if (string.equals("Copy")) {
                    GUIBuilder.this.doCopy();
                } else if (string.equals("Paste")) {
                    GUIBuilder.this.doPaste();
                } else if (string.equals("Delete")) {
                    GUIBuilder.this.doDelete();
                }
            } else if (string.startsWith("View")) {
                if ((string = string.substring(5)).equals("Properties")) {
                    if (GUIBuilder.this.m_propertyDialog.isShowing()) {
                        GUIBuilder.this.m_propertyDialog.dispose();
                    } else {
                        GUIBuilder.this.m_propertyDialog.show();
                    }
                } else if (string.equals("Options")) {
                    GUIBuilder.this.doOptionsDialog();
                }
            } else if (string.startsWith("Help")) {
                if ((string = string.substring(5)).equals("About")) {
                    GUIBuilder.this.doAbout();
                } else if (string.equals("Topics")) {
                    GUIBuilder.this.displayHelp(null, GUIBuilder.this);
                }
            } else if (string.startsWith("MRU.")) {
                try {
                    int n = Integer.parseInt(string.substring(4));
                    String string2 = (String)GUIBuilder.this.m_MRU.elementAt(n);
                    int n2 = string2.lastIndexOf(47);
                    String string3 = string2.substring(0, n2).replace('/', File.separatorChar);
                    String string4 = string2.substring(n2 + 1);
                    File file = new File(string3, string4);
                    if (file.exists()) {
                        GUIBuilder.this.setCursor(Cursor.getPredefinedCursor(3));
                        GUIBuilder.this.doOpenFileBuilder(file);
                        GUIBuilder.this.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        Object[] objectArray = new Object[]{string2};
                        String string5 = MessageFormat.format(GUIFactory.getString("IDS_MRU_FILE_NOT_FOUND"), objectArray);
                        JOptionPane.showMessageDialog(GUIBuilder.this, string5, GUIFactory.getString("IDS_ALERT_TITLEBAR"), 2);
                        GUIBuilder.this.removeMRU(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    class GUIKeyListener
    extends KeyAdapter {
        GUIKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 74 && keyEvent.isAltDown() && keyEvent.isControlDown() && keyEvent.isShiftDown()) {
                GUIBuilder.this.doEasterEgg(GUIBuilder.this.getContentPane());
            }
        }
    }

    class GUISelectionListener
    implements SelectionListener {
        GUISelectionListener() {
        }

        public void selectionChanged(SelectionEvent selectionEvent) {
            GUIBuilder.this.m_propertyDialog.setProperties(selectionEvent.getSelection());
            GUIBuilder.this.updateBuilder();
        }
    }

    class GUIWindowListener
    extends WindowAdapter {
        GUIBuilder m_builder;

        GUIWindowListener(GUIBuilder gUIBuilder2) {
            this.m_builder = gUIBuilder2;
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (windowEvent.getWindow() == this.m_builder) {
                GUIBuilder.this.doExit();
            } else if (windowEvent.getWindow() instanceof FileBuilder) {
                GUIBuilder.this.doClose();
            } else if (windowEvent.getWindow().equals(GUIBuilder.this.m_propertyDialog)) {
                ((Component)windowEvent.getWindow()).setVisible(false);
            } else if (GUIBuilder.this.m_activeEditor != null) {
                XMLGUIBuilderDefinition xMLGUIBuilderDefinition;
                MutableProperties mutableProperties = GUIBuilder.this.m_activeEditor.getProperties();
                int n = mutableProperties.getType();
                LoopDialog loopDialog = new LoopDialog(mutableProperties, GUIBuilder.this, GUIBuilder.this.m_activeEditor);
                if (loopDialog.findLoops()) {
                    return;
                }
                if (n != 103 && n != 9 && n != 104 && n != 8 && (xMLGUIBuilderDefinition = GUIBuilder.this.m_activeEditor.getPDMLDocument()) != null && !GUIBuilder.this.m_validationDialog.validatePDMLDocument(xMLGUIBuilderDefinition, null)) {
                    GUIBuilder.this.m_validationDialog.show();
                }
                windowEvent.getWindow().dispose();
            } else {
                windowEvent.getWindow().dispose();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (GUIBuilder.this.m_activeEditor != null && windowEvent.getWindow() != GUIBuilder.this.m_activeEditor) {
                GUIBuilder.this.m_activeEditor.stopEditing();
            }
            if (windowEvent.getWindow() != this.m_builder) {
                BuilderFrame builderFrame = (BuilderFrame)windowEvent.getWindow();
                if (GUIBuilder.this.m_activeEditor != null) {
                    GUIBuilder.this.m_activeEditor.removeSelectionListener(GUIBuilder.this.m_selectionListener);
                }
                GUIBuilder.this.m_activeEditor = builderFrame;
                if (!GUIBuilder.this.m_activeEditor.equals(GUIBuilder.this.m_propertyDialog)) {
                    GUIBuilder.this.m_propertyDialog.setProperties(GUIBuilder.this.m_activeEditor.getSelectedProperties());
                }
                GUIBuilder.this.m_activeEditor.addSelectionListener(GUIBuilder.this.m_selectionListener);
            }
            GUIBuilder.this.updateBuilder();
        }
    }
}

