/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.tools;

import com.ibm.as400.ui.framework.java.GroupBox;
import com.ibm.as400.ui.tools.ButtonGroupProperties;
import com.ibm.as400.ui.tools.GUIFactory;
import com.ibm.as400.ui.tools.MenuBuilder;
import com.ibm.as400.ui.tools.MutableProperties;
import com.ibm.as400.ui.tools.PanelEditor;
import com.ibm.spinner.SpinnerGUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeCellRenderer;

class ComponentInfo
extends JPanel {
    MutableProperties m_properties;
    PanelEditor m_panelEditor;
    Component m_component;
    ComponentMouseListener m_mouseListener;
    ComponentFocusListener m_focusListener;
    ActionListener m_menuListener;
    JPopupMenu m_contextMenu;
    static int m_multilineThreshold = -1;

    ComponentInfo(PanelEditor panelEditor, MutableProperties mutableProperties) {
        this.m_panelEditor = panelEditor;
        this.m_properties = mutableProperties;
        this.setLayout(new BorderLayout());
        if (mutableProperties.getType() == 3) {
            this.setOpaque(false);
        }
        if (m_multilineThreshold == -1) {
            Rectangle rectangle = new Rectangle();
            rectangle.setSize(this.m_panelEditor.getDefaultComponentSize(2));
            m_multilineThreshold = rectangle.height;
        }
        this.m_menuListener = panelEditor.getContextMenuListener();
        this.m_mouseListener = new ComponentMouseListener();
        this.m_focusListener = new ComponentFocusListener();
        this.m_contextMenu = this.createContextMenu();
        this.m_component = this.createWrapper();
        if (this.m_component != null) {
            this.add(this.m_component, "Center");
        }
    }

    MutableProperties getProperties() {
        return this.m_properties;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.m_component != null) {
            this.m_component.setCursor(cursor);
            this.recursiveSetCursor(this.m_component, cursor);
        }
    }

    private void recursiveSetCursor(Component component, Cursor cursor) {
        Component[] componentArray;
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].setCursor(cursor);
                this.recursiveSetCursor(componentArray[n], cursor);
                ++n;
            }
        }
    }

    private void recursiveSetFont(Component component, Font font) {
        Component[] componentArray;
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].setFont(font);
                this.recursiveSetFont(componentArray[n], font);
                ++n;
            }
        }
    }

    private void recursiveAddListeners(Component component) {
        Component[] componentArray;
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].addFocusListener(this.m_focusListener);
                componentArray[n].addMouseListener(this.m_mouseListener);
                componentArray[n].addMouseMotionListener(this.m_mouseListener);
                this.recursiveAddListeners(componentArray[n]);
                ++n;
            }
        }
    }

    private void recursiveRemoveListeners(Component component) {
        Component[] componentArray;
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null) {
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].removeFocusListener(this.m_focusListener);
                componentArray[n].removeMouseListener(this.m_mouseListener);
                componentArray[n].removeMouseMotionListener(this.m_mouseListener);
                this.recursiveRemoveListeners(componentArray[n]);
                ++n;
            }
        }
    }

    Component createCustomWrapper() {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setVerticalAlignment(0);
        jLabel.setVerticalTextPosition(3);
        jLabel.setText((String)this.m_properties.getProperty("Name"));
        jLabel.setBorder(new LineBorder(Color.black));
        ImageIcon imageIcon = null;
        int n = this.m_properties.getType();
        imageIcon = n == 60 ? GUIFactory.getImage("DeckPane.gif", true) : (n == 61 ? GUIFactory.getImage("SplitPane.gif", true) : (n == 62 ? GUIFactory.getImage("TabbedPane.gif", true) : GUIFactory.getImage("Custom.gif", true)));
        jLabel.setIcon(imageIcon);
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jLabel.setEnabled(!bl);
        return jLabel;
    }

    Component createImageWrapper() {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setVerticalAlignment(0);
        jLabel.setVerticalTextPosition(3);
        String string = (String)this.m_properties.getProperty("Title");
        ImageIcon imageIcon = null;
        if (!string.equals("")) {
            imageIcon = GUIFactory.getUserImage(string);
        }
        if (imageIcon == null) {
            jLabel.setBorder(new LineBorder(Color.black, 1));
            jLabel.setText((String)this.m_properties.getProperty("Name"));
            imageIcon = GUIFactory.getImage("Bitmap.gif", true);
        } else {
            Rectangle rectangle = (Rectangle)this.m_properties.getProperty("Bounds");
            Image image = imageIcon.getImage();
            image = image.getScaledInstance(rectangle.width, rectangle.height, 1);
            imageIcon.setImage(image);
            image.flush();
        }
        jLabel.setIcon(imageIcon);
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jLabel.setEnabled(!bl);
        return jLabel;
    }

    Component createLabelWrapper() {
        Rectangle rectangle = (Rectangle)this.m_properties.getProperty("Bounds");
        if (rectangle.height > m_multilineThreshold) {
            JTextArea jTextArea = new JTextArea((String)this.m_properties.getProperty("Title"));
            jTextArea.setFont(UIManager.getFont("Label.font"));
            jTextArea.setForeground(UIManager.getColor("Label.foreground"));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            jTextArea.setOpaque(false);
            jTextArea.setSelectionColor(this.getBackground());
            jTextArea.setSelectedTextColor(jTextArea.getForeground());
            jTextArea.setBorder(null);
            boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
            jTextArea.setEnabled(!bl);
            return jTextArea;
        }
        JLabel jLabel = new JLabel((String)this.m_properties.getProperty("Title"));
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jLabel.setEnabled(!bl);
        return jLabel;
    }

    Component createGroupBoxWrapper() {
        GroupBox groupBox = new GroupBox((String)this.m_properties.getProperty("Title"));
        groupBox.setOpaque(false);
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        groupBox.setEnabled(!bl);
        return groupBox;
    }

    Component createSpinnerWrapper() {
        SpinnerGUI spinnerGUI = new SpinnerGUI();
        String string = (String)this.m_properties.getProperty("Orientation");
        if (string.equals("horizontal")) {
            spinnerGUI.setOrientation(1);
        } else {
            spinnerGUI.setOrientation(0);
        }
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        boolean bl2 = (Boolean)this.m_properties.getProperty("Editable");
        spinnerGUI.setEnabled(!bl);
        spinnerGUI.setBackground(!bl2 || bl ? UIManager.getColor("Panel.background") : UIManager.getColor("TextField.background"));
        return spinnerGUI;
    }

    Component createTextFieldWrapper() {
        boolean bl = (Boolean)this.m_properties.getProperty("Multiline");
        if (bl) {
            return this.createTextAreaWrapper();
        }
        JTextField jTextField = null;
        boolean bl2 = (Boolean)this.m_properties.getProperty("Masked");
        jTextField = bl2 ? new JPasswordField() : new JTextField();
        jTextField.setText((String)this.m_properties.getProperty("Title"));
        jTextField.setSelectionColor(jTextField.getBackground());
        jTextField.setSelectedTextColor(jTextField.getForeground());
        jTextField.setCaretColor(jTextField.getBackground());
        boolean bl3 = (Boolean)this.m_properties.getProperty("Disabled");
        jTextField.setEnabled(!bl3);
        boolean bl4 = (Boolean)this.m_properties.getProperty("Editable");
        jTextField.setBackground(!bl4 || bl3 ? UIManager.getColor("Panel.background") : UIManager.getColor("TextField.background"));
        return jTextField;
    }

    Component createTextAreaWrapper() {
        JTextArea jTextArea = new JTextArea((String)this.m_properties.getProperty("Title"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(new BevelBorder(1));
        jTextArea.setCaretPosition(0);
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jTextArea.setEnabled(!bl);
        boolean bl2 = (Boolean)this.m_properties.getProperty("Editable");
        jTextArea.setBackground(!bl2 || bl ? UIManager.getColor("Panel.background") : UIManager.getColor("TextField.background"));
        return jScrollPane;
    }

    Component createButtonWrapper() {
        JButton jButton = new JButton();
        MenuBuilder.resetMenu(jButton, this.m_properties);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setFocusPainted(false);
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jButton.setEnabled(!bl);
        if (this.m_properties.getProperty("Action").equals("HELP")) {
            JButton jButton2 = new JButton("?");
            jButton2.setMargin(new Insets(2, 2, 2, 2));
            jButton2.setEnabled(!bl);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jButton, "Center");
            jPanel.add((Component)jButton2, "East");
            return jPanel;
        }
        return jButton;
    }

    Component createToggleButtonWrapper() {
        ButtonGroupProperties buttonGroupProperties;
        boolean bl;
        JToggleButton jToggleButton = null;
        jToggleButton = this.m_properties.getType() == 101 ? new JRadioButton() : new JCheckBox();
        MenuBuilder.resetMenu(jToggleButton, this.m_properties);
        jToggleButton.setFocusPainted(false);
        jToggleButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AbstractButton abstractButton = (AbstractButton)changeEvent.getSource();
                if (abstractButton.isSelected()) {
                    abstractButton.setSelected(false);
                }
            }
        });
        boolean bl2 = (Boolean)this.m_properties.getProperty("Disabled");
        Object object = this.m_properties.getProperty("Button Group");
        if (object instanceof ButtonGroupProperties && (bl = ((Boolean)(buttonGroupProperties = (ButtonGroupProperties)object).getProperty("Disabled")).booleanValue())) {
            bl2 = bl;
        }
        jToggleButton.setEnabled(!bl2);
        return jToggleButton;
    }

    Component createComboBoxWrapper() {
        JComboBox jComboBox = new JComboBox();
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jComboBox.setEnabled(!bl);
        return jComboBox;
    }

    Component createListWrapper() {
        Object[] objectArray = new Object[]{GUIFactory.getString("IDS_DEFAULT_LABEL_LIST")};
        JList<Object> jList = new JList<Object>(objectArray);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ((JList)listSelectionEvent.getSource()).clearSelection();
            }
        });
        jList.setBorder(new BevelBorder(1));
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jList.setEnabled(!bl);
        return jList;
    }

    Component createTreeWrapper() {
        JTree jTree = new JTree();
        jTree.setCellRenderer(new TreeRenderer(jTree));
        jTree.setBorder(new BevelBorder(1));
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jTree.setEnabled(!bl);
        jTree.setBackground(bl ? UIManager.getColor("Panel.background") : UIManager.getColor("Tree.background"));
        jTree.repaint();
        return jTree;
    }

    Component createTableWrapper() {
        JTextArea jTextArea = new JTextArea(GUIFactory.getString("IDS_DEFAULT_LABEL_TABLE"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setSelectionColor(jTextArea.getBackground());
        jTextArea.setSelectedTextColor(jTextArea.getForeground());
        jTextArea.setCaretColor(jTextArea.getBackground());
        jTextArea.setBorder(new BevelBorder(1));
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jTextArea.setEnabled(!bl);
        return jTextArea;
    }

    Component createSliderWrapper() {
        boolean bl;
        boolean bl2 = this.m_properties.getProperty("Orientation").equals("vertical");
        int n = (Integer)this.m_properties.getProperty("Min Value");
        int n2 = (Integer)this.m_properties.getProperty("Max Value");
        int n3 = (Integer)this.m_properties.getProperty("Major Ticks");
        int n4 = (Integer)this.m_properties.getProperty("Minor Ticks");
        boolean bl3 = n3 > 0;
        JSlider jSlider = new JSlider();
        if (bl2) {
            jSlider.setOrientation(1);
        } else {
            jSlider.setOrientation(0);
        }
        jSlider.setMinimum(n);
        jSlider.setMaximum(n2);
        jSlider.setValue((n2 - n) / 2);
        jSlider.setPaintTicks(bl3);
        jSlider.setPaintLabels(bl3);
        jSlider.setSnapToTicks(bl3);
        jSlider.setMajorTickSpacing(n3);
        jSlider.setMinorTickSpacing(n4);
        if (bl3) {
            jSlider.setLabelTable(jSlider.createStandardLabels(n3));
        }
        jSlider.setEnabled(!(bl = ((Boolean)this.m_properties.getProperty("Disabled")).booleanValue()));
        return jSlider;
    }

    Component createProgressBarWrapper() {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setValue(2 * jProgressBar.getMaximum() / 3);
        boolean bl = (Boolean)this.m_properties.getProperty("Disabled");
        jProgressBar.setEnabled(!bl);
        return jProgressBar;
    }

    Component createWrapper() {
        Component component = null;
        switch (this.m_properties.getType()) {
            default: {
                return null;
            }
            case 60: 
            case 61: 
            case 62: 
            case 111: {
                component = this.createCustomWrapper();
                break;
            }
            case 110: {
                component = this.createImageWrapper();
                break;
            }
            case 2: {
                component = this.createLabelWrapper();
                break;
            }
            case 3: {
                component = this.createGroupBoxWrapper();
                break;
            }
            case 4: {
                component = this.createTextFieldWrapper();
                break;
            }
            case 5: {
                component = this.createTextAreaWrapper();
                break;
            }
            case 106: {
                component = this.createSpinnerWrapper();
                break;
            }
            case 6: {
                component = this.createButtonWrapper();
                break;
            }
            case 8: {
                component = this.createComboBoxWrapper();
                break;
            }
            case 9: {
                component = this.createListWrapper();
                break;
            }
            case 101: 
            case 102: {
                component = this.createToggleButtonWrapper();
                break;
            }
            case 104: {
                component = this.createTreeWrapper();
                break;
            }
            case 103: {
                component = this.createTableWrapper();
                break;
            }
            case 109: {
                component = this.createSliderWrapper();
                break;
            }
            case 108: {
                component = this.createProgressBarWrapper();
            }
        }
        if (component != null) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new WrapperOverlayLayout());
            jPanel.setOpaque(false);
            JLabel jLabel = new JLabel("");
            jLabel.setOpaque(false);
            jPanel.add(jLabel);
            jPanel.add(component);
            component = jPanel;
            component.addFocusListener(this.m_focusListener);
            component.addMouseListener(this.m_mouseListener);
            component.addMouseMotionListener(this.m_mouseListener);
            component.setFont(this.m_panelEditor.m_panelBuilder.getBuilder().getScaledFont());
            this.recursiveSetFont(component, component.getFont());
            this.recursiveAddListeners(component);
            component.removeMouseListener(this.m_mouseListener);
            Rectangle rectangle = (Rectangle)this.m_properties.getProperty("Bounds");
            this.setBounds(rectangle);
            String string = (String)this.m_properties.getProperty("Flyover Text");
            if (string != null && string.equals("")) {
                string = null;
            }
            jLabel.setToolTipText(string);
        }
        return component;
    }

    void refresh() {
        if (this.m_component != null) {
            this.m_component.removeFocusListener(this.m_focusListener);
            this.m_component.removeMouseListener(this.m_mouseListener);
            this.m_component.removeMouseMotionListener(this.m_mouseListener);
            this.recursiveRemoveListeners(this.m_component);
            this.remove(this.m_component);
            this.m_component = null;
        }
        this.m_component = this.createWrapper();
        if (this.m_component != null) {
            this.add(this.m_component, "Center");
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    JPopupMenu createCustomMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_CUSTOM_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_CUSTOM_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_CUSTOM_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_CUSTOM_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_CUSTOM_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareCustomMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createDeckPaneMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Editor", null, "IDCM_DECKPANE_EDIT_PANES", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_DECKPANE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_DECKPANE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_DECKPANE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_DECKPANE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_DECKPANE_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareDeckPaneMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createSplitPaneMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Editor", null, "IDCM_SPLITPANE_EDIT_PANES", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_SPLITPANE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_SPLITPANE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_SPLITPANE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_SPLITPANE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_SPLITPANE_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareSplitPaneMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createTabbedPaneMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Editor", null, "IDCM_TABBEDPANE_EDIT_PANES", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_TABBEDPANE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_TABBEDPANE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_TABBEDPANE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_TABBEDPANE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_TABBEDPANE_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareTabbedPaneMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createImageMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Image Default Size", null, "IDCM_IMAGE_DEFAULT_SIZE", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_IMAGE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_IMAGE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_IMAGE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_IMAGE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_IMAGE_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareImageMenu() {
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createLabelMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_LABEL_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_LABEL_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_LABEL_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_LABEL_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_LABEL_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareLabelMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createGroupBoxMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_GROUPBOX_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_GROUPBOX_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_GROUPBOX_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_GROUPBOX_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_GROUPBOX_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareGroupBoxMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createSpinnerMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_SPIN_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_SPIN_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_SPIN_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_SPIN_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_SPIN_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareSpinnerMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createTextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_TEXT_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_TEXT_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_TEXT_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_TEXT_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_TEXT_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareTextMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createButtonMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = GUIFactory.createMenu("Selected", "IDCM_BUTTON_SELECTED", null, true);
        jPopupMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Selected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Selected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_BUTTON_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_BUTTON_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_BUTTON_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_BUTTON_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_BUTTON_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareButtonMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createToggleButtonMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Button Group", null, "IDCM_TOGGLE_CREATE_GROUP", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        JMenu jMenu = GUIFactory.createMenu("Selected", "IDCM_TOGGLE_SELECTED", null, true);
        jPopupMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Selected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Selected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        jMenu = GUIFactory.createMenu("Deselected", "IDCM_TOGGLE_DESELECTED", null, true);
        jPopupMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Deselected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Deselected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_TOGGLE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_TOGGLE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_TOGGLE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_TOGGLE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_TOGGLE_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareToggleButtonMenu() {
        Object object = this.getProperties().getProperty("Button Group");
        boolean bl = object instanceof ButtonGroupProperties;
        String string = bl ? "IDCM_TOGGLE_MODIFY_GROUP" : "IDCM_TOGGLE_CREATE_GROUP";
        JMenuItem jMenuItem = (JMenuItem)this.m_contextMenu.getComponent(0);
        GUIFactory.setMenuText(jMenuItem, GUIFactory.getString(string));
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(3).setEnabled(!bl && !this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(6).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(7).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(8).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createComboBoxMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Editor", null, "IDCM_COMBOBOX_EDIT_ITEMS", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_COMBOBOX_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_COMBOBOX_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_COMBOBOX_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_COMBOBOX_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_COMBOBOX_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareComboBoxMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createListMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Editor", null, "IDCM_LIST_EDIT_ITEMS", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        JMenu jMenu = GUIFactory.createMenu("Selected", "IDCM_LIST_SELECTED", null, true);
        jPopupMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Selected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Selected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        jMenu = GUIFactory.createMenu("Deselected", "IDCM_LIST_DESELECTED", null, true);
        jPopupMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Deselected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Deselected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_LIST_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_LIST_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_LIST_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_LIST_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_LIST_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareListMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(3).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(6).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(7).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(8).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createTableMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Editor", null, "IDCM_TABLE_EDIT_COLUMNS", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        JMenu jMenu = GUIFactory.createMenu("Selected", "IDCM_TABLE_SELECTED", null, true);
        jPopupMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Selected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Selected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Selected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        jMenu = GUIFactory.createMenu("Deselected", "IDCM_TABLE_DESELECTED", null, true);
        jPopupMenu.add(jMenu);
        jMenu.add(GUIFactory.createMenuItem("Deselected Enable", null, "IDM_SELECTED_ENABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Disable", null, "IDM_SELECTED_DISABLE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Refresh", null, "IDM_SELECTED_REFRESH", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Show", null, "IDM_SELECTED_SHOW", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Hide", null, "IDM_SELECTED_HIDE", null, true, this.m_menuListener));
        jMenu.add(GUIFactory.createMenuItem("Deselected Display", null, "IDM_SELECTED_DISPLAY", null, true, this.m_menuListener));
        jMenu.addSeparator();
        jMenu.add(GUIFactory.createMenuItem("Deselected Other", null, "IDM_SELECTED_OTHER", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_TABLE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_TABLE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_TABLE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_TABLE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_TABLE_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareTableMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(3).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(6).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(7).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(8).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createTreeMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Editor", null, "IDCM_TREE_EDIT_NODES", null, true, this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_TREE_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_TREE_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_TREE_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_TREE_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_TREE_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareTreeMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(!this.m_panelEditor.m_panelBuilder.getBuilder().isTranslationMode());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(4).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(5).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createSliderMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_SLIDER_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_SLIDER_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_SLIDER_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_SLIDER_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_SLIDER_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareSliderMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createProgressBarMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Cut", null, "IDCM_PROGRESSBAR_EDIT_CUT", null, false, KeyStroke.getKeyStroke(88, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Copy", null, "IDCM_PROGRESSBAR_EDIT_COPY", null, false, KeyStroke.getKeyStroke(67, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Paste", null, "IDCM_PROGRESSBAR_EDIT_PASTE", null, false, KeyStroke.getKeyStroke(86, 2), this.m_menuListener));
        jPopupMenu.add(GUIFactory.createMenuItem("Edit Delete", null, "IDCM_PROGRESSBAR_EDIT_DELETE", null, false, KeyStroke.getKeyStroke(127, 0), this.m_menuListener));
        jPopupMenu.addSeparator();
        jPopupMenu.add(GUIFactory.createMenuItem("Show Properties", null, "IDCM_PROGRESSBAR_PROPERTIES", null, true, this.m_menuListener));
        return jPopupMenu;
    }

    void prepareProgressBarMenu() {
        this.m_contextMenu.getComponent(0).setEnabled(this.m_panelEditor.m_panelBuilder.canCut());
        this.m_contextMenu.getComponent(1).setEnabled(this.m_panelEditor.m_panelBuilder.canCopy());
        this.m_contextMenu.getComponent(2).setEnabled(this.m_panelEditor.m_panelBuilder.canPaste());
        this.m_contextMenu.getComponent(3).setEnabled(this.m_panelEditor.m_panelBuilder.canDelete());
    }

    JPopupMenu createContextMenu() {
        JPopupMenu jPopupMenu = null;
        switch (this.m_properties.getType()) {
            default: {
                return null;
            }
            case 111: {
                jPopupMenu = this.createCustomMenu();
                break;
            }
            case 61: {
                jPopupMenu = this.createSplitPaneMenu();
                break;
            }
            case 62: {
                jPopupMenu = this.createTabbedPaneMenu();
                break;
            }
            case 60: {
                jPopupMenu = this.createDeckPaneMenu();
                break;
            }
            case 110: {
                jPopupMenu = this.createImageMenu();
                break;
            }
            case 106: {
                jPopupMenu = this.createSpinnerMenu();
                break;
            }
            case 2: {
                jPopupMenu = this.createLabelMenu();
                break;
            }
            case 3: {
                jPopupMenu = this.createGroupBoxMenu();
                break;
            }
            case 4: 
            case 5: {
                jPopupMenu = this.createTextMenu();
                break;
            }
            case 6: {
                jPopupMenu = this.createButtonMenu();
                break;
            }
            case 8: {
                jPopupMenu = this.createComboBoxMenu();
                break;
            }
            case 9: {
                jPopupMenu = this.createListMenu();
                break;
            }
            case 101: 
            case 102: {
                jPopupMenu = this.createToggleButtonMenu();
                break;
            }
            case 104: {
                jPopupMenu = this.createTreeMenu();
                break;
            }
            case 103: {
                jPopupMenu = this.createTableMenu();
                break;
            }
            case 109: {
                jPopupMenu = this.createSliderMenu();
                break;
            }
            case 108: {
                jPopupMenu = this.createProgressBarMenu();
            }
        }
        return jPopupMenu;
    }

    JPopupMenu getContextMenu() {
        switch (this.m_properties.getType()) {
            default: {
                return null;
            }
            case 111: {
                this.prepareCustomMenu();
                break;
            }
            case 61: {
                this.prepareSplitPaneMenu();
                break;
            }
            case 62: {
                this.prepareTabbedPaneMenu();
                break;
            }
            case 60: {
                this.prepareDeckPaneMenu();
                break;
            }
            case 110: {
                this.prepareImageMenu();
                break;
            }
            case 2: {
                this.prepareLabelMenu();
                break;
            }
            case 3: {
                this.prepareGroupBoxMenu();
                break;
            }
            case 106: {
                this.prepareSpinnerMenu();
                break;
            }
            case 4: 
            case 5: {
                this.prepareTextMenu();
                break;
            }
            case 6: {
                this.prepareButtonMenu();
                break;
            }
            case 8: {
                this.prepareComboBoxMenu();
                break;
            }
            case 9: {
                this.prepareListMenu();
                break;
            }
            case 101: 
            case 102: {
                this.prepareToggleButtonMenu();
                break;
            }
            case 104: {
                this.prepareTreeMenu();
                break;
            }
            case 103: {
                this.prepareTableMenu();
                break;
            }
            case 109: {
                this.prepareSliderMenu();
                break;
            }
            case 108: {
                this.prepareProgressBarMenu();
            }
        }
        return this.m_contextMenu;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    class WrapperOverlayLayout
    implements LayoutManager {
        WrapperOverlayLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Rectangle rectangle = container.getBounds();
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension(0, 0);
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component = container.getComponent(n2);
                    component.setBounds(rectangle);
                    ++n2;
                }
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Rectangle rectangle = null;
            Object object = container.getTreeLock();
            synchronized (object) {
                block6: {
                    Serializable serializable;
                    Dimension dimension = new Dimension(0, 0);
                    int n = container.getComponentCount();
                    int n2 = 0;
                    while (n2 < n) {
                        serializable = container.getComponent(n2);
                        if (rectangle == null) {
                            rectangle = ((Component)serializable).getBounds();
                        }
                        rectangle = rectangle.union(((Component)serializable).getBounds());
                        ++n2;
                    }
                    if (rectangle == null) break block6;
                    serializable = rectangle.getSize();
                    return serializable;
                }
                Dimension dimension = new Dimension(0, 0);
                return dimension;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Rectangle rectangle = null;
            Object object = container.getTreeLock();
            synchronized (object) {
                block6: {
                    Serializable serializable;
                    Dimension dimension = new Dimension(0, 0);
                    int n = container.getComponentCount();
                    int n2 = 0;
                    while (n2 < n) {
                        serializable = container.getComponent(n2);
                        if (rectangle == null) {
                            rectangle = ((Component)serializable).getBounds();
                        }
                        rectangle = rectangle.union(((Component)serializable).getBounds());
                        ++n2;
                    }
                    if (rectangle == null) break block6;
                    serializable = rectangle.getSize();
                    return serializable;
                }
                Dimension dimension = new Dimension(0, 0);
                return dimension;
            }
        }
    }

    class TreeRenderer
    extends JLabel
    implements TreeCellRenderer {
        private boolean m_bSelected;
        private boolean m_bHasFocus;
        private JTree m_tree;

        public TreeRenderer(JTree jTree) {
            this.m_tree = jTree;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            Icon icon = null;
            icon = bl3 ? UIManager.getIcon("Tree.leafIcon") : (bl2 ? UIManager.getIcon("Tree.openIcon") : UIManager.getIcon("Tree.closedIcon"));
            this.setText(string);
            this.setIcon(icon);
            this.setFont(jTree.getFont());
            this.m_bSelected = bl;
            this.m_bHasFocus = bl4;
            return this;
        }

        public void paint(Graphics graphics) {
            Color color;
            Icon icon = this.getIcon();
            if (this.m_bSelected) {
                color = UIManager.getColor("Tree.selectionBackground");
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                color = this.m_tree.getBackground();
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            graphics.setColor(color);
            if (icon != null && this.getText() != null) {
                int n = icon.getIconWidth() + this.getIconTextGap();
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            if (this.m_bHasFocus) {
                graphics.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(graphics);
        }
    }

    class ComponentMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        ComponentMouseListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ComponentInfo.this.m_panelEditor.componentMouseMoved(mouseEvent, ComponentInfo.this);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ComponentInfo.this.m_panelEditor.componentMouseDragged(mouseEvent, ComponentInfo.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ComponentInfo.this.m_panelEditor.componentMousePressed(mouseEvent, ComponentInfo.this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ComponentInfo.this.m_panelEditor.componentMouseReleased(mouseEvent, ComponentInfo.this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ComponentInfo.this.m_panelEditor.componentMouseClicked(mouseEvent, ComponentInfo.this);
        }
    }

    class ComponentFocusListener
    implements FocusListener {
        ComponentFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            ComponentInfo.this.requestFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

