/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JavaApplicationCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VJavaGetResult;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VJavaApplicationCall
extends JComponent
implements KeyListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    private JavaApplicationCall javaAppCall_ = null;
    private String classPath_ = "";
    private Vector inputVector_;
    private int inputIndex_ = 0;
    private String inputStr_;
    private JTextField inputText_;
    private JScrollPane scrollPane_;
    private boolean javaRunOver_ = true;
    private String[] optionArray_ = new String[]{"*NONE"};
    private JTextArea outputText_;
    private int paramNum_;
    private StringTokenizer strToken_;
    private VJavaGetResult vJavaGetResult_;
    private boolean hasNext = false;
    private boolean hasPrevious = false;
    private boolean firstDraw = true;
    private long linesWritten_ = 0L;
    private static final int ROWS = 24;
    private static final int COLUMNS = 72;

    public VJavaApplicationCall() {
        this.initialize();
    }

    public VJavaApplicationCall(JavaApplicationCall javaApplicationCall) {
        if (javaApplicationCall == null) {
            throw new NullPointerException("JavaApplicationCall");
        }
        this.javaAppCall_ = javaApplicationCall;
        this.initialize();
    }

    public void addErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addNotify() {
        super.addNotify();
        this.inputText_.requestFocus();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        if (workingListener == null) {
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    void appendOutput(String string) {
        this.outputText_.append(string);
        ++this.linesWritten_;
        int n = this.outputText_.getSize().width;
        int n2 = this.outputText_.getSize().height;
        Rectangle rectangle = new Rectangle(0, n2 - 2, n - 1, n2 - 1);
        if (this.linesWritten_ < 24L) {
            int n3;
            int n4 = n2 / 24;
            if (n4 > 0 && this.linesWritten_ > (long)(n3 = this.scrollPane_.getSize().height / n4)) {
                this.outputText_.scrollRectToVisible(rectangle);
            }
        } else if (n2 > this.scrollPane_.getSize().height) {
            this.outputText_.scrollRectToVisible(rectangle);
        }
    }

    protected void finalize() throws Throwable {
        this.vJavaGetResult_ = null;
        super.finalize();
    }

    public JavaApplicationCall getJavaApplicationCall() {
        return this.javaAppCall_;
    }

    public JTextArea getOutputText() {
        return this.outputText_;
    }

    private void initialize() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.inputVector_ = new Vector();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(ResourceLoader.getText("REMOTE_OUTPUT_LABEL"));
        JLabel jLabel2 = new JLabel(ResourceLoader.getText("REMOTE_INPUT_LABEL"));
        this.outputText_ = new JTextArea();
        this.outputText_.setEditable(false);
        this.outputText_.setRows(24);
        this.outputText_.setColumns(72);
        this.scrollPane_ = new JScrollPane(this.outputText_);
        this.scrollPane_.setVerticalScrollBarPolicy(20);
        this.inputText_ = new JTextField();
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.scrollPane_, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel2, "North");
        jPanel2.add((Component)this.inputText_, "Center");
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.inputText_.addKeyListener(this);
        this.appendOutput(ResourceLoader.getText("REMOTE_PROMPT"));
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.javaAppCall_ == null) {
            throw new ExtendedIllegalStateException("JavaApplicationCall", 4);
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.processEnter();
                break;
            }
            case 34: {
                if (this.inputVector_.size() <= 0) break;
                this.inputIndex_ = this.inputVector_.size() - 1;
                this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                break;
            }
            case 33: {
                if (this.inputVector_.size() <= 0) break;
                this.inputIndex_ = 0;
                this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                break;
            }
            case 38: {
                if (this.inputVector_.size() <= 0) break;
                if (this.hasPrevious) {
                    if (this.inputIndex_ > 0) {
                        --this.inputIndex_;
                    }
                    this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                } else {
                    this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                }
                this.hasPrevious = true;
                this.hasNext = true;
                break;
            }
            case 40: {
                if (this.inputVector_.size() <= 0 || !this.hasNext) break;
                if (this.inputIndex_ < this.inputVector_.size() - 1) {
                    ++this.inputIndex_;
                }
                this.inputText_.setText((String)this.inputVector_.elementAt(this.inputIndex_));
                this.hasPrevious = true;
                break;
            }
            case 27: {
                this.inputText_.setText("");
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void load() {
        if (this.vJavaGetResult_ == null) {
            this.vJavaGetResult_ = new VJavaGetResult(this);
        }
        try {
            this.javaAppCall_.getSystem().connectService(2);
        }
        catch (Exception exception) {
            this.appendOutput(exception.toString() + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            return;
        }
        this.appendOutput(ResourceLoader.getText("REMOTE_JAVA_START"));
        this.appendOutput(this.javaAppCall_.getJavaApplication() + "\n\n");
        this.vJavaGetResult_.play();
    }

    private void processDCommand() {
        if (this.paramNum_ > 1) {
            this.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_ERROR") + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        } else {
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE1") + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE2"));
            this.appendOutput(this.javaAppCall_.getSecurityCheckLevel() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE3"));
            this.appendOutput(this.classPath_ + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE4"));
            this.appendOutput(this.javaAppCall_.getGarbageCollectionFrequency() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE5"));
            this.appendOutput(this.javaAppCall_.getGarbageCollectionInitialSize() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE6"));
            this.appendOutput(this.javaAppCall_.getGarbageCollectionMaximumSize() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE7"));
            this.appendOutput(this.javaAppCall_.getGarbageCollectionPriority() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE8"));
            this.appendOutput(this.javaAppCall_.getInterpret() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE9"));
            this.appendOutput(this.javaAppCall_.getOptimization() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE10"));
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.optionArray_.length; ++i) {
                stringBuffer.append(this.optionArray_[i]);
                stringBuffer.append(" ");
            }
            this.appendOutput(stringBuffer.toString() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE11"));
            this.appendOutput(this.javaAppCall_.getDefaultPort() + "\n");
            this.appendOutput(ResourceLoader.getText("REMOTE_D_LINE12"));
            this.appendOutput(this.javaAppCall_.isFindPort() + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        }
    }

    void processEnter() {
        if (this.javaAppCall_ == null) {
            throw new ExtendedIllegalStateException("JavaApplicationCall", 4);
        }
        if (this.javaRunOver_) {
            if (this.inputText_.getText().trim().equals("")) {
                this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            } else {
                if (this.inputVector_.size() > 0) {
                    int n = this.inputIndex_;
                    int n2 = this.inputVector_.size();
                    String string = (String)this.inputVector_.lastElement();
                    String string2 = (String)this.inputVector_.elementAt(n);
                    if (!string.equalsIgnoreCase(this.inputText_.getText())) {
                        this.inputVector_.addElement(this.inputText_.getText());
                    }
                    this.hasNext = false;
                    this.hasPrevious = false;
                    n2 = this.inputVector_.size();
                    this.inputIndex_ = n2 - 1;
                    if (n < n2 - 1 && this.inputText_.getText().equals(string2)) {
                        this.inputIndex_ = n;
                        this.hasNext = true;
                    }
                } else {
                    this.inputVector_.addElement(this.inputText_.getText());
                    this.inputIndex_ = 0;
                    this.hasNext = false;
                    this.hasPrevious = false;
                }
                this.appendOutput(this.inputText_.getText() + "\n");
                this.inputStr_ = this.inputText_.getText().trim();
                this.inputText_.setText("");
                this.strToken_ = new StringTokenizer(this.inputStr_, " ");
                this.paramNum_ = this.strToken_.countTokens();
                String string = this.strToken_.nextToken().toUpperCase();
                if (string.equals("JAVA")) {
                    this.processJavaCommand();
                } else if (string.equals("D")) {
                    this.processDCommand();
                } else if (string.equals("SET")) {
                    this.processSetCommand();
                } else if (string.equals("HELP") || string.equals("?") || string.equals("H")) {
                    this.processHelpCommand();
                } else if (string.equals("QUIT") || string.equals("Q")) {
                    if (this.paramNum_ > 1) {
                        this.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_ERROR") + "\n");
                        this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
                    } else {
                        System.exit(0);
                    }
                } else {
                    this.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_ERROR") + "\n");
                    this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
                }
            }
        } else {
            this.appendOutput(this.inputText_.getText() + "\n");
            this.inputStr_ = this.inputText_.getText();
            this.inputText_.setText("");
            this.javaAppCall_.sendStandardInString(this.inputStr_);
        }
    }

    private void processHelpCommand() {
        if (this.paramNum_ > 1) {
            this.appendOutput(ResourceLoader.getText("REMOTE_COMMAND_ERROR") + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        } else {
            this.appendOutput(ResourceLoader.getText("REMOTE_HELP"));
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        }
    }

    private void processJavaCommand() {
        Properties properties = new Properties();
        String string = "";
        String string2 = "";
        Vector vector = new Vector();
        if (this.paramNum_ == 1) {
            this.appendOutput(ResourceLoader.getText("REMOTE_JAVA_ERROR") + "\n");
            this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
        } else {
            int n;
            Vector<String> vector2 = new Vector<String>();
            while (this.strToken_.hasMoreTokens()) {
                vector2.addElement(this.strToken_.nextToken());
            }
            int n2 = vector2.size();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                if (((String)vector2.elementAt(n)).startsWith("-")) continue;
                string = (String)vector2.elementAt(n);
                bl = true;
                break;
            }
            if (bl) {
                int n3;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                for (n3 = 0; n3 < n; ++n3) {
                    String string3;
                    if (((String)vector2.elementAt(n3)).toUpperCase().startsWith("-CLASSPATH")) {
                        if (!bl3) {
                            bl3 = true;
                            string3 = (String)vector2.elementAt(n3);
                            int n4 = string3.indexOf("=");
                            if (n4 > 0 && n4 + 1 < string3.length()) {
                                string2 = string3.substring(n4 + 1);
                                continue;
                            }
                            bl2 = true;
                            break;
                        }
                        bl2 = true;
                        break;
                    }
                    if (((String)vector2.elementAt(n3)).toUpperCase().startsWith("-D")) {
                        string3 = (String)vector2.elementAt(n3);
                        String string4 = string3.substring(2);
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, "=");
                        if (stringTokenizer.countTokens() < 2) {
                            bl2 = true;
                            break;
                        }
                        String string5 = stringTokenizer.nextToken();
                        String string6 = (String)vector2.elementAt(n3);
                        int n5 = string6.indexOf("=");
                        String string7 = string6.substring(n5 + 1);
                        ((Hashtable)properties).put(string5, string7);
                        bl5 = true;
                        continue;
                    }
                    if (((String)vector2.elementAt(n3)).toUpperCase().startsWith("-VERBOSE")) {
                        if (!bl4) {
                            bl4 = true;
                            continue;
                        }
                        bl2 = true;
                        break;
                    }
                    bl2 = true;
                    break;
                }
                boolean bl6 = false;
                for (n3 = n + 1; n3 < n2 && !bl2; ++n3) {
                    bl6 = true;
                    vector.addElement(vector2.elementAt(n3));
                }
                if (!bl2) {
                    try {
                        this.javaAppCall_.setJavaApplication(string);
                        if (bl6) {
                            String[] stringArray = new String[vector.size()];
                            for (int i = 0; i < vector.size(); ++i) {
                                stringArray[i] = (String)vector.elementAt(i);
                            }
                            this.javaAppCall_.setParameters(stringArray);
                        }
                        if (bl5) {
                            this.javaAppCall_.setProperties(properties);
                        }
                        if (bl3) {
                            this.javaAppCall_.setClassPath(string2);
                        } else {
                            this.javaAppCall_.setClassPath(this.classPath_);
                        }
                        if (bl4) {
                            String[] stringArray = new String[]{"*VERBOSE"};
                            this.javaAppCall_.setOptions(stringArray);
                        } else {
                            this.javaAppCall_.setOptions(this.optionArray_);
                        }
                        this.load();
                    }
                    catch (Exception exception) {
                        this.appendOutput(exception + "\n");
                        this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
                    }
                } else {
                    this.appendOutput(ResourceLoader.getText("REMOTE_JAVA_ERROR") + "\n");
                    this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
                }
            } else {
                this.appendOutput(ResourceLoader.getText("REMOTE_JAVA_ERROR") + "\n");
                this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            }
        }
    }

    private void processSetCommand() {
        if (this.paramNum_ == 1) {
            this.processDCommand();
        } else {
            String string = this.inputStr_;
            String string2 = null;
            String string3 = null;
            int n = string.toUpperCase().indexOf("SET");
            String string4 = this.inputStr_.substring(n + 4).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "=");
            int n2 = stringTokenizer.countTokens();
            if (n2 == 1) {
                this.appendOutput(ResourceLoader.getText("REMOTE_SET_ERROR") + "\n");
                this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            } else {
                string2 = stringTokenizer.nextToken().toUpperCase().trim();
                string3 = stringTokenizer.nextToken().trim();
                try {
                    if (string2.equals("SECURITYCHECKLEVEL")) {
                        this.javaAppCall_.setSecurityCheckLevel(string3);
                    } else if (string2.equals("CLASSPATH")) {
                        int n3 = string4.indexOf("=");
                        String string5 = string4.substring(n3 + 1).trim();
                        this.javaAppCall_.setClassPath(string5);
                        this.classPath_ = string5;
                    } else if (string2.equals("GARBAGECOLLECTIONFREQUENCY")) {
                        this.javaAppCall_.setGarbageCollectionFrequency(Integer.valueOf(string3));
                    } else if (string2.equals("GARBAGECOLLECTIONINITIALSIZE")) {
                        this.javaAppCall_.setGarbageCollectionInitialSize(Integer.valueOf(string3));
                    } else if (string2.equals("GARBAGECOLLECTIONMAXIMUMSIZE")) {
                        this.javaAppCall_.setGarbageCollectionMaximumSize(string3);
                    } else if (string2.equals("GARBAGECOLLECTIONPRIORITY")) {
                        this.javaAppCall_.setGarbageCollectionPriority(Integer.valueOf(string3));
                    } else if (string2.equals("INTERPRET")) {
                        this.javaAppCall_.setInterpret(string3);
                    } else if (string2.equals("OPTIMIZE")) {
                        this.javaAppCall_.setOptimization(string3);
                    } else if (string2.equals("OPTION")) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, " ");
                        String[] stringArray = new String[stringTokenizer2.countTokens()];
                        int n4 = 0;
                        while (stringTokenizer2.hasMoreTokens()) {
                            stringArray[n4] = stringTokenizer2.nextToken().toUpperCase();
                            ++n4;
                        }
                        this.javaAppCall_.setOptions(stringArray);
                        this.optionArray_ = new String[stringArray.length];
                        System.arraycopy(stringArray, 0, this.optionArray_, 0, stringArray.length);
                    } else if (string2.equals("DEFAULTPORT")) {
                        this.javaAppCall_.setDefaultPort(Integer.valueOf(string3));
                    } else if (string2.equals("FINDPORT")) {
                        if (string3.toUpperCase().equals("TRUE") || string3.toUpperCase().equals("FALSE")) {
                            this.javaAppCall_.setFindPort(Boolean.valueOf(string3));
                        } else {
                            this.appendOutput(ResourceLoader.getText("REMOTE_PORT_VALUE_ERROR") + "\n");
                        }
                    } else {
                        this.appendOutput(ResourceLoader.getText("REMOTE_PROPERTY_ERROR_HEAD") + string2 + ResourceLoader.getText("REMOTE_PROPERTY_ERROR_END") + "\n");
                    }
                }
                catch (Exception exception) {
                    this.appendOutput(exception.toString() + "\n");
                    Trace.log(2, exception.toString());
                }
                this.appendOutput("\n" + ResourceLoader.getText("REMOTE_PROMPT"));
            }
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("ErrorListener");
        }
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        if (workingListener == null) {
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setJavaApplicationCall(JavaApplicationCall javaApplicationCall) throws PropertyVetoException {
        if (javaApplicationCall == null) {
            throw new NullPointerException("JavaApplicationCall");
        }
        this.javaAppCall_ = javaApplicationCall;
    }

    void setJavaAppRunOver(boolean bl) {
        this.javaRunOver_ = bl;
    }
}

