/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VIFSFile;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.TimeZone;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

class IFSFilePropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String attributesText_ = ResourceLoader.getText("IFS_ATTRIBUTES") + ":";
    private static final String byteText_ = ResourceLoader.getText("IFS_BYTE");
    private static final String bytesText_ = ResourceLoader.getText("IFS_BYTES");
    private static final String generalText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String locationText_ = ResourceLoader.getText("IFS_LOCATION") + ":";
    private static final String modifiedText_ = ResourceLoader.getText("IFS_MODIFIED") + ":";
    private static final String readText_ = ResourceLoader.getText("IFS_READ");
    private static final String sizeText_ = ResourceLoader.getText("IFS_SIZE") + ":";
    private static final String writeText_ = ResourceLoader.getText("IFS_WRITE");
    private static DateFormat dateFormat_ = DateFormat.getDateTimeInstance();
    private VIFSFile object_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSFilePropertiesPane(VIFSFile vIFSFile) {
        this.object_ = vIFSFile;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.addChangeListener(changeListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void applyChanges() throws Exception {
    }

    public Component getComponent() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), jPanel, gridBagLayout, 0, n++, 2, 1);
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n++, 2, 1);
        VUtilities.constrain(new JLabel(locationText_), jPanel, gridBagLayout, 0, n, 1, 1);
        VUtilities.constrain(new JLabel(this.object_.getParentDirectory()), jPanel, gridBagLayout, 1, n, 1, 1);
        VUtilities.constrain(new JLabel(sizeText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        long l = this.object_.getSize();
        VUtilities.constrain(new JLabel(Long.toString(l) + " " + (l == 1L ? byteText_ : bytesText_)), jPanel, gridBagLayout, 1, n, 1, 1);
        int n2 = ++n;
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n2, 2, 1);
        VUtilities.constrain(new JLabel(modifiedText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        VUtilities.constrain(new JLabel(dateFormat_.format(this.object_.getModified())), jPanel, gridBagLayout, 1, n, 1, 1);
        int n3 = ++n;
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n3, 2, 1);
        VUtilities.constrain(new JLabel(attributesText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        JCheckBox jCheckBox = new JCheckBox(readText_, this.object_.canRead());
        jCheckBox.setEnabled(false);
        VUtilities.constrain(jCheckBox, jPanel, gridBagLayout, 1, n, 1, 1);
        JCheckBox jCheckBox2 = new JCheckBox(writeText_, this.object_.canWrite());
        jCheckBox2.setEnabled(false);
        int n4 = ++n;
        ++n;
        VUtilities.constrain(jCheckBox2, jPanel, gridBagLayout, 1, n4, 1, 1);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(generalText_, null, jPanel);
        jTabbedPane.setSelectedIndex(0);
        return jTabbedPane;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.removeChangeListener(changeListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    static {
        dateFormat_.setTimeZone(TimeZone.getDefault());
    }
}

