/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.RJob;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ResourcePool;
import com.ibm.as400.resource.SystemResourceList;
import java.beans.PropertyVetoException;

public class RJobList
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRESENTATION_KEY_ = "JOB_LIST";
    private static final String ICON_BASE_NAME_ = "RJobList";
    private static final String SORTS_PRESENTATION_KEY_ = "JOB";
    private static PresentationLoader presentationLoader_;
    public static final String ALL = "*ALL";
    public static final String BLANK = "*BLANK";
    public static final String CURRENT = "*CURRENT";
    private static ResourceMetaDataTable selections_;
    public static final String JOB_NAME = "JOB_NAME";
    public static final String JOB_NUMBER = "JOB_NUMBER";
    public static final String JOB_TYPE = "JOB_TYPE";
    public static final String PRIMARY_JOB_STATUSES = "PRIMARY_JOB_STATUSES";
    public static final String USER_NAME = "USER_NAME";
    private static ResourceMetaDataTable sorts_;
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RJobList";
    private static final String formatName_ = "oljb0100";
    private static ProgramCallDocument staticDocument_;
    private static final String openListProgramName_ = "qgyoljob";
    static /* synthetic */ Class class$java$lang$String;

    public RJobList() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RJob.attributes_, selections_, sorts_, openListProgramName_, formatName_, null);
    }

    public RJobList(AS400 aS400) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void establishConnection() throws ResourceException {
        super.establishConnection();
        this.setDocument((ProgramCallDocument)staticDocument_.clone());
    }

    void setOpenParameters(ProgramCallDocument programCallDocument) throws PcmlException, ResourceException {
        super.setOpenParameters(programCallDocument);
        programCallDocument.setValue("qgyoljob.jobSelectionInformation.jobName", ((String)this.getSelectionValue(JOB_NAME)).toUpperCase());
        programCallDocument.setValue("qgyoljob.jobSelectionInformation.userName", ((String)this.getSelectionValue(USER_NAME)).toUpperCase());
        programCallDocument.setValue("qgyoljob.jobSelectionInformation.jobNumber", (String)this.getSelectionValue(JOB_NUMBER));
        String string = (String)this.getSelectionValue(JOB_TYPE);
        programCallDocument.setValue("qgyoljob.jobSelectionInformation.jobType", string.equals(ALL) ? "*" : string);
        int n = 108;
        String[] stringArray = (String[])this.getSelectionValue(PRIMARY_JOB_STATUSES);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        programCallDocument.setIntValue("qgyoljob.jobSelectionInformation.offsetToPrimaryJobStatusArray", n);
        programCallDocument.setIntValue("qgyoljob.jobSelectionInformation.numberOfPrimaryJobStatusEntries", stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            programCallDocument.setValue("qgyoljob.jobSelectionInformation.primaryJobStatus", new int[]{i}, stringArray[i]);
            n += 10;
        }
        Object[] objectArray = this.getSortValue();
        programCallDocument.setIntValue("qgyoljob.sortInformation.numberOfKeysToSortOn", objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            int n2;
            int n3;
            int n4 = 4;
            boolean bl = this.getSortOrder(objectArray[i]);
            if (objectArray[i].equals(JOB_NAME)) {
                n3 = 1;
                n2 = 10;
            } else if (objectArray[i].equals(USER_NAME)) {
                n3 = 11;
                n2 = 10;
            } else if (objectArray[i].equals(JOB_NUMBER)) {
                n3 = 21;
                n2 = 6;
            } else if (objectArray[i].equals(JOB_TYPE)) {
                n3 = 53;
                n2 = 1;
            } else if (objectArray[i].equals("JOB_SUBTYPE")) {
                n3 = 54;
                n2 = 1;
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Bad sort value specified: " + objectArray[i] + "(" + objectArray[i].getClass() + ")");
                }
                throw new ExtendedIllegalStateException("sortValue[" + i + "]", 6);
            }
            int[] nArray = new int[]{i};
            programCallDocument.setIntValue("qgyoljob.sortInformation.sortKey.sortKeyFieldStartingPosition", nArray, n3);
            programCallDocument.setIntValue("qgyoljob.sortInformation.sortKey.sortKeyFieldLength", nArray, n2);
            programCallDocument.setIntValue("qgyoljob.sortInformation.sortKey.sortKeyFieldDataType", nArray, n4);
            programCallDocument.setValue("qgyoljob.sortInformation.sortKey.sortOrder", nArray, bl ? "1" : "2");
        }
    }

    Resource newResource(String string, int[] nArray) throws PcmlException, ResourceException {
        ProgramCallDocument programCallDocument = this.getDocument();
        String string2 = (String)programCallDocument.getValue(string + ".receiverVariable.jobNameUsed", nArray);
        String string3 = (String)programCallDocument.getValue(string + ".receiverVariable.userNameUsed", nArray);
        String string4 = (String)programCallDocument.getValue(string + ".receiverVariable.jobNumberUsed", nArray);
        byte[] byArray = (byte[])programCallDocument.getValue(string + ".receiverVariable.internalJobIdentifier", nArray);
        String string5 = (String)programCallDocument.getValue(string + ".receiverVariable.status", nArray);
        String string6 = (String)programCallDocument.getValue(string + ".receiverVariable.jobType", nArray);
        String string7 = (String)programCallDocument.getValue(string + ".receiverVariable.jobSubtype", nArray);
        AS400 aS400 = this.getSystem();
        Object object = RJob.computeResourceKey(aS400, string2, string3, string4, byArray);
        RJob rJob = (RJob)ResourcePool.GLOBAL_RESOURCE_POOL.getResource(object);
        if (rJob == null) {
            try {
                rJob = new RJob(aS400, byArray);
                rJob.setResourceKey(object);
                rJob.setName(string2);
                rJob.setUser(string3);
                rJob.setNumber(string4);
                rJob.freezeProperties();
            }
            catch (Exception exception) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Exception while creating user from user list", (Throwable)exception);
                }
                throw new ResourceException(exception);
            }
        }
        rJob.initializeAttributeValue("INTERNAL_JOB_ID", byArray);
        rJob.initializeAttributeValue(JOB_NAME, string2);
        rJob.initializeAttributeValue(USER_NAME, string3);
        rJob.initializeAttributeValue(JOB_NUMBER, string4);
        rJob.initializeAttributeValue("JOB_STATUS", string5);
        rJob.initializeAttributeValue(JOB_TYPE, string6);
        rJob.initializeAttributeValue("JOB_SUBTYPE", string7);
        return rJob;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selections_.add(JOB_NAME, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, false, new String[]{"*", CURRENT, ALL}, ALL, false);
            selections_.add(JOB_NUMBER, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, false, new String[]{ALL}, ALL, false);
            selections_.add(JOB_TYPE, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, false, new String[]{ALL, "A", "B", "I", "M", "R", "S", "W", "X"}, ALL, true);
            selections_.add(PRIMARY_JOB_STATUSES, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, false, new String[]{"*ACTIVE", "*JOBQ", "*OUTQ"}, null, true, true);
            selections_.add(USER_NAME, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, false, new String[]{CURRENT, ALL}, ALL, false);
            sorts_ = new ResourceMetaDataTable(presentationLoader_, SORTS_PRESENTATION_KEY_);
            sorts_.add((Object)JOB_NAME, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, true);
            sorts_.add((Object)USER_NAME, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, true);
            sorts_.add((Object)JOB_NUMBER, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, true);
            sorts_.add((Object)JOB_TYPE, class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, true);
            sorts_.add((Object)"JOB_SUBTYPE", class$java$lang$String == null ? (class$java$lang$String = RJobList.class$("java.lang.String")) : class$java$lang$String, true);
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException pcmlException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)pcmlException);
            }
        }
    }
}

