/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.InternalErrorException;
import java.io.IOException;

class DDMS38OpenFeedback {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final int FILE_OPEN_TYPE = 10;
    private static final int FILE_NAME = 11;
    private static final int FILE_NAME_LENGTH = 10;
    private static final int LIB_NAME = 21;
    private static final int LIB_NAME_LENGTH = 10;
    private static final int MBR_NAME = 31;
    private static final int MBR_NAME_LENGTH = 10;
    private static final int RECORD_LEN = 41;
    private static final int INP_BUFFER_LEN = 45;
    private static final int OUT_BUFFER_LEN = 49;
    private static final int NUM_RECORDS = 53;
    private static final int ACCESS_TYPE = 57;
    private static final int ACCESS_TYPE_LENGTH = 2;
    private static final int SUPPORT_DUPLICATE_KEYS = 59;
    private static final int SUPPORT_DUPLICATE_KEYS_LENGTH = 1;
    private static final int SOURCE_FILE_INDICATOR = 60;
    private static final int SOURCE_FILE_INDICATOR_LENGTH = 1;
    private static final int UFCB_PARAMETERS = 61;
    private static final int UFCB_PARAMETERS_LENGTH = 10;
    private static final int MAX_BLOCKED_RECORDS_TRANSFERRED = 71;
    private static final int RECORD_INCREMENT = 73;
    private static final int OPEN_FLAGS_1 = 75;
    private static final int NUMBER_OF_ASSOCIATED_PHYS_FILE_MBRS = 76;
    private static final int MAX_RECORD_LENGTH = 82;
    private static final int RECORD_WAIT_TIME = 84;
    private static final int OPEN_FLAGS_2 = 88;
    private static final int NULL_FIELD_BYTE_MAP = 90;
    private static final int NULL_KEY_FIELD_BYTE_MAP = 92;
    private static final int CCSID = 98;
    private static final int FIXED_FIELD_LEN = 100;
    private static final int MIN_RECORD_LEN = 102;
    byte[] data_;
    int offset_;
    ConverterImplRemote conv_;

    DDMS38OpenFeedback(AS400ImplRemote aS400ImplRemote, byte[] byArray) throws AS400SecurityException, InterruptedException, IOException {
        this(aS400ImplRemote, byArray, 0);
    }

    DDMS38OpenFeedback(AS400ImplRemote aS400ImplRemote, byte[] byArray, int n) throws AS400SecurityException, InterruptedException, IOException {
        this.data_ = byArray;
        this.offset_ = n;
        this.conv_ = ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
    }

    String getAccessType() throws AS400SecurityException, InterruptedException, IOException {
        return this.conv_.byteArrayToString(this.data_, this.offset_ + 57, 2);
    }

    int getCCSID() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 98);
    }

    boolean duplicateKeysSupported() {
        return this.data_[this.offset_ + 59] == -60;
    }

    String getFileName() throws AS400SecurityException, InterruptedException, IOException {
        return this.conv_.byteArrayToString(this.data_, this.offset_ + 11, 10);
    }

    int getInputBufferLength() {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + 45);
    }

    String getLibraryName() throws AS400SecurityException, InterruptedException, IOException {
        return this.conv_.byteArrayToString(this.data_, this.offset_ + 21, 10);
    }

    int getMaxNumberOfRecordsTransferred() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 71);
    }

    String getMemberName() throws AS400SecurityException, InterruptedException, IOException {
        return this.conv_.byteArrayToString(this.data_, this.offset_ + 31, 10);
    }

    int getNullFieldByteMapOffset() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 90);
    }

    int getNumberOfRecords() {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + 53);
    }

    int getOpenType() {
        int n = this.data_[this.offset_ + 10] & 0xFFFF;
        if (n == 64 || n == 68 || n == 192 || n == 196) {
            return 0;
        }
        if (n == 32 || n == 36 || n == 160 || n == 164) {
            return 2;
        }
        return 1;
    }

    int getOutputBufferLength() {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + 49);
    }

    int getRecordIncrement() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 73);
    }

    int getRecordLength() {
        return BinaryConverter.byteArrayToUnsignedShort(this.data_, this.offset_ + 41);
    }

    boolean hasVariableLengthFields() {
        return (this.data_[this.offset_ + 88 + 1] & 0x80) == 128;
    }

    boolean isLogicalFile() {
        return (this.data_[this.offset_ + 75] & 0x80) == 128;
    }

    boolean isLogicalJoinFile() {
        return (this.data_[this.offset_ + 75] & 4) == 4;
    }

    boolean isNullCapable() {
        return (this.data_[this.offset_ + 88 + 1] & 0x40) == 64;
    }

    boolean isSourceFile() {
        return this.data_[this.offset_ + 60] == -24;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(0);
        try {
            stringBuffer.append("Open type: ");
            stringBuffer.append(this.getOpenType());
            stringBuffer.append("\n");
            stringBuffer.append("Library name: ");
            stringBuffer.append(this.getLibraryName());
            stringBuffer.append("\n");
            stringBuffer.append("File name: ");
            stringBuffer.append(this.getFileName());
            stringBuffer.append("\n");
            stringBuffer.append("Member name: ");
            stringBuffer.append(this.getMemberName());
            stringBuffer.append("\n");
            stringBuffer.append("Record length: ");
            stringBuffer.append(this.getRecordLength());
            stringBuffer.append("\n");
            stringBuffer.append("Input buffer length: ");
            stringBuffer.append(this.getInputBufferLength());
            stringBuffer.append("\n");
            stringBuffer.append("Output buffer length: ");
            stringBuffer.append(this.getOutputBufferLength());
            stringBuffer.append("\n");
            stringBuffer.append("Number of records: ");
            stringBuffer.append(this.getNumberOfRecords());
            stringBuffer.append("\n");
            stringBuffer.append("Access type: ");
            stringBuffer.append(this.getAccessType());
            stringBuffer.append("\n");
            stringBuffer.append("Duplicate keys supported: ");
            stringBuffer.append(this.duplicateKeysSupported());
            stringBuffer.append("\n");
            stringBuffer.append("Source file: ");
            stringBuffer.append(this.isSourceFile());
            stringBuffer.append("\n");
            stringBuffer.append("Max blocked records transferred: ");
            stringBuffer.append(this.getMaxNumberOfRecordsTransferred());
            stringBuffer.append("\n");
            stringBuffer.append("Record increment: ");
            stringBuffer.append(this.getRecordIncrement());
            stringBuffer.append("\n");
            stringBuffer.append("Has variable length fields: ");
            stringBuffer.append(this.hasVariableLengthFields());
            stringBuffer.append("\n");
            stringBuffer.append("Is null capable: ");
            stringBuffer.append(this.isNullCapable());
            stringBuffer.append("\n");
            stringBuffer.append("Offset to null byte field map: ");
            stringBuffer.append(this.getNullFieldByteMapOffset());
            stringBuffer.append("\n");
            stringBuffer.append("Logical file: ");
            stringBuffer.append(this.isLogicalFile());
            stringBuffer.append("\n");
            stringBuffer.append("Logical join file: ");
            stringBuffer.append(this.isLogicalJoinFile());
            stringBuffer.append("\n");
            stringBuffer.append("CCSID: ");
            stringBuffer.append(this.getCCSID());
            stringBuffer.append("\n");
        }
        catch (Exception exception) {
            throw new InternalErrorException(6);
        }
        return stringBuffer.toString();
    }
}

